/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.nei.NEI_GT_Config;
import java.awt.Rectangle;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GTPP_NEI_DefaultHandler
extends TemplateRecipeHandler {
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;
    private SoftReference<List<CachedDefaultRecipe>> mCachedRecipes = null;
    private static final HashMap<Integer, Pair<Integer, Integer>> mInputSlotMap;
    private static final HashMap<Integer, Pair<Integer, Integer>> mOutputSlotMap;
    protected final GT_Recipe.GT_Recipe_Map mRecipeMap;

    public GTPP_NEI_DefaultHandler(GT_Recipe.GT_Recipe_Map tMap) {
        this.mRecipeMap = tMap;
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_GT_Config.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)GT_Values.GT, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("gregtechplusplus@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(aString, aX, aY, aColor);
    }

    public TemplateRecipeHandler newInstance() {
        return new GTPP_NEI_DefaultHandler(this.mRecipeMap);
    }

    public List<GT_Recipe> getSortedRecipes() {
        ArrayList<GT_Recipe> result = new ArrayList<GT_Recipe>(this.mRecipeMap.mRecipeList);
        Collections.sort(result);
        return result;
    }

    public List<CachedDefaultRecipe> getCache() {
        List<CachedDefaultRecipe> cache;
        if (this.mCachedRecipes == null || (cache = this.mCachedRecipes.get()) == null) {
            cache = this.mRecipeMap.mRecipeList.stream().filter(r -> !r.mHidden).sorted().map(temp -> this.createCachedRecipe((GT_Recipe)temp)).collect(Collectors.toList());
            this.mCachedRecipes = new SoftReference<List<CachedDefaultRecipe>>(cache);
        }
        return cache;
    }

    public CachedDefaultRecipe createCachedRecipe(GT_Recipe aRecipe) {
        return new CachedDefaultRecipe(aRecipe);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.addAll(this.getCache());
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        FluidStack tFluidStack;
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation((ItemStack)aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GT_OreDictUnificator.get((boolean)true, (ItemStack)aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GT_OreDictUnificator.get((OrePrefixes)tPrefix, (Object)tPrefixMaterial.mMaterial.mMaterial, (long)1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem((ItemStack)aResult, (boolean)true)) != null) {
            tFluidStack = tFluid;
            tResults.add(GT_Utility.getFluidDisplayStack((FluidStack)tFluid, (boolean)false));
        } else {
            tFluidStack = GT_Utility.getFluidFromDisplayStack((ItemStack)aResult);
        }
        if (tFluidStack != null) {
            tResults.addAll(GT_Utility.getContainersFromFluid((FluidStack)tFluidStack));
        }
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tResults.stream().anyMatch(stack -> recipe.contains(recipe.mOutputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack aInput) {
        FluidStack tFluidStack;
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation((ItemStack)aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GT_OreDictUnificator.get((boolean)false, (ItemStack)aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GT_OreDictUnificator.get((OrePrefixes)tPrefix, (Object)tPrefixMaterial.mMaterial.mMaterial, (long)1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem((ItemStack)aInput, (boolean)true)) != null) {
            tFluidStack = tFluid;
            tInputs.add(GT_Utility.getFluidDisplayStack((FluidStack)tFluid, (boolean)false));
        } else {
            tFluidStack = GT_Utility.getFluidFromDisplayStack((ItemStack)aInput);
        }
        if (tFluidStack != null) {
            tInputs.addAll(GT_Utility.getContainersFromFluid((FluidStack)tFluidStack));
        }
        for (CachedDefaultRecipe recipe : this.getCache()) {
            if (!tInputs.stream().anyMatch(stack -> recipe.contains(recipe.mInputs, (ItemStack)stack))) continue;
            this.arecipes.add(recipe);
        }
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNEIName;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)78);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return GT_LanguageManager.getTranslation((String)this.mRecipeMap.mUnlocalizedName);
    }

    public String getGuiTexture() {
        return this.mRecipeMap.mNEIGUIPath;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == 10000) break;
                currenttip.add("Chance: " + ((FixedPositionedStack)tStack).mChance / 100 + "." + (((FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((FixedPositionedStack)tStack).mChance % 100)) + "%");
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (gregtech.api.enums.ItemList.Display_Fluid.isStackEqual((Object)tStack.item, true, true) || tStack.item.field_77994_a != 0) break;
                currenttip.add("Does not get consumed in the process");
                break;
            }
        }
        return currenttip;
    }

    public void drawExtras(int aRecipeIndex) {
        long tEUt = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mEUt;
        long tDuration = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mDuration;
        if (tEUt != 0L) {
            GTPP_NEI_DefaultHandler.drawText(10, 73, "Total: " + MathUtils.formatNumbers(tDuration * tEUt) + " EU", -16777216);
            GTPP_NEI_DefaultHandler.drawText(10, 83, "Usage: " + MathUtils.formatNumbers(tEUt) + " EU/t", -16777216);
            if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                GTPP_NEI_DefaultHandler.drawText(10, 93, "Voltage: " + MathUtils.formatNumbers(tEUt / (long)this.mRecipeMap.mAmperage) + " EU", -16777216);
                GTPP_NEI_DefaultHandler.drawText(10, 103, "Amperage: " + this.mRecipeMap.mAmperage, -16777216);
            } else {
                GTPP_NEI_DefaultHandler.drawText(10, 93, "Voltage: unspecified", -16777216);
                GTPP_NEI_DefaultHandler.drawText(10, 103, "Amperage: unspecified", -16777216);
            }
        }
        if (tDuration > 0L) {
            GTPP_NEI_DefaultHandler.drawText(10, 113, "Time: " + (tDuration < 20L ? "< 1" : MathUtils.formatNumbers(0.05 * (double)tDuration)) + " secs", -16777216);
        }
        if (GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePre) || GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePost)) {
            GTPP_NEI_DefaultHandler.drawText(10, 123, this.mRecipeMap.mNEISpecialValuePre + ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue * this.mRecipeMap.mNEISpecialValueMultiplier + this.mRecipeMap.mNEISpecialValuePost, -16777216);
        }
    }

    static {
        int x;
        int y;
        mInputSlotMap = new HashMap();
        mOutputSlotMap = new HashMap();
        int[] aSlotX = new int[]{12, 30, 48};
        int[] aSlotY = new int[]{5, 23, 41, 64};
        int aIndex = 0;
        for (y = 0; y < aSlotY.length; ++y) {
            for (x = 0; x < aSlotX.length; ++x) {
                mInputSlotMap.put(aIndex++, new Pair<Integer, Integer>(aSlotX[x], aSlotY[y]));
            }
        }
        aSlotX = new int[]{102, 120, 138};
        aIndex = 0;
        for (y = 0; y < aSlotY.length; ++y) {
            for (x = 0; x < aSlotX.length; ++x) {
                mOutputSlotMap.put(aIndex++, new Pair<Integer, Integer>(aSlotX[x], aSlotY[y]));
            }
        }
    }

    public class NoCellMultiDefaultRecipe
    extends CachedDefaultRecipe {
        public NoCellMultiDefaultRecipe(GT_Recipe aRecipe) {
            super(aRecipe);
        }

        @Override
        public void handleSlots() {
            ItemStack aRepStack;
            int y;
            int x;
            int i;
            int aInputItemsCount = this.mRecipe.mInputs.length;
            int aInputFluidsCount = this.mRecipe.mFluidInputs.length;
            int aOutputItemsCount = this.mRecipe.mOutputs.length;
            int aOutputFluidsCount = this.mRecipe.mFluidOutputs.length;
            int aInputSlotsUsed = 0;
            int aOutputSlotsUsed = 0;
            int aSlotToCheck = 0;
            if (this.mRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(this.mRecipe.mSpecialItems, 120, 52));
            }
            if (aInputItemsCount > 0) {
                if (aInputItemsCount > 9) {
                    aInputItemsCount = 9;
                }
                for (i = 0; i < aInputItemsCount; ++i) {
                    x = (Integer)((Pair)mInputSlotMap.get(aInputSlotsUsed)).getKey();
                    y = (Integer)((Pair)mInputSlotMap.get(aInputSlotsUsed)).getValue();
                    if ((aRepStack = this.mRecipe.getRepresentativeInput(aSlotToCheck++)) == null) continue;
                    this.mInputs.add(new FixedPositionedStack(aRepStack, x, y));
                    ++aInputSlotsUsed;
                }
            }
            aSlotToCheck = 0;
            if (aOutputItemsCount > 0) {
                if (aOutputItemsCount > 9) {
                    aOutputItemsCount = 9;
                }
                for (i = 0; i < aOutputItemsCount; ++i) {
                    x = (Integer)((Pair)mOutputSlotMap.get(aOutputSlotsUsed)).getKey();
                    y = (Integer)((Pair)mOutputSlotMap.get(aOutputSlotsUsed)).getValue();
                    aRepStack = this.mRecipe.getOutput(aSlotToCheck);
                    if (aRepStack != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRepStack, x, y, this.mRecipe.getOutputChance(aSlotToCheck)));
                        ++aOutputSlotsUsed;
                    }
                    ++aSlotToCheck;
                }
            }
            aSlotToCheck = aInputSlotsUsed;
            if (aInputFluidsCount > 0) {
                for (i = 0; i < aInputFluidsCount; ++i) {
                    x = (Integer)((Pair)mInputSlotMap.get(aSlotToCheck)).getKey();
                    y = (Integer)((Pair)mInputSlotMap.get(aSlotToCheck)).getValue();
                    this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[i], (boolean)true), x, y));
                    ++aSlotToCheck;
                    ++aInputSlotsUsed;
                }
            }
            aSlotToCheck = aOutputSlotsUsed;
            if (aOutputFluidsCount > 0) {
                for (i = 0; i < aOutputFluidsCount; ++i) {
                    x = (Integer)((Pair)mOutputSlotMap.get(aSlotToCheck)).getKey();
                    y = (Integer)((Pair)mOutputSlotMap.get(aSlotToCheck)).getValue();
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[i], (boolean)true), x, y));
                    ++aSlotToCheck;
                    ++aOutputSlotsUsed;
                }
            }
        }
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GT_Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public CachedDefaultRecipe(GT_Recipe aRecipe) {
            super((TemplateRecipeHandler)GTPP_NEI_DefaultHandler.this);
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            this.mRecipe = aRecipe;
            this.handleSlots();
        }

        public void handleSlots() {
            int tStartIndex = 0;
            switch (GTPP_NEI_DefaultHandler.this.mRecipeMap.mUsualInputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 23));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 32));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 30, 32));
                    }
                    if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 48, 32));
                    }
                    ++tStartIndex;
                }
            }
            if (this.mRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(this.mRecipe.mSpecialItems, 120, 52));
            }
            tStartIndex = 0;
            switch (GTPP_NEI_DefaultHandler.this.mRecipeMap.mUsualOutputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 23, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 23, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 23, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 23, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 5, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 23, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 23, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 23, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 32, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 32, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 32, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (this.mRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, -4, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 14, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 32, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 32, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    if (this.mRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 138, 32, this.mRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                }
            }
            if (this.mRecipe.mFluidInputs.length > 0 && this.mRecipe.mFluidInputs[0] != null && this.mRecipe.mFluidInputs[0].getFluid() != null) {
                this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[0], (boolean)true), 48, 52));
                if (this.mRecipe.mFluidInputs.length > 1 && this.mRecipe.mFluidInputs[1] != null && this.mRecipe.mFluidInputs[1].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[1], (boolean)true), 30, 52));
                }
            }
            if (this.mRecipe.mFluidOutputs.length > 1) {
                if (this.mRecipe.mFluidOutputs[0] != null && this.mRecipe.mFluidOutputs[0].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[0], (boolean)true), 120, 5));
                }
                if (this.mRecipe.mFluidOutputs[1] != null && this.mRecipe.mFluidOutputs[1].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[1], (boolean)true), 138, 5));
                }
                if (this.mRecipe.mFluidOutputs.length > 2 && this.mRecipe.mFluidOutputs[2] != null && this.mRecipe.mFluidOutputs[2].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[2], (boolean)true), 102, 23));
                }
                if (this.mRecipe.mFluidOutputs.length > 3 && this.mRecipe.mFluidOutputs[3] != null && this.mRecipe.mFluidOutputs[3].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[3], (boolean)true), 120, 23));
                }
                if (this.mRecipe.mFluidOutputs.length > 4 && this.mRecipe.mFluidOutputs[4] != null && this.mRecipe.mFluidOutputs[4].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[4], (boolean)true), 138, 23));
                }
            } else if (this.mRecipe.mFluidOutputs.length > 0 && this.mRecipe.mFluidOutputs[0] != null && this.mRecipe.mFluidOutputs[0].getFluid() != null) {
                this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[0], (boolean)true), 102, 52));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(GTPP_NEI_DefaultHandler.this.cycleticks / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public class FixedPositionedStack
    extends PositionedStack {
        public final int mChance;
        public boolean permutated;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            super(object, x, y, true);
            this.permutated = false;
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayList<ItemStack> tDisplayStacks = new ArrayList<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!GT_Utility.isStackValid((Object)tStack)) continue;
                if (tStack.func_77960_j() == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.func_77973_b());
                    if (!permutations.isEmpty()) {
                        for (ItemStack stack : permutations) {
                            tDisplayStacks.add(GT_Utility.copyAmount((long)tStack.field_77994_a, (Object[])new Object[]{stack}));
                        }
                        continue;
                    }
                    ItemStack base = new ItemStack(tStack.func_77973_b(), tStack.field_77994_a);
                    base.field_77990_d = tStack.field_77990_d;
                    tDisplayStacks.add(base);
                    continue;
                }
                tDisplayStacks.add(GT_Utility.copy((Object[])new Object[]{tStack}));
            }
            this.items = tDisplayStacks.toArray(new ItemStack[0]);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }

    @Deprecated
    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            return false;
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return false;
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        private boolean transferRect(GuiContainer gui, boolean usage) {
            return false;
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }
}

