/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.reflect;

import cpw.mods.fml.common.SidedProxy;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;

public class ProxyFinder {
    public static Object getServerProxy(Object modInstance) throws ReflectiveOperationException {
        for (Field field : modInstance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(SidedProxy.class)) continue;
            SidedProxy sidedProxy = field.getAnnotation(SidedProxy.class);
            Object fieldValue = field.get(modInstance);
            try {
                Class<?> serverSideClass = ReflectionUtils.getClass(sidedProxy.serverSide());
                if (serverSideClass.isAssignableFrom(fieldValue.getClass())) {
                    Object serverProxy2 = serverSideClass.cast(fieldValue);
                    return serverProxy2;
                }
                break;
            }
            catch (NoClassDefFoundError err) {
                return null;
            }
        }
        return null;
    }

    public static Object getClientProxy(Object modInstance) throws ReflectiveOperationException {
        for (Field field : modInstance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(SidedProxy.class)) continue;
            SidedProxy sidedProxy = field.getAnnotation(SidedProxy.class);
            Object fieldValue = field.get(modInstance);
            try {
                Class<?> clientSideClass = ReflectionUtils.getClass(sidedProxy.clientSide());
                if (clientSideClass.isAssignableFrom(fieldValue.getClass())) {
                    Object clientProxy2 = clientSideClass.cast(fieldValue);
                    return clientProxy2;
                }
                break;
            }
            catch (NoClassDefFoundError err) {
                return null;
            }
        }
        return null;
    }
}

