/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.reflect;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.internal.IGT_RecipeAdder;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class AddGregtechRecipe {
    public static boolean importPyroRecipe(GT_Recipe aRecipe) {
        int aModifiedTime = (int)((double)aRecipe.mDuration * 0.8);
        if (aRecipe.mInputs == null || aRecipe.mFluidInputs == null || aRecipe.mFluidOutputs == null || aRecipe.mOutputs == null) {
            return false;
        }
        if (aRecipe.mInputs.length > 2 || aRecipe.mFluidInputs.length > 1 || aRecipe.mFluidOutputs.length > 1 || aRecipe.mOutputs.length > 9) {
            return false;
        }
        if (aRecipe.mInputs.length <= 0) {
            return false;
        }
        int aCircuitNumber = -1;
        Item aCircuit = CI.getNumberedCircuit(1).func_77973_b();
        boolean hasCircuit = false;
        for (ItemStack a : aRecipe.mInputs) {
            if (a == null || a.func_77973_b() != aCircuit) continue;
            hasCircuit = true;
            aCircuitNumber = a.func_77960_j();
            break;
        }
        ItemStack aInputItem = null;
        if (!hasCircuit || aCircuitNumber < 1) {
            return false;
        }
        for (ItemStack a : aRecipe.mInputs) {
            if (a == null || a.func_77973_b() == aCircuit) continue;
            aInputItem = a;
            break;
        }
        return CORE.RA.addCokeOvenRecipe(aCircuitNumber, aInputItem, aRecipe.mFluidInputs, aRecipe.mFluidOutputs, aRecipe.mOutputs, aModifiedTime, aRecipe.mEUt);
    }

    public static boolean addCokeAndPyrolyseRecipes(ItemStack input1, int circuitNumber, FluidStack inputFluid1, ItemStack output1, FluidStack outputFluid1, int timeInSeconds, int euTick) {
        int TIME = timeInSeconds * 20;
        int TIMEPYRO = TIME + TIME / 5;
        CORE.RA.addCokeOvenRecipe(input1, ItemUtils.getGregtechCircuit(circuitNumber), inputFluid1, outputFluid1, output1, TIME, euTick);
        AddGregtechRecipe.PyrolyseOven(input1, inputFluid1, circuitNumber, output1, outputFluid1, TIMEPYRO, euTick);
        return false;
    }

    public static boolean PyrolyseOven(ItemStack p0, FluidStack p1, int p2, ItemStack p3, FluidStack p4, int p5, int p6) {
        try {
            IGT_RecipeAdder IGT_RecipeAdder2 = GT_Values.RA;
            if (IGT_RecipeAdder2 != null) {
                Class<?> classRA = IGT_RecipeAdder2.getClass();
                Method addRecipe = classRA.getMethod("addPyrolyseRecipe", ItemStack.class, FluidStack.class, Integer.TYPE, ItemStack.class, FluidStack.class, Integer.TYPE, Integer.TYPE);
                if (addRecipe != null) {
                    return (Boolean)addRecipe.invoke((Object)IGT_RecipeAdder2, p0, p1, p2, p3, p4, p5, p6);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return false;
        }
        return false;
    }

    public static boolean addAssemblylineRecipe(ItemStack aResearchItem, int aResearchTime, ItemStack[] aInputs, FluidStack[] aFluidInputs, ItemStack aOutput, int aDuration, int aEUt) {
        return false;
    }

    public static boolean addCircuitAssemblerRecipe(ItemStack[] aInputs, FluidStack aFluidInput, ItemStack aOutput, int aDuration, int aEUt) {
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            try {
                Class<?> classRA;
                Method addRecipe;
                IGT_RecipeAdder IGT_RecipeAdder2 = GT_Values.RA;
                if (IGT_RecipeAdder2 != null && (addRecipe = (classRA = IGT_RecipeAdder2.getClass()).getMethod("addCircuitAssemblerRecipe", ItemStack.class, FluidStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE)) != null) {
                    if (aFluidInput.isFluidEqual(FluidUtils.getFluidStack("molten.tin", 1))) {
                        boolean[] didAdd = new boolean[3];
                        FluidStack moltenMetal = FluidUtils.getFluidStack("molten.tin", 144);
                        didAdd[0] = (Boolean)addRecipe.invoke((Object)IGT_RecipeAdder2, aInputs, moltenMetal, aOutput, aDuration, aEUt);
                        moltenMetal = FluidUtils.getFluidStack("molten.lead", 144);
                        didAdd[1] = (Boolean)addRecipe.invoke((Object)IGT_RecipeAdder2, aInputs, moltenMetal, aOutput, aDuration, aEUt);
                        moltenMetal = FluidUtils.getFluidStack("molten.solderingalloy", 72);
                        didAdd[2] = (Boolean)addRecipe.invoke((Object)IGT_RecipeAdder2, aInputs, moltenMetal, aOutput, aDuration, aEUt);
                        return didAdd[0] && didAdd[1] && didAdd[2];
                    }
                    return (Boolean)addRecipe.invoke((Object)IGT_RecipeAdder2, aInputs, aFluidInput, aOutput, aDuration, aEUt);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean addChemicalRecipeForBasicMachineOnly(ItemStack p0, ItemStack p1, FluidStack p2, FluidStack p3, ItemStack p4, ItemStack p5, int p6, int p7) {
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            try {
                IGT_RecipeAdder IGT_RecipeAdder2 = GT_Values.RA;
                if (IGT_RecipeAdder2 != null) {
                    Class<?> classRA = IGT_RecipeAdder2.getClass();
                    Method addRecipe = classRA.getMethod("addChemicalRecipeForBasicMachineOnly", ItemStack.class, ItemStack.class, FluidStack.class, FluidStack.class, ItemStack.class, ItemStack.class, Integer.TYPE, Integer.TYPE);
                    if (addRecipe != null) {
                        return (Boolean)addRecipe.invoke((Object)IGT_RecipeAdder2, p0, p1, p2, p3, p4, p5, p6, p7);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return GT_Values.RA.addChemicalRecipe(p0, p1, p2, p3, p4, p6);
    }
}

