/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft.gregtech;

import gregtech.GT_Mod;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.common.GT_Pollution;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.item.base.cell.BaseItemCell;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class PollutionUtils {
    private static boolean mIsPollutionEnabled = true;
    public static AutoMap<FluidStack> mPollutionFluidStacks = new AutoMap();

    public static boolean isPollutionEnabled() {
        return mIsPollutionEnabled;
    }

    private static boolean mPollution() {
        return GT_Mod.gregtechproxy.mPollution;
    }

    public static boolean addPollution(IGregTechTileEntity te, int pollutionValue) {
        if (mIsPollutionEnabled) {
            GT_Pollution.addPollution((IGregTechTileEntity)te, (int)pollutionValue);
            return true;
        }
        return false;
    }

    public static boolean addPollution(IHasWorldObjectAndCoords aTileOfSomeSort, int pollutionValue) {
        if (mIsPollutionEnabled) {
            IHasWorldObjectAndCoords j = aTileOfSomeSort;
            Chunk c = j.getWorld().func_72938_d(j.getXCoord(), j.getZCoord());
            return PollutionUtils.addPollution(c, pollutionValue);
        }
        return false;
    }

    public static boolean addPollution(Chunk aChunk, int pollutionValue) {
        if (mIsPollutionEnabled) {
            GT_Pollution.addPollution((Chunk)aChunk, (int)pollutionValue);
            return true;
        }
        return false;
    }

    public static boolean removePollution(IGregTechTileEntity te, int pollutionValue) {
        return PollutionUtils.addPollution(te, -pollutionValue);
    }

    public static boolean removePollution(IHasWorldObjectAndCoords aTileOfSomeSort, int pollutionValue) {
        return PollutionUtils.addPollution(aTileOfSomeSort, -pollutionValue);
    }

    public static boolean removePollution(Chunk aChunk, int pollutionValue) {
        return PollutionUtils.addPollution(aChunk, -pollutionValue);
    }

    public static boolean nullifyPollution(IGregTechTileEntity te) {
        if (te == null) {
            return false;
        }
        return PollutionUtils.nullifyPollution((IHasWorldObjectAndCoords)te);
    }

    public static boolean nullifyPollution(IHasWorldObjectAndCoords aTileOfSomeSort) {
        if (aTileOfSomeSort == null) {
            return false;
        }
        IHasWorldObjectAndCoords j = aTileOfSomeSort;
        Chunk c = j.getWorld().func_72938_d(j.getXCoord(), j.getZCoord());
        return PollutionUtils.nullifyPollution(c);
    }

    public static boolean nullifyPollution(Chunk aChunk) {
        if (mIsPollutionEnabled) {
            if (aChunk == null) {
                return false;
            }
            int getCurrentPollution = PollutionUtils.getPollution(aChunk);
            if (getCurrentPollution <= 0) {
                return false;
            }
            return PollutionUtils.removePollution(aChunk, getCurrentPollution);
        }
        return false;
    }

    public static int getPollution(IGregTechTileEntity te) {
        return GT_Pollution.getPollution((IGregTechTileEntity)te);
    }

    public static int getPollution(Chunk te) {
        return GT_Pollution.getPollution((Chunk)te);
    }

    public static boolean setPollutionFluids() {
        if (mPollutionFluidStacks.isEmpty()) {
            FluidStack CD = FluidUtils.getFluidStack("carbondioxide", 1000);
            FluidStack CM = FluidUtils.getFluidStack("carbonmonoxide", 1000);
            FluidStack SD = FluidUtils.getFluidStack("sulfurdioxide", 1000);
            if (mPollutionFluidStacks.size() == 0) {
                ItemStack cellCD;
                if (CD != null) {
                    Logger.INFO("[PollutionCompat] Found carbon dioxide fluid, registering it.");
                    mPollutionFluidStacks.put(CD);
                    MISC_MATERIALS.CARBON_DIOXIDE.registerComponentForMaterial(CD);
                    cellCD = ItemUtils.getItemStackOfAmountFromOreDict("cellCarbonDioxide", 1);
                    if (ItemUtils.checkForInvalidItems(cellCD)) {
                        Logger.INFO("[PollutionCompat] Found carbon dioxide cell, registering component.");
                        MISC_MATERIALS.CARBON_DIOXIDE.registerComponentForMaterial(OrePrefixes.cell, cellCD);
                    } else {
                        Logger.INFO("[PollutionCompat] Did not find carbon dioxide cell, registering new component.");
                        new BaseItemCell(MISC_MATERIALS.CARBON_DIOXIDE);
                    }
                } else {
                    MaterialGenerator.generate(MISC_MATERIALS.CARBON_DIOXIDE, false, false);
                }
                if (CM != null) {
                    Logger.INFO("[PollutionCompat] Found carbon monoxide fluid, registering it.");
                    mPollutionFluidStacks.put(CM);
                    MISC_MATERIALS.CARBON_MONOXIDE.registerComponentForMaterial(CM);
                    cellCD = ItemUtils.getItemStackOfAmountFromOreDict("cellCarbonMonoxide", 1);
                    if (ItemUtils.checkForInvalidItems(cellCD)) {
                        Logger.INFO("[PollutionCompat] Found carbon monoxide cell, registering component.");
                        MISC_MATERIALS.CARBON_MONOXIDE.registerComponentForMaterial(OrePrefixes.cell, cellCD);
                    } else {
                        Logger.INFO("[PollutionCompat] Did not find carbon monoxide cell, registering new component.");
                        new BaseItemCell(MISC_MATERIALS.CARBON_MONOXIDE);
                    }
                } else {
                    MaterialGenerator.generate(MISC_MATERIALS.CARBON_MONOXIDE, false, false);
                }
                if (SD != null) {
                    Logger.INFO("[PollutionCompat] Found sulfur dioxide fluid, registering it.");
                    mPollutionFluidStacks.put(SD);
                }
            }
            return mPollutionFluidStacks.size() > 0;
        }
        if (mPollutionFluidStacks.size() != 3) {
            Logger.INFO("Unable to detect all 3 pollution fluids. Found: ");
            Logger.INFO(ArrayUtils.toString(mPollutionFluidStacks));
            return false;
        }
        return true;
    }

    static {
        mIsPollutionEnabled = CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK || CORE.GTNH ? PollutionUtils.mPollution() : false;
    }
}

