/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import codechicken.nei.api.API;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.base.BasicSpawnEgg;
import gtPlusPlus.core.item.base.dusts.BaseItemDustUnique;
import gtPlusPlus.core.item.base.dusts.decimal.BaseItemCentidust;
import gtPlusPlus.core.item.base.dusts.decimal.BaseItemDecidust;
import gtPlusPlus.core.item.base.plates.BaseItemPlate_OLD;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.item.tool.staballoy.MultiPickaxeBase;
import gtPlusPlus.core.item.tool.staballoy.MultiSpadeBase;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.LangUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.OreDictUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.xmod.gregtech.api.items.Gregtech_MetaTool;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_DustGeneration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;
    private static Map<Item, String> mModidCache = new HashMap<Item, String>();

    public static ItemStack getSimpleStack(Item x) {
        return ItemUtils.getSimpleStack(x, 1);
    }

    public static ItemStack getSimpleStack(Block x) {
        return ItemUtils.simpleMetaStack(Item.func_150898_a((Block)x), 0, 1);
    }

    public static ItemStack getSimpleStack(Block x, int i) {
        if (i == 0) {
            return ItemUtils.getSimpleStack(x, i, 1);
        }
        return ItemUtils.getSimpleStack(x, 0, i);
    }

    public static ItemStack getSimpleStack(Block x, int meta, int i) {
        return ItemUtils.simpleMetaStack(Item.func_150898_a((Block)x), meta, i);
    }

    public static ItemStack getSimpleStack(Item x, int i) {
        try {
            ItemStack r = new ItemStack(x, i);
            return r.func_77946_l();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ItemStack getSimpleStack(ItemStack x, int i) {
        try {
            ItemStack r = x.func_77946_l();
            r.field_77994_a = i;
            return r;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ItemStack getWildcardStack(Item x) {
        ItemStack y = new ItemStack(x, 1, Short.MAX_VALUE);
        return y;
    }

    public static ItemStack getWildcardStack(ItemStack x) {
        ItemStack y = ItemUtils.simpleMetaStack(x, Short.MAX_VALUE, 1);
        return y;
    }

    public static ItemStack getIC2Cell(String S) {
        ItemStack moreTemp = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cell" + S, 1);
        if (moreTemp == null) {
            boolean cellID = false;
            ItemStack temp = GT_ModHandler.getModItem((String)"IC2", (String)"itemCellEmpty", (long)1L, (int)0);
            return temp != null ? temp : null;
        }
        return moreTemp;
    }

    public static ItemStack getIC2Cell(int meta) {
        ItemStack temp = GT_ModHandler.getModItem((String)"IC2", (String)"itemCellEmpty", (long)1L, (int)meta);
        return temp != null ? temp : null;
    }

    public static ItemStack getEmptyCell() {
        return ItemUtils.getEmptyCell(1);
    }

    public static ItemStack getEmptyCell(int i) {
        if (ItemList.Cell_Empty.hasBeenSet()) {
            return ItemList.Cell_Empty.get((long)i, new Object[0]);
        }
        ItemStack temp = GT_ModHandler.getModItem((String)"IC2", (String)"itemCellEmpty", (long)i, (int)0);
        return temp != null ? temp : null;
    }

    public static void getItemForOreDict(String FQRN, String oreDictName, String itemName, int meta) {
        try {
            Item em = null;
            Item em1 = ItemUtils.getItemFromFQRN(FQRN);
            if (em1 != null) {
                em = em1;
            }
            if (em != null) {
                ItemStack metaStack = new ItemStack(em, 1, meta);
                GT_OreDictUnificator.registerOre((Object)oreDictName, (ItemStack)metaStack);
            }
        }
        catch (NullPointerException e) {
            Logger.ERROR(itemName + " not found. [NULL]");
        }
    }

    public static void addItemToOreDictionary(ItemStack stack, String oreDictName, boolean useWildcardMeta) {
        if (useWildcardMeta) {
            stack = ItemUtils.getWildcardStack(stack);
        }
        try {
            OreDictionary.registerOre((String)oreDictName, (ItemStack)stack);
        }
        catch (NullPointerException e) {
            Logger.ERROR(ItemUtils.getItemName(stack) + " not registered. [NULL]");
        }
    }

    public static void addItemToOreDictionary(ItemStack stack, String oreDictName) {
        ItemUtils.addItemToOreDictionary(stack, oreDictName, false);
    }

    public static ItemStack getItemStackWithMeta(boolean MOD, String FQRN, String itemName, int meta, int itemstackSize) {
        if (MOD) {
            try {
                Item em = null;
                Item em1 = ItemUtils.getItemFromFQRN(FQRN);
                if (em1 != null) {
                    if (null == em) {
                        em = em1;
                    }
                    if (em != null) {
                        ItemStack metaStack = new ItemStack(em, itemstackSize, meta);
                        return metaStack;
                    }
                }
                return null;
            }
            catch (NullPointerException e) {
                Logger.ERROR(itemName + " not found. [NULL]");
                return null;
            }
        }
        return null;
    }

    public static ItemStack simpleMetaStack(String FQRN, int meta, int itemstackSize) {
        try {
            Item em = null;
            Item em1 = ItemUtils.getItemFromFQRN(FQRN);
            if (em1 != null) {
                if (null == em) {
                    em = em1;
                }
                if (em != null) {
                    ItemStack metaStack = new ItemStack(em, itemstackSize, meta);
                    return metaStack;
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.ERROR(FQRN + " not found. [NULL]");
            return null;
        }
    }

    public static ItemStack simpleMetaStack(ItemStack simpleStack, int meta, int size) {
        return ItemUtils.simpleMetaStack(simpleStack.func_77973_b(), meta, size);
    }

    public static ItemStack simpleMetaStack(Item item, int meta, int size) {
        if (item == null) {
            return null;
        }
        if (meta < 0 || meta > Short.MAX_VALUE) {
            meta = 0;
        }
        if (size < 0 || size > 64) {
            size = 1;
        }
        ItemStack metaStack = new ItemStack(item, size, meta);
        return metaStack;
    }

    public static ItemStack simpleMetaStack(Block block, int meta, int size) {
        return ItemUtils.simpleMetaStack(Item.func_150898_a((Block)block), meta, size);
    }

    public static ItemStack getCorrectStacktype(String fqrn, int stackSize) {
        String oreDict = "ore:";
        if (fqrn.toLowerCase().contains("ore:".toLowerCase())) {
            String sanitizedName = fqrn.replace("ore:", "");
            ItemStack temp = ItemUtils.getItemStackFromFQRN(sanitizedName, stackSize);
            return temp;
        }
        String[] fqrnSplit = fqrn.split(":");
        String temp1 = fqrnSplit[1];
        String temp2 = fqrnSplit.length < 3 ? "0" : fqrnSplit[2];
        ItemStack temp = ItemUtils.getItemStackWithMeta(LoadedMods.MiscUtils, fqrn, temp1, Integer.parseInt(temp2), stackSize);
        return temp;
    }

    public static ItemStack getCorrectStacktype(Object item_Input, int stackSize) {
        if (item_Input instanceof String) {
            return ItemUtils.getItemStackOfAmountFromOreDictNoBroken((String)item_Input, stackSize);
        }
        if (item_Input instanceof ItemStack) {
            return (ItemStack)item_Input;
        }
        return null;
    }

    public static Item getItemFromFQRN(String fqrn) {
        String[] fqrnSplit = fqrn.split(":");
        return GameRegistry.findItem((String)fqrnSplit[0], (String)fqrnSplit[1]);
    }

    public static ItemStack getItemStackFromFQRN(String fqrn, int Size) {
        Logger.INFO("Trying to split string '" + fqrn + "'.");
        String[] fqrnSplit = fqrn.split(":");
        if (fqrnSplit.length < 2) {
            return null;
        }
        if (fqrnSplit.length == 2) {
            Logger.INFO("Mod: " + fqrnSplit[0] + ", Item: " + fqrnSplit[1]);
            return GameRegistry.findItemStack((String)fqrnSplit[0], (String)fqrnSplit[1], (int)Size);
        }
        if (fqrnSplit.length == 3 && fqrnSplit[2] != null && fqrnSplit[2].length() > 0) {
            Logger.INFO("Mod: " + fqrnSplit[0] + ", Item: " + fqrnSplit[1] + ", Meta: " + fqrnSplit[2]);
            ItemStack aStack = GameRegistry.findItemStack((String)fqrnSplit[0], (String)fqrnSplit[1], (int)Size);
            int aMeta = Integer.parseInt(fqrnSplit[2]);
            if (aStack != null && aMeta >= 0 && aMeta <= Short.MAX_VALUE) {
                return ItemUtils.simpleMetaStack(aStack, aMeta, Size);
            }
            Logger.INFO("Could not find instance of Item: " + fqrnSplit[1]);
        }
        return null;
    }

    public static void generateSpawnEgg(String entityModID, String parSpawnName, int colourEgg, int colourOverlay) {
        Item itemSpawnEgg = new BasicSpawnEgg(entityModID, parSpawnName, colourEgg, colourOverlay).func_77655_b("spawn_egg_" + parSpawnName.toLowerCase()).func_111206_d("miscutils:spawn_egg");
        GameRegistry.registerItem((Item)itemSpawnEgg, (String)("spawnEgg" + parSpawnName));
    }

    public static ItemStack[] validItemsForOreDict(String oredictName) {
        List<?> validNames = MaterialUtils.oreDictValuesForEntry(oredictName);
        ItemStack[] inputs = new ItemStack[validNames.size()];
        for (int i = 0; i < validNames.size(); ++i) {
            inputs[i] = (ItemStack)validNames.get(i);
        }
        return inputs;
    }

    public static ItemStack getItemStackOfAmountFromOreDict(String oredictName, int amount) {
        ArrayList oreDictList;
        String mTemp = oredictName;
        mTemp = oredictName.contains("-") || oredictName.contains("_") ? Utils.sanitizeString(mTemp, new char[]{'-', '_'}) : Utils.sanitizeString(mTemp);
        if (oredictName.contains("rod")) {
            String s;
            oredictName = s = "stick" + oredictName.substring(3);
        }
        if (oredictName.toLowerCase().contains("ingotclay")) {
            return ItemUtils.getSimpleStack(Items.field_151119_aD, amount);
        }
        if (!CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            if (oredictName.toLowerCase().contains("rutile")) {
                mTemp = oredictName.replace("Rutile", "Titanium");
            }
            if (oredictName.toLowerCase().contains("vanadiumsteel")) {
                mTemp = oredictName.replace("VanadiumSteel", "StainlessSteel");
            }
        }
        if (!(oreDictList = OreDictionary.getOres((String)mTemp)).isEmpty()) {
            ItemStack returnValue = ((ItemStack)oreDictList.get(0)).func_77946_l();
            returnValue.field_77994_a = amount;
            return returnValue;
        }
        Logger.INFO("Failed to find `" + oredictName + "` in OD.");
        return ItemUtils.getErrorStack(amount, oredictName + " x" + amount);
    }

    public static ItemStack getItemStackOfAmountFromOreDictNoBroken(String oredictName, int amount) {
        if (CORE_Preloader.DEBUG_MODE) {
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(1));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(2));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(3));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(4));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(5));
        }
        try {
            String MaterialName;
            Materials m;
            oredictName = oredictName.contains("-") || oredictName.contains("_") ? Utils.sanitizeString(oredictName, new char[]{'-', '_'}) : Utils.sanitizeString(oredictName);
            ItemStack returnValue = null;
            if (oredictName.toLowerCase().contains("dust") && (m = Materials.get((String)(MaterialName = oredictName.toLowerCase().replace("dust", "")))) != null && m != Materials._NULL && ItemUtils.checkForInvalidItems(returnValue = ItemUtils.getGregtechDust(m, amount))) {
                return returnValue;
            }
            if (returnValue == null && ItemUtils.checkForInvalidItems(returnValue = ItemUtils.getItemStackOfAmountFromOreDict(oredictName, amount))) {
                return returnValue.func_77946_l();
            }
            Logger.RECIPE(oredictName + " was not valid.");
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ItemStack getGregtechDust(Materials material, int amount) {
        ItemStack returnValue = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)material, (long)1L);
        if (returnValue != null && ItemUtils.checkForInvalidItems(returnValue)) {
            return returnValue.func_77946_l();
        }
        Logger.WARNING(material + " was not valid.");
        return null;
    }

    public static Item[] generateSpecialUseDusts(String unlocalizedName, String materialName, int Colour) {
        return ItemUtils.generateSpecialUseDusts(unlocalizedName, materialName, "NullFormula", Colour);
    }

    public static Item[] generateSpecialUseDusts(String unlocalizedName, String materialName, String mChemForm, int Colour) {
        Item[] output = new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, mChemForm, Colour, "Dust"), new BaseItemDustUnique("itemDustSmall" + unlocalizedName, materialName, mChemForm, Colour, "Small"), new BaseItemDustUnique("itemDustTiny" + unlocalizedName, materialName, mChemForm, Colour, "Tiny")};
        ItemStack normalDust = ItemUtils.getSimpleStack(output[0]);
        ItemStack smallDust = ItemUtils.getSimpleStack(output[1]);
        ItemStack tinyDust = ItemUtils.getSimpleStack(output[2]);
        CORE.RA.addpackagerRecipe(ItemList.Schematic_Dust.get(0L, new Object[0]), smallDust, tinyDust, normalDust);
        if (ItemUtils.checkForInvalidItems(tinyDust) && ItemUtils.checkForInvalidItems(normalDust)) {
            if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, normalDust)) {
                Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + materialName + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(normalDust, null, null, null, null, null, null, null, null, ItemUtils.getSimpleStack(tinyDust, 9))) {
                Logger.WARNING("9 Tiny dust from 1 Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("9 Tiny dust from 1 Recipe: " + materialName + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(smallDust) && ItemUtils.checkForInvalidItems(normalDust)) {
            if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, normalDust)) {
                Logger.WARNING("4 Small dust to 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("4 Small dust to 1 Dust Recipe: " + materialName + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(null, normalDust, null, null, null, null, null, null, null, ItemUtils.getSimpleStack(smallDust, 4))) {
                Logger.WARNING("4 Small dust from 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("4 Small dust from 1 Dust Recipe: " + materialName + " - Failed");
            }
        }
        return output;
    }

    public static Item generateSpecialUsePlate(String internalName, String displayName, short[] rgb, int radioactivity) {
        return ItemUtils.generateSpecialUsePlate(internalName, displayName, Utils.rgbtoHexValue(rgb[0], rgb[1], rgb[2]), radioactivity);
    }

    public static Item generateSpecialUsePlate(String internalName, String displayName, String mFormula, short[] rgb, int radioactivity) {
        return ItemUtils.generateSpecialUsePlate(internalName, displayName, mFormula, Utils.rgbtoHexValue(rgb[0], rgb[1], rgb[2]), radioactivity);
    }

    public static Item generateSpecialUsePlate(String internalName, String displayName, int rgb, int radioactivity) {
        return new BaseItemPlate_OLD(internalName, displayName, rgb, radioactivity);
    }

    public static Item generateSpecialUsePlate(String internalName, String displayName, String mFormula, int rgb, int radioactivity) {
        return new BaseItemPlate_OLD(internalName, displayName, mFormula, rgb, radioactivity);
    }

    public static Item[] generateSpecialUseDusts(Material material, boolean onlyLargeDust) {
        return ItemUtils.generateSpecialUseDusts(material, onlyLargeDust, false);
    }

    public static Item[] generateSpecialUseDusts(Material material, boolean onlyLargeDust, boolean disableExtraRecipes) {
        String materialName = material.getLocalizedName();
        String unlocalizedName = Utils.sanitizeString(materialName);
        int Colour = material.getRgbAsHex();
        String aChemForm = material.vChemicalFormula;
        boolean isChemFormvalid = aChemForm != null && aChemForm.length() > 0;
        Item[] output = null;
        output = !onlyLargeDust ? new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Dust"), new BaseItemDustUnique("itemDustSmall" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Small"), new BaseItemDustUnique("itemDustTiny" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Tiny")} : new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, Colour, "Dust")};
        new RecipeGen_DustGeneration(material, disableExtraRecipes);
        return output;
    }

    public static MultiPickaxeBase generateMultiPick(boolean GT_Durability, Materials material) {
        Item.ToolMaterial customMaterial = Utils.generateToolMaterialFromGT(material);
        byte enchantLevel = material.mEnchantmentToolsLevel;
        Pair<Enchantment, Integer> enchant = new Pair<Enchantment, Integer>(material.mEnchantmentTools, Integer.valueOf(enchantLevel));
        return ItemUtils.generateMultiPick(GT_Durability, customMaterial, material.mDefaultLocalName, material.mDurability, material.mRGBa, enchant);
    }

    public static MultiPickaxeBase generateMultiPick(Material material) {
        Item.ToolMaterial customMaterial = Utils.generateToolMaterial(material);
        return ItemUtils.generateMultiPick(true, customMaterial, material.getLocalizedName(), (int)material.vDurability, material.getRGBA(), null);
    }

    public static MultiPickaxeBase generateMultiPick(boolean GT_Durability, Item.ToolMaterial customMaterial, String name, int durability, short[] rgba, Object enchantment) {
        Logger.WARNING("Generating a Multi-Pick out of " + name);
        short[] rgb = rgba;
        int dur = customMaterial.func_77997_a();
        Logger.WARNING("Determined durability for " + name + " is " + dur);
        if (GT_Durability) {
            dur = durability * 100;
            Logger.WARNING("Using gregtech durability value, " + name + " is now " + dur + ".");
        } else if (dur <= 0) {
            dur = durability;
            Logger.WARNING("Determined durability too low, " + name + " is now " + dur + " based on the GT material durability.");
        }
        if (dur <= 0) {
            Logger.WARNING("Still too low, " + name + " will now go unused.");
            return null;
        }
        if (enchantment != null) {
            if (enchantment instanceof Pair) {
                Object enchant = enchantment;
            }
        } else {
            Object var8_9 = null;
        }
        MultiPickaxeBase MP_Redstone = new MultiPickaxeBase(name + " Multipick", customMaterial, dur, Utils.rgbtoHexValue(rgb[0], rgb[1], rgb[2]), enchantment);
        if (MP_Redstone.isValid) {
            return MP_Redstone;
        }
        Logger.WARNING("Pickaxe was not valid.");
        return null;
    }

    public static MultiSpadeBase generateMultiShovel(boolean GT_Durability, Materials material) {
        Item.ToolMaterial customMaterial = Utils.generateToolMaterialFromGT(material);
        return ItemUtils.generateMultiShovel(GT_Durability, customMaterial, material.mDefaultLocalName, material.mDurability, material.mRGBa);
    }

    public static MultiSpadeBase generateMultiShovel(Material material) {
        Item.ToolMaterial customMaterial = Utils.generateToolMaterial(material);
        return ItemUtils.generateMultiShovel(true, customMaterial, material.getLocalizedName(), (int)material.vDurability, material.getRGBA());
    }

    public static MultiSpadeBase generateMultiShovel(boolean GT_Durability, Item.ToolMaterial customMaterial, String name, int durability, short[] rgba) {
        Logger.WARNING("Generating a Multi-Spade out of " + name);
        short[] rgb = rgba;
        int dur = customMaterial.func_77997_a();
        Logger.WARNING("Determined durability for " + name + " is " + dur);
        if (GT_Durability) {
            dur = durability * 100;
            Logger.WARNING("Using gregtech durability value, " + name + " is now " + dur + ".");
        } else if (dur <= 0) {
            dur = durability;
            Logger.WARNING("Determined durability too low, " + name + " is now " + dur + " based on the GT material durability.");
        }
        if (dur <= 0) {
            Logger.WARNING("Still too low, " + name + " will now go unused.");
            return null;
        }
        MultiSpadeBase MP_Redstone = new MultiSpadeBase(name + " Multispade", customMaterial, dur, Utils.rgbtoHexValue(rgb[0], rgb[1], rgb[2]));
        if (MP_Redstone.isValid) {
            return MP_Redstone;
        }
        return null;
    }

    public static BaseItemDecidust generateDecidust(Materials material) {
        Material placeholder;
        if (GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)material, (long)1L) != null && (placeholder = MaterialUtils.generateMaterialFromGtENUM(material)) != null) {
            ItemUtils.generateDecidust(placeholder);
        }
        return null;
    }

    public static BaseItemDecidust generateDecidust(Material material) {
        if (material.getDust(1) != null && MaterialUtils.hasValidRGBA(material.getRGBA())) {
            BaseItemDecidust Decidust = new BaseItemDecidust(material);
            return Decidust;
        }
        return null;
    }

    public static BaseItemCentidust generateCentidust(Materials material) {
        Material placeholder;
        if (GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)material, (long)1L) != null && (placeholder = MaterialUtils.generateMaterialFromGtENUM(material)) != null) {
            ItemUtils.generateCentidust(placeholder);
        }
        return null;
    }

    public static BaseItemCentidust generateCentidust(Material material) {
        if (material.getDust(1) != null && MaterialUtils.hasValidRGBA(material.getRGBA())) {
            BaseItemCentidust Centidust = new BaseItemCentidust(material);
            return Centidust;
        }
        return null;
    }

    public static boolean isRadioactive(String materialName) {
        int sRadiation = 0;
        if (materialName.toLowerCase().contains("uranium")) {
            sRadiation = 2;
        } else if (materialName.toLowerCase().contains("plutonium")) {
            sRadiation = 4;
        } else if (materialName.toLowerCase().contains("thorium")) {
            sRadiation = 1;
        }
        return sRadiation >= 1;
    }

    public static int getRadioactivityLevel(String materialName) {
        int sRadiation = 0;
        if (materialName.toLowerCase().contains("uranium")) {
            sRadiation = 2;
        } else if (materialName.toLowerCase().contains("plutonium")) {
            sRadiation = 4;
        } else if (materialName.toLowerCase().contains("thorium")) {
            sRadiation = 1;
        }
        return sRadiation;
    }

    public static String getArrayStackNames(ArrayList<?> aStack) {
        Object aType = aStack.get(0);
        if (aType instanceof FluidStack) {
            FluidStack[] aItems = new FluidStack[aStack.size()];
            for (int i = 0; i < aItems.length; ++i) {
                aItems[i] = (FluidStack)aStack.get(i);
            }
            return ItemUtils.getArrayStackNames(aItems);
        }
        if (aType instanceof ItemStack) {
            ItemStack[] aItems = new ItemStack[aStack.size()];
            for (int i = 0; i < aItems.length; ++i) {
                aItems[i] = (ItemStack)aStack.get(i);
            }
            return ItemUtils.getArrayStackNames(aItems);
        }
        return "";
    }

    public static String getArrayStackNames(AutoMap<?> aStack) {
        Object aType = aStack.get(0);
        if (aType instanceof FluidStack) {
            FluidStack[] aItems = new FluidStack[aStack.size()];
            for (int i = 0; i < aItems.length; ++i) {
                aItems[i] = (FluidStack)aStack.get(i);
            }
            return ItemUtils.getArrayStackNames(aItems);
        }
        if (aType instanceof ItemStack) {
            ItemStack[] aItems = new ItemStack[aStack.size()];
            for (int i = 0; i < aItems.length; ++i) {
                aItems[i] = (ItemStack)aStack.get(i);
            }
            return ItemUtils.getArrayStackNames(aItems);
        }
        return "";
    }

    public static String getArrayStackNames(FluidStack[] aStack) {
        String itemNames = "Fluid Array: ";
        for (FluidStack alph : aStack) {
            String temp;
            if (alph != null) {
                temp = itemNames;
                itemNames = temp + ", " + alph.getLocalizedName() + " x" + alph.amount;
                continue;
            }
            temp = itemNames;
            itemNames = temp + ", null x0";
        }
        return itemNames;
    }

    public static String getArrayStackNames(ItemStack[] aStack) {
        String itemNames = "";
        int aPos = 0;
        for (ItemStack alph : aStack) {
            if (alph == null || alph == null) continue;
            String temp = itemNames;
            itemNames = temp + (aPos > 0 ? ", " : "") + alph.func_82833_r() + " x" + alph.field_77994_a;
            ++aPos;
        }
        return itemNames;
    }

    public static String[] getArrayStackNamesAsArray(ItemStack[] aStack) {
        String[] itemNames;
        String[] stringArray = itemNames = aStack == null ? new String[]{} : new String[aStack.length];
        if (aStack != null) {
            Logger.INFO("" + aStack.length);
        }
        if (aStack == null || aStack.length < 1) {
            return itemNames;
        }
        int arpos = 0;
        for (ItemStack alph : aStack) {
            if (alph == null) continue;
            try {
                itemNames[arpos] = alph.func_82833_r();
                ++arpos;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return itemNames;
    }

    public static String getFluidArrayStackNames(FluidStack[] aStack) {
        String itemNames = "Fluid Array: ";
        for (FluidStack alph : aStack) {
            String temp = itemNames;
            itemNames = temp + ", " + alph.getFluid().getName() + " x" + alph.amount;
        }
        return itemNames;
    }

    public static ItemStack getGregtechCircuit(int Meta) {
        return ItemUtils.getItemStackWithMeta(LoadedMods.Gregtech, "gregtech:gt.integrated_circuit", "Gregtech Circuit", Meta, 0);
    }

    public static ItemStack[] getBlockDrops(ArrayList<ItemStack> blockDrops) {
        if (blockDrops == null) {
            return null;
        }
        if (blockDrops.isEmpty()) {
            return null;
        }
        ItemStack[] outputs = new ItemStack[blockDrops.size()];
        int forCounter = 0;
        for (ItemStack I : blockDrops) {
            int n = forCounter;
            forCounter = (short)(forCounter + 1);
            outputs[n] = I;
        }
        return outputs;
    }

    private static String getModId(Item item) {
        if (mModidCache.containsKey(item)) {
            return mModidCache.get(item);
        }
        String value = "";
        try {
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)item);
            if (id != null) {
                String modname = id.modId == null ? id.name : id.modId;
                value = id == null || id.modId.equals("") ? "minecraft" : modname;
            }
        }
        catch (Throwable t) {
            try {
                GameRegistry.UniqueIdentifier t2 = GameRegistry.findUniqueIdentifierFor((Block)Block.func_149634_a((Item)item));
                if (t2 != null) {
                    String modname = t2.modId == null ? t2.name : t2.modId;
                    value = t2 == null || t2.modId.equals("") ? "minecraft" : modname;
                }
            }
            catch (Throwable t3) {
                t3.printStackTrace();
                value = "bad modid";
            }
        }
        if (!mModidCache.containsKey(item)) {
            return mModidCache.put(item, value);
        }
        return value;
    }

    public static String getModId(ItemStack key) {
        return ItemUtils.getModId(key.func_77973_b());
    }

    public static ItemStack getGregtechDust(String oredictName, int amount) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictName);
        if (!oreDictList.isEmpty()) {
            for (int xrc = 0; xrc < oreDictList.size(); ++xrc) {
                String modid = ItemUtils.getModId(((ItemStack)oreDictList.get(xrc)).func_77973_b());
                if (modid == null || !modid.equals("gregtech") && !modid.equals("miscutils")) continue;
                ItemStack returnvalue = ((ItemStack)oreDictList.get(xrc)).func_77946_l();
                returnvalue.field_77994_a = amount;
                return returnvalue;
            }
        }
        return ItemUtils.getNonTinkersDust(oredictName, amount);
    }

    public static ItemStack getNonTinkersDust(String oredictName, int amount) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictName);
        if (!oreDictList.isEmpty()) {
            for (int xrc = 0; xrc < oreDictList.size(); ++xrc) {
                String modid = ItemUtils.getModId(((ItemStack)oreDictList.get(xrc)).func_77973_b());
                if (modid == null || modid.equals("tconstruct")) continue;
                ItemStack returnvalue = ((ItemStack)oreDictList.get(xrc)).func_77946_l();
                returnvalue.field_77994_a = amount;
                return returnvalue;
            }
        }
        return ItemUtils.getItemStackOfAmountFromOreDictNoBroken(oredictName, amount);
    }

    @Deprecated
    public static ItemStack getGregtechOreStack(OrePrefixes mPrefix, Materials mMat, int mAmount) {
        ItemStack aTemp = ItemUtils.getOrePrefixStack(mPrefix, mMat, mAmount);
        if (aTemp != null) {
            return aTemp;
        }
        String mName = MaterialUtils.getMaterialName(mMat);
        String mItemName = mPrefix.name() + mName;
        ItemStack gregstack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken(mItemName, mAmount);
        if (gregstack == null) {
            return null;
        }
        return gregstack;
    }

    public static ItemStack getOrePrefixStack(OrePrefixes mPrefix, Material mMat, int mAmount) {
        String mName = Utils.sanitizeString(mMat.getLocalizedName());
        String mItemName = mPrefix.name() + mName;
        ItemStack gregstack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken(mItemName, mAmount);
        if (gregstack == null) {
            return null;
        }
        return gregstack;
    }

    public static ItemStack getOrePrefixStack(OrePrefixes mPrefix, Materials mMat, int mAmount) {
        ItemStack aGtStack;
        if (mPrefix == OrePrefixes.rod) {
            mPrefix = OrePrefixes.stick;
        }
        if ((aGtStack = GT_OreDictUnificator.get((OrePrefixes)mPrefix, (Object)mMat, (long)mAmount)) == null) {
            Logger.INFO("Failed to find `" + mPrefix + MaterialUtils.getMaterialName(mMat) + "` in OD. [Prefix Search]");
            return ItemUtils.getErrorStack(mAmount, mPrefix.toString() + MaterialUtils.getMaterialName(mMat) + " x" + mAmount);
        }
        return aGtStack;
    }

    public static ItemStack getErrorStack(int mAmount) {
        return ItemUtils.getErrorStack(mAmount, null);
    }

    public static ItemStack getErrorStack(int mAmount, String aName) {
        ItemStack g = ItemUtils.getSimpleStack(ModItems.AAA_Broken, 1);
        if (aName != null) {
            NBTUtils.setBookTitle(g, EnumChatFormatting.RED + aName);
        }
        return g;
    }

    public static ItemStack[] getStackOfAllOreDictGroup(String oredictname) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictname);
        if (!oreDictList.isEmpty()) {
            ItemStack[] returnValues = new ItemStack[oreDictList.size()];
            for (int i = 0; i < oreDictList.size(); ++i) {
                if (oreDictList.get(i) == null) continue;
                returnValues[i] = (ItemStack)oreDictList.get(i);
            }
            return returnValues.length > 0 ? returnValues : null;
        }
        return null;
    }

    public static boolean registerFuel(ItemStack aBurnable, int burn) {
        return CORE.burnables.add(new Pair<Integer, ItemStack>(burn, aBurnable));
    }

    public static String getLocalizedNameOfBlock(BlockPos pos) {
        Block block = pos.world.func_147439_a(pos.xPos, pos.yPos, pos.zPos);
        int metaData = pos.world.func_72805_g(pos.xPos, pos.yPos, pos.zPos);
        return LangUtils.getLocalizedNameOfBlock(block, metaData);
    }

    public static boolean checkForInvalidItems(ItemStack mInput) {
        return ItemUtils.checkForInvalidItems(new ItemStack[]{mInput});
    }

    public static boolean checkForInvalidItems(ItemStack[] mInput) {
        return ItemUtils.checkForInvalidItems(mInput, new ItemStack[0]);
    }

    public static boolean checkForInvalidItems(ItemStack[] mInputs, ItemStack[] mOutputs) {
        if (mInputs == null || mOutputs == null) {
            return false;
        }
        if (mInputs.length > 0) {
            for (ItemStack stack : mInputs) {
                if (stack != null) {
                    if (stack.func_77973_b() == null) continue;
                    if (stack.func_77973_b() == ModItems.AAA_Broken || stack.func_77973_b().getClass() == ModItems.AAA_Broken.getClass()) {
                        return false;
                    }
                    if (stack.func_77973_b() != ModItems.ZZZ_Empty && stack.func_77973_b().getClass() != ModItems.ZZZ_Empty.getClass()) continue;
                    return false;
                }
                return false;
            }
        }
        if (mOutputs.length > 0) {
            for (ItemStack stack : mOutputs) {
                if (stack != null) {
                    if (stack.func_77973_b() == null) continue;
                    if (stack.func_77973_b() == ModItems.AAA_Broken || stack.func_77973_b().getClass() == ModItems.AAA_Broken.getClass()) {
                        return false;
                    }
                    if (stack.func_77973_b() != ModItems.ZZZ_Empty && stack.func_77973_b().getClass() != ModItems.ZZZ_Empty.getClass()) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static IInventory organiseInventory(IInventory aInputInventory) {
        ItemStack[] p = new ItemStack[aInputInventory.func_70302_i_()];
        for (int o = 0; o < aInputInventory.func_70302_i_(); ++o) {
            p[o] = aInputInventory.func_70301_a(o);
        }
        IInventory aTemp = aInputInventory;
        for (int i = 0; i < p.length; ++i) {
            for (int j = i + 1; j < p.length; ++j) {
                if (p[j] == null || p[i] != null && !GT_Utility.areStacksEqual((ItemStack)p[i], (ItemStack)p[j])) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)aTemp, (IInventory)aTemp, (int)j, (int)i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
        return aTemp;
    }

    public static ItemStack[] organiseInventory(ItemStack[] aInputs) {
        int aInvSize = aInputs.length;
        ItemStack[] newArray = new ItemStack[aInvSize];
        for (int i = 0; i < aInvSize; ++i) {
            for (int i2 = 0; i2 < aInvSize; ++i2) {
                ItemStack[] t1;
                if (i == i2 || (t1 = new ItemStack[]{aInputs[i], aInputs[i2]})[0] == null || t1[1] == null || !GT_Utility.areStacksEqual((ItemStack)t1[0], (ItemStack)t1[1]) || !GT_Utility.areStacksEqual((ItemStack)t1[0], (ItemStack)t1[1])) continue;
                while (t1[0].field_77994_a < 64 && t1[1].field_77994_a > 0) {
                    ++t1[0].field_77994_a;
                    --t1[1].field_77994_a;
                    if (t1[1].field_77994_a <= 0) {
                        t1[1] = null;
                        break;
                    }
                    if (t1[0].field_77994_a != 64) continue;
                }
                newArray[i] = t1[1];
                newArray[i2] = t1[0];
            }
        }
        ItemStack[] newArray2 = new ItemStack[aInvSize];
        int count2 = 0;
        for (int i = 0; i < aInvSize; ++i) {
            if (newArray[i] == null) continue;
            newArray2[count2++] = newArray[i];
        }
        while (count2 < aInvSize) {
            newArray2[count2++] = null;
        }
        return newArray2;
    }

    public static String getFluidName(FluidStack aFluid) {
        return aFluid != null ? aFluid.getFluid().getLocalizedName(aFluid) : "NULL";
    }

    public static String getFluidName(Fluid aFluid) {
        return aFluid != null ? aFluid.getLocalizedName() : "NULL";
    }

    public static String getItemName(ItemStack aStack) {
        if (aStack == null) {
            return "ERROR - Empty Stack";
        }
        String aDisplay = null;
        try {
            NBTTagCompound nbttagcompound;
            aDisplay = ("" + StatCollector.func_74838_a((String)(aStack.func_77973_b().func_77657_g(aStack) + ".name"))).trim();
            if (aStack.func_77942_o() && aStack.field_77990_d != null && aStack.field_77990_d.func_150297_b("display", 10) && (nbttagcompound = aStack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
                aDisplay = nbttagcompound.func_74779_i("Name");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        aDisplay = aDisplay == null || aDisplay.length() <= 0 ? aStack.func_77977_a() + ":" + aStack.func_77960_j() : aDisplay + " | Meta: " + aStack.func_77960_j();
        return aDisplay;
    }

    public static String getUnlocalizedItemName(ItemStack aStack) {
        if (aStack == null) {
            return "ERROR.Empty.Stack";
        }
        String aDisplay = null;
        try {
            aDisplay = aStack.func_77977_a().trim();
        }
        catch (Throwable t) {
            aDisplay = aStack.func_77973_b().func_77658_a();
        }
        if (aDisplay == null || aDisplay.length() <= 0) {
            aDisplay = aStack.func_77973_b().func_77657_g(aStack);
        }
        return aDisplay;
    }

    public static boolean isItemGregtechTool(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        Item mItem = aStack.func_77973_b();
        Item aSkookum = ItemUtils.getItemFromFQRN("miscutils:gt.plusplus.metatool.01");
        Class<?> aSkookClass = aSkookum.getClass();
        return aSkookClass.isInstance(mItem) || mItem instanceof GT_MetaGenerated_Tool_01 || mItem instanceof MetaGeneratedGregtechTools || mItem instanceof Gregtech_MetaTool || mItem == aSkookum;
    }

    public static boolean isToolWrench(ItemStack aWrench) {
        return ItemUtils.isItemGregtechTool(aWrench) && (aWrench.func_77960_j() == 16 || aWrench.func_77960_j() == 120 || aWrench.func_77960_j() == 122 || aWrench.func_77960_j() == 124 || aWrench.func_77960_j() == 7734);
    }

    public static boolean isToolMallet(ItemStack aMallet) {
        return ItemUtils.isItemGregtechTool(aMallet) && aMallet.func_77960_j() == 14;
    }

    public static boolean isToolScrewdriver(ItemStack aScrewdriver) {
        return ItemUtils.isItemGregtechTool(aScrewdriver) && (aScrewdriver.func_77960_j() == 22 || aScrewdriver.func_77960_j() == 150);
    }

    public static boolean isToolCrowbar(ItemStack aCrowbar) {
        return ItemUtils.isItemGregtechTool(aCrowbar) && aCrowbar.func_77960_j() == 20;
    }

    public static boolean isToolWirecutters(ItemStack aWirecutters) {
        return ItemUtils.isItemGregtechTool(aWirecutters) && aWirecutters.func_77960_j() == 26;
    }

    public static boolean isToolHammer(ItemStack aHammer) {
        return ItemUtils.isItemGregtechTool(aHammer) && (aHammer.func_77960_j() == 12 || aHammer.func_77960_j() == 7734);
    }

    public static boolean isToolSolderingIron(ItemStack aSoldering) {
        return ItemUtils.isItemGregtechTool(aSoldering) && aSoldering.func_77960_j() == 160;
    }

    public static ItemStack[] cleanItemStackArray(ItemStack[] input) {
        int aArraySize = input.length;
        ItemStack[] aOutput = new ItemStack[aArraySize];
        AutoMap<ItemStack> aCleanedItems = new AutoMap<ItemStack>();
        for (ItemStack checkStack : input) {
            if (!ItemUtils.checkForInvalidItems(checkStack)) continue;
            aCleanedItems.put(checkStack);
        }
        for (int i = 0; i < aArraySize; ++i) {
            ItemStack aMappedStack = (ItemStack)aCleanedItems.get(i);
            if (aMappedStack == null) continue;
            aOutput[i] = aMappedStack;
        }
        return aOutput;
    }

    public static ItemStack getEnchantedBook(Enchantment aEnch, int aLevel) {
        return ItemUtils.enchantItem(new ItemStack((Item)Items.field_151134_bR), aEnch, aLevel);
    }

    public static ItemStack enchantItem(ItemStack aStack, Enchantment aEnch, int aLevel) {
        Items.field_151134_bR.func_92115_a(aStack, new EnchantmentData(aEnch, aLevel));
        return aStack;
    }

    public static boolean doesOreDictHaveEntryFor(String string) {
        return OreDictUtils.containsValidEntries(string);
    }

    public static void hideItemFromNEI(ItemStack aItemToHide) {
        API.hideItem((ItemStack)aItemToHide);
    }

    public static ItemStack getNullStack() {
        return GT_Values.NI;
    }

    public static ItemStack depleteStack(ItemStack aStack) {
        return ItemUtils.depleteStack(aStack, 1);
    }

    public static ItemStack depleteStack(ItemStack aStack, int aAmount) {
        int cap = aStack.field_77994_a;
        if (cap >= 1 && cap >= aAmount) {
            ItemStack aDepStack = aStack.func_77946_l();
            aDepStack.field_77994_a = MathUtils.balance(aDepStack.field_77994_a - 1, 0, 64);
            if (aDepStack.field_77994_a > 0) {
                return aDepStack;
            }
        }
        return ItemUtils.getNullStack();
    }

    public static boolean isControlCircuit(ItemStack aStack) {
        Item aItem;
        return aStack != null && ((aItem = aStack.func_77973_b()) == CI.getNumberedBioCircuit(0).func_77973_b() || aItem == CI.getNumberedCircuit(0).func_77973_b() || aItem == CI.getNumberedAdvancedCircuit(0).func_77973_b());
    }

    public static boolean isCatalyst(ItemStack aStack) {
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mBlueCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mBrownCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mOrangeCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mPurpleCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mRedCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mYellowCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mPinkCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mFormaldehydeCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mSolidAcidCatalyst, (boolean)true)) {
            return true;
        }
        return GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)AgriculturalChem.mGreenCatalyst, (boolean)true);
    }

    public static boolean isMillingBall(ItemStack aStack) {
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mMillingBallAlumina, (boolean)true)) {
            return true;
        }
        return GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mMillingBallSoapstone, (boolean)true);
    }

    public static String getLocalizedNameOfBlock(Block aBlock, int aMeta) {
        return LangUtils.getLocalizedNameOfBlock(aBlock, aMeta);
    }

    public static boolean doesItemListEntryExist(String string) {
        ItemList[] aListValues;
        for (ItemList aItem : aListValues = (ItemList[])ItemList.class.getEnumConstants()) {
            if (aItem == null || !aItem.name().equals(string) && !aItem.name().toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static ItemList getValueOfItemList(String string, ItemList aOther) {
        ItemList[] aListValues;
        for (ItemList aItem : aListValues = (ItemList[])ItemList.class.getEnumConstants()) {
            if (aItem == null || !aItem.name().equals(string) && !aItem.name().toLowerCase().equals(string.toLowerCase())) continue;
            return aItem;
        }
        Logger.INFO("Tried to obtain '" + string + "' from the GT ItemList, however it does not exist.");
        if (aOther != null) {
            Logger.INFO("Using fallback option instead - " + aOther.name());
        }
        return aOther;
    }

    public static ItemStack getValueOfItemList(String string, int aAmount, ItemList aOther) {
        return ItemUtils.getValueOfItemList(string, aOther).get((long)aAmount, new Object[0]);
    }

    public static ItemStack getValueOfItemList(String string, int aAmount, ItemStack aOther) {
        ItemList[] aListValues;
        for (ItemList aItem : aListValues = (ItemList[])ItemList.class.getEnumConstants()) {
            if (aItem == null || !aItem.name().equals(string) && !aItem.name().toLowerCase().equals(string.toLowerCase())) continue;
            return aItem.get((long)aAmount, new Object[0]);
        }
        Logger.INFO("Tried to obtain '" + string + "' from the GT ItemList, however it does not exist.");
        if (aOther != null) {
            Logger.INFO("Using fallback option instead - " + ItemUtils.getItemName(aOther));
        }
        return aOther;
    }

    public static boolean areItemsEqual(ItemStack aStack1, ItemStack aStack2) {
        return ItemUtils.areItemsEqual(aStack1, aStack2, true);
    }

    public static boolean areItemsEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return GT_Utility.areStacksEqual((ItemStack)aStack1, (ItemStack)aStack2, (boolean)aIgnoreNBT);
    }
}

