/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.GregTech_API;
import gregtech.api.objects.GT_HashSet;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.EnergyUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import ic2.core.Ic2Items;
import ic2.core.item.armor.ItemArmorHazmat;
import ic2.core.item.armor.ItemArmorNanoSuit;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class HazmatUtils {
    public static final GT_HashSet<GT_ItemStack> sHazmatList = new GT_HashSet();
    private static final HashMap<String, AutoMap<String>> mToolTips = new HashMap();
    private static boolean mInit = false;
    private static HazmatUtils mInstance;
    private static final String mToolTipText = "Provides protection from:";

    public static void init() {
        if (mInit) {
            return;
        }
    }

    public static void doInit() {
        Class<?> aItemsTaintedMagic;
        AutoMap<ItemStack> aItemMap;
        Item aItemObject;
        Class<?> aItemsEMT;
        AutoMap<Field> aItemFields;
        mInstance = new HazmatUtils();
        sHazmatList.add(ItemUtils.getSimpleStack(Ic2Items.hazmatHelmet, 1));
        sHazmatList.add(ItemUtils.getSimpleStack(Ic2Items.hazmatChestplate, 1));
        sHazmatList.add(ItemUtils.getSimpleStack(Ic2Items.hazmatLeggings, 1));
        sHazmatList.add(ItemUtils.getSimpleStack(Ic2Items.hazmatBoots, 1));
        if (LoadedMods.IndustrialCraft2 || LoadedMods.IndustrialCraft2Classic) {
            AutoMap<ItemStack> aVanillaIC2Armour = new AutoMap<ItemStack>();
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.nanoHelmet, 1));
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.nanoBodyarmor, 1));
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.nanoLeggings, 1));
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.nanoBoots, 1));
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.quantumHelmet, 1));
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.quantumBodyarmor, 1));
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.quantumLeggings, 1));
            aVanillaIC2Armour.add(ItemUtils.getSimpleStack(Ic2Items.quantumBoots, 1));
            for (ItemStack aItem : aVanillaIC2Armour) {
                HazmatUtils.addProtection(aItem);
            }
            Logger.INFO("[Hazmat] Registered IC2 Items as hazmat gear.");
        }
        if (LoadedMods.isModLoaded("EMT")) {
            aItemFields = new AutoMap<Field>();
            aItemsEMT = ReflectionUtils.getClass("emt.init.EMTItems");
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "nanoThaumicHelmet"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "nanoWing"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "nanoBootsTraveller"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "quantumThaumicHelmet"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "quantumWing"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "quantumArmor"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "quantumBootsTraveller"));
            AutoMap<ItemStack> aEMT = new AutoMap<ItemStack>();
            for (Field aItemField : aItemFields) {
                aItemObject = null;
                if (aItemField != null) {
                    try {
                        aItemObject = (Item)aItemField.get(null);
                    }
                    catch (Exception t) {
                        t.printStackTrace();
                    }
                }
                if (aItemObject != null) {
                    aEMT.add(ItemUtils.getSimpleStack(aItemObject));
                    continue;
                }
                Logger.INFO("[Hazmat] Could not get " + aItemField.getName() + " from " + aItemsEMT.getName());
            }
            Logger.INFO("[Hazmat] Registering " + aEMT.size() + " EMT Items as hazmat gear.");
            for (ItemStack aItem : aEMT) {
                HazmatUtils.addProtection(aItem);
            }
            Logger.INFO("[Hazmat] Registered EMT Items as hazmat gear.");
        }
        if (LoadedMods.isModLoaded("DraconicEvolution")) {
            aItemFields = new AutoMap();
            Class<?> aItemsDE = ReflectionUtils.getClass("com.brandon3055.draconicevolution.ModItems");
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "draconicHelm"));
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "draconicChest"));
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "draconicLeggs"));
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "draconicBoots"));
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "wyvernHelm"));
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "wyvernChest"));
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "wyvernLeggs"));
            aItemFields.add(ReflectionUtils.getField(aItemsDE, "wyvernBoots"));
            aItemMap = new AutoMap();
            for (Field aItemField : aItemFields) {
                aItemObject = null;
                if (aItemField != null) {
                    try {
                        aItemObject = (Item)aItemField.get(null);
                    }
                    catch (Exception t) {
                        t.printStackTrace();
                    }
                }
                if (aItemObject != null) {
                    aItemMap.add(ItemUtils.getSimpleStack(aItemObject));
                    continue;
                }
                Logger.INFO("[Hazmat] Could not get " + aItemField.getName() + " from " + aItemsDE.getName());
            }
            Logger.INFO("[Hazmat] Registering " + aItemMap.size() + " Draconic Evolution Items as hazmat gear.");
            for (ItemStack aItem : aItemMap) {
                HazmatUtils.addProtection(aItem);
            }
            Logger.INFO("[Hazmat] Registered Draconic Evolution Items as hazmat gear.");
        }
        if (LoadedMods.isModLoaded("TaintedMagic")) {
            aItemFields = new AutoMap();
            aItemsTaintedMagic = ReflectionUtils.getClass("taintedmagic.common.registry.ItemRegistry");
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemShadowFortressHelmet"));
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemShadowFortressChestplate"));
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemShadowFortressLeggings"));
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemVoidwalkerBoots"));
            aItemMap = new AutoMap<ItemStack>();
            for (Field aItemField : aItemFields) {
                aItemObject = null;
                if (aItemField != null) {
                    try {
                        aItemObject = (Item)aItemField.get(null);
                    }
                    catch (Exception t) {
                        t.printStackTrace();
                    }
                }
                if (aItemObject != null) {
                    aItemMap.add(ItemUtils.getSimpleStack(aItemObject));
                    continue;
                }
                Logger.INFO("[Hazmat] Could not get " + aItemField.getName() + " from " + aItemsTaintedMagic.getName());
            }
            Logger.INFO("[Hazmat] Registering " + aItemMap.size() + " Tainted Magic Items as hazmat gear.");
            for (ItemStack aItem : aItemMap) {
                HazmatUtils.addProtection(aItem);
            }
            Logger.INFO("[Hazmat] Registered Tainted Magic Items as hazmat gear.");
        }
        if (LoadedMods.isModLoaded("WitchingGadgets")) {
            aItemFields = new AutoMap();
            aItemsTaintedMagic = ReflectionUtils.getClass("witchinggadgets.common.WGContent");
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemPrimordialHelm"));
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemPrimordialChest"));
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemPrimordialLegs"));
            aItemFields.add(ReflectionUtils.getField(aItemsTaintedMagic, "ItemPrimordialBoots"));
            aItemMap = new AutoMap();
            for (Field aItemField : aItemFields) {
                aItemObject = null;
                if (aItemField != null) {
                    try {
                        aItemObject = (Item)aItemField.get(null);
                    }
                    catch (Exception t) {
                        t.printStackTrace();
                    }
                }
                if (aItemObject != null) {
                    aItemMap.add(ItemUtils.getSimpleStack(aItemObject));
                    continue;
                }
                Logger.INFO("[Hazmat] Could not get " + aItemField.getName() + " from " + aItemsTaintedMagic.getName());
            }
            Logger.INFO("[Hazmat] Registering " + aItemMap.size() + " Witching Gadgets Items as hazmat gear.");
            for (ItemStack aItem : aItemMap) {
                HazmatUtils.addProtection(aItem);
            }
            Logger.INFO("[Hazmat] Registered Witching Gadgets Items as hazmat gear.");
        }
        if (LoadedMods.isModLoaded("ThaumicTinkerer")) {
            Logger.INFO("[Hazmat] Did not register Thaumic Tinkerer Items as hazmat gear.");
        }
        if (LoadedMods.isModLoaded("GraviSuite")) {
            aItemFields = new AutoMap();
            Class<?> aItemsGravisuite = ReflectionUtils.getClass("gravisuite.GraviSuite");
            aItemFields.add(ReflectionUtils.getField(aItemsGravisuite, "advNanoChestPlate"));
            aItemFields.add(ReflectionUtils.getField(aItemsGravisuite, "graviChestPlate"));
            AutoMap<ItemStack> aGravisuite = new AutoMap<ItemStack>();
            for (Field aItemField : aItemFields) {
                aItemObject = (Item)ReflectionUtils.getFieldValue(aItemField);
                if (aItemObject == null) continue;
                aGravisuite.add(ItemUtils.getSimpleStack(aItemObject));
            }
            Logger.INFO("[Hazmat] Registering " + aGravisuite.size() + " Gravisuit Items as hazmat gear.");
            for (ItemStack aItem : aGravisuite) {
                HazmatUtils.addProtection(aItem);
            }
            Logger.INFO("[Hazmat] Registered Gravisuit Items as hazmat gear.");
        }
        if (LoadedMods.isModLoaded("AdvancedSolarPanel")) {
            aItemFields = new AutoMap();
            aItemsEMT = ReflectionUtils.getClass("advsolar.common.AdvancedSolarPanel");
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "advancedSolarHelmet"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "hybridSolarHelmet"));
            aItemFields.add(ReflectionUtils.getField(aItemsEMT, "ultimateSolarHelmet"));
            AutoMap<ItemStack> aASP = new AutoMap<ItemStack>();
            for (Field aItemField : aItemFields) {
                aItemObject = (Item)ReflectionUtils.getFieldValue(aItemField);
                if (aItemObject == null) continue;
                aASP.add(ItemUtils.getSimpleStack(aItemObject));
            }
            Logger.INFO("[Hazmat] Registering " + aASP.size() + " Adv. Solar Items as hazmat gear.");
            for (ItemStack aItem : aASP) {
                HazmatUtils.addProtection(aItem);
            }
            Logger.INFO("[Hazmat] Registered Adv. Solar Items as hazmat gear.");
        }
        Utils.registerEvent(mInstance);
        Logger.INFO("[Hazmat] Registered Tooltip handler for hazmat gear.");
        mInit = true;
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
            if (event.itemStack == null || HazmatUtils.isVanillaHazmatPiece(event.itemStack)) {
                return;
            }
            ItemStack aStackTemp = event.itemStack;
            GT_ItemStack aStack = new GT_ItemStack(aStackTemp);
            if (HazmatUtils.isNanoArmourPiece(aStackTemp) || HazmatUtils.isQuantumArmourPiece(aStackTemp)) {
                event.toolTip.add(EnumChatFormatting.DARK_PURPLE + "Provides full hazmat protection.");
            } else {
                String[] aTooltips = HazmatUtils.getTooltips(aStack);
                if (aTooltips == null || aTooltips.length == 0) {
                    return;
                }
                if (HazmatUtils.providesProtection(aStackTemp)) {
                    event.toolTip.add(EnumChatFormatting.LIGHT_PURPLE + "Provides full hazmat protection.");
                } else {
                    event.toolTip.add(mToolTipText);
                    for (String r : aTooltips) {
                        event.toolTip.add(" - " + r);
                    }
                }
            }
        }
    }

    public static boolean hasCompleteHazmat(EntityLivingBase living) {
        if (living == null || living.field_70128_L) {
            return false;
        }
        AutoMap<ItemStack> aEquipment = new AutoMap<ItemStack>();
        for (int i = 1; i < 5; ++i) {
            ItemStack stack = living.func_71124_b(i);
            if (stack == null) {
                return false;
            }
            aEquipment.put(stack);
        }
        for (ItemStack aSlotStack : aEquipment) {
            if (HazmatUtils.isHazmatPiece(aSlotStack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVanillaHazmatPiece(ItemStack aArmour) {
        return aArmour != null ? aArmour.func_77973_b() instanceof ItemArmorHazmat : false;
    }

    public static boolean isNanoArmourPiece(ItemStack aArmour) {
        return aArmour != null ? aArmour.func_77973_b() instanceof ItemArmorNanoSuit : false;
    }

    public static boolean isQuantumArmourPiece(ItemStack aArmour) {
        return aArmour != null ? aArmour.func_77973_b() instanceof ItemArmorQuantumSuit : false;
    }

    public static boolean isHazmatPiece(ItemStack aStack) {
        return HazmatUtils.isVanillaHazmatPiece(aStack) || HazmatUtils.providesProtection(aStack);
    }

    public static boolean addProtection(ItemStack aVanStack) {
        if (!ItemUtils.checkForInvalidItems(aVanStack)) {
            Logger.INFO("=================Bad Hazmat Addition======================");
            Logger.INFO("Called from: " + ReflectionUtils.getMethodName(0));
            Logger.INFO(ReflectionUtils.getMethodName(1));
            Logger.INFO(ReflectionUtils.getMethodName(2));
            Logger.INFO(ReflectionUtils.getMethodName(3));
            Logger.INFO(ReflectionUtils.getMethodName(4));
            Logger.INFO(ReflectionUtils.getMethodName(5));
            Logger.INFO(ReflectionUtils.getMethodName(6));
            Logger.INFO("==========================================================");
            return false;
        }
        Logger.INFO("[Hazmat] Registering " + ItemUtils.getItemName(aVanStack) + " for full Hazmat protection.");
        GT_ItemStack aStack = HazmatUtils.getGtStackFromVanilla(aVanStack);
        AutoMap<Boolean> aAdded = new AutoMap<Boolean>();
        aAdded.put(HazmatUtils.addProtection_Frost(aStack));
        aAdded.put(HazmatUtils.addProtection_Fire(aStack));
        aAdded.put(HazmatUtils.addProtection_Biohazard(aStack));
        aAdded.put(HazmatUtils.addProtection_Gas(aStack));
        aAdded.put(HazmatUtils.addProtection_Radiation(aStack));
        aAdded.put(HazmatUtils.addProtection_Electricty(aStack));
        Iterator iterator = aAdded.iterator();
        while (iterator.hasNext()) {
            boolean b = (Boolean)iterator.next();
            if (b) continue;
            return false;
        }
        Logger.INFO("[Hazmat] Protection added for all 6 damage types, registering to master Hazmat list.");
        sHazmatList.add(aStack);
        return true;
    }

    public static boolean addProtection_Frost(GT_ItemStack aStack) {
        HazmatUtils.registerTooltip(aStack, EnumChatFormatting.AQUA + "Frost");
        return HazmatUtils.addProtection_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sFrostHazmatList, aStack);
    }

    public static boolean addProtection_Fire(GT_ItemStack aStack) {
        HazmatUtils.registerTooltip(aStack, EnumChatFormatting.DARK_RED + "Heat");
        return HazmatUtils.addProtection_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sHeatHazmatList, aStack);
    }

    public static boolean addProtection_Biohazard(GT_ItemStack aStack) {
        HazmatUtils.registerTooltip(aStack, EnumChatFormatting.GREEN + "Biohazards");
        return HazmatUtils.addProtection_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sBioHazmatList, aStack);
    }

    public static boolean addProtection_Gas(GT_ItemStack aStack) {
        HazmatUtils.registerTooltip(aStack, EnumChatFormatting.WHITE + "Gas");
        return HazmatUtils.addProtection_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sGasHazmatList, aStack);
    }

    public static boolean addProtection_Radiation(GT_ItemStack aStack) {
        HazmatUtils.registerTooltip(aStack, EnumChatFormatting.DARK_GREEN + "Radiation");
        return HazmatUtils.addProtection_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sRadioHazmatList, aStack);
    }

    public static boolean addProtection_Electricty(GT_ItemStack aStack) {
        HazmatUtils.registerTooltip(aStack, EnumChatFormatting.YELLOW + "Electricity");
        return HazmatUtils.addProtection_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sElectroHazmatList, aStack);
    }

    private static boolean addProtection_Generic(GT_HashSet<GT_ItemStack> aSet, GT_ItemStack aStack) {
        int aMapSize = aSet.size();
        aSet.add(aStack);
        return aMapSize < aSet.size();
    }

    public static boolean providesProtection(ItemStack aStack) {
        return HazmatUtils.providesProtetion_Generic(sHazmatList, aStack);
    }

    public static boolean providesProtetion_Frost(ItemStack aStack) {
        return HazmatUtils.providesProtetion_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sFrostHazmatList, aStack);
    }

    public static boolean providesProtetion_Fire(ItemStack aStack) {
        return HazmatUtils.providesProtetion_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sHeatHazmatList, aStack);
    }

    public static boolean providesProtetion_Biohazard(ItemStack aStack) {
        return HazmatUtils.providesProtetion_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sBioHazmatList, aStack);
    }

    public static boolean providesProtetion_Gas(ItemStack aStack) {
        return HazmatUtils.providesProtetion_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sGasHazmatList, aStack);
    }

    public static boolean providesProtetion_Radiation(ItemStack aStack) {
        return HazmatUtils.providesProtetion_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sRadioHazmatList, aStack);
    }

    public static boolean providesProtetion_Electricity(ItemStack aStack) {
        return HazmatUtils.providesProtetion_Generic((GT_HashSet<GT_ItemStack>)GregTech_API.sElectroHazmatList, aStack);
    }

    private static boolean providesProtetion_Generic(GT_HashSet<GT_ItemStack> aSet, ItemStack aStack) {
        if (HazmatUtils.isVanillaHazmatPiece(aStack)) {
            return true;
        }
        for (GT_ItemStack o : aSet) {
            if (o == null || o.mItem == null || aStack == null || aStack.func_77973_b() == null) continue;
            if (GT_Utility.areStacksEqual((ItemStack)o.toStack(), (ItemStack)aStack, (boolean)true)) {
                return true;
            }
            if (o.isStackEqual(aStack)) {
                return true;
            }
            if (o.mItem != aStack.func_77973_b() || !EnergyUtils.EU.isElectricItem(aStack)) continue;
            return true;
        }
        return false;
    }

    private static String[] getTooltips(GT_ItemStack aStack) {
        String aKey = HazmatUtils.convertGtItemstackToStringDataIgnoreDamage(aStack);
        AutoMap<String> aTempTooltipData = mToolTips.get(aKey);
        if (aTempTooltipData == null || aTempTooltipData.isEmpty()) {
            return new String[0];
        }
        String[] mBuiltOutput = new String[aTempTooltipData.size()];
        int aIndex = 0;
        for (String i : aTempTooltipData) {
            mBuiltOutput[aIndex++] = i;
        }
        return mBuiltOutput;
    }

    private static void registerTooltip(GT_ItemStack aStack, String aTooltip) {
        String aKey = HazmatUtils.convertGtItemstackToStringDataIgnoreDamage(aStack);
        Logger.INFO("[Hazmat] Mapping " + aTooltip + " for " + aKey);
        AutoMap<String> aTempTooltipData = mToolTips.get(aKey);
        if (aTempTooltipData == null) {
            Logger.INFO("No data mapped yet, creating.");
            aTempTooltipData = new AutoMap();
            mToolTips.put(aKey, aTempTooltipData);
        }
        aTempTooltipData.add(aTooltip);
    }

    public static ItemStack getStackFromGtStack(GT_ItemStack aGtStack) {
        return ItemUtils.simpleMetaStack(aGtStack.mItem, (int)aGtStack.mMetaData, (int)aGtStack.mStackSize);
    }

    public static GT_ItemStack getGtStackFromVanilla(ItemStack aStack) {
        return new GT_ItemStack(aStack);
    }

    private static String convertGtItemstackToStringData(GT_ItemStack aStack) {
        if (aStack == null) {
            return "NULL";
        }
        return aStack.mItem.func_77658_a() + "." + aStack.mMetaData + "." + aStack.mStackSize;
    }

    private static String convertGtItemstackToStringDataIgnoreDamage(GT_ItemStack aStack) {
        if (aStack == null) {
            return "NULL";
        }
        return aStack.mItem.func_77658_a() + "." + aStack.mStackSize;
    }
}

