/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.recipe;

import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.bop.blocks.BOP_Block_Registrator;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.common.Meta_GT_Proxy;
import gtPlusPlus.xmod.gregtech.common.helpers.VolumetricFlaskHelper;
import gtPlusPlus.xmod.gregtech.registration.gregtech.GregtechConduits;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class RECIPES_General {
    static final ItemStack NULL = null;
    static ItemStack RECIPE_Paper;
    static ItemStack RECIPE_Dirt;
    static ItemStack RECIPE_Snow;
    static ItemStack RECIPE_Obsidian;
    static String RECIPE_LapisDust;
    static ItemStack OUTPUT_Blueprint;
    static ItemStack RECIPE_CraftingTable;
    static String RECIPE_BronzePlate;
    static String RECIPE_StainlessPlate;
    static ItemStack RECIPE_BasicCasingIC2;
    static ItemStack OUTPUT_Workbench_Bronze;
    static ItemStack OUTPUT_Workbench_Advanced;
    static ItemStack RECIPE_HydrogenDust;

    public static void loadRecipes() {
        if (LoadedMods.Gregtech) {
            RECIPE_Paper = ItemUtils.getSimpleStack(Items.field_151121_aF);
            RECIPE_Dirt = ItemUtils.getSimpleStack(Blocks.field_150346_d);
            RECIPE_Snow = ItemUtils.getSimpleStack(Blocks.field_150433_aE);
            RECIPE_Obsidian = ItemUtils.getSimpleStack(Blocks.field_150343_Z);
            RECIPE_CraftingTable = ItemUtils.getSimpleStack(Blocks.field_150462_ai);
            RECIPE_HydrogenDust = ItemUtils.getSimpleStack(ModItems.itemHydrogenBlob);
            RECIPE_BasicCasingIC2 = ItemUtils.getItemStackFromFQRN("IC2:blockMachine", 1);
            OUTPUT_Workbench_Bronze = GregtechItemList.GT4_Workbench_Bronze.get(1L, new Object[0]);
            OUTPUT_Workbench_Advanced = GregtechItemList.GT4_Workbench_Advanced.get(1L, new Object[0]);
            OUTPUT_Blueprint = ItemUtils.getSimpleStack(ModItems.itemBlueprintBase, 2);
            RECIPES_General.run();
            RECIPES_General.addCompressedObsidian();
            RECIPES_General.migratedRecipes();
        }
    }

    private static void run() {
        ItemStack ironBars;
        RecipeUtils.addShapedRecipe(RECIPE_Paper, RECIPE_LapisDust, NULL, RECIPE_Paper, RECIPE_LapisDust, NULL, RECIPE_LapisDust, RECIPE_LapisDust, NULL, OUTPUT_Blueprint);
        RecipeUtils.addShapedRecipe(RECIPE_BronzePlate, RECIPE_CraftingTable, RECIPE_BronzePlate, RECIPE_BronzePlate, RECIPE_BasicCasingIC2, RECIPE_BronzePlate, RECIPE_BronzePlate, CI.getTieredCircuitOreDictName(0), RECIPE_BronzePlate, OUTPUT_Workbench_Bronze);
        RecipeUtils.addShapedRecipe(RECIPE_StainlessPlate, CI.getTieredCircuitOreDictName(3), RECIPE_StainlessPlate, RECIPE_StainlessPlate, OUTPUT_Workbench_Bronze, RECIPE_StainlessPlate, RECIPE_StainlessPlate, CI.getTieredCircuitOreDictName(3), RECIPE_StainlessPlate, OUTPUT_Workbench_Advanced);
        if (!LoadedMods.Thaumcraft) {
            RecipeUtils.addShapedRecipe(RECIPE_HydrogenDust, RECIPE_HydrogenDust, RECIPE_HydrogenDust, RECIPE_HydrogenDust, ItemUtils.getSimpleStack(ModItems.shardDull), RECIPE_HydrogenDust, RECIPE_HydrogenDust, RECIPE_HydrogenDust, RECIPE_HydrogenDust, ItemUtils.getSimpleStack(ModItems.shardAer));
            RecipeUtils.addShapedRecipe(RECIPE_Obsidian, RECIPE_Obsidian, RECIPE_Obsidian, RECIPE_Obsidian, ItemUtils.getSimpleStack(ModItems.shardDull), RECIPE_Obsidian, RECIPE_Obsidian, RECIPE_Obsidian, RECIPE_Obsidian, ItemUtils.getSimpleStack(ModItems.shardIgnis));
            RecipeUtils.addShapedRecipe(RECIPE_Dirt, RECIPE_Dirt, RECIPE_Dirt, RECIPE_Dirt, ItemUtils.getSimpleStack(ModItems.shardDull), RECIPE_Dirt, RECIPE_Dirt, RECIPE_Dirt, RECIPE_Dirt, ItemUtils.getSimpleStack(ModItems.shardTerra));
            RecipeUtils.addShapedRecipe(RECIPE_LapisDust, RECIPE_LapisDust, RECIPE_LapisDust, RECIPE_LapisDust, ItemUtils.getSimpleStack(ModItems.shardDull), RECIPE_LapisDust, RECIPE_LapisDust, RECIPE_LapisDust, RECIPE_LapisDust, ItemUtils.getSimpleStack(ModItems.shardAqua));
            GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(ModItems.shardAer), (ItemStack)ItemUtils.getSimpleStack(ModItems.dustAer, 2));
            GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(ModItems.shardIgnis), (ItemStack)ItemUtils.getSimpleStack(ModItems.dustIgnis, 2));
            GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(ModItems.shardTerra), (ItemStack)ItemUtils.getSimpleStack(ModItems.dustTerra, 2));
            GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(ModItems.shardAqua), (ItemStack)ItemUtils.getSimpleStack(ModItems.dustAqua, 2));
        }
        if (OreDictionary.doesOreNameExist((String)"dustPotassiumNitrade")) {
            ItemStack aDustKNO3 = ItemUtils.getItemStackOfAmountFromOreDict("dustPotassiumNitrade", 1);
            ItemStack aDustGtppKNO3 = MISC_MATERIALS.POTASSIUM_NITRATE.getDust(1);
            if (RecipeUtils.addShapedRecipe(null, null, null, null, "dustPotassiumNitrade", null, null, null, null, ItemUtils.getSimpleStack(aDustGtppKNO3, 1))) {
                Logger.INFO("Add conversion recipe (GT Potassium Nitrade -> GT++ Potassium Nitrate)");
            }
            if (RecipeUtils.addShapedRecipe(null, null, null, null, "dustPotassiumNitrate", null, null, null, null, ItemUtils.getSimpleStack(aDustKNO3, 1))) {
                Logger.INFO("Add conversion recipe (GT++ Potassium Nitrate -> GT Potassium Nitrade)");
            }
        }
        if (RecipeUtils.addShapedRecipe("stickWood", "stickWood", "stickWood", "stickWood", "treeSapling", "stickWood", "stickWood", "dustBone", "stickWood", ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Rainforest))) {
            Logger.INFO("Added a recipe for Rainforest oak Saplings.");
        }
        if (RecipeUtils.addShapedRecipe(ironBars = CORE.GTNH ? ItemUtils.getItemStackFromFQRN("dreamcraft:item.SteelBars", 1) : ItemUtils.getItemStackFromFQRN("minecraft:iron_bars", 1), ironBars, ironBars, ironBars, "frameGtWroughtIron", ironBars, ironBars, ironBars, ironBars, ItemUtils.getSimpleStack(ModBlocks.blockFishTrap))) {
            Logger.INFO("Added a recipe for the Fish Trap.");
        }
        if (!CORE.GTNH) {
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Shape_Extruder_SmallGear.get(1L, new Object[0]), (long)(GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.REVERSIBLE), (Object[])new Object[]{"hXS", "XPX", "fXd", Character.valueOf('P'), ItemList.Shape_Extruder_Gear, Character.valueOf('X'), OrePrefixes.plate.get((Object)Materials.Steel), Character.valueOf('S'), OrePrefixes.screw.get((Object)Materials.Steel)});
            String[] ironTypes = new String[]{"", "Wrought", "Pig", "Any"};
            for (int y = 0; y < ironTypes.length; ++y) {
                String ironRecipe = "stick" + ironTypes[y] + "Iron";
                if (!RecipeUtils.addShapedRecipe(null, CI.craftingToolWrench, null, ironRecipe, ironRecipe, ironRecipe, ironRecipe, ironRecipe, ironRecipe, ItemUtils.getItemStackFromFQRN("minecraft:iron_bars", 8))) continue;
                Logger.INFO("Re-added old GT recipe for Iron Bars.");
            }
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new Object[]{"dustLead", "dustBronze", "dustTin", "dustLead", "dustBronze"}, ALLOY.POTIN.getDust(5))) {
            Logger.INFO("Added shapeless recipe for Potin Dust.");
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new Object[]{"dustGold", "dustGold", "dustCopper"}, ItemUtils.getSimpleStack(ModItems.dustTumbagaMix))) {
            Logger.INFO("Added shapeless recipe for Tumbaga Mix.");
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new Object[]{ItemUtils.getSimpleStack(ModItems.dustTumbagaMix), ItemUtils.getSimpleStack(ModItems.dustTumbagaMix), ItemUtils.getSimpleStack(ModItems.dustTumbagaMix), "dustGold"}, ALLOY.TUMBAGA.getDust(10))) {
            Logger.INFO("Added shapeless recipe for Tumbaga Dust.");
        }
        if (CORE.ConfigSwitches.enableMachine_Pollution) {
            RecipeUtils.addShapedRecipe(CI.craftingToolFile, "plateIron", "stickIron", "plateIron", "ringIron", "plateIron", "stickIron", "plateIron", CI.craftingToolHammer_Hard, ItemUtils.simpleMetaStack(ModItems.itemBasicTurbine, 0, 1));
            RecipeUtils.addShapedRecipe(CI.craftingToolFile, "plateBronze", "stickBronze", "plateBronze", "ringBronze", "plateBronze", "stickBronze", "plateBronze", CI.craftingToolHammer_Hard, ItemUtils.simpleMetaStack(ModItems.itemBasicTurbine, 1, 1));
            RecipeUtils.addShapedRecipe(CI.craftingToolFile, "plateSteel", "stickSteel", "plateSteel", "ringSteel", "plateSteel", "stickSteel", "plateSteel", CI.craftingToolHammer_Hard, ItemUtils.simpleMetaStack(ModItems.itemBasicTurbine, 2, 1));
        }
        if (Meta_GT_Proxy.sDoesVolumetricFlaskExist) {
            CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(4), ItemUtils.getSimpleStack(Blocks.field_150359_w, 16), ItemUtils.getSimpleStack(Blocks.field_150426_aN, 16), ItemList.Large_Fluid_Cell_Steel.get(1L, new Object[0])}, FluidUtils.getFluidStack("molten.borosilicateglass", 2000), VolumetricFlaskHelper.getLargeVolumetricFlask(2), 300, MaterialUtils.getVoltageForTier(3));
            CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(5), ItemUtils.getSimpleStack(Blocks.field_150359_w, 64), ItemUtils.getSimpleStack(Blocks.field_150426_aN, 64), ItemList.Large_Fluid_Cell_TungstenSteel.get(1L, new Object[0])}, FluidUtils.getFluidStack("molten.borosilicateglass", 8000), VolumetricFlaskHelper.getGiganticVolumetricFlask(2), 300, MaterialUtils.getVoltageForTier(5));
        }
        Logger.RECIPE("[Inspection] Explosives");
        if (RecipeUtils.addShapedRecipe(CI.explosiveITNT, CI.explosiveTNT, CI.explosiveITNT, CI.explosiveTNT, "frameGtIron", CI.explosiveTNT, "dustSulfur", CI.explosiveTNT, "dustSulfur", ItemUtils.getSimpleStack(ModBlocks.blockMiningExplosive, 3))) {
            Logger.INFO("Added a recipe for Mining Explosives.");
        }
        if (RecipeUtils.addShapedRecipe("gemExquisiteRuby", "gemFlawlessDiamond", "gemExquisiteDiamond", "gemFlawlessRuby", ItemList.Credit_Greg_Osmium.get(1L, new Object[0]), "gemFlawlessSapphire", "gemExquisiteEmerald", "gemFlawlessEmerald", "gemExquisiteSapphire", ItemUtils.getSimpleStack(ModItems.itemAlkalusDisk))) {
            Logger.INFO("Added a recipe for The Alkalus Disk.");
        }
        Logger.RECIPE("[Inspection] Wither Cage");
        if (RecipeUtils.addShapedRecipe("stickBlackSteel", "plateTungstenSteel", "stickBlackSteel", "plateTungstenSteel", ItemUtils.getSimpleStack(Items.field_151156_bN), "plateTungstenSteel", "stickBlackSteel", "plateTungstenSteel", "stickBlackSteel", ItemUtils.getSimpleStack(ModBlocks.blockWitherGuard, 32))) {
            Logger.INFO("Added a recipe for Wither Cages.");
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDictNoBroken(CI.craftingToolKnife, 1), ItemUtils.getSimpleStack(Items.field_151120_aE)}, ItemUtils.getSimpleStack(ModItems.itemFiber, 16))) {
            Logger.INFO("Added a recipe for Fiber.");
        }
        if (RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDictNoBroken(CI.craftingToolKnife, 1), ItemUtils.getSimpleStack(Blocks.field_150345_g)}, ItemUtils.getSimpleStack(ModItems.itemFiber, 32))) {
            Logger.INFO("Added a recipe for Fiber.");
        }
        if (RecipeUtils.addShapedRecipe(null, ItemUtils.getSimpleStack(ModItems.itemFiber, 1), null, ItemUtils.getSimpleStack(ModItems.itemFiber, 1), CI.craftingToolKnife, ItemUtils.getSimpleStack(ModItems.itemFiber, 1), null, ItemUtils.getSimpleStack(ModItems.itemFiber, 1), null, ItemUtils.getSimpleStack(ModItems.itemRope, 3))) {
            Logger.INFO("Added a recipe for Rope.");
        }
        Logger.RECIPE("[Inspection] Net");
        if (RecipeUtils.addShapedRecipe(ItemUtils.getSimpleStack(ModItems.itemRope, 1), ItemUtils.getSimpleStack(ModItems.itemRope, 1), ItemUtils.getSimpleStack(ModItems.itemRope, 1), ItemUtils.getSimpleStack(ModItems.itemRope, 1), ItemUtils.getSimpleStack(ModItems.itemRope, 1), ItemUtils.getSimpleStack(ModItems.itemRope, 1), null, null, null, ItemUtils.getSimpleStack(ModBlocks.blockNet, 2))) {
            Logger.INFO("Added a recipe for Nets.");
        }
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150432_aD, 8), ItemUtils.getSimpleStack(ModBlocks.blockNet, 8), ItemUtils.getSimpleStack(Blocks.field_150395_bd, 8), ALLOY.TUMBAGA.getRing(1)}, FluidUtils.getWater(1000), ItemUtils.getItemStackFromFQRN("miscutils:SlowBuildingRing", 1), 600, 16);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{ItemUtils.getSimpleStack(Items.field_151008_G, 64), ItemUtils.getSimpleStack(Blocks.field_150475_bE, 32), ItemUtils.getSimpleStack(Blocks.field_150484_ah, 32), Materials.Ruby.getBlocks(32), Materials.Sapphire.getBlocks(32), ItemUtils.getSimpleStack(Blocks.field_150340_R, 32)}, Materials.Silver.getMolten(4608L), ItemUtils.getSimpleStack(ModItems.itemMagicFeather, 1), 2400, MaterialUtils.getVoltageForTier(4));
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{CI.getNumberedCircuit(16), CI.getTieredMachineCasing(1), CI.getElectricPump(2, 1), CI.getPlate(2, CORE.GTNH ? 4 : 2), ItemUtils.getItemStackOfAmountFromOreDict(CI.getTieredCircuitOreDictName(0), CORE.GTNH ? 2 : 1)}, FluidUtils.getHotWater(500), ItemUtils.getSimpleStack(ModBlocks.blockPestKiller), 1200, 16);
    }

    private static boolean addCompressedObsidian() {
        ItemStack output;
        ItemStack input;
        int r;
        ItemStack aInvertedObsidian = ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, 5, 1);
        if (RecipeUtils.addShapedRecipe(ItemUtils.getSimpleStack(Items.field_151137_ax), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.getSimpleStack(Items.field_151137_ax), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, 1, 1), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.getSimpleStack(Items.field_151137_ax), ItemUtils.getSimpleStack(Items.field_151114_aO), ItemUtils.getSimpleStack(Items.field_151137_ax), aInvertedObsidian)) {
            Logger.INFO("Added a recipe for Inverted Obsidian.");
        }
        ItemStack[] mItems = new ItemStack[6];
        mItems[0] = ItemUtils.getSimpleStack(Blocks.field_150343_Z);
        for (int r2 = 0; r2 < 5; ++r2) {
            mItems[r2 + 1] = ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, r2, 1);
        }
        ItemStack[] mItems2 = new ItemStack[6];
        mItems2[0] = ItemUtils.getSimpleStack(Blocks.field_150426_aN);
        for (r = 0; r < 5; ++r) {
            mItems2[r + 1] = ItemUtils.simpleMetaStack(ModBlocks.blockCompressedObsidian, 6 + r, 1);
        }
        for (r = 0; r < 5; ++r) {
            input = mItems[r];
            output = mItems[r + 1];
            if (RecipeUtils.addShapedRecipe(input, input, input, input, input, input, input, input, input, output)) {
                Logger.INFO("Added a recipe for Compressed Obsidian [" + r + "]");
            }
            if (!RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{output}, ItemUtils.getSimpleStack(input, 9))) continue;
            Logger.INFO("Added a shapeless recipe for Compressed Obsidian [" + r + "]");
        }
        for (r = 0; r < 5; ++r) {
            input = mItems2[r];
            if (RecipeUtils.addShapedRecipe(input, input, input, input, r == 2 ? aInvertedObsidian : input, input, input, input, input, output = mItems2[r + 1])) {
                Logger.INFO("Added a recipe for Compressed Glowstone [" + r + "]");
            }
            if (!RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{output}, ItemUtils.getSimpleStack(input, 9))) continue;
            Logger.INFO("Added a shapeless recipe for Compressed Glowstone [" + r + "]");
        }
        return true;
    }

    private static void migratedRecipes() {
        Materials[] h;
        GregtechOrePrefixes.GT_Materials[] g;
        RecipeUtils.generateMortarRecipe(ItemUtils.getSimpleStack(ModItems.itemPlateRawMeat), ItemUtils.getItemStackOfAmountFromOreDict("dustMeatRaw", 1));
        GregtechConduits.generateWireRecipes(ELEMENT.getInstance().ZIRCONIUM);
        GregtechConduits.generateWireRecipes(ALLOY.HG1223);
        GregtechConduits.generateWireRecipes(ALLOY.LEAGRISIUM);
        GregtechConduits.generateWireRecipes(ALLOY.TRINIUM_TITANIUM);
        for (GregtechOrePrefixes.GT_Materials e : g = new GregtechOrePrefixes.GT_Materials[]{GregtechOrePrefixes.GT_Materials.Staballoy, GregtechOrePrefixes.GT_Materials.Tantalloy60, GregtechOrePrefixes.GT_Materials.Tantalloy61, GregtechOrePrefixes.GT_Materials.Void, GregtechOrePrefixes.GT_Materials.Potin, GregtechOrePrefixes.GT_Materials.MaragingSteel300, GregtechOrePrefixes.GT_Materials.MaragingSteel350, GregtechOrePrefixes.GT_Materials.Inconel690, GregtechOrePrefixes.GT_Materials.Inconel792, GregtechOrePrefixes.GT_Materials.HastelloyX, GregtechOrePrefixes.GT_Materials.TriniumNaquadahCarbonite}) {
            if (e == GregtechOrePrefixes.GT_Materials.Void && !LoadedMods.Thaumcraft) continue;
            int tVoltageMultiplier = e.mBlastFurnaceTemp >= 2800 ? 64 : 16;
            GregtechConduits.generatePipeRecipes(e.mDefaultLocalName, e.getMass(), tVoltageMultiplier);
        }
        for (Materials e : h = new Materials[]{Materials.Europium, Materials.Tungsten, Materials.DarkSteel, Materials.Clay, Materials.Lead}) {
            if (e == Materials.DarkSteel && !LoadedMods.EnderIO) continue;
            int tVoltageMultiplier = e.mBlastFurnaceTemp >= 2800 ? 64 : 16;
            GregtechConduits.generatePipeRecipes(e.mDefaultLocalName, e.getMass(), tVoltageMultiplier);
        }
        RecipeUtils.addShapedGregtechRecipe(CI.component_Plate[6], ALLOY.MARAGING250.getGear(1), CI.component_Plate[6], CI.getTieredCircuitOreDictName(4), GregtechItemList.Casing_AdvancedVacuum.get(1L, new Object[0]), CI.getTieredCircuitOreDictName(4), CI.component_Plate[5], ItemList.Hatch_Input_IV.get(1L, new Object[0]), CI.component_Plate[5], GregtechItemList.Hatch_Input_Cryotheum.get(1L, new Object[0]));
        RecipeUtils.addShapedGregtechRecipe(CI.component_Plate[5], ALLOY.MARAGING300.getGear(1), CI.component_Plate[5], CI.getTieredCircuitOreDictName(4), GregtechItemList.Casing_Adv_BlastFurnace.get(1L, new Object[0]), CI.getTieredCircuitOreDictName(4), CI.component_Plate[6], ItemList.Hatch_Input_IV.get(1L, new Object[0]), CI.component_Plate[6], GregtechItemList.Hatch_Input_Pyrotheum.get(1L, new Object[0]));
        RecipeUtils.addShapedGregtechRecipe(CI.component_Plate[8], ALLOY.PIKYONIUM.getGear(1), CI.component_Plate[9], CI.getTieredCircuitOreDictName(7), GregtechItemList.Casing_Naq_Reactor_A.get(1L, new Object[0]), CI.getTieredCircuitOreDictName(7), CI.component_Plate[9], ItemList.Hatch_Input_ZPM.get(1L, new Object[0]), CI.component_Plate[8], GregtechItemList.Hatch_Input_Naquadah.get(1L, new Object[0]));
        if (PollutionUtils.isPollutionEnabled()) {
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_LV.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_LV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_LV.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_MV.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_MV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_MV.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_HV.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_HV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_HV.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_EV.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_EV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_EV.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_IV.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_IV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_IV.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_LuV.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_LuV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_LuV.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_ZPM.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_ZPM.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_ZPM.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_UV.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_UV.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_UV.get(1L, new Object[0])});
            GT_ModHandler.addCraftingRecipe((ItemStack)GregtechItemList.Hatch_Muffler_Adv_MAX.get(1L, new Object[0]), (long)CI.bitsd, (Object[])new Object[]{"M", "P", Character.valueOf('M'), ItemList.Hatch_Muffler_MAX.get(1L, new Object[0]), Character.valueOf('P'), GregtechItemList.Pollution_Cleaner_MAX.get(1L, new Object[0])});
        }
    }

    static {
        RECIPE_LapisDust = "dustLazurite";
        RECIPE_BronzePlate = "plateBronze";
        RECIPE_StainlessPlate = "plateStainlessSteel";
    }
}

