/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.material;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.item.ItemStack;

public class MaterialStack {
    private final transient int[] vAmount;
    private final Material stackMaterial;
    private final double vPercentageToUse;

    public MaterialStack(Material inputs, double partOutOf100) {
        this.stackMaterial = inputs;
        this.vPercentageToUse = partOutOf100;
        this.vAmount = this.math(partOutOf100);
    }

    private int[] math(double val) {
        BigDecimal bd = new BigDecimal(val).setScale(2, RoundingMode.HALF_EVEN);
        double i = bd.doubleValue();
        String[] arr = String.valueOf(i).split("\\.");
        int[] intArr = new int[]{Integer.parseInt(arr[0]), Integer.parseInt(arr[1])};
        return intArr;
    }

    public ItemStack getValidStack() {
        if (this.stackMaterial.getDust(1) == null) {
            return null;
        }
        return this.stackMaterial.getDust(this.vAmount[0]);
    }

    public ItemStack getDustStack() {
        return this.stackMaterial.getDust(this.vAmount[0]);
    }

    public ItemStack getDustStack(int amount) {
        return this.stackMaterial.getDust(amount);
    }

    public Material getStackMaterial() {
        if (this.stackMaterial == null) {
            Logger.MATERIALS("Tried getStackMaterial, got an invalid material.");
            Logger.MATERIALS(ReflectionUtils.getMethodName(0));
            Logger.MATERIALS(ReflectionUtils.getMethodName(1));
            Logger.MATERIALS(ReflectionUtils.getMethodName(2));
            Logger.MATERIALS(ReflectionUtils.getMethodName(3));
            return null;
        }
        return this.stackMaterial;
    }

    public double getvPercentageToUse() {
        return this.vPercentageToUse;
    }

    public long[] getSmallestStackSizes() {
        return this.stackMaterial.getSmallestRatio(this.stackMaterial.getComposites());
    }

    public int getPartsPerOneHundred() {
        if (this.vAmount != null && this.vAmount[0] >= 1 && this.vAmount[0] <= 100) {
            return this.vAmount[0];
        }
        return 100;
    }

    public ItemStack getLeftOverStacksFromDecimalValue() {
        int temp = this.vAmount[1];
        if (temp >= 25 && temp <= 99) {
            int getCount = temp / 25;
            return this.stackMaterial.getSmallDust(getCount);
        }
        if (temp >= 11 && temp <= 24) {
            int getCount = temp / 11;
            return this.stackMaterial.getTinyDust(getCount);
        }
        return null;
    }

    public ItemStack[] getValidItemStacks() {
        return ItemUtils.validItemsForOreDict(this.stackMaterial.getUnlocalizedName());
    }
}

