/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general.rfchargingpack;

import cofh.api.energy.ItemEnergyContainer;
import gtPlusPlus.core.util.math.MathUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ChargingPackBase
extends ItemEnergyContainer {
    protected final int mCapacityMax;
    protected final byte mTier;

    public ChargingPackBase(byte tier) {
        this(tier, tier == 1 ? 4000000 : (tier == 2 ? 8000000 : (tier == 3 ? 16000000 : (tier == 4 ? 32000000 : 64000000))));
    }

    private ChargingPackBase(byte tier, int maxStorage) {
        super(maxStorage);
        this.mTier = tier;
        this.mCapacityMax = maxStorage;
    }

    public int getMaxEnergyInput(ItemStack container) {
        return this.maxReceive;
    }

    public int getMaxEnergyExtracted(ItemStack container) {
        return this.maxExtract;
    }

    public void func_77663_a(ItemStack aStack, World aWorld, Entity aEnt, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(aStack, aWorld, aEnt, p_77663_4_, p_77663_5_);
        ChargingPackBase current = this;
        int currentStored = 0;
        if (current != null) {
            currentStored = current.getEnergyStored(aStack);
        }
        if (currentStored > 0 && aEnt instanceof EntityPlayer && ((EntityPlayer)aEnt).field_71071_by != null) {
            for (ItemStack invStack : ((EntityPlayer)aEnt).field_71071_by.field_70462_a) {
                if (invStack == null || !(invStack.func_77973_b() instanceof ItemEnergyContainer) || current == null || (currentStored = current.getEnergyStored(aStack)) <= 0) continue;
                int mTransLimit = this.getMaxEnergyInput(invStack);
                int mMaxStorage = current.getMaxEnergyStored(invStack);
                int mCurrent = current.getEnergyStored(invStack);
                if (mCurrent + mTransLimit > mMaxStorage) continue;
                current.extractEnergy(aStack, current.receiveEnergy(invStack, mTransLimit, false), false);
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer p_77624_2_, List list, boolean p_77624_4_) {
        list.add(EnumChatFormatting.RED + "RF Information");
        list.add(EnumChatFormatting.GRAY + "Extraction Rate: [" + EnumChatFormatting.RED + this.maxExtract + EnumChatFormatting.GRAY + "Rf/t] Insert Rate: [" + EnumChatFormatting.RED + this.maxReceive + EnumChatFormatting.GRAY + "Rf/t]");
        list.add(EnumChatFormatting.GRAY + "Current Charge: [" + EnumChatFormatting.RED + this.getEnergyStored(stack) + EnumChatFormatting.GRAY + "Rf / " + this.getMaxEnergyStored(stack) + "Rf] " + EnumChatFormatting.RED + MathUtils.findPercentage(this.getEnergyStored(stack), this.getMaxEnergyStored(stack)) + EnumChatFormatting.GRAY + "%");
        super.func_77624_a(stack, p_77624_2_, list, p_77624_4_);
    }
}

