/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.chemistry;

import gregtech.api.enums.Materials;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.api.objects.data.Quad;
import gtPlusPlus.api.objects.minecraft.ItemPackage;
import gtPlusPlus.core.item.base.ore.BaseItemMilledOre;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.NONMATERIAL;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.xmod.bop.HANDLER_BiomesOPlenty;
import gtPlusPlus.xmod.bop.blocks.BOP_Block_Registrator;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MilledOreProcessing
extends ItemPackage {
    public static Fluid SphaleriteFlotationFroth;
    public static Fluid ChalcopyriteFlotationFroth;
    public static Fluid NickelFlotationFroth;
    public static Fluid PlatinumFlotationFroth;
    public static Fluid PentlanditeFlotationFroth;
    public static Fluid RedstoneFlotationFroth;
    public static Fluid SpessartineFlotationFroth;
    public static Fluid GrossularFlotationFroth;
    public static Fluid AlmandineFlotationFroth;
    public static Fluid PyropeFlotationFroth;
    public static Fluid MonaziteFlotationFroth;
    public static Fluid PineOil;
    public static Item milledSphalerite;
    public static Item milledChalcopyrite;
    public static Item milledNickel;
    public static Item milledPlatinum;
    public static Item milledPentlandite;
    public static Item milledRedstone;
    public static Item milledSpessartine;
    public static Item milledGrossular;
    public static Item milledAlmandine;
    public static Item milledPyrope;
    public static Item milledMonazite;
    private static final HashMap<String, Quad<Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>>> aMilledFluidMap;

    @Override
    public void items() {
        milledSphalerite = BaseItemMilledOre.generate(Materials.Sphalerite, MaterialUtils.getVoltageForTier(6));
        milledChalcopyrite = BaseItemMilledOre.generate(Materials.Chalcopyrite, MaterialUtils.getVoltageForTier(5));
        milledNickel = BaseItemMilledOre.generate(Materials.Nickel, MaterialUtils.getVoltageForTier(5));
        milledPlatinum = BaseItemMilledOre.generate(Materials.Platinum, MaterialUtils.getVoltageForTier(6));
        milledPentlandite = BaseItemMilledOre.generate(Materials.Pentlandite, MaterialUtils.getVoltageForTier(6));
        milledRedstone = BaseItemMilledOre.generate(Materials.Redstone, MaterialUtils.getVoltageForTier(5));
        milledSpessartine = BaseItemMilledOre.generate(Materials.Spessartine, MaterialUtils.getVoltageForTier(6));
        milledGrossular = BaseItemMilledOre.generate(Materials.Grossular, MaterialUtils.getVoltageForTier(6));
        milledAlmandine = BaseItemMilledOre.generate(Materials.Almandine, MaterialUtils.getVoltageForTier(6));
        milledPyrope = BaseItemMilledOre.generate(Materials.Pyrope, MaterialUtils.getVoltageForTier(4));
        milledMonazite = BaseItemMilledOre.generate(Materials.Monazite, MaterialUtils.getVoltageForTier(7));
    }

    @Override
    public void blocks() {
    }

    @Override
    public void fluids() {
        short[] aZincFrothRGB = Materials.Sphalerite.mRGBa;
        SphaleriteFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.zincflotation", "Sphalerite Froth", 207, new short[]{aZincFrothRGB[0], aZincFrothRGB[1], aZincFrothRGB[2], 100}, true);
        short[] aCopperFrothRGB = Materials.Chalcopyrite.mRGBa;
        ChalcopyriteFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.copperflotation", "Chalcopyrite Froth", 207, new short[]{aCopperFrothRGB[0], aCopperFrothRGB[1], aCopperFrothRGB[2], 100}, true);
        short[] aNickelFrothRGB = Materials.Nickel.mRGBa;
        NickelFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.nickelflotation", "Nickel Froth", 207, new short[]{aNickelFrothRGB[0], aNickelFrothRGB[1], aNickelFrothRGB[2], 100}, true);
        short[] aPlatinumFrothRGB = Materials.Platinum.mRGBa;
        PlatinumFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.platinumflotation", "Platinum Froth", 207, new short[]{aPlatinumFrothRGB[0], aPlatinumFrothRGB[1], aPlatinumFrothRGB[2], 100}, true);
        short[] aPentlanditeFrothRGB = Materials.Pentlandite.mRGBa;
        PentlanditeFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.pentlanditeflotation", "Pentlandite Froth", 207, new short[]{aPentlanditeFrothRGB[0], aPentlanditeFrothRGB[1], aPentlanditeFrothRGB[2], 100}, true);
        short[] aRedstoneFrothRGB = Materials.Redstone.mRGBa;
        RedstoneFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.redstoneflotation", "Redstone Froth", 207, new short[]{aRedstoneFrothRGB[0], aRedstoneFrothRGB[1], aRedstoneFrothRGB[2], 100}, true);
        short[] aSpessartineFrothRGB = Materials.Spessartine.mRGBa;
        SpessartineFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.spessartineflotation", "Spessartine Froth", 207, new short[]{aSpessartineFrothRGB[0], aSpessartineFrothRGB[1], aSpessartineFrothRGB[2], 100}, true);
        short[] aGrossularFrothRGB = Materials.Grossular.mRGBa;
        GrossularFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.grossularflotation", "Grossular Froth", 207, new short[]{aGrossularFrothRGB[0], aGrossularFrothRGB[1], aGrossularFrothRGB[2], 100}, true);
        short[] aAlmandineFrothRGB = Materials.Almandine.mRGBa;
        AlmandineFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.almandineflotation", "Almandine Froth", 207, new short[]{aAlmandineFrothRGB[0], aAlmandineFrothRGB[1], aAlmandineFrothRGB[2], 100}, true);
        short[] aPyropeFrothRGB = Materials.Pyrope.mRGBa;
        PyropeFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.pyropeflotation", "Pyrope Froth", 207, new short[]{aPyropeFrothRGB[0], aPyropeFrothRGB[1], aPyropeFrothRGB[2], 100}, true);
        short[] aMonaziteFrothRGB = Materials.Monazite.mRGBa;
        MonaziteFlotationFroth = FluidUtils.generateFluidNoPrefix("froth.Monaziteflotation", "Monazite Froth", 207, new short[]{aMonaziteFrothRGB[0], aMonaziteFrothRGB[1], aMonaziteFrothRGB[2], 100}, true);
        PineOil = FluidUtils.generateFluidNoPrefix("pineoil", "Pine Oil", 207, new short[]{250, 200, 60, 100}, true);
    }

    public MilledOreProcessing() {
        Logger.INFO("Adding Ore Milling content");
    }

    private static void addMiscRecipes() {
        MilledOreProcessing.registerOreDataForMilledType(SphaleriteFlotationFroth, ELEMENT.getInstance().ZINC, 180, ELEMENT.getInstance().IRON, 120, ELEMENT.getInstance().INDIUM, 40, ELEMENT.getInstance().GERMANIUM, 15);
        MilledOreProcessing.registerOreDataForMilledType(ChalcopyriteFlotationFroth, ELEMENT.getInstance().COPPER, 180, ELEMENT.getInstance().IRON, 120, ELEMENT.getInstance().CADMIUM, 50, ELEMENT.getInstance().INDIUM, 10);
        MilledOreProcessing.registerOreDataForMilledType(NickelFlotationFroth, ELEMENT.getInstance().NICKEL, 150, ELEMENT.getInstance().COBALT, 120, ELEMENT.getInstance().RHODIUM, 32, ELEMENT.getInstance().RUTHENIUM, 16);
        MilledOreProcessing.registerOreDataForMilledType(PlatinumFlotationFroth, ELEMENT.getInstance().PLATINUM, 120, ELEMENT.getInstance().RHODIUM, 60, ELEMENT.getInstance().SELENIUM, 40, ELEMENT.getInstance().TELLURIUM, 10);
        MilledOreProcessing.registerOreDataForMilledType(PentlanditeFlotationFroth, ELEMENT.getInstance().IRON, 150, ELEMENT.getInstance().NICKEL, 100, ELEMENT.getInstance().PROMETHIUM, 20, ELEMENT.getInstance().HAFNIUM, 10);
        MilledOreProcessing.registerOreDataForMilledType(RedstoneFlotationFroth, NONMATERIAL.REDSTONE, 300, ELEMENT.getInstance().CHROMIUM, 60, MaterialUtils.generateMaterialFromGtENUM(Materials.Firestone), 45, ELEMENT.getInstance().DYSPROSIUM, 16);
        MilledOreProcessing.registerOreDataForMilledType(SpessartineFlotationFroth, ELEMENT.getInstance().MANGANESE, 150, ELEMENT.getInstance().ALUMINIUM, 90, ELEMENT.getInstance().OSMIUM, 30, ELEMENT.getInstance().STRONTIUM, 20);
        MilledOreProcessing.registerOreDataForMilledType(GrossularFlotationFroth, ELEMENT.getInstance().CALCIUM, 180, ELEMENT.getInstance().ALUMINIUM, 110, ELEMENT.getInstance().TUNGSTEN, 60, ELEMENT.getInstance().THALLIUM, 15);
        MilledOreProcessing.registerOreDataForMilledType(AlmandineFlotationFroth, ELEMENT.getInstance().ALUMINIUM, 150, ELEMENT.getInstance().MAGNESIUM, 75, ELEMENT.getInstance().YTTRIUM, 25, ELEMENT.getInstance().YTTERBIUM, 15);
        MilledOreProcessing.registerOreDataForMilledType(PyropeFlotationFroth, ELEMENT.getInstance().MAGNESIUM, 110, ELEMENT.getInstance().MANGANESE, 70, MaterialUtils.generateMaterialFromGtENUM(Materials.Borax), 60, ELEMENT.getInstance().RHENIUM, 20);
        MilledOreProcessing.registerOreDataForMilledType(MonaziteFlotationFroth, ELEMENT.getInstance().ERBIUM, 64, ELEMENT.getInstance().LANTHANUM, 32, ELEMENT.getInstance().LUTETIUM, 16, ELEMENT.getInstance().EUROPIUM, 8);
    }

    @Override
    public String errorMessage() {
        return "Failed to generate recipes for OreMillingProc.";
    }

    @Override
    public boolean generateRecipes() {
        MilledOreProcessing.addMiscRecipes();
        this.addPineOilExtraction();
        this.addFlotationRecipes1();
        this.addFlotationRecipes2();
        this.addVacuumFurnaceRecipes();
        return true;
    }

    private void addVacuumFurnaceRecipes() {
        int aCircuitID = 1;
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(SphaleriteFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(SphaleriteFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(6), 5500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(ChalcopyriteFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(ChalcopyriteFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(5), 4500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(NickelFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(NickelFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(5), 4500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(PlatinumFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(PlatinumFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(6), 5500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(PentlanditeFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(PentlanditeFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(6), 5500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(RedstoneFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(RedstoneFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(5), 4500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(SpessartineFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(SpessartineFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(6), 5500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(GrossularFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(GrossularFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(6), 5500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(AlmandineFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(AlmandineFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(6), 5500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(PyropeFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(PyropeFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(4), 3500);
        CORE.RA.addVacuumFurnaceRecipe(new ItemStack[]{CI.getNumberedCircuit(aCircuitID++)}, new FluidStack[]{FluidUtils.getFluidStack(MonaziteFlotationFroth, 4000)}, MilledOreProcessing.getOutputsFromMap(MonaziteFlotationFroth), new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 2000), FluidUtils.getWater(2000)}, 2400, MaterialUtils.getVoltageForTier(7), 7500);
    }

    private void addFlotationRecipes1() {
        CORE.RA.addFlotationRecipe(Materials.Sphalerite, ItemUtils.getSimpleStack(GenericChem.mSodiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 14000)}, new FluidStack[]{FluidUtils.getFluidStack(SphaleriteFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(6));
        CORE.RA.addFlotationRecipe(Materials.Chalcopyrite, ItemUtils.getSimpleStack(GenericChem.mSodiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 12000)}, new FluidStack[]{FluidUtils.getFluidStack(ChalcopyriteFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(5));
        CORE.RA.addFlotationRecipe(Materials.Nickel, ItemUtils.getSimpleStack(GenericChem.mPotassiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 25000)}, new FluidStack[]{FluidUtils.getFluidStack(NickelFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(5));
        CORE.RA.addFlotationRecipe(Materials.Platinum, ItemUtils.getSimpleStack(GenericChem.mPotassiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 35000)}, new FluidStack[]{FluidUtils.getFluidStack(PlatinumFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(6));
        CORE.RA.addFlotationRecipe(Materials.Pentlandite, ItemUtils.getSimpleStack(GenericChem.mSodiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 14000)}, new FluidStack[]{FluidUtils.getFluidStack(PentlanditeFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(6));
    }

    private void addFlotationRecipes2() {
        CORE.RA.addFlotationRecipe(Materials.Redstone, ItemUtils.getSimpleStack(GenericChem.mSodiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 13000)}, new FluidStack[]{FluidUtils.getFluidStack(RedstoneFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(5));
        CORE.RA.addFlotationRecipe(Materials.Spessartine, ItemUtils.getSimpleStack(GenericChem.mPotassiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 35000)}, new FluidStack[]{FluidUtils.getFluidStack(SpessartineFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(6));
        CORE.RA.addFlotationRecipe(Materials.Grossular, ItemUtils.getSimpleStack(GenericChem.mPotassiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 28000)}, new FluidStack[]{FluidUtils.getFluidStack(GrossularFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(6));
        CORE.RA.addFlotationRecipe(Materials.Almandine, ItemUtils.getSimpleStack(GenericChem.mSodiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 18000)}, new FluidStack[]{FluidUtils.getFluidStack(AlmandineFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(5));
        CORE.RA.addFlotationRecipe(Materials.Pyrope, ItemUtils.getSimpleStack(GenericChem.mSodiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 8000)}, new FluidStack[]{FluidUtils.getFluidStack(PyropeFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(4));
        CORE.RA.addFlotationRecipe(Materials.Monazite, ItemUtils.getSimpleStack(GenericChem.mPotassiumEthylXanthate, 1), new FluidStack[]{FluidUtils.getFluidStack(PineOil, 30000)}, new FluidStack[]{FluidUtils.getFluidStack(MonaziteFlotationFroth, 1000)}, 24000, MaterialUtils.getVoltageForTier(6));
    }

    private void addPineOilExtraction() {
        AutoMap<ItemStack> aLogs = new AutoMap<ItemStack>();
        AutoMap<ItemStack> aLeaves = new AutoMap<ItemStack>();
        AutoMap<ItemStack> aSaplings = new AutoMap<ItemStack>();
        AutoMap<ItemStack> aPinecones = new AutoMap<ItemStack>();
        ItemStack aCrushedPine = ItemUtils.getSimpleStack(AgriculturalChem.mCrushedPine, 1);
        aLogs.add(ItemUtils.getSimpleStack(BOP_Block_Registrator.log_Pine));
        aLeaves.add(ItemUtils.getSimpleStack(BOP_Block_Registrator.leaves_Pine));
        aSaplings.add(ItemUtils.getSimpleStack(BOP_Block_Registrator.sapling_Pine));
        aPinecones.add(ItemUtils.getSimpleStack(AgriculturalChem.mPinecone, 1));
        if (LoadedMods.BiomesOPlenty) {
            aLogs.add(HANDLER_BiomesOPlenty.getStack(HANDLER_BiomesOPlenty.logs4, 0, 1));
            aLeaves.add(HANDLER_BiomesOPlenty.getStack(HANDLER_BiomesOPlenty.colorizedLeaves2, 1, 1));
            aSaplings.add(HANDLER_BiomesOPlenty.getStack(HANDLER_BiomesOPlenty.colorizedSaplings, 5, 1));
            aPinecones.add(ItemUtils.simpleMetaStack(HANDLER_BiomesOPlenty.mPineCone, 13, 1));
        }
        if (LoadedMods.Forestry) {
            ItemStack aForestryLeaves;
            ItemStack aForestryLog = ItemUtils.getItemStackFromFQRN("Forestry:logs", 1);
            if (aForestryLog != null) {
                aForestryLog.func_77964_b(20);
                aLogs.add(aForestryLog);
            }
            if ((aForestryLeaves = ItemUtils.getItemStackFromFQRN("Forestry:leaves", 1)) != null) {
                NBTUtils.setString(aForestryLeaves, "species", "forestry.treePine");
                aLeaves.add(aForestryLeaves);
            }
        }
        for (ItemStack aLog : aLogs) {
            this.addRecipe(aLog, ItemUtils.getSimpleStack(aCrushedPine, 16), new int[]{10000, 7500, 5000, 2500}, 10, 120);
        }
        for (ItemStack aLeaf : aLeaves) {
            this.addRecipe(aLeaf, ItemUtils.getSimpleStack(aCrushedPine, 2), new int[]{5000, 5000, 2500, 2500}, 10, 30);
        }
        for (ItemStack aSapling : aSaplings) {
            this.addRecipe(aSapling, ItemUtils.getSimpleStack(aCrushedPine, 4), new int[]{7500, 7500, 2500, 2500}, 10, 60);
        }
        for (ItemStack aCone : aPinecones) {
            this.addRecipe(aCone, ItemUtils.getSimpleStack(aCrushedPine, 1), new int[]{7500, 7500, 5000, 2500}, 10, 60);
        }
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(16), ItemUtils.getSimpleStack(aCrushedPine, 64)}, new FluidStack[]{FluidUtils.getSteam(5000)}, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAsh", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAsh", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyDarkAsh", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyDarkAsh", 5)}, new FluidStack[]{FluidUtils.getFluidStack(PineOil, 500)}, new int[]{2000, 2000, 2000, 2000}, 1200, 120L, 3);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(18), ItemUtils.getSimpleStack(aCrushedPine, 64)}, new FluidStack[]{FluidUtils.getSuperHeatedSteam(5000)}, new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAsh", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyAsh", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyDarkAsh", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyDarkAsh", 5)}, new FluidStack[]{FluidUtils.getFluidStack(PineOil, 1500)}, new int[]{3000, 3000, 3000, 3000}, 900, 120L, 4);
    }

    public boolean addRecipe(ItemStack aInput, ItemStack aOutput1, int[] aChances, int aTime, int aEU) {
        aOutput1 = GT_OreDictUnificator.get((boolean)true, (ItemStack)aOutput1);
        ItemStack[] aOutputs = new ItemStack[4];
        for (int i = 0; i < aChances.length; ++i) {
            aOutputs[i] = aOutput1;
        }
        aOutputs = MilledOreProcessing.cleanArray(aOutputs);
        if (GT_Utility.isStackInvalid((Object)aInput) || GT_Utility.isStackInvalid((Object)aOutput1) || GT_Utility.getContainerItem((ItemStack)aInput, (boolean)false) != null) {
            return false;
        }
        return CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedAdvancedCircuit(14), aInput}, new FluidStack[0], aOutputs, new FluidStack[0], aChances, aTime * 20, aEU, 3);
    }

    public static ItemStack[] cleanArray(ItemStack[] input) {
        int aArraySize = input.length;
        AutoMap<ItemStack> aCleanedItems = new AutoMap<ItemStack>();
        for (ItemStack checkStack : input) {
            if (!ItemUtils.checkForInvalidItems(checkStack)) continue;
            aCleanedItems.put(checkStack);
        }
        ItemStack[] aOutput = new ItemStack[aCleanedItems.size()];
        for (int i = 0; i < aArraySize; ++i) {
            ItemStack aMappedStack = (ItemStack)aCleanedItems.get(i);
            if (aMappedStack == null) continue;
            aOutput[i] = aMappedStack;
        }
        return aOutput;
    }

    public static void registerOreDataForMilledType(Fluid aMilledFluid, Materials aOutput1, int aPerc1, Materials aOutput2, int aPerc2, Materials aOutput3, int aPerc3, Materials aOutput4, int aPerc4) {
        MilledOreProcessing.registerOreDataForMilledType(aMilledFluid, MaterialUtils.generateMaterialFromGtENUM(aOutput1), aPerc1, MaterialUtils.generateMaterialFromGtENUM(aOutput2), aPerc2, MaterialUtils.generateMaterialFromGtENUM(aOutput3), aPerc3, MaterialUtils.generateMaterialFromGtENUM(aOutput4), aPerc4);
    }

    public static void registerOreDataForMilledType(Fluid aMilledFluid, Material aOutput1, int aPerc1, Material aOutput2, int aPerc2, Material aOutput3, int aPerc3, Material aOutput4, int aPerc4) {
        Pair<Material, Integer> aFluidOutput1 = new Pair<Material, Integer>(aOutput1, aPerc1);
        Pair<Material, Integer> aFluidOutput2 = new Pair<Material, Integer>(aOutput2, aPerc2);
        Pair<Material, Integer> aFluidOutput3 = new Pair<Material, Integer>(aOutput3, aPerc3);
        Pair<Material, Integer> aFluidOutput4 = new Pair<Material, Integer>(aOutput4, aPerc4);
        Quad<Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>> aDataQuad = new Quad<Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>>(aFluidOutput1, aFluidOutput2, aFluidOutput3, aFluidOutput4);
        aMilledFluidMap.put(aMilledFluid.getUnlocalizedName(), aDataQuad);
    }

    private static ItemStack[] getOutputsFromMap(Fluid aFluid) {
        String aKey = aFluid.getUnlocalizedName();
        return MilledOreProcessing.getArrayFromQuad(aMilledFluidMap.get(aKey));
    }

    private static ItemStack[] getArrayFromQuad(Quad<Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>, Pair<Material, Integer>> aData) {
        AutoMap<ItemStack> aOutputs = new AutoMap<ItemStack>();
        for (Object aPair : aData.values()) {
            if (aPair == null || !Pair.class.isInstance(aPair)) continue;
            Pair aObj = (Pair)aPair;
            Material aMat = (Material)aObj.getKey();
            int aCount = (Integer)aObj.getValue();
            aOutputs.addAll((Collection<ItemStack>)MilledOreProcessing.getItemStackFromPair(aMat, aCount));
        }
        ItemStack[] aRealOutputArray = new ItemStack[aOutputs.size()];
        int aIndex = 0;
        for (ItemStack aStack : aOutputs) {
            aRealOutputArray[aIndex++] = aStack;
        }
        return aRealOutputArray;
    }

    private static AutoMap<ItemStack> getItemStackFromPair(Material aMat, Integer aCount) {
        AutoMap<ItemStack> aOutputs = new AutoMap<ItemStack>();
        if (aCount > 64) {
            AutoMap<Integer> sizes = MilledOreProcessing.getStackSizes(aCount);
            for (int aSplitSize : sizes) {
                ItemStack aDustStack = aMat.getDust(aSplitSize);
                aOutputs.put(aDustStack);
            }
        } else {
            ItemStack aDustStack = aMat.getDust(aCount);
            aOutputs.put(aDustStack);
        }
        return aOutputs;
    }

    private static AutoMap<Integer> getStackSizes(int aBigSize) {
        AutoMap<Integer> aSizes = new AutoMap<Integer>();
        if (aBigSize <= 64) {
            aSizes.add(aBigSize);
        } else {
            for (int i = aBigSize; i > 0; i -= 64) {
                aSizes.add(i);
            }
        }
        return aSizes;
    }

    static {
        aMilledFluidMap = new HashMap();
    }
}

