/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.potion.GtPotionEffect;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;

public class PlayerSleepEventHandler {
    private static Field sEffectDuration = ReflectionUtils.getField(PotionEffect.class, "duration");
    private static ArrayList<Potion> sPositiveEffects = new ArrayList();
    private static ArrayList<Potion> sNegativeEffects = new ArrayList();

    public static void init() {
        Utils.registerEvent(new PlayerSleepEventHandler());
        sPositiveEffects.add(Potion.field_76424_c);
        sPositiveEffects.add(Potion.field_76427_o);
        sPositiveEffects.add(Potion.field_76429_m);
        sPositiveEffects.add(Potion.field_76428_l);
        sPositiveEffects.add(Potion.field_76420_g);
        sPositiveEffects.add(Potion.field_76422_e);
        sPositiveEffects.add(Potion.field_76426_n);
        sPositiveEffects.add(Potion.field_76434_w);
        sPositiveEffects.add(Potion.field_76444_x);
        sNegativeEffects.add(Potion.field_76440_q);
        sNegativeEffects.add(Potion.field_76431_k);
        sNegativeEffects.add(Potion.field_76419_f);
        sNegativeEffects.add(Potion.field_76433_i);
        sNegativeEffects.add(Potion.field_76438_s);
        sNegativeEffects.add(Potion.field_76421_d);
        sNegativeEffects.add(Potion.field_76436_u);
        sNegativeEffects.add(Potion.field_76437_t);
        sNegativeEffects.add(Potion.field_82731_v);
    }

    @SubscribeEvent
    public void sleep(PlayerSleepInBedEvent event) {
    }

    @SubscribeEvent
    public void wake(PlayerWakeUpEvent event) {
        EntityPlayer aPlayer = event.entityPlayer;
        if (aPlayer != null && !aPlayer.field_70170_p.field_72995_K) {
            boolean aRemovedBad = false;
            try {
                Collection aActive = aPlayer.func_70651_bq();
                for (PotionEffect aEffect : aActive) {
                    for (Potion aBadPotion : sNegativeEffects) {
                        if (aEffect.func_76456_a() != aBadPotion.func_76396_c()) continue;
                        ReflectionUtils.setField((Object)aEffect, sEffectDuration, (Object)1);
                        aRemovedBad = true;
                        Logger.INFO("Set duration of " + aEffect.func_76453_d() + " to 1 tick");
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (aRemovedBad) {
                PlayerSleepEventHandler.messagePlayer(aPlayer, "sleep.event.downsides");
            } else {
                float aMaxHP;
                float aCurrentHP = aPlayer.func_110143_aJ();
                if (aCurrentHP < (aMaxHP = aPlayer.func_110138_aP())) {
                    float aDamage = aMaxHP - aCurrentHP;
                    float aToHeal = MathUtils.randFloat(1.0f, aDamage);
                    if (aToHeal > 0.0f) {
                        aPlayer.func_70691_i(aToHeal);
                        PlayerSleepEventHandler.messagePlayer(aPlayer, aToHeal >= aDamage / 2.0f ? "sleep.event.good" : "sleep.event.okay");
                    }
                } else {
                    int aRandomBuff = MathUtils.randInt(0, sPositiveEffects.size() - 1);
                    Potion aPotionToApply = sPositiveEffects.get(aRandomBuff);
                    if (aPotionToApply != null) {
                        aPlayer.func_70690_d((PotionEffect)new GtPotionEffect(aPotionToApply.field_76415_H, MathUtils.randInt(60, 180), MathUtils.randInt(0, 2)));
                        PlayerSleepEventHandler.messagePlayer(aPlayer, "sleep.event.wellrested");
                    }
                }
            }
        }
    }

    private static void messagePlayer(EntityPlayer aPlayer, String aChatKey) {
        PlayerUtils.messagePlayer(aPlayer, (IChatComponent)new ChatComponentTranslation(aChatKey, new Object[0]));
    }
}

