/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.entity;

import gtPlusPlus.api.damage.DamageTeslaTower;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.random.XSTR;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityWeatherEffect;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityTeslaTowerLightning
extends EntityWeatherEffect {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private final UUID boltID;
    private final UUID boltOwnerID;
    private final Entity boltValidDamageTarget;

    public EntityTeslaTowerLightning(World p_i1703_1_, double p_i1703_2_, double p_i1703_4_, double p_i1703_6_, Entity valid, UUID owner) {
        super(p_i1703_1_);
        Logger.INFO("Plasma Bolt - Created.");
        XSTR rand = new XSTR(p_i1703_1_.func_72905_C());
        this.func_70012_b(p_i1703_2_, p_i1703_4_, p_i1703_6_, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = ((Random)rand).nextLong();
        this.boltLivingTime = 1 + ((Random)rand).nextInt(3) + 1;
        this.boltValidDamageTarget = valid;
        this.boltID = UUID.randomUUID();
        this.boltOwnerID = owner;
        if (!p_i1703_1_.field_72995_K && p_i1703_1_.func_82736_K().func_82766_b("doFireTick") && (p_i1703_1_.field_73013_u == EnumDifficulty.NORMAL || p_i1703_1_.field_73013_u == EnumDifficulty.HARD) && p_i1703_1_.func_72873_a(MathHelper.func_76128_c((double)p_i1703_2_), MathHelper.func_76128_c((double)p_i1703_4_), MathHelper.func_76128_c((double)p_i1703_6_), 10)) {
            Logger.INFO("Plasma Bolt - Putting out fires?.");
            int i = MathHelper.func_76128_c((double)p_i1703_2_);
            int j = MathHelper.func_76128_c((double)p_i1703_4_);
            int k = MathHelper.func_76128_c((double)p_i1703_6_);
            if (p_i1703_1_.func_147439_a(i, j, k).func_149688_o() == Material.field_151581_o) {
                p_i1703_1_.func_147449_b(i, j, k, Blocks.field_150350_a);
            }
            for (i = 0; i < 4; ++i) {
                int l;
                j = MathHelper.func_76128_c((double)p_i1703_2_) + ((Random)rand).nextInt(3) - 1;
                if (p_i1703_1_.func_147439_a(j, k = MathHelper.func_76128_c((double)p_i1703_4_) + ((Random)rand).nextInt(3) - 1, l = MathHelper.func_76128_c((double)p_i1703_6_) + ((Random)rand).nextInt(3) - 1).func_149688_o() != Material.field_151581_o) continue;
                p_i1703_1_.func_147449_b(j, k, l, Blocks.field_150350_a);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Logger.INFO("Plasma Bolt - Tick.");
        XSTR rand = new XSTR(this.field_70170_p.func_72905_C());
        if (this.lightningState == 2) {
            Logger.INFO("Plasma Bolt - Playing Sound.");
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "ambient.weather.thunder", 10000.0f, 0.8f + ((Random)rand).nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState >= 0) {
            Logger.INFO("Plasma Bolt - state >= 0.");
            if (this.field_70170_p.field_72995_K) {
                Logger.INFO("Plasma Bolt - World is remote, resetting state to 2.");
                this.field_70170_p.field_73016_r = 2;
            } else {
                Logger.INFO("Plasma Bolt - World is server side.");
                double d0 = 3.0;
                List list = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - d0), (double)(this.field_70163_u - d0), (double)(this.field_70161_v - d0), (double)(this.field_70165_t + d0), (double)(this.field_70163_u + 6.0 + d0), (double)(this.field_70161_v + d0)));
                for (int l = 0; l < list.size(); ++l) {
                    Entity entity = (Entity)list.get(l);
                    if (!this.boltValidDamageTarget.func_110124_au().equals(entity.func_110124_au()) || entity.func_110124_au().equals(this.boltOwnerID)) continue;
                    Logger.INFO("Plasma Bolt - Hurting Entity.");
                    Logger.INFO("Plasma Bolt - " + entity.func_70005_c_() + ".");
                    EntityUtils.doFireDamage(entity, 5);
                    EntityUtils.doDamage(entity, (DamageSource)new DamageTeslaTower(entity), 20);
                }
            }
        }
        if (this.lightningState < 0) {
            Logger.INFO("Plasma Bolt - state < 0.");
            if (this.boltLivingTime == 0) {
                Logger.INFO("Plasma Bolt - setting dead.");
                this.func_70106_y();
            } else if (this.lightningState < -((Random)rand).nextInt(10)) {
                Logger.INFO("Plasma Bolt - dunno.");
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = ((Random)rand).nextLong();
                if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doFireTick") && this.field_70170_p.func_72873_a(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), 10)) {
                    Logger.INFO("Plasma Bolt - Putting fires out [2].");
                    int i = MathHelper.func_76128_c((double)this.field_70165_t);
                    int j = MathHelper.func_76128_c((double)this.field_70163_u);
                    int k = MathHelper.func_76128_c((double)this.field_70161_v);
                    if (this.field_70170_p.func_147439_a(i, j, k).func_149688_o() == Material.field_151581_o) {
                        this.field_70170_p.func_147449_b(i, j, k, Blocks.field_150350_a);
                    }
                }
            }
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }
}

