/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.chunkloading;

import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gtPlusPlus.api.interfaces.IChunkLoader;
import gtPlusPlus.core.chunkloading.GTPP_ChunkManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;

public class StaticChunkFunctions {
    public static void saveNBTDataForTileEntity(IGregTechTileEntity aBaseMetaTileEntity, NBTTagCompound aNBT) {
        IChunkLoader aTileEntity = StaticChunkFunctions.getChunkLoader(aBaseMetaTileEntity);
        aNBT.func_74757_a("chunkLoadingEnabled", aTileEntity.getChunkLoadingActive());
        aNBT.func_74757_a("isChunkloading", aTileEntity.getResidingChunk() != null);
        if (aTileEntity.getResidingChunk() != null) {
            aNBT.func_74768_a("loadedChunkXPos", aTileEntity.getResidingChunk().field_77276_a);
            aNBT.func_74768_a("loadedChunkZPos", aTileEntity.getResidingChunk().field_77275_b);
        }
    }

    public static void loadNBTDataForTileEntity(IGregTechTileEntity aBaseMetaTileEntity, NBTTagCompound aNBT) {
        IChunkLoader aTileEntity = StaticChunkFunctions.getChunkLoader(aBaseMetaTileEntity);
        if (aNBT.func_74764_b("chunkLoadingEnabled")) {
            aTileEntity.setChunkLoadingActive(aNBT.func_74767_n("chunkLoadingEnabled"));
        }
        if (aNBT.func_74767_n("isChunkloading")) {
            aTileEntity.setResidingChunk(new ChunkCoordIntPair(aNBT.func_74762_e("loadedChunkXPos"), aNBT.func_74762_e("loadedChunkZPos")));
        }
    }

    public static void onRemoval(IGregTechTileEntity aBaseMetaTileEntity) {
        IChunkLoader aTileEntity = StaticChunkFunctions.getChunkLoader(aBaseMetaTileEntity);
        if (aTileEntity.getChunkLoadingActive()) {
            GTPP_ChunkManager.releaseTicket((TileEntity)aBaseMetaTileEntity);
        }
    }

    public static boolean onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IChunkLoader aTileEntity = StaticChunkFunctions.getChunkLoader(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isServerSide() && aTileEntity.getResidingChunk() != null && !aTileEntity.getDoesWorkChunkNeedReload() && !aBaseMetaTileEntity.isAllowedToWork()) {
            GTPP_ChunkManager.releaseTicket((TileEntity)aBaseMetaTileEntity);
            aTileEntity.setDoesWorkChunkNeedReload(true);
            return false;
        }
        return true;
    }

    public static void createInitialWorkingChunk(IGregTechTileEntity aBaseMetaTileEntity, int aChunkX, int aDrillZ) {
        int centerX = aChunkX >> 4;
        int centerZ = aDrillZ >> 4;
        IChunkLoader aTileEntity = StaticChunkFunctions.getChunkLoader(aBaseMetaTileEntity);
        aTileEntity.addChunkToLoadedList(new ChunkCoordIntPair(centerX, centerZ));
        GTPP_ChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity.getMetaTileEntity(), aTileEntity.getResidingChunk());
        aTileEntity.setDoesWorkChunkNeedReload(false);
    }

    private static final IChunkLoader getChunkLoader(IGregTechTileEntity aTile) {
        return (IChunkLoader)aTile.getMetaTileEntity();
    }
}

