/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.chunkloading;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import gregtech.GT_Mod;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Log;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.interfaces.IChunkLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class GTPP_ChunkManager
implements ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private Map<TileEntity, ForgeChunkManager.Ticket> registeredTickets = new HashMap<TileEntity, ForgeChunkManager.Ticket>();
    private static GTPP_ChunkManager instance = new GTPP_ChunkManager();
    public static boolean enableChunkloaders = true;
    public static boolean alwaysReloadChunkloaders = false;
    public static boolean debugChunkloaders = false;

    public static void init() {
        if (enableChunkloaders) {
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)GTplusplus.instance, (ForgeChunkManager.LoadingCallback)instance);
        }
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        ArrayList<ForgeChunkManager.Ticket> validTickets = new ArrayList<ForgeChunkManager.Ticket>();
        if (alwaysReloadChunkloaders) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                TileEntity tile;
                int x = ticket.getModData().func_74762_e("OwnerX");
                int y = ticket.getModData().func_74762_e("OwnerY");
                int z = ticket.getModData().func_74762_e("OwnerZ");
                if (y <= 0 || (tile = world.func_147438_o(x, y, z)) == null || !(tile instanceof IGregTechTileEntity) || !((IGregTechTileEntity)tile).isAllowedToWork()) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x >> 4, z >> 4));
                if (this.registeredTickets.containsKey(tile)) continue;
                this.registeredTickets.put(tile, ticket);
                if (((IGregTechTileEntity)tile).getMetaTileEntity() instanceof IChunkLoader) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)((IChunkLoader)((IGregTechTileEntity)tile).getMetaTileEntity()).getResidingChunk());
                }
                validTickets.add(ticket);
            }
        }
        return validTickets;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return ArrayListMultimap.create();
    }

    public static boolean requestPlayerChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ, String player) {
        if (!enableChunkloaders) {
            return false;
        }
        if (!alwaysReloadChunkloaders && chunkXZ == null) {
            return false;
        }
        if (debugChunkloaders && chunkXZ != null) {
            GT_Log.out.println("GT_ChunkManager: Chunk request: (" + chunkXZ.field_77276_a + ", " + chunkXZ.field_77275_b + ")");
        }
        if (GTPP_ChunkManager.instance.registeredTickets.containsKey(owner)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)GTPP_ChunkManager.instance.registeredTickets.get(owner), (ChunkCoordIntPair)chunkXZ);
        } else {
            ForgeChunkManager.Ticket ticket = null;
            ticket = player != "" ? ForgeChunkManager.requestPlayerTicket((Object)GT_Mod.instance, (String)player, (World)owner.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL) : ForgeChunkManager.requestTicket((Object)GT_Mod.instance, (World)owner.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket == null) {
                if (debugChunkloaders) {
                    GT_Log.out.println("GT_ChunkManager: ForgeChunkManager.requestTicket failed");
                }
                return false;
            }
            if (debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: ticket issued for machine at: (" + owner.field_145851_c + ", " + owner.field_145848_d + ", " + owner.field_145849_e + ")");
            }
            NBTTagCompound tag = ticket.getModData();
            tag.func_74768_a("OwnerX", owner.field_145851_c);
            tag.func_74768_a("OwnerY", owner.field_145848_d);
            tag.func_74768_a("OwnerZ", owner.field_145849_e);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
            if (alwaysReloadChunkloaders) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(owner.field_145851_c << 4, owner.field_145849_e << 4));
            }
            GTPP_ChunkManager.instance.registeredTickets.put(owner, ticket);
        }
        return true;
    }

    public static boolean requestChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        return GTPP_ChunkManager.requestPlayerChunkLoad(owner, chunkXZ, "");
    }

    public static void releaseChunk(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        if (!enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GTPP_ChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: Chunk release: (" + chunkXZ.field_77276_a + ", " + chunkXZ.field_77275_b + ")");
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
        }
    }

    public static void releaseTicket(TileEntity owner) {
        if (!enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GTPP_ChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: ticket released by machine at: (" + owner.field_145851_c + ", " + owner.field_145848_d + ", " + owner.field_145849_e + ")");
                for (ChunkCoordIntPair chunk : ticket.getChunkList()) {
                    GT_Log.out.println("GT_ChunkManager: Chunk release: (" + chunk.field_77276_a + ", " + chunk.field_77275_b + ")");
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            GTPP_ChunkManager.instance.registeredTickets.remove(owner);
        }
    }

    public static void printTickets() {
        if (!debugChunkloaders) {
            return;
        }
        GT_Log.out.println("GT_ChunkManager: Start forced chunks dump:");
        GTPP_ChunkManager.instance.registeredTickets.forEach((machine, ticket) -> {
            GT_Log.out.print("GT_ChunkManager: Chunks forced by the machine at (" + machine.field_145851_c + ", " + machine.field_145848_d + ", " + machine.field_145849_e + ")");
            if (ticket.isPlayerTicket()) {
                GT_Log.out.print(" Owner: " + ticket.getPlayerName());
            }
            GT_Log.out.print(" :");
            for (ChunkCoordIntPair c : ticket.getChunkList()) {
                GT_Log.out.print("(");
                GT_Log.out.print(c.field_77276_a);
                GT_Log.out.print(", ");
                GT_Log.out.print(c.field_77275_b);
                GT_Log.out.print("), ");
            }
        });
        GT_Log.out.println("GT_ChunkManager: End forced chunks dump:");
    }

    public static class DebugCommand
    extends CommandBase {
        public String func_71517_b() {
            return "gtpp:dump_chunks";
        }

        public int func_82362_a() {
            return 0;
        }

        public String func_71518_a(ICommandSender sender) {
            return "/" + this.func_71517_b();
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            GTPP_ChunkManager.printTickets();
        }
    }
}

