/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.general.antigrief;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.tileentities.general.TileEntityReverter;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TowerDevice
extends Block {
    private static IIcon TEX_ANTIBUILDER;
    public static final int META_ANTIBUILDER = 9;
    private boolean bUnbreakable;

    public TowerDevice() {
        super(Material.field_151575_d);
        this.func_149711_c(10.0f);
        this.func_149752_b(35.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149647_a(AddToCreativeTab.tabMachines);
    }

    public int tickRate() {
        return 15;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("bUnbreakable", this.bUnbreakable);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.bUnbreakable = aNBT.func_74767_n("bUnbreakable");
    }

    public IIcon func_149691_a(int side, int meta) {
        return TEX_ANTIBUILDER;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        TEX_ANTIBUILDER = par1IconRegister.func_94245_a("miscutils:blockAntiGrief");
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 9));
    }

    public boolean func_149727_a(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        int meta = par1World.func_72805_g(x, y, z);
        return false;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return super.func_149712_f(world, x, y, z);
    }

    public static boolean areNearbyLockBlocks(World world, int x, int y, int z) {
        boolean locked = false;
        for (int dx = x - 2; dx <= x + 2; ++dx) {
            for (int dy = y - 2; dy <= y + 2; ++dy) {
                for (int dz = z - 2; dz <= z + 2; ++dz) {
                    if (world.func_147439_a(dx, dy, dz) != ModBlocks.blockGriefSaver || world.func_72805_g(dx, dy, dz) != 4) continue;
                    locked = true;
                }
            }
        }
        return locked;
    }

    public static void unlockBlock(World par1World, int x, int y, int z) {
        Block thereBlockID = par1World.func_147439_a(x, y, z);
        int thereBlockMeta = par1World.func_72805_g(x, y, z);
        if (thereBlockID == ModBlocks.blockGriefSaver || thereBlockMeta == 4) {
            TowerDevice.changeToBlockMeta(par1World, x, y, z, 5);
            par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
        }
    }

    private static void changeToBlockMeta(World par1World, int x, int y, int z, int meta) {
        Block thereBlockID = par1World.func_147439_a(x, y, z);
        if (thereBlockID == ModBlocks.blockGriefSaver) {
            par1World.func_147465_d(x, y, z, thereBlockID, meta, 3);
            par1World.func_147458_c(x, y, z, x, y, z);
            par1World.func_147459_d(x, y, z, thereBlockID);
        }
    }

    public void func_149726_b(World par1World, int x, int y, int z) {
        int meta = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K) {
            // empty if block
        }
    }

    public void func_149695_a(World par1World, int x, int y, int z, Block myBlockID) {
        int meta = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K) {
            // empty if block
        }
    }

    public void func_149674_a(World par1World, int x, int y, int z, Random par5Random) {
        if (!par1World.field_72995_K) {
            int n = par1World.func_72805_g(x, y, z);
        }
    }

    private void letsBuild(World par1World, int x, int y, int z) {
    }

    private boolean isInactiveTrapCharged(World par1World, int x, int y, int z) {
        return false;
    }

    private boolean isReactorReady(World world, int x, int y, int z) {
        return world.func_147439_a(x, y + 1, z) == Blocks.field_150451_bX && world.func_147439_a(x, y - 1, z) == Blocks.field_150451_bX && world.func_147439_a(x + 1, y, z) == Blocks.field_150451_bX && world.func_147439_a(x - 1, y, z) == Blocks.field_150451_bX && world.func_147439_a(x, y, z + 1) == Blocks.field_150451_bX && world.func_147439_a(x, y, z - 1) == Blocks.field_150451_bX;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int x, int y, int z, Random par5Random) {
        int meta = par1World.func_72805_g(x, y, z);
        if (meta == 3 || meta == 1 || meta == 9) {
            for (int i = 0; i < 1; ++i) {
                this.sparkle(par1World, x, y, z, par5Random);
            }
        }
    }

    public void sparkle(World world, int x, int y, int z, Random rand) {
        double offset = 0.0625;
        for (int side = 0; side < 6; ++side) {
            double rx = (float)x + rand.nextFloat();
            double ry = (float)y + rand.nextFloat();
            double rz = (float)z + rand.nextFloat();
            if (side == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                ry = (double)(y + 1) + 0.0625;
            }
            if (side == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                ry = (double)(y + 0) - 0.0625;
            }
            if (side == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                rz = (double)(z + 1) + 0.0625;
            }
            if (side == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                rz = (double)(z + 0) - 0.0625;
            }
            if (side == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                rx = (double)(x + 1) + 0.0625;
            }
            if (side == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                rx = (double)(x + 0) - 0.0625;
            }
            if (!(rx < (double)x || rx > (double)(x + 1) || ry < 0.0 || ry > (double)(y + 1) || rz < (double)z) && !(rz > (double)(z + 1))) continue;
            world.func_72869_a("reddust", rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }

    public static void checkAndActivateVanishBlock(World world, int x, int y, int z) {
        Block thereID = world.func_147439_a(x, y, z);
        int thereMeta = world.func_72805_g(x, y, z);
    }

    public static void changeToActiveVanishBlock(World par1World, int x, int y, int z, int meta) {
        TowerDevice.changeToBlockMeta(par1World, x, y, z, meta);
        par1World.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.3f, 0.6f);
        Block thereBlockID = par1World.func_147439_a(x, y, z);
        par1World.func_147464_a(x, y, z, thereBlockID, TowerDevice.getTickRateFor(thereBlockID, meta, par1World.field_73012_v));
    }

    private static int getTickRateFor(Block thereBlockID, int meta, Random rand) {
        return 15;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block blockID = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (blockID != this) {
            return 0;
        }
        return 10;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata == 0) {
            Logger.INFO("I have been created. [Antigriefer]" + this.func_149732_F());
            return new TileEntityReverter();
        }
        return null;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        switch (meta) {
            case 0: {
                return null;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149692_a(int meta) {
        return meta;
    }
}

