/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.api.interfaces.ITileTooltip;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.CubicObject;
import gtPlusPlus.api.objects.minecraft.SafeTexture;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.InventoryUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BasicTileBlockWithTooltip
extends BlockContainer
implements ITileTooltip {
    @SideOnly(value=Side.CLIENT)
    private AutoMap<CubicObject<SafeTexture>> mSidedTextureArray;
    @SideOnly(value=Side.CLIENT)
    private AutoMap<CubicObject<String>> mSidedTexturePathArray;

    public final boolean hasMeta() {
        return this.getMetaCount() > 0;
    }

    public abstract int getMetaCount();

    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlock.class;
    }

    public abstract String getUnlocalBlockName();

    public final boolean hasTooltip() {
        return this.getTooltipID() >= -1;
    }

    protected abstract float initBlockHardness();

    protected abstract float initBlockResistance();

    protected abstract CreativeTabs initCreativeTab();

    @Override
    public abstract int getTooltipID();

    public BasicTileBlockWithTooltip(Material aBlockMat) {
        super(aBlockMat);
        this.func_149711_c(this.initBlockHardness());
        this.func_149752_b(this.initBlockResistance());
        this.func_149663_c(this.getUnlocalBlockName());
        this.func_149647_a(this.initCreativeTab());
        GameRegistry.registerBlock((Block)this, this.getItemBlockClass(), (String)this.getUnlocalBlockName());
        Logger.INFO("Registered " + this.getTileEntityName() + ".");
        if (Utils.isClient()) {
            this.handleTextures();
        }
    }

    protected abstract String getTileEntityName();

    private final String getTileEntityNameForTexturePathing() {
        return Utils.sanitizeString(this.getTileEntityName().replace(" ", ""));
    }

    public CubicObject<String>[] getCustomTextureDirectoryObject() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int aSide, int aMeta) {
        return this.mSidedTextureArray.get(aMeta).get(aSide).getIcon();
    }

    public IIcon func_149673_e(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return super.func_149673_e(aWorld, aX, aY, aZ, aSide);
    }

    @SideOnly(value=Side.CLIENT)
    private final void handleTextures() {
        Logger.INFO("[TeTexture] Building Texture Maps for " + this.getTileEntityName() + ".");
        this.mSidedTextureArray = new AutoMap();
        this.mSidedTexturePathArray = new AutoMap();
        String aPrefixTexPath = "miscutils:";
        String aTexPathMid = "TileEntities/" + this.getTileEntityNameForTexturePathing() + "/";
        String aTexPathBuilt = "miscutils:" + aTexPathMid;
        if (this.getCustomTextureDirectoryObject() != null) {
            CubicObject<String>[] aDataMap = this.getCustomTextureDirectoryObject();
            Logger.INFO("[TeTexture] Found custom texture data, using this instead. Size: " + aDataMap.length);
            for (int i = 0; i < aDataMap.length; ++i) {
                this.mSidedTexturePathArray.put(aDataMap[i]);
                Logger.INFO("Mapped value for meta " + i + ".");
            }
        } else {
            Logger.INFO("[TeTexture] Processing " + (1 + this.getMetaCount()) + " sets.");
            for (int i = 0; i < 1 + this.getMetaCount(); ++i) {
                String aStringBot = "Bottom";
                String aStringTop = "Top";
                String aStringBack = "Back";
                String aStringFront = "Front";
                String aStringLeft = "Left";
                String aStringRight = "Right";
                if (this.hasMeta()) {
                    aStringBot = aStringBot + "_" + i;
                    aStringTop = aStringTop + "_" + i;
                    aStringBack = aStringBack + "_" + i;
                    aStringFront = aStringFront + "_" + i;
                    aStringLeft = aStringLeft + "_" + i;
                    aStringRight = aStringRight + "_" + i;
                }
                aStringBot = aTexPathBuilt + aStringBot;
                aStringTop = aTexPathBuilt + aStringTop;
                aStringBack = aTexPathBuilt + aStringBack;
                aStringFront = aTexPathBuilt + aStringFront;
                aStringLeft = aTexPathBuilt + aStringLeft;
                aStringRight = aTexPathBuilt + aStringRight;
                CubicObject<String> aMetaBlob = new CubicObject<String>(aStringBot, aStringTop, aStringBack, aStringFront, aStringLeft, aStringRight);
                this.mSidedTexturePathArray.put(aMetaBlob);
                Logger.INFO("[TeTexture] Added Texture Path data to map for meta " + i);
            }
        }
        Logger.INFO("[TeTexture] Map size for pathing: " + this.mSidedTexturePathArray.size());
        int aIndex = 0;
        for (CubicObject<String> aMetaBlob : this.mSidedTexturePathArray) {
            SafeTexture aBottom = SafeTexture.register((String)aMetaBlob.DOWN);
            SafeTexture aTop = SafeTexture.register((String)aMetaBlob.UP);
            SafeTexture aBack = SafeTexture.register((String)aMetaBlob.NORTH);
            SafeTexture aFont = SafeTexture.register((String)aMetaBlob.SOUTH);
            SafeTexture aWest = SafeTexture.register((String)aMetaBlob.WEST);
            SafeTexture aEast = SafeTexture.register((String)aMetaBlob.EAST);
            SafeTexture[] aInjectBlob = new SafeTexture[]{aBottom, aTop, aBack, aFont, aWest, aEast};
            CubicObject<SafeTexture> aMetaBlob2 = new CubicObject<SafeTexture>(aInjectBlob);
            this.mSidedTextureArray.put(aMetaBlob2);
            Logger.INFO("[TeTexture] Added SafeTexture data to map for meta " + aIndex++);
        }
        Logger.INFO("[TeTexture] Map size for registration: " + this.mSidedTextureArray.size());
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister aRegisterer) {
        this.field_149761_L = aRegisterer.func_94245_a("miscutils:net");
    }

    public abstract TileEntity func_149915_a(World var1, int var2);

    public void onBlockBreak() {
    }

    public final void func_149749_a(World world, int x, int y, int z, Block block, int number) {
        this.onBlockBreak();
        InventoryUtils.dropInventoryItems(world, x, y, z, block);
        super.func_149749_a(world, x, y, z, block, number);
    }

    public final void func_149666_a(Item aItem, CreativeTabs p_149666_2_, List aList) {
        if (this.hasMeta()) {
            for (int i = 0; i < this.getMetaCount(); ++i) {
                aList.add(ItemUtils.simpleMetaStack(aItem, i, 1));
            }
        } else {
            aList.add(ItemUtils.getSimpleStack(aItem));
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        int l = aWorld.func_72805_g(aX, aY, aZ);
        return l;
    }

    public Item func_149650_a(int meta, Random rand, int p_149650_3_) {
        return ItemUtils.getSimpleStack((Block)this, 1).func_77973_b();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(ItemUtils.simpleMetaStack((Block)this, metadata, 1));
        return drops;
    }
}

