/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.australia.gen.world;

import gtPlusPlus.core.util.math.MathUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenAustralianTrees
extends WorldGenTrees {
    private final int minHeight;
    private final boolean growVines;
    private final int woodMeta;
    private final int leavesMeta;

    public WorldGenAustralianTrees(boolean p_i2027_1_) {
        this(p_i2027_1_, 4, false);
    }

    public WorldGenAustralianTrees(boolean p_i2028_1_, int aMinHeight, boolean aVinesGrow) {
        super(p_i2028_1_, aMinHeight, 0, 0, aVinesGrow);
        this.minHeight = aMinHeight;
        this.woodMeta = 0;
        this.leavesMeta = 0;
        this.growVines = aVinesGrow;
    }

    public boolean func_76484_a(World aWorld, Random aRand, int aX, int aY, int aZ) {
        int aActualMinHeight = MathUtils.randInt(4, 8) + this.minHeight;
        boolean flag = true;
        if (aY >= 1 && aY + aActualMinHeight + 1 <= 256) {
            Block block;
            int k1;
            int b0;
            for (int i1 = aY; i1 <= aY + 1 + aActualMinHeight; ++i1) {
                b0 = 1;
                if (i1 == aY) {
                    b0 = 0;
                }
                if (i1 >= aY + 1 + aActualMinHeight - 2) {
                    b0 = 2;
                }
                for (int j1 = aX - b0; j1 <= aX + b0 && flag; ++j1) {
                    for (k1 = aZ - b0; k1 <= aZ + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            block = aWorld.func_147439_a(j1, i1, k1);
                            if (this.isReplaceable(aWorld, j1, i1, k1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block2 = aWorld.func_147439_a(aX, aY - 1, aZ);
            boolean isSoil = true;
            for (int gh = 0; gh < 5; ++gh) {
                int zMod;
                int xMod;
                if (gh == 0) {
                    xMod = 1;
                    zMod = 0;
                } else if (gh == 1) {
                    xMod = 0;
                    zMod = 1;
                } else if (gh == 2) {
                    xMod = -1;
                    zMod = 0;
                } else if (gh == 3) {
                    xMod = 0;
                    zMod = -1;
                } else {
                    xMod = 0;
                    zMod = 0;
                }
                block2 = aWorld.func_147439_a(aX + xMod, aY - 1, aZ + zMod);
                if (block2 != Blocks.field_150350_a && block2.canSustainPlant((IBlockAccess)aWorld, aX + xMod, aY - 1, aZ + zMod, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) continue;
                isSoil = false;
                break;
            }
            if (isSoil && aY < 256 - aActualMinHeight - 1) {
                int j2;
                int i2;
                int l1;
                int i3;
                block2.onPlantGrow(aWorld, aX, aY - 1, aZ, aX, aY, aZ);
                b0 = 5;
                int b1 = 0;
                for (k1 = aY - b0 + aActualMinHeight; k1 <= aY + aActualMinHeight; ++k1) {
                    i3 = k1 - (aY + aActualMinHeight);
                    l1 = b1 + 3 - i3 / 2;
                    for (i2 = aX - l1; i2 <= aX + l1; ++i2) {
                        j2 = i2 - aX;
                        for (int k2 = aZ - l1; k2 <= aZ + l1; ++k2) {
                            Block block1;
                            int l2 = k2 - aZ;
                            if (Math.abs(j2) == l1 && Math.abs(l2) == l1 && (aRand.nextInt(2) == 0 || i3 == 0) || !(block1 = aWorld.func_147439_a(i2, k1, k2)).isAir((IBlockAccess)aWorld, i2, k1, k2) && !block1.isLeaves((IBlockAccess)aWorld, i2, k1, k2)) continue;
                            this.func_150516_a(aWorld, i2, k1, k2, (Block)Blocks.field_150362_t, this.leavesMeta);
                        }
                    }
                }
                for (k1 = 0; k1 < aActualMinHeight; ++k1) {
                    block = aWorld.func_147439_a(aX, aY + k1, aZ);
                    if (!block.isAir((IBlockAccess)aWorld, aX, aY + k1, aZ) && !block.isLeaves((IBlockAccess)aWorld, aX, aY + k1, aZ)) continue;
                    this.func_150516_a(aWorld, aX, aY + k1, aZ, Blocks.field_150364_r, this.woodMeta);
                    if (k1 < aActualMinHeight - 2) {
                        if (aWorld.func_147437_c(aX + 1, aY + k1, aZ) || block.isLeaves((IBlockAccess)aWorld, aX + 1, aY + k1, aZ)) {
                            this.func_150516_a(aWorld, aX + 1, aY + k1, aZ, Blocks.field_150364_r, this.woodMeta);
                        }
                        if (aWorld.func_147437_c(aX - 1, aY + k1, aZ) || block.isLeaves((IBlockAccess)aWorld, aX - 1, aY + k1, aZ)) {
                            this.func_150516_a(aWorld, aX - 1, aY + k1, aZ, Blocks.field_150364_r, this.woodMeta);
                        }
                        if (aWorld.func_147437_c(aX, aY + k1, aZ + 1) || block.isLeaves((IBlockAccess)aWorld, aX, aY + k1, aZ + 1)) {
                            this.func_150516_a(aWorld, aX, aY + k1, aZ + 1, Blocks.field_150364_r, this.woodMeta);
                        }
                        if (aWorld.func_147437_c(aX, aY + k1, aZ - 1) || block.isLeaves((IBlockAccess)aWorld, aX, aY + k1, aZ - 1)) {
                            this.func_150516_a(aWorld, aX, aY + k1, aZ - 1, Blocks.field_150364_r, this.woodMeta);
                        }
                    }
                    if (!this.growVines || k1 <= 0) continue;
                    if (aRand.nextInt(3) > 0 && aWorld.func_147437_c(aX - 1, aY + k1, aZ)) {
                        this.func_150516_a(aWorld, aX - 1, aY + k1, aZ, Blocks.field_150395_bd, 8);
                    }
                    if (aRand.nextInt(3) > 0 && aWorld.func_147437_c(aX + 1, aY + k1, aZ)) {
                        this.func_150516_a(aWorld, aX + 1, aY + k1, aZ, Blocks.field_150395_bd, 2);
                    }
                    if (aRand.nextInt(3) > 0 && aWorld.func_147437_c(aX, aY + k1, aZ - 1)) {
                        this.func_150516_a(aWorld, aX, aY + k1, aZ - 1, Blocks.field_150395_bd, 1);
                    }
                    if (aRand.nextInt(3) <= 0 || !aWorld.func_147437_c(aX, aY + k1, aZ + 1)) continue;
                    this.func_150516_a(aWorld, aX, aY + k1, aZ + 1, Blocks.field_150395_bd, 4);
                }
                if (this.growVines) {
                    for (k1 = aY - 3 + aActualMinHeight; k1 <= aY + aActualMinHeight; ++k1) {
                        i3 = k1 - (aY + aActualMinHeight);
                        l1 = 2 - i3 / 2;
                        for (i2 = aX - l1; i2 <= aX + l1; ++i2) {
                            for (j2 = aZ - l1; j2 <= aZ + l1; ++j2) {
                                if (!aWorld.func_147439_a(i2, k1, j2).isLeaves((IBlockAccess)aWorld, i2, k1, j2)) continue;
                                if (aRand.nextInt(4) == 0 && aWorld.func_147439_a(i2 - 1, k1, j2).isAir((IBlockAccess)aWorld, i2 - 1, k1, j2)) {
                                    this.growVines(aWorld, i2 - 1, k1, j2, 8);
                                }
                                if (aRand.nextInt(4) == 0 && aWorld.func_147439_a(i2 + 1, k1, j2).isAir((IBlockAccess)aWorld, i2 + 1, k1, j2)) {
                                    this.growVines(aWorld, i2 + 1, k1, j2, 2);
                                }
                                if (aRand.nextInt(4) == 0 && aWorld.func_147439_a(i2, k1, j2 - 1).isAir((IBlockAccess)aWorld, i2, k1, j2 - 1)) {
                                    this.growVines(aWorld, i2, k1, j2 - 1, 1);
                                }
                                if (aRand.nextInt(4) != 0 || !aWorld.func_147439_a(i2, k1, j2 + 1).isAir((IBlockAccess)aWorld, i2, k1, j2 + 1)) continue;
                                this.growVines(aWorld, i2, k1, j2 + 1, 4);
                            }
                        }
                    }
                    if (aRand.nextInt(5) == 0 && aActualMinHeight > 5) {
                        for (k1 = 0; k1 < 2; ++k1) {
                            for (i3 = 0; i3 < 4; ++i3) {
                                if (aRand.nextInt(4 - k1) != 0) continue;
                                l1 = aRand.nextInt(3);
                                this.func_150516_a(aWorld, aX + Direction.field_71583_a[Direction.field_71580_e[i3]], aY + aActualMinHeight - 5 + k1, aZ + Direction.field_71581_b[Direction.field_71580_e[i3]], Blocks.field_150375_by, l1 << 2 | i3);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void growVines(World p_76529_1_, int p_76529_2_, int p_76529_3_, int p_76529_4_, int p_76529_5_) {
        this.func_150516_a(p_76529_1_, p_76529_2_, p_76529_3_, p_76529_4_, Blocks.field_150395_bd, p_76529_5_);
        int i1 = 4;
        while (p_76529_1_.func_147439_a(p_76529_2_, --p_76529_3_, p_76529_4_).isAir((IBlockAccess)p_76529_1_, p_76529_2_, p_76529_3_, p_76529_4_) && i1 > 0) {
            this.func_150516_a(p_76529_1_, p_76529_2_, p_76529_3_, p_76529_4_, Blocks.field_150395_bd, p_76529_5_);
            --i1;
        }
        return;
    }
}

