/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.australia.gen.map.component;

import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gtPlusPlus.api.interfaces.IGeneratorWorld;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.australia.GTplusplus_Australia;
import gtPlusPlus.australia.gen.map.component.AustraliaComponent;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComponentShack
extends AustraliaComponent {
    public static final int DIM_X = 9;
    public static final int DIM_Y = 10;
    public static final int DIM_Z = 9;
    private int nativesSpawned = 0;
    public static final WeightedRandomChestContent[] shackChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("dustIron", MathUtils.randInt(1, 4)), 0, MathUtils.randInt(1, 9), 50), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", MathUtils.randInt(1, 4)), 0, MathUtils.randInt(1, 6), 50), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("dustTin", MathUtils.randInt(1, 4)), 0, MathUtils.randInt(1, 6), 50), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("dustGold", MathUtils.randInt(1, 4)), 0, MathUtils.randInt(1, 3), 30), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("dustSilver", MathUtils.randInt(1, 4)), 0, MathUtils.randInt(1, 3), 30), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("gemDiamond", MathUtils.randInt(1, 2)), 0, MathUtils.randInt(1, 2), 5), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("gemEmerald", MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 5), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("gemRuby", MathUtils.randInt(1, 4)), 0, MathUtils.randInt(1, 4), 15), new WeightedRandomChestContent(ItemUtils.getItemStackOfAmountFromOreDict("gemSapphire", MathUtils.randInt(1, 4)), 0, MathUtils.randInt(1, 4), 15), new WeightedRandomChestContent(ItemUtils.getSimpleStack(CI.electricMotor_LV, MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 5), new WeightedRandomChestContent(ItemUtils.getSimpleStack(CI.electricPiston_LV, MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 5), new WeightedRandomChestContent(ItemUtils.getSimpleStack(CI.robotArm_LV, MathUtils.randInt(1, 2)), 0, MathUtils.randInt(1, 2), 2), new WeightedRandomChestContent(ItemUtils.getGregtechOreStack(OrePrefixes.cableGt01, Materials.Copper, MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 25), new WeightedRandomChestContent(ItemUtils.getGregtechOreStack(OrePrefixes.cableGt01, Materials.Tin, MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 25), new WeightedRandomChestContent(ItemUtils.getGregtechOreStack(OrePrefixes.wireGt01, Materials.Copper, MathUtils.randInt(2, 5)), 0, MathUtils.randInt(2, 5), 35), new WeightedRandomChestContent(ItemUtils.getGregtechOreStack(OrePrefixes.wireGt01, Materials.Tin, MathUtils.randInt(2, 5)), 0, MathUtils.randInt(2, 5), 35), new WeightedRandomChestContent(ItemUtils.getGregtechOreStack(OrePrefixes.pipeSmall, Materials.Copper, MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 25), new WeightedRandomChestContent(ItemUtils.getGregtechOreStack(OrePrefixes.pipeSmall, Materials.Bronze, MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 15), new WeightedRandomChestContent(ItemUtils.getGregtechOreStack(OrePrefixes.pipeTiny, Materials.Steel, MathUtils.randInt(1, 3)), 0, MathUtils.randInt(1, 3), 5)};
    private boolean hasMadeChest;
    private static final String CHEST_KEY = "AUSShackChest";

    public ComponentShack() {
    }

    public ComponentShack(int direction, Random random, int x, int z) {
        super(direction, random, x, z, 9, 10, 9);
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        int logID;
        Block mWoodenStairs;
        Block mStone;
        BiomeGenBase biom = world.func_72807_a(this.func_74865_a(0, 0), this.func_74873_b(0, 0));
        int groundAvg = this.calcGroundHeight(world, this.field_74887_e);
        if (groundAvg < 0) {
            return true;
        }
        this.field_74887_e.func_78886_a(0, groundAvg - this.field_74887_e.field_78894_e + 10 - 1, 0);
        if (this.isWaterBelow(world, 0, -1, 0, this.field_74887_e) || this.isWaterBelow(world, 0, -1, 6, this.field_74887_e) || this.isWaterBelow(world, 6, -1, 0, this.field_74887_e) || this.isWaterBelow(world, 6, -1, 6, this.field_74887_e)) {
            return false;
        }
        BlockGrass groundID = Blocks.field_150349_c;
        Block undergroundID = Blocks.field_150346_d;
        if (biom.field_76756_M == GTplusplus_Australia.Australian_Desert_Biome_3.field_76756_M) {
            groundID = Blocks.field_150354_m;
            undergroundID = Blocks.field_150354_m;
            mStone = Blocks.field_150322_A;
        } else if (biom.field_76756_M == GTplusplus_Australia.Australian_Outback_Biome.field_76756_M) {
            groundID = Blocks.field_150405_ch;
            undergroundID = Blocks.field_150406_ce;
            mStone = Blocks.field_150406_ce;
        } else {
            mStone = Blocks.field_150417_aV;
        }
        int mWoodType = MathUtils.randInt(0, 5);
        if (mWoodType == 1) {
            mWoodenStairs = Blocks.field_150485_bF;
            logID = 1;
        } else if (mWoodType == 2) {
            mWoodenStairs = Blocks.field_150487_bG;
            logID = 2;
        } else if (mWoodType == 3) {
            mWoodenStairs = Blocks.field_150481_bH;
            logID = 3;
        } else if (mWoodType == 4) {
            mWoodenStairs = Blocks.field_150400_ck;
            logID = 0;
        } else if (mWoodType == 5) {
            mWoodenStairs = Blocks.field_150401_cl;
            logID = 1;
        } else {
            mWoodenStairs = Blocks.field_150476_ad;
            logID = 0;
        }
        Block mLog = mWoodType >= 4 ? Blocks.field_150363_s : Blocks.field_150364_r;
        int mStoneMeta = MathUtils.randInt(0, mStone == Blocks.field_150406_ce ? 15 : (mStone == Blocks.field_150322_A ? 2 : 3));
        this.func_74878_a(world, this.field_74887_e, 0, 1, 0, 7, 7, 4);
        this.func_151556_a(world, this.field_74887_e, 1, 0, 1, 7, 1, 5, mStone, mStoneMeta, mStone, mStoneMeta, false);
        this.func_151556_a(world, this.field_74887_e, 1, 2, 1, 7, 3, 5, Blocks.field_150344_f, mWoodType, Blocks.field_150344_f, mWoodType, false);
        this.func_74878_a(world, this.field_74887_e, 2, 1, 2, 6, 3, 4);
        this.place(mLog, logID, 1, 1, 1, this.field_74887_e, world);
        this.place(mLog, logID, 1, 2, 1, this.field_74887_e, world);
        this.place(mLog, logID, 1, 3, 1, this.field_74887_e, world);
        this.place(mLog, logID, 1, 1, 5, this.field_74887_e, world);
        this.place(mLog, logID, 1, 2, 5, this.field_74887_e, world);
        this.place(mLog, logID, 1, 3, 5, this.field_74887_e, world);
        this.place(mLog, logID, 7, 1, 1, this.field_74887_e, world);
        this.place(mLog, logID, 7, 2, 1, this.field_74887_e, world);
        this.place(mLog, logID, 7, 3, 1, this.field_74887_e, world);
        this.place(mLog, logID, 7, 1, 5, this.field_74887_e, world);
        this.place(mLog, logID, 7, 2, 5, this.field_74887_e, world);
        this.place(mLog, logID, 7, 3, 5, this.field_74887_e, world);
        int meta = this.field_74885_f == 3 || this.field_74885_f == 1 ? 4 : 8;
        this.place(mLog, logID, 1, 4, 2, this.field_74887_e, world);
        this.place(mLog, logID, 1, 4, 3, this.field_74887_e, world);
        this.place(mLog, logID, 1, 4, 4, this.field_74887_e, world);
        this.place(mLog, logID, 7, 4, 2, this.field_74887_e, world);
        this.place(mLog, logID, 7, 4, 3, this.field_74887_e, world);
        this.place(mLog, logID, 7, 4, 4, this.field_74887_e, world);
        for (int x = 0; x < 9; ++x) {
            this.place(mWoodenStairs, this.func_151555_a(Blocks.field_150476_ad, 3), x, 3, 0, this.field_74887_e, world);
            this.place(mWoodenStairs, this.func_151555_a(Blocks.field_150476_ad, 3), x, 4, 1, this.field_74887_e, world);
            this.place(mWoodenStairs, this.func_151555_a(Blocks.field_150476_ad, 3), x, 5, 2, this.field_74887_e, world);
            this.place(Blocks.field_150344_f, mWoodType, x, 5, 3, this.field_74887_e, world);
            this.place(mWoodenStairs, this.func_151555_a(Blocks.field_150476_ad, 2), x, 5, 4, this.field_74887_e, world);
            this.place(mWoodenStairs, this.func_151555_a(Blocks.field_150476_ad, 2), x, 4, 5, this.field_74887_e, world);
            this.place(mWoodenStairs, this.func_151555_a(Blocks.field_150476_ad, 2), x, 3, 6, this.field_74887_e, world);
        }
        int glassMeta = Math.min(16, this.field_74885_f + MathUtils.randInt(0, 8));
        this.place((Block)Blocks.field_150397_co, glassMeta, 3, 2, 1, this.field_74887_e, world);
        this.place((Block)Blocks.field_150397_co, glassMeta, 3, 2, 5, this.field_74887_e, world);
        this.place((Block)Blocks.field_150397_co, glassMeta, 5, 2, 5, this.field_74887_e, world);
        this.place((Block)Blocks.field_150397_co, glassMeta, 1, 2, 3, this.field_74887_e, world);
        this.place((Block)Blocks.field_150397_co, glassMeta, 7, 2, 3, this.field_74887_e, world);
        this.func_74881_a(world, this.field_74887_e, random, 5, 1, 1, this.func_151555_a(Blocks.field_150466_ao, 1));
        this.place(Blocks.field_150379_bu, mWoodType, 2, 1, 4, this.field_74887_e, world);
        this.place(Blocks.field_150429_aA, 0, 2, 2, 4, this.field_74887_e, world);
        this.place(mWoodenStairs, this.func_151555_a(mWoodenStairs, 1), 2, 1, 3, this.field_74887_e, world);
        this.place(mWoodenStairs, this.func_151555_a(mWoodenStairs, 3), 3, 1, 4, this.field_74887_e, world);
        this.place(Blocks.field_150422_aJ, 0, 3, 1, 3, this.field_74887_e, world);
        this.place(Blocks.field_150443_bT, 0, 3, 2, 3, this.field_74887_e, world);
        if (!this.hasMadeChest) {
            int kc;
            int ic = this.func_74862_a(0);
            int jc = this.func_74865_a(7, 1);
            if (this.field_74887_e.func_78890_b(jc, ic, kc = this.func_74873_b(7, 1))) {
                this.hasMadeChest = true;
                this.func_74879_a(world, this.field_74887_e, random, 2, 1, 2, shackChestContents, 1 + random.nextInt(3));
            }
        }
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_74871_b(world, j, 6, i, this.field_74887_e);
                this.func_151554_b(world, undergroundID, 0, j, 0, i, this.field_74887_e);
            }
        }
        this.spawnNatives(world, this.field_74887_e, 3, 2, 3, MathUtils.randInt(3, 5));
        return true;
    }

    private void spawnNatives(World par1World, StructureBoundingBox par2StructureBoundingBox, int par3, int par4, int par5, int maxSpawned) {
        if (this.nativesSpawned < maxSpawned) {
            int l1;
            int k1;
            int j1;
            for (int i1 = this.nativesSpawned; i1 < maxSpawned && par2StructureBoundingBox.func_78890_b(j1 = this.func_74865_a(par3 + i1, par5), k1 = this.func_74862_a(par4), l1 = this.func_74873_b(par3 + i1, par5)); ++i1) {
                if (par1World.field_73012_v.nextInt(MathUtils.randInt(1, 3)) == 0) continue;
                EntityVillager entityvillager = new EntityVillager(par1World, 7736 + MathUtils.randInt(0, 1));
                entityvillager.func_110163_bv();
                entityvillager.func_70012_b((double)j1 + 0.5, (double)k1, (double)l1 + 0.5, 0.0f, 0.0f);
                par1World.func_72838_d((Entity)entityvillager);
                ++this.nativesSpawned;
            }
        }
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a(CHEST_KEY, this.hasMadeChest);
        par1NBTTagCompound.func_74768_a("AUSWCount", this.nativesSpawned);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        super.func_143011_b(par1NBTTagCompound);
        this.hasMadeChest = par1NBTTagCompound.func_74767_n(CHEST_KEY);
        this.nativesSpawned = par1NBTTagCompound.func_74764_b("AUSWCount") ? par1NBTTagCompound.func_74762_e("AUSWCount") : 0;
    }

    public static class WorldHandlerShack
    implements IGeneratorWorld {
        private final double chance;
        private final int range;

        public WorldHandlerShack(double chance) {
            this.chance = chance;
            this.range = 400;
        }

        @Override
        public int getExtentX() {
            return 7;
        }

        @Override
        public int getExtentZ() {
            return 7;
        }

        @Override
        public int getRange() {
            return this.range;
        }

        @Override
        public boolean generate(World world, Random random, int x, int z) {
            if ((double)MathUtils.randInt(0, 100) < this.chance / 5.0) {
                int direction = MathUtils.randInt(0, 3);
                new ComponentShack(direction, random, x, z).addComponentParts(world, random);
                Logger.WORLD("NativeShack x: " + x + " | z: " + z + " | dir: " + direction);
                return true;
            }
            return false;
        }

        @Override
        public void initiate() {
        }
    }
}

