/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.data;

import gtPlusPlus.api.objects.data.AutoMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReverseAutoMap<N>
extends AutoMap<N> {
    private Map<N, Integer> mInternalMapReverseLookup = new HashMap<N, Integer>();
    private int mInternalID = 0;
    private static final long serialVersionUID = 3771412318075131790L;

    @Override
    public Iterator<N> iterator() {
        return this.values().iterator();
    }

    @Override
    public synchronized boolean setValue(N object) {
        int mOriginalID = this.mInternalID;
        this.put(object);
        return this.mInternalMap.get(mOriginalID).equals(object) || mOriginalID > this.mInternalID;
    }

    @Override
    public synchronized N put(N object) {
        return this.set(object);
    }

    @Override
    public synchronized N set(N object) {
        int newID = this.getNextFreeMapID();
        this.mInternalMapReverseLookup.put(object, newID);
        return this.mInternalMap.put(newID, object);
    }

    public synchronized int putToInternalMap(N object) {
        return this.setInternalMap(object);
    }

    public synchronized int setInternalMap(N object) {
        int newID = this.getNextFreeMapID();
        this.mInternalMap.put(newID, object);
        this.mInternalMapReverseLookup.put(object, newID);
        return newID;
    }

    public synchronized boolean injectCleanDataToAutoMap(Integer g, N object) {
        if (!this.mInternalMap.containsKey(g) && !this.mInternalMapReverseLookup.containsKey(object)) {
            int a1 = 0;
            int a2 = 0;
            int a11 = 0;
            int a22 = 0;
            a1 = this.mInternalMap.size();
            a2 = this.mInternalMapReverseLookup.size();
            a11 = a1;
            a22 = a2;
            this.mInternalMap.put(g, object);
            a1 = this.mInternalMap.size();
            this.mInternalMapReverseLookup.put(object, g);
            a2 = this.mInternalMapReverseLookup.size();
            if (a1 > a11 && a2 > a22) {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean injectDataToAutoMap(Integer g, N object) {
        int a1 = 0;
        int a2 = 0;
        int a11 = 0;
        int a22 = 0;
        a1 = this.mInternalMap.size();
        a2 = this.mInternalMapReverseLookup.size();
        a11 = a1;
        a22 = a2;
        this.mInternalMap.put(g, object);
        a1 = this.mInternalMap.size();
        this.mInternalMapReverseLookup.put(object, g);
        a2 = this.mInternalMapReverseLookup.size();
        return a1 > a11 && a2 > a22;
    }

    private boolean raiseInternalID() {
        int mOld;
        return this.mInternalID > (mOld = this.mInternalID++);
    }

    public synchronized int getNextFreeMapID() {
        if (this.raiseInternalID()) {
            return this.mInternalID;
        }
        return Short.MIN_VALUE;
    }

    @Override
    public synchronized N get(int id) {
        return (N)this.mInternalMap.get(id);
    }

    public synchronized int get(N key) {
        return this.mInternalMapReverseLookup.get(key);
    }

    @Override
    public synchronized Collection<N> values() {
        return this.mInternalMap.values();
    }

    public synchronized Collection<Integer> keys() {
        return this.mInternalMapReverseLookup.values();
    }

    @Override
    public synchronized int size() {
        return this.mInternalMap.size();
    }

    @Override
    public synchronized int hashCode() {
        return this.mInternalMap.hashCode() + this.mInternalMapReverseLookup.hashCode();
    }

    @Override
    public synchronized boolean containsKey(int key) {
        return this.mInternalMap.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(N value) {
        return this.mInternalMap.containsValue(value);
    }

    public synchronized boolean containsKey(N key) {
        return this.mInternalMapReverseLookup.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(int value) {
        return this.mInternalMapReverseLookup.containsValue(value);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.mInternalMap.isEmpty() && this.mInternalMapReverseLookup.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.mInternalID = 0;
        this.mInternalMap.clear();
        this.mInternalMapReverseLookup.clear();
    }

    @Override
    public synchronized N[] toArray() {
        Collection col = this.mInternalMap.values();
        Object[] val = col.toArray();
        return val;
    }

    public synchronized Integer[] toArrayInternalMap() {
        Collection<Integer> col = this.mInternalMapReverseLookup.values();
        Integer[] val = col.toArray(new Integer[col.size()]);
        return val;
    }
}

