/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.helpers;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.WeightedCollection;
import gtPlusPlus.api.objects.minecraft.multi.SpecialMultiBehaviour;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy_RTG;
import gtPlusPlus.xmod.gregtech.api.util.SpecialBehaviourTooltipHandler;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GregtechPlusPlus_API {

    private static class GregtechPlusPlus_API_Internal {
        private GregtechPlusPlus_API_Internal() {
        }

        private static void writeBlockToDimensionInCache(int aDim, int aType, Block aBlock, int aWeight) {
            HashMap aDimMap = (HashMap)VoidMiner_API.mMinerLootCache.get(aDim);
            if (aDimMap == null) {
                aDimMap = new HashMap();
            }
            WeightedCollection<Block> aMappedBlocks = GregtechPlusPlus_API_Internal.getBlockMap(aType, aDimMap);
            aMappedBlocks.put(aWeight, aBlock);
        }

        private static WeightedCollection<Block> getBlockMap(int aType, HashMap<String, WeightedCollection<Block>> aDimMap) {
            String aTypeName = aType == 0 ? "ore" : (aType == 1 ? "dirt" : (aType == 2 ? "stone" : "error"));
            WeightedCollection<Object> aMappedBlocks = aDimMap.get(aTypeName);
            if (aMappedBlocks == null) {
                aMappedBlocks = new WeightedCollection();
            }
            return aMappedBlocks;
        }
    }

    public static class VoidMiner_API {
        private static final HashMap<Integer, HashMap<String, WeightedCollection<Block>>> mMinerLootCache = new HashMap();

        public static boolean registerOreForVoidMiner(int aDim, String aOredictName) {
            return VoidMiner_API.registerOreForVoidMiner(aDim, aOredictName, 100);
        }

        public static boolean registerOreForVoidMiner(int aDim, String aOredictName, int aWeight) {
            ItemStack[] aValidItems;
            Block b = null;
            for (ItemStack g : aValidItems = ItemUtils.validItemsForOreDict(aOredictName)) {
                if (g != null && (b = Block.func_149634_a((Item)g.func_77973_b())) != null) break;
            }
            if (b != null) {
                VoidMiner_API.registerOreForVoidMiner(aDim, b, aWeight);
                return true;
            }
            return false;
        }

        public static void registerOreForVoidMiner(int aDim, Block aOreBlock) {
            VoidMiner_API.registerOreForVoidMiner(aDim, aOreBlock, 100);
        }

        public static void registerOreForVoidMiner(int aDim, Block aOreBlock, int aWeight) {
            GregtechPlusPlus_API_Internal.writeBlockToDimensionInCache(aDim, 0, aOreBlock, aWeight);
        }

        public static void registerEarthSurfaceForVoidMiner(int aDim, Block aDirtBlock) {
            VoidMiner_API.registerEarthSurfaceForVoidMiner(aDim, aDirtBlock, 100);
        }

        public static void registerEarthSurfaceForVoidMiner(int aDim, Block aDirtBlock, int aWeight) {
            GregtechPlusPlus_API_Internal.writeBlockToDimensionInCache(aDim, 0, aDirtBlock, aWeight);
        }

        public static void registerEarthStoneForVoidMiner(int aDim, Block aStoneBlock) {
            VoidMiner_API.registerEarthStoneForVoidMiner(aDim, aStoneBlock, 100);
        }

        public static void registerEarthStoneForVoidMiner(int aDim, Block aStoneBlock, int aWeight) {
            GregtechPlusPlus_API_Internal.writeBlockToDimensionInCache(aDim, 0, aStoneBlock, aWeight);
        }

        public static WeightedCollection<Block> getAllRegisteredOresForDimension(int aDim) {
            return mMinerLootCache.get(aDim).get("ore");
        }

        public static WeightedCollection<Block> getAllRegisteredDirtTypesForDimension(int aDim) {
            return mMinerLootCache.get(aDim).get("dirt");
        }

        public static WeightedCollection<Block> getAllRegisteredStoneTypesForDimension(int aDim) {
            return mMinerLootCache.get(aDim).get("stone");
        }

        public static final HashMap<Integer, HashMap<String, WeightedCollection<Block>>> getVoidMinerLootCache() {
            return mMinerLootCache;
        }
    }

    public static class Multiblock_API {
        private static final HashMap<String, SpecialMultiBehaviour> mSpecialBehaviourItemMap = new HashMap();

        public static boolean registerSpecialMultiBehaviour(SpecialMultiBehaviour aBehaviour) {
            if (aBehaviour.getTriggerItem() == null || aBehaviour.getTriggerItemTooltip() == null || aBehaviour.getTriggerItemTooltip().length() <= 0) {
                Logger.INFO("Failed to attach custom multiblock logic to " + ItemUtils.getItemName(aBehaviour.getTriggerItem()));
                return false;
            }
            mSpecialBehaviourItemMap.put("UniqueKey_" + aBehaviour.hashCode(), aBehaviour);
            SpecialBehaviourTooltipHandler.addTooltipForItem(aBehaviour.getTriggerItem(), aBehaviour.getTriggerItemTooltip());
            Logger.INFO("Attached custom multiblock logic to " + ItemUtils.getItemName(aBehaviour.getTriggerItem()));
            return true;
        }

        public static final HashMap<String, SpecialMultiBehaviour> getSpecialBehaviourItemMap() {
            return mSpecialBehaviourItemMap;
        }

        public static boolean registerPelletForRtgHatch(ItemStack aStack, long aFuelValue) {
            return GT_MetaTileEntity_Hatch_Energy_RTG.registerPelletForHatch(aStack, aFuelValue);
        }
    }

    public static class MolecularTransformer_API {
        public static boolean addRecipe(ItemStack aInput, ItemStack aOutput, int aDuration, int aEU) {
            return CORE.RA.addMolecularTransformerRecipe(aInput, aOutput, aDuration, aEU, 1);
        }
    }
}

