/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.enums;

import gtPlusPlus.core.util.math.MathUtils;
import net.minecraft.util.EnumChatFormatting;

public enum Quality {
    POOR("Poor", EnumChatFormatting.GRAY),
    COMMON("Common", EnumChatFormatting.WHITE),
    UNCOMMON("Uncommon", EnumChatFormatting.DARK_GREEN),
    MAGIC("Magic", EnumChatFormatting.BLUE),
    RARE("Rare", EnumChatFormatting.YELLOW),
    UNIQUE("Unique", EnumChatFormatting.GOLD),
    ARTIFACT("Artifact", EnumChatFormatting.AQUA),
    SET("Set Piece", EnumChatFormatting.GREEN),
    TRADEOFF("Trade-off", EnumChatFormatting.DARK_RED),
    EPIC("Epic", EnumChatFormatting.LIGHT_PURPLE);

    private String LOOT;
    private EnumChatFormatting COLOUR;

    private Quality(String lootTier, EnumChatFormatting tooltipColour) {
        this.LOOT = lootTier;
        this.COLOUR = tooltipColour;
    }

    public String getQuality() {
        return this.LOOT;
    }

    protected EnumChatFormatting getColour() {
        return this.COLOUR;
    }

    public String formatted() {
        return this.COLOUR + this.LOOT;
    }

    public static Quality getRandomQuality() {
        int lootChance = MathUtils.randInt(0, 100);
        if (lootChance <= 10) {
            return POOR;
        }
        if (lootChance <= 45) {
            return COMMON;
        }
        if (lootChance <= 65) {
            return UNCOMMON;
        }
        if (lootChance <= 82) {
            return MAGIC;
        }
        if (lootChance <= 92) {
            return EPIC;
        }
        if (lootChance <= 97) {
            return RARE;
        }
        if (lootChance <= 99) {
            return ARTIFACT;
        }
        return null;
    }
}

