/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import codechicken.nei.PositionedStack;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.interfaces.IComparableRecipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GTPP_Recipe
extends GT_Recipe
implements IComparableRecipe {
    private final String mRecipeHash;
    private final AutoMap<Integer> mHashMap = new AutoMap();

    public GTPP_Recipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecialItems, int[] aChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
        super(aOptimize, aInputs, aOutputs, aSpecialItems, aChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue);
        this.mRecipeHash = GTPP_Recipe.getRecipeHash(this);
        this.mHashMap.addAll((Collection<Integer>)GTPP_Recipe.convertStringDataToInts(GTPP_Recipe.getEncodedRecipeData(this)));
    }

    public GTPP_Recipe(ItemStack aInput1, ItemStack aOutput1, int aFuelValue, int aType) {
        this(aInput1, aOutput1, null, null, null, aFuelValue, aType);
    }

    private static AutoMap<Integer> convertStringDataToInts(AutoMap<String> aData) {
        AutoMap<Integer> aMap = new AutoMap<Integer>();
        for (String string : aData) {
            aMap.add(string.hashCode());
        }
        return aMap;
    }

    private static AutoMap<String> getEncodedRecipeData(GTPP_Recipe aRecipe) {
        AutoMap<String> aData = new AutoMap<String>();
        aData.add(aRecipe.mRecipeHash);
        aData.add("" + aRecipe.mCanBeBuffered);
        aData.add("" + aRecipe.mHidden);
        aData.add("" + aRecipe.mEnabled);
        aData.add("" + aRecipe.mDuration);
        aData.add("" + aRecipe.mEUt);
        aData.add("" + aRecipe.mFakeRecipe);
        aData.add("" + aRecipe.mSpecialItems);
        aData.add(aRecipe.mChances.toString());
        aData.add(aRecipe.mInputs.toString());
        aData.add(aRecipe.mOutputs.toString());
        aData.add(aRecipe.mFluidInputs.toString());
        aData.add(aRecipe.mFluidOutputs.toString());
        return aData;
    }

    public static String getRecipeHash(GT_Recipe aRecipe) {
        String aEncoderString = aRecipe.toString();
        return aEncoderString;
    }

    private final void checkModified() {
        if (this.hasBeenModified()) {
            String[] aInfo;
            for (String s : aInfo = RecipeUtils.getRecipeInfo(this)) {
                Logger.INFO(s);
            }
            CORE.crash("Someone has edited an internal GT++ recipe, which is no longer allowed. Please complain to whoever has done this, not Alkalus.");
        }
    }

    private final boolean hasBeenModified() {
        int a;
        String aEncoderString = this.toString();
        boolean aBasicHashCheck = this.mRecipeHash.equals(aEncoderString);
        if (!aBasicHashCheck) {
            Logger.INFO("This Recipe Hash: " + aEncoderString);
            Logger.INFO("Expected Hash Code: " + this.mRecipeHash);
            return true;
        }
        AutoMap<Integer> aData = new AutoMap<Integer>();
        aData.addAll((Collection<Integer>)GTPP_Recipe.convertStringDataToInts(GTPP_Recipe.getEncodedRecipeData(this)));
        long aHashTotal = 0L;
        long aExpectedHashTotal = 0L;
        Iterator<Object> iterator = aData.iterator();
        while (iterator.hasNext()) {
            a = (Integer)iterator.next();
            aHashTotal += (long)a;
        }
        iterator = this.mHashMap.iterator();
        while (iterator.hasNext()) {
            a = (Integer)iterator.next();
            aExpectedHashTotal += (long)a;
        }
        if (aHashTotal != aExpectedHashTotal) {
            Logger.INFO("This Recipe Hash: " + aEncoderString);
            Logger.INFO("Expected Hash Code: " + this.mRecipeHash);
            Logger.INFO("This Recipe Hash: " + aHashTotal);
            Logger.INFO("Expected Hash Code: " + aExpectedHashTotal);
            return true;
        }
        return false;
    }

    public GTPP_Recipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2, ItemStack aOutput3, ItemStack aOutput4, int aSpecialValue, int aType) {
        this(true, new ItemStack[]{aInput1}, new ItemStack[]{aOutput1, aOutput2, aOutput3, aOutput4}, null, null, null, null, 0, 0, Math.max(1, aSpecialValue));
        Logger.WARNING("Switch case method for adding fuels");
        if (this.mInputs.length > 0 && aSpecialValue > 0) {
            switch (aType) {
                case 0: {
                    Logger.WARNING("Added fuel " + aInput1.func_82833_r() + " is ROCKET FUEL - continuing");
                    GTPP_Recipe_Map.sRocketFuels.addRecipe((GT_Recipe)this);
                    break;
                }
                case 1: {
                    GTPP_Recipe_Map.sGeoThermalFuels.addRecipe(this);
                    break;
                }
                case 2: {
                    GTPP_Recipe_Map.sRTGFuels.addRecipe((GT_Recipe)this);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
    }

    public GTPP_Recipe(ItemStack aInput, FluidStack aFluid, ItemStack[] aOutput, int aDuration, int aEUt) {
        this(true, new ItemStack[]{aInput}, (ItemStack[])aOutput.clone(), null, null, new FluidStack[]{aFluid}, null, aDuration, aEUt, 0);
        if (this.mInputs.length > 0 && this.mOutputs[0] != null) {
            GTPP_Recipe_Map.sChemicalDehydratorRecipes.addRecipe(this);
        }
    }

    public static void reInit() {
        GT_Log.out.println("GT_Mod: Re-Unificating Recipes.");
        for (GTPP_Recipe_Map gTPP_Recipe_Map : GTPP_Recipe_Map.sMappings) {
            if (gTPP_Recipe_Map == null || gTPP_Recipe_Map.mRecipeList == null || gTPP_Recipe_Map.mRecipeList.isEmpty()) continue;
            for (GT_Recipe gT_Recipe : gTPP_Recipe_Map.mRecipeList) {
                GTPP_Recipe.checkRecipeOwnership(gT_Recipe);
            }
        }
        for (GTPP_Recipe_Map_Internal gTPP_Recipe_Map_Internal : GTPP_Recipe_Map_Internal.sMappingsEx) {
            if (gTPP_Recipe_Map_Internal == null || gTPP_Recipe_Map_Internal.mRecipeList == null || gTPP_Recipe_Map_Internal.mRecipeList.isEmpty()) continue;
            for (GT_Recipe gT_Recipe : gTPP_Recipe_Map_Internal.mRecipeList) {
                GTPP_Recipe.checkRecipeOwnership(gT_Recipe);
            }
        }
    }

    private static final boolean checkRecipeOwnership(GT_Recipe aRecipe) {
        if (aRecipe != null && aRecipe instanceof GTPP_Recipe) {
            GTPP_Recipe nRecipe = (GTPP_Recipe)aRecipe;
            GTPP_Recipe_Map_Internal.mHashedRecipes.put(nRecipe.hashCode(), nRecipe);
            return true;
        }
        return false;
    }

    public static final void checkRecipeModifications() {
        for (GTPP_Recipe aRecipe : GTPP_Recipe_Map_Internal.mHashedRecipes.values()) {
            Logger.INFO("Checking recipe: " + aRecipe.hashCode());
            aRecipe.checkModified();
        }
    }

    public ItemStack getRepresentativeInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mInputs.length) {
            return null;
        }
        return GT_Utility.copy((Object[])new Object[]{this.mInputs[aIndex]});
    }

    public ItemStack getOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mOutputs.length) {
            return null;
        }
        return GT_Utility.copy((Object[])new Object[]{this.mOutputs[aIndex]});
    }

    public int getOutputChance(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mChances.length) {
            return 10000;
        }
        return this.mChances[aIndex];
    }

    public FluidStack getRepresentativeFluidInput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidInputs.length || this.mFluidInputs[aIndex] == null) {
            return null;
        }
        return this.mFluidInputs[aIndex].copy();
    }

    public FluidStack getFluidOutput(int aIndex) {
        if (aIndex < 0 || aIndex >= this.mFluidOutputs.length || this.mFluidOutputs[aIndex] == null) {
            return null;
        }
        return this.mFluidOutputs[aIndex].copy();
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        return this.isRecipeInputEqual(aDecreaseStacksizeBySuccess, false, aFluidInputs, aInputs);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess, boolean aDontCheckStackSizes, FluidStack[] aFluidInputs, ItemStack ... aInputs) {
        int n;
        int n2;
        FluidStack[] fluidStackArray;
        boolean temp;
        if (this.mFluidInputs.length > 0 && aFluidInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : this.mFluidInputs) {
            if (fluidStack == null) continue;
            temp = true;
            fluidStackArray = aFluidInputs;
            n2 = fluidStackArray.length;
            for (n = 0; n < n2; ++n) {
                FluidStack aFluid = fluidStackArray[n];
                if (aFluid == null || !aFluid.isFluidEqual(fluidStack) || !aDontCheckStackSizes && aFluid.amount < fluidStack.amount) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (this.mInputs.length > 0 && aInputs == null) {
            return false;
        }
        for (FluidStack fluidStack : this.mInputs) {
            if (fluidStack == null) continue;
            temp = true;
            fluidStackArray = aInputs;
            n2 = fluidStackArray.length;
            for (n = 0; n < n2; ++n) {
                FluidStack aStack = fluidStackArray[n];
                if (!GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)fluidStack, (boolean)true) && !GT_Utility.areUnificationsEqual((ItemStack)GT_OreDictUnificator.get((boolean)false, (ItemStack)aStack), (ItemStack)fluidStack, (boolean)true) || !aDontCheckStackSizes && aStack.field_77994_a < fluidStack.field_77994_a) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            if (aFluidInputs != null) {
                block4: for (FluidStack fluidStack : this.mFluidInputs) {
                    if (fluidStack == null) continue;
                    FluidStack[] fluidStackArray2 = aFluidInputs;
                    int n3 = fluidStackArray2.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        FluidStack aFluid = fluidStackArray2[n2];
                        if (aFluid == null || !aFluid.isFluidEqual(fluidStack) || !aDontCheckStackSizes && aFluid.amount < fluidStack.amount) continue;
                        aFluid.amount -= fluidStack.amount;
                        continue block4;
                    }
                }
            }
            if (aInputs != null) {
                block6: for (FluidStack fluidStack : this.mInputs) {
                    if (fluidStack == null) continue;
                    for (ItemStack aStack : aInputs) {
                        if (!GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)fluidStack, (boolean)true) && !GT_Utility.areUnificationsEqual((ItemStack)GT_OreDictUnificator.get((boolean)false, (ItemStack)aStack), (ItemStack)fluidStack, (boolean)true) || !aDontCheckStackSizes && aStack.field_77994_a < fluidStack.field_77994_a) continue;
                        aStack.field_77994_a -= fluidStack.field_77994_a;
                        continue block6;
                    }
                }
            }
        }
        return true;
    }

    public ArrayList<PositionedStack> getInputPositionedStacks() {
        return null;
    }

    public ArrayList<PositionedStack> getOutputPositionedStacks() {
        return null;
    }

    @Override
    public int compareTo(GTPP_Recipe recipe) {
        if (this.mEUt != recipe.mEUt) {
            return this.mEUt - recipe.mEUt;
        }
        if (this.mDuration != recipe.mDuration) {
            return this.mDuration - recipe.mDuration;
        }
        if (this.mSpecialValue != recipe.mSpecialValue) {
            return this.mSpecialValue - recipe.mSpecialValue;
        }
        if (this.mFluidInputs.length != recipe.mFluidInputs.length) {
            return this.mFluidInputs.length - recipe.mFluidInputs.length;
        }
        if (this.mInputs.length != recipe.mInputs.length) {
            return this.mInputs.length - recipe.mInputs.length;
        }
        return 0;
    }

    @Override
    public int compareTo(GT_Recipe recipe) {
        if (this.mEUt != recipe.mEUt) {
            return this.mEUt - recipe.mEUt;
        }
        if (this.mDuration != recipe.mDuration) {
            return this.mDuration - recipe.mDuration;
        }
        if (this.mSpecialValue != recipe.mSpecialValue) {
            return this.mSpecialValue - recipe.mSpecialValue;
        }
        if (this.mFluidInputs.length != recipe.mFluidInputs.length) {
            return this.mFluidInputs.length - recipe.mFluidInputs.length;
        }
        if (this.mInputs.length != recipe.mInputs.length) {
            return this.mInputs.length - recipe.mInputs.length;
        }
        return 0;
    }

    public static class Gregtech_Recipe_Map_Fuel
    extends GTPP_Recipe_Map {
        public Gregtech_Recipe_Map_Fuel(Collection<GTPP_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        public GTPP_Recipe addFuel(ItemStack aInput, ItemStack aOutput, int aFuelValueInEU) {
            Logger.WARNING("Adding Fuel using method 1");
            return this.addFuel(aInput, aOutput, null, null, 10000, aFuelValueInEU);
        }

        public GTPP_Recipe addFuel(ItemStack aInput, ItemStack aOutput, int aChance, int aFuelValueInEU) {
            Logger.WARNING("Adding Fuel using method 2");
            return this.addFuel(aInput, aOutput, null, null, aChance, aFuelValueInEU);
        }

        public GTPP_Recipe addFuel(FluidStack aFluidInput, FluidStack aFluidOutput, int aFuelValueInEU) {
            Logger.WARNING("Adding Fuel using method 3");
            return this.addFuel(null, null, aFluidInput, aFluidOutput, 10000, aFuelValueInEU);
        }

        public GTPP_Recipe addFuel(ItemStack aInput, ItemStack aOutput, FluidStack aFluidInput, FluidStack aFluidOutput, int aFuelValueInEU) {
            Logger.WARNING("Adding Fuel using method 4");
            return this.addFuel(aInput, aOutput, aFluidInput, aFluidOutput, 10000, aFuelValueInEU);
        }

        public GTPP_Recipe addFuel(ItemStack aInput, ItemStack aOutput, FluidStack aFluidInput, FluidStack aFluidOutput, int aChance, int aFuelValueInEU) {
            Logger.WARNING("Adding Fuel using method 5");
            return this.addRecipe(true, new ItemStack[]{aInput}, new ItemStack[]{aOutput}, null, new int[]{aChance}, new FluidStack[]{aFluidInput}, new FluidStack[]{aFluidOutput}, 0, 0, aFuelValueInEU);
        }
    }

    public static abstract class GT_Recipe_Map_NonGTRecipes
    extends GTPP_Recipe_Map {
        public GT_Recipe_Map_NonGTRecipes(Collection<GTPP_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
        }

        @Override
        public boolean containsInput(ItemStack aStack) {
            return false;
        }

        @Override
        public boolean containsInput(FluidStack aFluid) {
            return false;
        }

        @Override
        public boolean containsInput(Fluid aFluid) {
            return false;
        }

        @Override
        public GTPP_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GTPP_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GTPP_Recipe addRecipe(GTPP_Recipe aRecipe) {
            return null;
        }

        @Override
        public GTPP_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GTPP_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return null;
        }

        @Override
        public GTPP_Recipe addFakeRecipe(boolean aCheckForCollisions, GTPP_Recipe aRecipe) {
            return null;
        }

        @Override
        public GTPP_Recipe add(GTPP_Recipe aRecipe) {
            return null;
        }

        @Override
        public void reInit() {
        }

        @Override
        protected GTPP_Recipe addToItemMap(GTPP_Recipe aRecipe) {
            return null;
        }
    }

    public static class GTPP_Recipe_Map {
        public static final Collection<GTPP_Recipe_Map> sMappings = new ArrayList<GTPP_Recipe_Map>();
        public static final GTPP_Recipe_Map_Internal sCokeOvenRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.cokeoven", "Coke Oven", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 1, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sMatterFab2Recipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.matterfab2", "Matter Fabricator", null, "gregtech:textures/gui/basicmachines/Default", 9, 9, 0, 0, 1, "", 1, "", true, true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sRocketFuels = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.rocketenginefuel", "Rocket Engine Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 3000, " EU", true, true);
        public static final GTPP_Recipe_Map_Internal sGeoThermalFuels = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10), "gtpp.recipe.geothermalfuel", "GeoThermal Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GTPP_Recipe_Map_Internal sChemicalDehydratorRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.chemicaldehydrator", "Dehydrator", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sVacuumFurnaceRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(500), "gtpp.recipe.vacfurnace", "Vacuum Furnace", null, "gregtech:textures/gui/basicmachines/Default", 6, 6, 1, 0, 1, "Heat Capacity: ", 1, " K", false, true);
        public static final GTPP_Recipe_Map_Internal sAlloyBlastSmelterRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.alloyblastsmelter", "Alloy Blast Smelter", null, "gregtech:textures/gui/basicmachines/BlastSmelter", 9, 9, 1, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sSteamTurbineFuels = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10), "gtpp.recipe.steamturbinefuel", "GeoThermal Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, false);
        public static final GTPP_Recipe_Map_Internal sLiquidFluorineThoriumReactorRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(50), "gtpp.recipe.lftr", "Liquid Fluoride Thorium Reactor", null, "gregtech:textures/gui/basicmachines/FissionFuel", 0, 0, 0, 2, 0, "Power: ", 1, " EU/t per Dynamo", true, true);
        public static final GTPP_Recipe_Map_Internal sOreMillRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.oremill", "Milling", null, "gregtech:textures/gui/basicmachines/LFTR", 3, 4, 1, 0, 1, "", 1, "", true, false);
        public static final GTPP_Recipe_Map_Internal sFissionFuelProcessing = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(50), "gtpp.recipe.fissionfuel", "Nuclear Fuel Processing", null, "gregtech:textures/gui/basicmachines/FissionFuel", 0, 0, 0, 0, 1, "", 1, "", true, false);
        public static final GTPP_Recipe_Map_Internal sColdTrapRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.coldtrap", "Cold Trap", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sReactorProcessingUnitRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.reactorprocessingunit", "Reactor Processing Unit", null, "gregtech:textures/gui/basicmachines/Dehydrator", 2, 9, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sSimpleWasherRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.simplewasher", "Simple Dust Washer", null, "gregtech:textures/gui/basicmachines/PotionBrewer", 1, 1, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sMolecularTransformerRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.moleculartransformer", "Molecular Transformer", null, "gregtech:textures/gui/basicmachines/Scanner", 1, 1, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sElementalDuplicatorRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.elementaldupe", "Elemental Duplicator", null, "gregtech:textures/gui/basicmachines/Replicator", 1, 1, 0, 1, 1, "", 1, "", true, false);
        public static final GTPP_Recipe_Map_Internal sChemicalPlantRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(100), "gtpp.recipe.fluidchemicaleactor", "Chemical Plant", null, "miscutils:textures/gui/FluidReactor", 0, 0, 0, 2, 1, "Tier: ", 1, "", true, false);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sRTGFuels = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.RTGgenerators", "RTG", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 365, " Minecraft Days", true, true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sThermalFuels = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.thermalgeneratorfuel", "Thermal Generator Fuel", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, null, 1000, null, true, false);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sSolarTowerRecipes = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.solartower", "Solar Tower", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, null, 1000, null, true, false);
        public static final GTPP_Recipe_Map_Internal sCyclotronRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(200), "gtpp.recipe.cyclotron", "COMET - Compact Cyclotron", null, "gregtech:textures/gui/basicmachines/BlastSmelter", 2, 16, 0, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sAdvancedMixerRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(1000), "gtpp.recipe.advanced.mixer", "Advanced Material Combiner", null, "gregtech:textures/gui/basicmachines/MixerAdvanced", 4, 4, 1, 0, 2, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sSlowFusionRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(50), "gtpp.recipe.slowfusionreactor", "Mimir - Slow Fusion", null, "gregtech:textures/gui/basicmachines/LFTR", 0, 0, 0, 2, 1, "Start: ", 1, " EU", true, true);
        public static final GT_Recipe.GT_Recipe_Map sComponentAssemblerRecipes = new GT_Recipe.GT_Recipe_Map_Assembler(new HashSet(300), "gtpp.recipe.componentassembler", "Component Assembler", null, "gregtech:textures/gui/basicmachines/Assembler", 6, 1, 1, 0, 1, "", 1, "", true, true);
        public static final GTPP_Recipe_Map_Internal sFishPondRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(3), "gtpp.recipe.fishpond", "Zhuhai - Fishing Port", null, "gregtech:textures/gui/basicmachines/PotionBrewer", 0, 1, 0, 0, 1, "Requires Circuit: ", 1, ".", true, true);
        public static final GTPP_Recipe_Map_Internal sSpargeTowerRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.spargetower", "Sparging", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 1, "", true, false);
        public static final GTPP_Recipe_Map_Internal sAdvFreezerRecipes_GT = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(2000), "gtpp.recipe.cryogenicfreezer", "Cryogenic Freezer", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GTPP_Recipe_Map_Internal sMultiblockCentrifugeRecipes_GT = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(2000), "gtpp.recipe.multicentrifuge", "Multiblock Centrifuge", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GTPP_Recipe_Map_Internal sMultiblockElectrolyzerRecipes_GT = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(2000), "gtpp.recipe.multielectro", "Multiblock Electrolyzer", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GTPP_Recipe_Map_Internal sChemicalPlant_GT = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(2000), "gtpp.recipe.temp4", "temp4", null, "gregtech:textures/gui/basicmachines/PotionBrewer", 0, 0, 0, 0, 0, "", 0, "", false, false);
        public static final GTPP_Recipe_Map_Internal sMultiblockMixerRecipes_GT = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(2000), "gtpp.recipe.multimixer", "Multiblock Mixer", null, "gregtech:textures/gui/basicmachines/FissionFuel", 12, 9, 0, 0, 1, "", 0, "", false, true);
        public static final GT_Recipe.GT_Recipe_Map_Fuel sSemiFluidLiquidFuels = new GT_Recipe.GT_Recipe_Map_Fuel(new HashSet(10), "gtpp.recipe.semifluidgeneratorfuels", "Semifluid Generator Fuels", null, "gregtech:textures/gui/basicmachines/Default", 1, 1, 0, 0, 1, "Fuel Value: ", 1000, " EU", true, true);
        public static final GTPP_Recipe_Map_Internal sFlotationCellRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(10000), "gtpp.recipe.flotationcell", "Flotation Cell", null, "gregtech:textures/gui/basicmachines/LFTR", 6, 4, 1, 1, 1, "Ore Key: ", 1, "", true, false);
        public static final GTPP_Recipe_Map_Internal sTreeSimFakeRecipes = new GTPP_Recipe_Map_Internal(new HashSet<GT_Recipe>(100), "gtpp.recipe.treefarm", "Tree Growth Simulator", null, "gregtech:textures/gui/basicmachines/FissionFuel", 9, 9, 1, 0, 1, "", 1, "", false, true);
        public final Map<GT_ItemStack, Collection<GTPP_Recipe>> mRecipeItemMap = new HashMap<GT_ItemStack, Collection<GTPP_Recipe>>();
        public final Map<Fluid, Collection<GTPP_Recipe>> mRecipeFluidMap = new HashMap<Fluid, Collection<GTPP_Recipe>>();
        public final Collection<GTPP_Recipe> mRecipeList;
        public final String mUnlocalizedName;
        public final String mNEIName;
        public final String mNEIGUIPath;
        public final String mNEISpecialValuePre;
        public final String mNEISpecialValuePost;
        public final int mUsualInputCount;
        public final int mUsualOutputCount;
        public final int mNEISpecialValueMultiplier;
        public final int mMinimalInputItems;
        public final int mMinimalInputFluids;
        public final int mAmperage;
        public final boolean mNEIAllowed;
        public final boolean mShowVoltageAmperageInNEI;

        public GTPP_Recipe_Map(Collection<GTPP_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            sMappings.add(this);
            this.mNEIAllowed = aNEIAllowed;
            this.mShowVoltageAmperageInNEI = aShowVoltageAmperageInNEI;
            this.mRecipeList = aRecipeList;
            this.mNEIName = aNEIName == null ? aUnlocalizedName : aNEIName;
            this.mNEIGUIPath = aNEIGUIPath.endsWith(".png") ? aNEIGUIPath : aNEIGUIPath + ".png";
            this.mNEISpecialValuePre = aNEISpecialValuePre;
            this.mNEISpecialValueMultiplier = aNEISpecialValueMultiplier;
            this.mNEISpecialValuePost = aNEISpecialValuePost;
            this.mAmperage = aAmperage;
            this.mUsualInputCount = aUsualInputCount;
            this.mUsualOutputCount = aUsualOutputCount;
            this.mMinimalInputItems = aMinimalInputItems;
            this.mMinimalInputFluids = aMinimalInputFluids;
            GregTech_API.sFluidMappings.add(this.mRecipeFluidMap);
            GregTech_API.sItemStackMappings.add(this.mRecipeItemMap);
            this.mUnlocalizedName = aUnlocalizedName;
            GT_LanguageManager.addStringLocalization((String)this.mUnlocalizedName, (String)aLocalName);
        }

        public GTPP_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe(aOptimize, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GTPP_Recipe addRecipe(int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe(false, null, null, null, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue), false, false, false);
        }

        public GTPP_Recipe addRecipe(boolean aOptimize, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe(aOptimize, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GTPP_Recipe addRecipe(boolean aOptimize, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addRecipe(new GTPP_Recipe(aOptimize, null, null, null, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GTPP_Recipe addRecipe(GTPP_Recipe aRecipe) {
            Logger.WARNING("Adding Recipe Method 1");
            return this.addRecipe(aRecipe, true, false, false);
        }

        protected GTPP_Recipe addRecipe(GTPP_Recipe aRecipe, boolean aCheckForCollisions, boolean aFakeRecipe, boolean aHidden) {
            Logger.WARNING("Adding Recipe Method 2 - This Checks if hidden, fake or if duplicate recipes exists, I think.");
            aRecipe.mHidden = aHidden;
            aRecipe.mFakeRecipe = aFakeRecipe;
            Logger.WARNING("Logging some data about this method: GregtechRecipe[" + aRecipe.toString() + "] | aCheckForCollisions[" + aCheckForCollisions + "] | aFakeRecipe[" + aFakeRecipe + "] | aHidden[" + aHidden + "]");
            Logger.WARNING("Logging some data about this method: mMinimalInputFluids[" + this.mMinimalInputFluids + "] | mMinimalInputItems[" + this.mMinimalInputItems + "] | aRecipe.mFluidInputs.length[" + aRecipe.mFluidInputs.length + "] | aRecipe.mInputs.length[" + aRecipe.mInputs.length + "]");
            if (aRecipe.mFluidInputs.length < this.mMinimalInputFluids && aRecipe.mInputs.length < this.mMinimalInputItems) {
                Logger.WARNING("Step 2 failed");
                return null;
            }
            Logger.WARNING("Logging some data about this method: aCheckForCollisions[" + aCheckForCollisions + "] | findRecipe != null [" + (this.findRecipe(null, false, Long.MAX_VALUE, aRecipe.mFluidInputs, aRecipe.mInputs) != null) + "]");
            if (aCheckForCollisions && this.findRecipe(null, false, Long.MAX_VALUE, aRecipe.mFluidInputs, aRecipe.mInputs) != null) {
                Logger.WARNING("Step 2 failed - 2");
                return null;
            }
            return this.add(aRecipe);
        }

        public GTPP_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, int[] aOutputChances, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GTPP_Recipe(false, aInputs, aOutputs, aSpecial, aOutputChances, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GTPP_Recipe addFakeRecipe(boolean aCheckForCollisions, ItemStack[] aInputs, ItemStack[] aOutputs, Object aSpecial, FluidStack[] aFluidInputs, FluidStack[] aFluidOutputs, int aDuration, int aEUt, int aSpecialValue) {
            return this.addFakeRecipe(aCheckForCollisions, new GTPP_Recipe(false, aInputs, aOutputs, aSpecial, null, aFluidInputs, aFluidOutputs, aDuration, aEUt, aSpecialValue));
        }

        public GTPP_Recipe addFakeRecipe(boolean aCheckForCollisions, GTPP_Recipe aRecipe) {
            return this.addRecipe(aRecipe, aCheckForCollisions, true, false);
        }

        public GTPP_Recipe add(GTPP_Recipe aRecipe) {
            Logger.WARNING("Adding Recipe Method 3");
            this.mRecipeList.add(aRecipe);
            for (FluidStack aFluid : aRecipe.mFluidInputs) {
                if (aFluid == null) continue;
                Logger.WARNING("Fluid is valid - getting some kind of fluid instance to add to the recipe hashmap.");
                Collection<GTPP_Recipe> tList = this.mRecipeFluidMap.get(aFluid.getFluid());
                if (tList == null) {
                    tList = new HashSet<GTPP_Recipe>(1);
                    this.mRecipeFluidMap.put(aFluid.getFluid(), tList);
                }
                tList.add(aRecipe);
            }
            return this.addToItemMap(aRecipe);
        }

        public void reInit() {
            Map<GT_ItemStack, Collection<GTPP_Recipe>> tMap = this.mRecipeItemMap;
            if (tMap != null) {
                tMap.clear();
            }
            for (GTPP_Recipe tRecipe : this.mRecipeList) {
                GT_OreDictUnificator.setStackArray((boolean)true, (ItemStack[])tRecipe.mInputs);
                GT_OreDictUnificator.setStackArray((boolean)true, (ItemStack[])tRecipe.mOutputs);
                if (tMap == null) continue;
                this.addToItemMap(tRecipe);
            }
        }

        public boolean containsInput(ItemStack aStack) {
            return aStack != null && (this.mRecipeItemMap.containsKey(new GT_ItemStack(aStack)) || this.mRecipeItemMap.containsKey(new GT_ItemStack(GT_Utility.copyMetaData((long)32767L, (Object[])new Object[]{aStack}))));
        }

        public boolean containsInput(FluidStack aFluid) {
            return aFluid != null && this.containsInput(aFluid.getFluid());
        }

        public boolean containsInput(Fluid aFluid) {
            return aFluid != null && this.mRecipeFluidMap.containsKey(aFluid);
        }

        public GTPP_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, (GTPP_Recipe)null, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        public GTPP_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GTPP_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
            return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
        }

        public GTPP_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GTPP_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
            Collection<GTPP_Recipe> tRecipes;
            int n;
            if (this.mRecipeList.isEmpty()) {
                return null;
            }
            if (GregTech_API.sPostloadFinished) {
                int n2;
                FluidStack[] fluidStackArray;
                int tAmount;
                if (this.mMinimalInputFluids > 0) {
                    if (aFluids == null) {
                        return null;
                    }
                    tAmount = 0;
                    fluidStackArray = aFluids;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aFluid = fluidStackArray[n2];
                        if (aFluid == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputFluids) {
                        return null;
                    }
                }
                if (this.mMinimalInputItems > 0) {
                    if (aInputs == null) {
                        return null;
                    }
                    tAmount = 0;
                    fluidStackArray = aInputs;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aInput = fluidStackArray[n2];
                        if (aInput == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputItems) {
                        return null;
                    }
                }
            }
            if (aNotUnificated) {
                aInputs = GT_OreDictUnificator.getStackArray((boolean)true, (Object[])aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)aRecipe.mEUt ? aRecipe : null;
            }
            if (this.mUsualInputCount > 0 && aInputs != null) {
                ItemStack[] itemStackArray = aInputs;
                int n3 = itemStackArray.length;
                for (n = 0; n < n3; ++n) {
                    ItemStack tStack = itemStackArray[n];
                    if (tStack == null) continue;
                    tRecipes = this.mRecipeItemMap.get(new GT_ItemStack(tStack));
                    if (tRecipes != null) {
                        for (GTPP_Recipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                        }
                    }
                    if ((tRecipes = this.mRecipeItemMap.get(new GT_ItemStack(GT_Utility.copyMetaData((long)32767L, (Object[])new Object[]{tStack})))) == null) continue;
                    for (GTPP_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                    }
                }
            }
            if (this.mMinimalInputItems == 0 && aFluids != null) {
                for (FluidStack aFluid : aFluids) {
                    if (aFluid == null || (tRecipes = this.mRecipeFluidMap.get(aFluid.getFluid())) == null) continue;
                    for (GTPP_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                    }
                }
            }
            return null;
        }

        protected GTPP_Recipe addToItemMap(GTPP_Recipe aRecipe) {
            Logger.WARNING("Adding Recipe Method 4");
            for (ItemStack aStack : aRecipe.mInputs) {
                if (aStack == null) continue;
                Logger.WARNING("Method 4 - Manipulating " + aStack.func_82833_r());
                GT_ItemStack tStack = new GT_ItemStack(aStack);
                Logger.WARNING("Method 4 - Made gt stack of item " + tStack.toStack().func_82833_r());
                Collection<GTPP_Recipe> tList = this.mRecipeItemMap.get(tStack);
                if (tList != null) {
                    Logger.WARNING("Method 4 - Gt Recipe Hashmap: " + tList.toString());
                }
                if (tList == null) {
                    Logger.WARNING("Method 4 - brrr list was NUll");
                    tList = new HashSet<GTPP_Recipe>(1);
                    this.mRecipeItemMap.put(tStack, tList);
                    Logger.WARNING("Method 4 - Attemping backup method for Gt Recipe Hashmap:");
                    while (tList.iterator().hasNext()) {
                        Logger.WARNING(tList.iterator().next().toString());
                    }
                }
                tList.add(aRecipe);
                Logger.WARNING("Method 4 - Added recipe to map? I think.");
            }
            return aRecipe;
        }

        public GTPP_Recipe findRecipe(IGregTechTileEntity baseMetaTileEntity, GTPP_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, FluidStack[] fluidStacks) {
            Collection<GTPP_Recipe> tRecipes;
            int n;
            ItemStack[] aInputs = null;
            if (this.mRecipeList.isEmpty()) {
                return null;
            }
            if (GregTech_API.sPostloadFinished) {
                int n2;
                FluidStack[] fluidStackArray;
                int tAmount;
                if (this.mMinimalInputFluids > 0) {
                    if (aFluids == null) {
                        return null;
                    }
                    tAmount = 0;
                    fluidStackArray = aFluids;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aFluid = fluidStackArray[n2];
                        if (aFluid == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputFluids) {
                        return null;
                    }
                }
                if (this.mMinimalInputItems > 0) {
                    if (aInputs == null) {
                        return null;
                    }
                    tAmount = 0;
                    fluidStackArray = aInputs;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aInput = fluidStackArray[n2];
                        if (aInput == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.mMinimalInputItems) {
                        return null;
                    }
                }
            }
            if (aNotUnificated) {
                aInputs = GT_OreDictUnificator.getStackArray((boolean)true, (Object[])aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) {
                return aRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)aRecipe.mEUt ? aRecipe : null;
            }
            if (this.mUsualInputCount > 0 && aInputs != null) {
                ItemStack[] itemStackArray = aInputs;
                int n3 = itemStackArray.length;
                for (n = 0; n < n3; ++n) {
                    ItemStack tStack = itemStackArray[n];
                    if (tStack == null) continue;
                    tRecipes = this.mRecipeItemMap.get(new GT_ItemStack(tStack));
                    if (tRecipes != null) {
                        for (GTPP_Recipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                            return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                        }
                    }
                    if ((tRecipes = this.mRecipeItemMap.get(new GT_ItemStack(GT_Utility.copyMetaData((long)32767L, (Object[])new Object[]{tStack})))) == null) continue;
                    for (GTPP_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                    }
                }
            }
            if (this.mMinimalInputItems == 0 && aFluids != null) {
                for (FluidStack aFluid : aFluids) {
                    if (aFluid == null || (tRecipes = this.mRecipeFluidMap.get(aFluid.getFluid())) == null) continue;
                    for (GTPP_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, true, aFluids, aInputs)) continue;
                        return tRecipe.mEnabled && aVoltage * (long)this.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                    }
                }
            }
            return null;
        }
    }

    public static class GTPP_Recipe_Map_Internal
    extends GT_Recipe.GT_Recipe_Map {
        public static final Collection<GTPP_Recipe_Map_Internal> sMappingsEx = new ArrayList<GTPP_Recipe_Map_Internal>();
        private static final HashMap<Integer, GTPP_Recipe> mHashedRecipes = new HashMap();

        public GTPP_Recipe_Map_Internal(Collection<GT_Recipe> aRecipeList, String aUnlocalizedName, String aLocalName, String aNEIName, String aNEIGUIPath, int aUsualInputCount, int aUsualOutputCount, int aMinimalInputItems, int aMinimalInputFluids, int aAmperage, String aNEISpecialValuePre, int aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed) {
            super(aRecipeList, aUnlocalizedName, aLocalName, aNEIName, aNEIGUIPath, aUsualInputCount, aUsualOutputCount, aMinimalInputItems, aMinimalInputFluids, aAmperage, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed);
            GT_Recipe.GT_Recipe_Map.sMappings.remove((Object)this);
            sMappingsEx.add(this);
        }
    }
}

