/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner.components;

import Ic2ExpReactorPlanner.components.ReactorItem;
import gregtech.api.objects.GT_ItemStack;

public class Condensator
extends ReactorItem {
    public Condensator(int id, String baseName, GT_ItemStack aItem, double maxDamage, double maxHeat, String sourceMod) {
        super(id, baseName, aItem, maxDamage, maxHeat, sourceMod);
    }

    public Condensator(Condensator other) {
        super(other);
    }

    @Override
    public double adjustCurrentHeat(double heat) {
        if (heat < 0.0) {
            return heat;
        }
        this.currentCondensatorCooling += heat;
        this.bestCondensatorCooling = Math.max(this.currentCondensatorCooling, this.bestCondensatorCooling);
        double acceptedHeat = Math.min(heat, this.getMaxHeat() - heat);
        double result = heat - acceptedHeat;
        this.currentHeat += acceptedHeat;
        this.maxReachedHeat = Math.max(this.maxReachedHeat, this.currentHeat);
        return result;
    }

    @Override
    public boolean needsCoolantInjected() {
        return this.currentHeat > 0.85 * this.getMaxHeat();
    }

    @Override
    public void injectCoolant() {
        this.currentHeat = 0.0;
    }
}

