/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import Ic2ExpReactorPlanner.BigintStorage;
import Ic2ExpReactorPlanner.ComponentFactory;
import Ic2ExpReactorPlanner.TaloniusDecoder;
import Ic2ExpReactorPlanner.components.ReactorItem;
import java.awt.HeadlessException;
import java.util.ArrayList;

public class Reactor {
    private final ReactorItem[][] grid = new ReactorItem[6][9];
    private double currentEUoutput = 0.0;
    private double currentHeat = 0.0;
    private double maxHeat = 10000.0;
    private double ventedHeat = 0.0;
    private boolean fluid = false;
    private boolean pulsed = false;
    private boolean automated = false;
    private boolean usingReactorCoolantInjectors = false;
    private static final int DEFAULT_ON_PULSE = 5000000;
    private int onPulse = 5000000;
    private static final int DEFAULT_OFF_PULSE = 0;
    private int offPulse = 0;
    private static final int DEFAULT_SUSPEND_TEMP = 120000;
    private int suspendTemp = 120000;
    private static final int DEFAULT_RESUME_TEMP = 120000;
    private int resumeTemp = 120000;
    private int maxSimulationTicks = 5000000;
    private static final int MAX_PARAM_TYPES = 3;
    public static final int MAX_COMPONENT_HEAT = 1080000;

    public ReactorItem getComponentAt(int row, int column) {
        if (row >= 0 && row < this.grid.length && column >= 0 && column < this.grid[row].length) {
            return this.grid[row][column];
        }
        return null;
    }

    public void setComponentAt(int row, int column, ReactorItem component) {
        if (row >= 0 && row < this.grid.length && column >= 0 && column < this.grid[row].length) {
            if (this.grid[row][column] != null) {
                this.grid[row][column].removeFromReactor();
            }
            this.grid[row][column] = component;
            if (component != null) {
                component.addToReactor(this, row, column);
            }
        }
    }

    public void clearGrid() {
        for (int row = 0; row < this.grid.length; ++row) {
            for (int col = 0; col < this.grid[row].length; ++col) {
                this.setComponentAt(row, col, null);
            }
        }
    }

    public double getCurrentEUoutput() {
        return this.currentEUoutput;
    }

    public double getCurrentHeat() {
        return this.currentHeat;
    }

    public double getMaxHeat() {
        return this.maxHeat;
    }

    public void adjustMaxHeat(double adjustment) {
        this.maxHeat += adjustment;
    }

    public void setCurrentHeat(double currentHeat) {
        this.currentHeat = currentHeat;
    }

    public void adjustCurrentHeat(double adjustment) {
        this.currentHeat += adjustment;
        if (this.currentHeat < 0.0) {
            this.currentHeat = 0.0;
        }
    }

    public void addEUOutput(double amount) {
        this.currentEUoutput += amount;
    }

    public void clearEUOutput() {
        this.currentEUoutput = 0.0;
    }

    public ArrayList getMaterials() {
        return new ArrayList();
    }

    public ArrayList<ReactorItem> getComponentList() {
        ArrayList<ReactorItem> result = new ArrayList<ReactorItem>();
        for (int col = 0; col < this.grid[0].length; ++col) {
            for (int row = 0; row < this.grid.length; ++row) {
                if (this.getComponentAt(row, col) == null) continue;
                result.add(this.getComponentAt(row, col));
            }
        }
        return result;
    }

    public double getVentedHeat() {
        return this.ventedHeat;
    }

    public void ventHeat(double amount) {
        this.ventedHeat += amount;
    }

    public void clearVentedHeat() {
        this.ventedHeat = 0.0;
    }

    public String getCode() {
        return "erp=" + this.buildCodeString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCode(String code) {
        int pos = 0;
        int[][] ids = new int[this.grid.length][this.grid[0].length];
        char[][][] paramTypes = new char[this.grid.length][this.grid[0].length][3];
        int[][][] params = new int[this.grid.length][this.grid[0].length][3];
        if (code.startsWith("erp=")) {
            this.readCodeString(code.substring(4));
            return;
        } else if (code.length() >= 108 && code.matches("[0-9A-Za-z(),|]+")) {
            try {
                int col;
                int row;
                for (row = 0; row < this.grid.length; ++row) {
                    for (col = 0; col < this.grid[row].length; ++col) {
                        int tempPos;
                        ids[row][col] = Integer.parseInt(code.substring(pos, pos + 2), 16);
                        int paramNum = 0;
                        if ((pos += 2) + 1 >= code.length() || code.charAt(pos) != '(') continue;
                        paramTypes[row][col][paramNum] = code.charAt(pos + 1);
                        StringBuilder param = new StringBuilder(10);
                        for (tempPos = pos + 2; tempPos < code.length() && code.charAt(tempPos) != ')'; ++tempPos) {
                            if (code.charAt(tempPos) == ',') {
                                params[row][col][paramNum] = Integer.parseInt(param.toString(), 36);
                                ++paramNum;
                                if (tempPos + 1 < code.length()) {
                                    paramTypes[row][col][paramNum] = code.charAt(++tempPos);
                                }
                                param.setLength(0);
                                continue;
                            }
                            param.append(code.charAt(tempPos));
                        }
                        params[row][col][paramNum] = Integer.parseInt(param.toString(), 36);
                        pos = tempPos + 1;
                    }
                }
                for (row = 0; row < this.grid.length; ++row) {
                    for (col = 0; col < this.grid[row].length; ++col) {
                        ReactorItem component = ComponentFactory.createComponent(ids[row][col]);
                        block31: for (int paramNum = 0; paramNum < 3; ++paramNum) {
                            switch (paramTypes[row][col][paramNum]) {
                                case 'h': {
                                    component.setInitialHeat(params[row][col][paramNum]);
                                    continue block31;
                                }
                                case 'a': {
                                    component.setAutomationThreshold(params[row][col][paramNum]);
                                    continue block31;
                                }
                                case 'p': {
                                    component.setReactorPause(params[row][col][paramNum]);
                                    continue block31;
                                }
                            }
                        }
                        this.setComponentAt(row, col, component);
                    }
                }
                if (code.split("\\|").length > 1) {
                    String extraCode = code.split("\\|")[1];
                    switch (extraCode.charAt(0)) {
                        case 'f': {
                            this.fluid = true;
                            break;
                        }
                        case 'e': {
                            this.fluid = false;
                            break;
                        }
                    }
                    switch (extraCode.charAt(1)) {
                        case 's': {
                            this.pulsed = false;
                            this.automated = false;
                            break;
                        }
                        case 'p': {
                            this.pulsed = true;
                            this.automated = false;
                            break;
                        }
                        case 'a': {
                            this.pulsed = true;
                            this.automated = true;
                            break;
                        }
                    }
                    switch (extraCode.charAt(2)) {
                        case 'i': {
                            this.usingReactorCoolantInjectors = true;
                            break;
                        }
                        case 'n': {
                            this.usingReactorCoolantInjectors = false;
                            break;
                        }
                    }
                    this.currentHeat = extraCode.length() > 3 ? (double)Integer.parseInt(extraCode.substring(3), 36) : 0.0;
                }
                if (code.split("\\|").length <= 2) return;
                String[] moreCodes = code.split("\\|");
                block32: for (int i = 2; i < moreCodes.length; ++i) {
                    switch (moreCodes[i].charAt(0)) {
                        case 'n': {
                            this.onPulse = Integer.parseInt(moreCodes[i].substring(1), 36);
                            continue block32;
                        }
                        case 'f': {
                            this.offPulse = Integer.parseInt(moreCodes[i].substring(1), 36);
                            continue block32;
                        }
                        case 's': {
                            this.suspendTemp = Integer.parseInt(moreCodes[i].substring(1), 36);
                            continue block32;
                        }
                        case 'r': {
                            this.resumeTemp = Integer.parseInt(moreCodes[i].substring(1), 36);
                            continue block32;
                        }
                    }
                }
                return;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return;
            }
        } else {
            String tempCode = code;
            if (code.startsWith("http://www.talonfiremage.pwp.blueyonder.co.uk/v3/reactorplanner.html?")) {
                tempCode = code.replace("http://www.talonfiremage.pwp.blueyonder.co.uk/v3/reactorplanner.html?", "");
            }
            if (tempCode.matches("[0-9a-z]+")) {
                this.handleTaloniusCode(tempCode);
                return;
            } else if (code.matches("[0-9A-Za-z+/=]+")) {
                this.readCodeString(code);
                return;
            } else if (code.isEmpty()) return;
        }
    }

    private void handleTaloniusCode(String tempCode) throws HeadlessException {
        StringBuilder warnings = new StringBuilder(500);
        TaloniusDecoder decoder = new TaloniusDecoder(tempCode);
        this.currentHeat = 100 * decoder.readInt(10);
        for (int x = 8; x >= 0; --x) {
            block40: for (int y = 5; y >= 0; --y) {
                int nextValue = decoder.readInt(7);
                if (nextValue > 64) {
                    nextValue = decoder.readInt(7);
                }
                switch (nextValue) {
                    case 0: {
                        this.setComponentAt(y, x, null);
                        continue block40;
                    }
                    case 1: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("fuelRodUranium"));
                        continue block40;
                    }
                    case 2: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("dualFuelRodUranium"));
                        continue block40;
                    }
                    case 3: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("quadFuelRodUranium"));
                        continue block40;
                    }
                    case 5: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("neutronReflector"));
                        continue block40;
                    }
                    case 6: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("thickNeutronReflector"));
                        continue block40;
                    }
                    case 7: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("heatVent"));
                        continue block40;
                    }
                    case 8: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("reactorHeatVent"));
                        continue block40;
                    }
                    case 9: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("overclockedHeatVent"));
                        continue block40;
                    }
                    case 10: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("advancedHeatVent"));
                        continue block40;
                    }
                    case 11: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("componentHeatVent"));
                        continue block40;
                    }
                    case 12: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("rshCondensator"));
                        continue block40;
                    }
                    case 13: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("lzhCondensator"));
                        continue block40;
                    }
                    case 14: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("heatExchanger"));
                        continue block40;
                    }
                    case 15: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coreHeatExchanger"));
                        continue block40;
                    }
                    case 16: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("componentHeatExchanger"));
                        continue block40;
                    }
                    case 17: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("advancedHeatExchanger"));
                        continue block40;
                    }
                    case 18: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("reactorPlating"));
                        continue block40;
                    }
                    case 19: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("heatCapacityReactorPlating"));
                        continue block40;
                    }
                    case 20: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("containmentReactorPlating"));
                        continue block40;
                    }
                    case 21: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCell10k"));
                        continue block40;
                    }
                    case 22: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCell30k"));
                        continue block40;
                    }
                    case 23: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCell60k"));
                        continue block40;
                    }
                    case 24: {
                        warnings.append("Warning.Heating", y, x);
                        continue block40;
                    }
                    case 32: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("fuelRodThorium"));
                        continue block40;
                    }
                    case 33: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("dualFuelRodThorium"));
                        continue block40;
                    }
                    case 34: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("quadFuelRodThorium"));
                        continue block40;
                    }
                    case 35: {
                        warnings.append("Warning.Plutonium", y, x);
                        continue block40;
                    }
                    case 36: {
                        warnings.append("Warning.DualPlutonium", y, x);
                        continue block40;
                    }
                    case 37: {
                        warnings.append("Warning.QuadPlutonium", y, x);
                        continue block40;
                    }
                    case 38: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("iridiumNeutronReflector"));
                        continue block40;
                    }
                    case 39: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCellHelium60k"));
                        continue block40;
                    }
                    case 40: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCellHelium180k"));
                        continue block40;
                    }
                    case 41: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCellHelium360k"));
                        continue block40;
                    }
                    case 42: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCellNak60k"));
                        continue block40;
                    }
                    case 43: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCellNak180k"));
                        continue block40;
                    }
                    case 44: {
                        this.setComponentAt(y, x, ComponentFactory.createComponent("coolantCellNak360k"));
                        continue block40;
                    }
                    default: {
                        warnings.append("Warning.Unrecognized", y, x);
                    }
                }
            }
        }
        if (warnings.length() > 0) {
            warnings.setLength(warnings.length() - 1);
        }
    }

    private void readCodeString(String code) {
        BigintStorage storage = BigintStorage.inputBase64(code);
        int codeRevision = storage.extract(255);
        int maxComponentHeat = codeRevision == 3 ? 1080000 : 360000;
        if (codeRevision > 3) {
            throw new IllegalArgumentException("Unsupported code revision in reactor code.");
        }
        if (codeRevision >= 1) {
            this.pulsed = storage.extract(1) > 0;
            this.automated = storage.extract(1) > 0;
        }
        for (int row = 0; row < this.grid.length; ++row) {
            for (int col = 0; col < this.grid[row].length; ++col) {
                int componentId = 0;
                componentId = codeRevision <= 1 ? storage.extract(38) : (codeRevision == 2 ? storage.extract(44) : storage.extract(ComponentFactory.MAX_COMPONENT_ID));
                if (componentId != 0) {
                    ReactorItem component = ComponentFactory.createComponent(componentId);
                    int hasSpecialAutomationConfig = storage.extract(1);
                    if (hasSpecialAutomationConfig > 0) {
                        component.setInitialHeat(storage.extract(maxComponentHeat));
                        if (codeRevision == 0 || codeRevision >= 1 && this.automated) {
                            component.setAutomationThreshold(storage.extract(maxComponentHeat));
                            component.setReactorPause(storage.extract(10000));
                        }
                    }
                    this.setComponentAt(row, col, component);
                    continue;
                }
                this.setComponentAt(row, col, null);
            }
        }
        this.currentHeat = storage.extract(120000);
        if (codeRevision == 0 || codeRevision >= 1 && this.pulsed) {
            this.onPulse = storage.extract(5000000);
            this.offPulse = storage.extract(5000000);
            this.suspendTemp = storage.extract(120000);
            this.resumeTemp = storage.extract(120000);
        }
        this.fluid = storage.extract(1) > 0;
        boolean bl = this.usingReactorCoolantInjectors = storage.extract(1) > 0;
        if (codeRevision == 0) {
            this.pulsed = storage.extract(1) > 0;
            this.automated = storage.extract(1) > 0;
        }
        this.maxSimulationTicks = storage.extract(5000000);
    }

    private String buildCodeString() {
        BigintStorage storage = new BigintStorage();
        storage.store(this.maxSimulationTicks, 5000000);
        storage.store(this.usingReactorCoolantInjectors ? 1 : 0, 1);
        storage.store(this.fluid ? 1 : 0, 1);
        if (this.pulsed) {
            storage.store(this.resumeTemp, 120000);
            storage.store(this.suspendTemp, 120000);
            storage.store(this.offPulse, 5000000);
            storage.store(this.onPulse, 5000000);
        }
        storage.store((int)this.currentHeat, 120000);
        for (int row = this.grid.length - 1; row >= 0; --row) {
            for (int col = this.grid[row].length - 1; col >= 0; --col) {
                ReactorItem component = this.grid[row][col];
                if (component != null) {
                    int id = component.id;
                    if (component.getInitialHeat() > 0.0 || component.getAutomationThreshold() != ComponentFactory.getDefaultComponent(id).getAutomationThreshold() || component.getReactorPause() != ComponentFactory.getDefaultComponent(id).getReactorPause()) {
                        if (this.automated) {
                            storage.store(component.getReactorPause(), 10000);
                            storage.store(component.getAutomationThreshold(), 1080000);
                        }
                        storage.store((int)component.getInitialHeat(), 1080000);
                        storage.store(1, 1);
                    } else {
                        storage.store(0, 1);
                    }
                    storage.store(id, ComponentFactory.MAX_COMPONENT_ID);
                    continue;
                }
                storage.store(0, ComponentFactory.MAX_COMPONENT_ID);
            }
        }
        storage.store(this.automated ? 1 : 0, 1);
        storage.store(this.pulsed ? 1 : 0, 1);
        storage.store(3, 255);
        return storage.outputBase64();
    }

    public String getOldCode() {
        StringBuilder result = new StringBuilder(108);
        for (int row = 0; row < this.grid.length; ++row) {
            for (int col = 0; col < this.grid[row].length; ++col) {
                ReactorItem component = this.getComponentAt(row, col);
                int id = component != null ? component.id : 0;
                result.append(String.format("%02X", id));
                if (component == null || !(component.getInitialHeat() > 0.0 || this.automated && component.getAutomationThreshold() != ComponentFactory.getDefaultComponent(id).getAutomationThreshold()) && (!this.automated || component.getReactorPause() == ComponentFactory.getDefaultComponent(id).getReactorPause())) continue;
                result.append("(");
                if (component.getInitialHeat() > 0.0) {
                    result.append(String.format("h%s,", Integer.toString((int)component.getInitialHeat(), 36)));
                }
                if (this.automated && component.getAutomationThreshold() != ComponentFactory.getDefaultComponent(id).getAutomationThreshold()) {
                    result.append(String.format("a%s,", Integer.toString(component.getAutomationThreshold(), 36)));
                }
                if (this.automated && component.getReactorPause() != ComponentFactory.getDefaultComponent(id).getReactorPause()) {
                    result.append(String.format("p%s,", Integer.toString(component.getReactorPause(), 36)));
                }
                result.setLength(result.length() - 1);
                result.append(")");
            }
        }
        result.append('|');
        if (this.fluid) {
            result.append('f');
        } else {
            result.append('e');
        }
        if (this.automated) {
            result.append('a');
        } else if (this.pulsed) {
            result.append('p');
        } else {
            result.append('s');
        }
        if (this.usingReactorCoolantInjectors) {
            result.append('i');
        } else {
            result.append('n');
        }
        if (this.currentHeat > 0.0) {
            result.append(Integer.toString((int)this.currentHeat, 36));
        }
        if (this.pulsed && this.onPulse != 5000000) {
            result.append(String.format("|n%s", Integer.toString(this.onPulse, 36)));
        }
        if (this.pulsed && this.offPulse != 0) {
            result.append(String.format("|f%s", Integer.toString(this.offPulse, 36)));
        }
        if (this.pulsed && this.suspendTemp != 120000) {
            result.append(String.format("|s%s", Integer.toString(this.suspendTemp, 36)));
        }
        if (this.pulsed && this.resumeTemp != 120000) {
            result.append(String.format("|r%s", Integer.toString(this.resumeTemp, 36)));
        }
        return result.toString();
    }

    public boolean isFluid() {
        return this.fluid;
    }

    public void setFluid(boolean fluid) {
        this.fluid = fluid;
    }

    public boolean isUsingReactorCoolantInjectors() {
        return this.usingReactorCoolantInjectors;
    }

    public void setUsingReactorCoolantInjectors(boolean usingReactorCoolantInjectors) {
        this.usingReactorCoolantInjectors = usingReactorCoolantInjectors;
    }

    public int getOnPulse() {
        return this.onPulse;
    }

    public void setOnPulse(int onPulse) {
        this.onPulse = onPulse;
    }

    public int getOffPulse() {
        return this.offPulse;
    }

    public void setOffPulse(int offPulse) {
        this.offPulse = offPulse;
    }

    public int getSuspendTemp() {
        return this.suspendTemp;
    }

    public void setSuspendTemp(int suspendTemp) {
        this.suspendTemp = suspendTemp;
    }

    public int getResumeTemp() {
        return this.resumeTemp;
    }

    public void setResumeTemp(int resumeTemp) {
        this.resumeTemp = resumeTemp;
    }

    public boolean isPulsed() {
        return this.pulsed;
    }

    public void setPulsed(boolean pulsed) {
        this.pulsed = pulsed;
    }

    public boolean isAutomated() {
        return this.automated;
    }

    public void setAutomated(boolean automated) {
        this.automated = automated;
    }

    public int getMaxSimulationTicks() {
        return this.maxSimulationTicks;
    }

    public void setMaxSimulationTicks(int maxSimulationTicks) {
        this.maxSimulationTicks = maxSimulationTicks;
    }

    public void resetPulseConfig() {
        this.onPulse = 5000000;
        this.offPulse = 0;
        this.suspendTemp = 120000;
        this.resumeTemp = 120000;
    }
}

