/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import Ic2ExpReactorPlanner.components.Condensator;
import Ic2ExpReactorPlanner.components.CoolantCell;
import Ic2ExpReactorPlanner.components.Exchanger;
import Ic2ExpReactorPlanner.components.FuelRod;
import Ic2ExpReactorPlanner.components.Plating;
import Ic2ExpReactorPlanner.components.ReactorItem;
import Ic2ExpReactorPlanner.components.Reflector;
import Ic2ExpReactorPlanner.components.Vent;
import gregtech.api.enums.ItemList;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.xmod.bartworks.BW_Utils;
import gtPlusPlus.xmod.goodgenerator.GG_Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ComponentFactory {
    public static int MAX_COMPONENT_ID = 64;
    static ItemList[] aGtItems = new ItemList[]{ItemList.Neutron_Reflector, ItemList.Moxcell_1, ItemList.Moxcell_2, ItemList.Moxcell_4};
    private static LinkedHashMap<Integer, ReactorItem> ITEM_LIST = new LinkedHashMap();
    private static final Map<String, ReactorItem> ITEM_MAP;

    private ComponentFactory() {
    }

    private static Map<String, ReactorItem> makeItemMap() {
        HashMap<String, ReactorItem> result = new HashMap<String, ReactorItem>((int)((double)ITEM_LIST.size() * 1.5));
        for (ReactorItem reactorItem : ITEM_LIST.values()) {
            if (reactorItem == null) continue;
            result.put(reactorItem.baseName, reactorItem);
        }
        return Collections.unmodifiableMap(result);
    }

    private static ReactorItem copy(ReactorItem source) {
        if (source != null) {
            Class<?> aClass = source.getClass();
            if (aClass == Condensator.class) {
                return new Condensator((Condensator)source);
            }
            if (aClass == CoolantCell.class) {
                return new CoolantCell((CoolantCell)source);
            }
            if (aClass == Exchanger.class) {
                return new Exchanger((Exchanger)source);
            }
            if (aClass == FuelRod.class) {
                return new FuelRod((FuelRod)source);
            }
            if (aClass == Plating.class) {
                return new Plating((Plating)source);
            }
            if (aClass == Reflector.class) {
                return new Reflector((Reflector)source);
            }
            if (aClass == Vent.class) {
                return new Vent((Vent)source);
            }
        }
        return null;
    }

    public static ReactorItem getDefaultComponent(int id) {
        ReactorItem aItem = ITEM_LIST.get(id);
        if (aItem != null) {
            return aItem;
        }
        Logger.INFO("Tried to get default component with ID " + id + ". This is invalid.");
        return null;
    }

    public static ReactorItem getDefaultComponent(String name) {
        if (name != null) {
            return ITEM_MAP.get(name);
        }
        return null;
    }

    public static ReactorItem createComponent(int id) {
        ReactorItem aItem = ITEM_LIST.get(id);
        if (aItem != null) {
            return ComponentFactory.copy(aItem);
        }
        Logger.INFO("Tried to create component with ID " + id + ". This is invalid.");
        return null;
    }

    public static ReactorItem createComponent(String name) {
        if (name != null) {
            return ComponentFactory.copy(ITEM_MAP.get(name));
        }
        return null;
    }

    public static int getComponentCount() {
        return ITEM_LIST.size();
    }

    static {
        int aID = 0;
        ITEM_LIST.put(aID++, null);
        ITEM_LIST.put(aID++, new FuelRod(1, "fuelRodUranium", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorUraniumSimple", (long)1L).func_77946_l()), 20000.0, 1.0, null, 100, 2.0, 1, false));
        ITEM_LIST.put(aID++, new FuelRod(2, "dualFuelRodUranium", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorUraniumDual", (long)1L).func_77946_l()), 20000.0, 1.0, null, 200, 4.0, 2, false));
        ITEM_LIST.put(aID++, new FuelRod(3, "quadFuelRodUranium", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorUraniumQuad", (long)1L).func_77946_l()), 20000.0, 1.0, null, 400, 8.0, 4, false));
        ITEM_LIST.put(aID++, new FuelRod(4, "fuelRodMox", new GT_ItemStack(aGtItems[1].get(1L, new Object[0]).func_77946_l()), 10000.0, 1.0, null, 100, 2.0, 1, true));
        ITEM_LIST.put(aID++, new FuelRod(5, "dualFuelRodMox", new GT_ItemStack(aGtItems[2].get(1L, new Object[0]).func_77946_l()), 10000.0, 1.0, null, 200, 4.0, 2, true));
        ITEM_LIST.put(aID++, new FuelRod(6, "quadFuelRodMox", new GT_ItemStack(aGtItems[3].get(1L, new Object[0]).func_77946_l()), 10000.0, 1.0, null, 400, 8.0, 4, true));
        ITEM_LIST.put(aID++, new Reflector(7, "neutronReflector", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorReflector", (long)1L).func_77946_l()), 30000.0, 1.0, null));
        ITEM_LIST.put(aID++, new Reflector(8, "thickNeutronReflector", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorReflectorThick", (long)1L).func_77946_l()), 120000.0, 1.0, null));
        ITEM_LIST.put(aID++, new Vent(9, "heatVent", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorVent", (long)1L).func_77946_l()), 1.0, 1000.0, null, 6, 0, 0));
        ITEM_LIST.put(aID++, new Vent(10, "advancedHeatVent", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorVentDiamond", (long)1L).func_77946_l()), 1.0, 1000.0, null, 12, 0, 0));
        ITEM_LIST.put(aID++, new Vent(11, "reactorHeatVent", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorVentCore", (long)1L).func_77946_l()), 1.0, 1000.0, null, 5, 5, 0));
        ITEM_LIST.put(aID++, new Vent(12, "componentHeatVent", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorVentSpread", (long)1L).func_77946_l()), 1.0, 1.0, null, 0, 0, 4));
        ITEM_LIST.put(aID++, new Vent(13, "overclockedHeatVent", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorVentGold", (long)1L).func_77946_l()), 1.0, 1000.0, null, 20, 36, 0));
        ITEM_LIST.put(aID++, new CoolantCell(14, "coolantCell10k", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorCoolantSimple", (long)1L).func_77946_l()), 1.0, 10000.0, null));
        ITEM_LIST.put(aID++, new CoolantCell(15, "coolantCell30k", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorCoolantTriple", (long)1L).func_77946_l()), 1.0, 30000.0, null));
        ITEM_LIST.put(aID++, new CoolantCell(16, "coolantCell60k", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorCoolantSix", (long)1L).func_77946_l()), 1.0, 60000.0, null));
        ITEM_LIST.put(aID++, new Exchanger(17, "heatExchanger", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorHeatSwitch", (long)1L).func_77946_l()), 1.0, 2500.0, null, 12, 4));
        ITEM_LIST.put(aID++, new Exchanger(18, "advancedHeatExchanger", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorHeatSwitchDiamond", (long)1L).func_77946_l()), 1.0, 10000.0, null, 24, 8));
        ITEM_LIST.put(aID++, new Exchanger(19, "coreHeatExchanger", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorHeatSwitchCore", (long)1L).func_77946_l()), 1.0, 5000.0, null, 0, 72));
        ITEM_LIST.put(aID++, new Exchanger(20, "componentHeatExchanger", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorHeatSwitchSpread", (long)1L).func_77946_l()), 1.0, 5000.0, null, 36, 0));
        ITEM_LIST.put(aID++, new Plating(21, "reactorPlating", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorPlating", (long)1L).func_77946_l()), 1.0, 1.0, null, 1000, 0.9025));
        ITEM_LIST.put(aID++, new Plating(22, "heatCapacityReactorPlating", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorPlatingHeat", (long)1L).func_77946_l()), 1.0, 1.0, null, 1700, 0.9801));
        ITEM_LIST.put(aID++, new Plating(23, "containmentReactorPlating", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorPlatingExplosive", (long)1L).func_77946_l()), 1.0, 1.0, null, 500, 0.81));
        ITEM_LIST.put(aID++, new Condensator(24, "rshCondensator", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorCondensator", (long)1L).func_77946_l()), 1.0, 20000.0, null));
        ITEM_LIST.put(aID++, new Condensator(25, "lzhCondensator", new GT_ItemStack(GT_ModHandler.getIC2Item((String)"reactorCondensatorLap", (long)1L).func_77946_l()), 1.0, 100000.0, null));
        ITEM_LIST.put(aID++, new FuelRod(26, "fuelRodThorium", new GT_ItemStack(ItemList.ThoriumCell_1.get(1L, new Object[0]).func_77946_l()), 50000.0, 1.0, "GregTech", 20, 0.5, 1, false));
        ITEM_LIST.put(aID++, new FuelRod(27, "dualFuelRodThorium", new GT_ItemStack(ItemList.ThoriumCell_2.get(1L, new Object[0]).func_77946_l()), 50000.0, 1.0, "GregTech", 40, 1.0, 2, false));
        ITEM_LIST.put(aID++, new FuelRod(28, "quadFuelRodThorium", new GT_ItemStack(ItemList.ThoriumCell_4.get(1L, new Object[0]).func_77946_l()), 50000.0, 1.0, "GregTech", 80, 2.0, 4, false));
        ITEM_LIST.put(aID++, new CoolantCell(29, "coolantCellHelium60k", new GT_ItemStack(ItemList.Reactor_Coolant_He_1.get(1L, new Object[0]).func_77946_l()), 1.0, 60000.0, "GregTech"));
        ITEM_LIST.put(aID++, new CoolantCell(30, "coolantCellHelium180k", new GT_ItemStack(ItemList.Reactor_Coolant_He_3.get(1L, new Object[0]).func_77946_l()), 1.0, 180000.0, "GregTech"));
        ITEM_LIST.put(aID++, new CoolantCell(31, "coolantCellHelium360k", new GT_ItemStack(ItemList.Reactor_Coolant_He_6.get(1L, new Object[0]).func_77946_l()), 1.0, 360000.0, "GregTech"));
        ITEM_LIST.put(aID++, new CoolantCell(32, "coolantCellNak60k", new GT_ItemStack(ItemList.Reactor_Coolant_NaK_1.get(1L, new Object[0]).func_77946_l()), 1.0, 60000.0, "GregTech"));
        ITEM_LIST.put(aID++, new CoolantCell(33, "coolantCellNak180k", new GT_ItemStack(ItemList.Reactor_Coolant_NaK_3.get(1L, new Object[0]).func_77946_l()), 1.0, 180000.0, "GregTech"));
        ITEM_LIST.put(aID++, new CoolantCell(34, "coolantCellNak360k", new GT_ItemStack(ItemList.Reactor_Coolant_NaK_3.get(1L, new Object[0]).func_77946_l()), 1.0, 360000.0, "GregTech"));
        ITEM_LIST.put(aID++, new Reflector(35, "iridiumNeutronReflector", new GT_ItemStack(ItemList.Neutron_Reflector.get(1L, new Object[0]).func_77946_l()), 1.0, 1.0, null));
        ITEM_LIST.put(aID++, new FuelRod(36, "fuelRodNaquadah", new GT_ItemStack(ItemList.NaquadahCell_1.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GregTech", 100, 2.0, 1, true));
        ITEM_LIST.put(aID++, new FuelRod(37, "dualFuelRodNaquadah", new GT_ItemStack(ItemList.NaquadahCell_2.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GregTech", 200, 4.0, 2, true));
        ITEM_LIST.put(aID++, new FuelRod(38, "quadFuelRodNaquadah", new GT_ItemStack(ItemList.NaquadahCell_4.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GregTech", 400, 8.0, 4, true));
        aID = 45;
        ITEM_LIST.put(aID++, new FuelRod(45, "fuelRodNaquadahGTNH", new GT_ItemStack(ItemList.NaquadahCell_1.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GTNH", 100, 2.0, 1, false));
        ITEM_LIST.put(aID++, new FuelRod(46, "dualFuelRodNaquadahGTNH", new GT_ItemStack(ItemList.NaquadahCell_2.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GTNH", 200, 4.0, 2, false));
        ITEM_LIST.put(aID++, new FuelRod(47, "quadFuelRodNaquadahGTNH", new GT_ItemStack(ItemList.NaquadahCell_4.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GTNH", 400, 8.0, 4, false));
        ITEM_LIST.put(aID++, new FuelRod(48, "fuelRodNaquadria", new GT_ItemStack(ItemList.MNqCell_1.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GTNH", 100, 2.0, 1, true));
        ITEM_LIST.put(aID++, new FuelRod(49, "dualFuelRodNaquadria", new GT_ItemStack(ItemList.MNqCell_2.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GTNH", 200, 4.0, 2, true));
        ITEM_LIST.put(aID++, new FuelRod(50, "quadFuelRodNaquadria", new GT_ItemStack(ItemList.MNqCell_4.get(1L, new Object[0]).func_77946_l()), 100000.0, 1.0, "GTNH", 400, 8.0, 4, true));
        aID = 51;
        if (LoadedMods.BartWorks) {
            ITEM_LIST.put(aID++, new FuelRod(51, "fuelRodTiberium", new GT_ItemStack(BW_Utils.getBW_NonMeta_MaterialItems(BW_Utils.NonMeta_MaterialItem.TiberiumCell_1, 1L)), 50000.0, 1.0, "Bartworks", 100, 1.0, 1, false));
            ITEM_LIST.put(aID++, new FuelRod(52, "dualFuelRodTiberium", new GT_ItemStack(BW_Utils.getBW_NonMeta_MaterialItems(BW_Utils.NonMeta_MaterialItem.TiberiumCell_2, 1L)), 50000.0, 1.0, "Bartworks", 200, 2.0, 2, false));
            ITEM_LIST.put(aID++, new FuelRod(53, "quadFuelRodTiberium", new GT_ItemStack(BW_Utils.getBW_NonMeta_MaterialItems(BW_Utils.NonMeta_MaterialItem.TiberiumCell_4, 1L)), 50000.0, 1.0, "Bartworks", 400, 4.0, 4, false));
            ITEM_LIST.put(aID++, new FuelRod(54, "fuelRodTheCore", new GT_ItemStack(BW_Utils.getBW_NonMeta_MaterialItems(BW_Utils.NonMeta_MaterialItem.TheCoreCell, 1L)), 100000.0, 1.0, "Bartworks", 72534, 816.0, 32, false));
        }
        aID = 55;
        ITEM_LIST.put(aID++, new CoolantCell(55, "coolantCellSpace180k", new GT_ItemStack(ItemList.Reactor_Coolant_Sp_1.get(1L, new Object[0]).func_77946_l()), 1.0, 180000.0, "GTNH"));
        ITEM_LIST.put(aID++, new CoolantCell(56, "coolantCellSpace360k", new GT_ItemStack(ItemList.Reactor_Coolant_Sp_2.get(1L, new Object[0]).func_77946_l()), 1.0, 360000.0, "GTNH"));
        ITEM_LIST.put(aID++, new CoolantCell(57, "coolantCellSpace540k", new GT_ItemStack(ItemList.Reactor_Coolant_Sp_3.get(1L, new Object[0]).func_77946_l()), 1.0, 540000.0, "GTNH"));
        ITEM_LIST.put(aID++, new CoolantCell(58, "coolantCellSpace1080k", new GT_ItemStack(ItemList.Reactor_Coolant_Sp_6.get(1L, new Object[0]).func_77946_l()), 1.0, 1080000.0, "GTNH"));
        aID = 59;
        if (LoadedMods.GoodGenerator) {
            ITEM_LIST.put(aID++, new FuelRod(59, "fuelRodCompressedUranium", new GT_ItemStack(GG_Utils.getGG_Fuel_Rod(GG_Utils.GG_Fuel_Rod.rodCompressedUranium, 1)), 50000.0, 1.0, "GoodGenerator", 100, 1.0, 1, false));
            ITEM_LIST.put(aID++, new FuelRod(60, "fuelRodDoubleCompressedUranium", new GT_ItemStack(GG_Utils.getGG_Fuel_Rod(GG_Utils.GG_Fuel_Rod.rodCompressedUranium_2, 1)), 50000.0, 1.0, "GoodGenerator", 100, 1.0, 2, false));
            ITEM_LIST.put(aID++, new FuelRod(61, "fuelRodQuadCompressedUranium", new GT_ItemStack(GG_Utils.getGG_Fuel_Rod(GG_Utils.GG_Fuel_Rod.rodCompressedUranium_4, 1)), 50000.0, 1.0, "GoodGenerator", 100, 1.0, 4, false));
            ITEM_LIST.put(aID++, new FuelRod(62, "fuelRodCompressedPlutonium", new GT_ItemStack(GG_Utils.getGG_Fuel_Rod(GG_Utils.GG_Fuel_Rod.rodCompressedPlutonium, 1)), 50000.0, 1.0, "GoodGenerator", 50, 1.0, 1, true));
            ITEM_LIST.put(aID++, new FuelRod(63, "fuelRodDoubleCompressedPlutonium", new GT_ItemStack(GG_Utils.getGG_Fuel_Rod(GG_Utils.GG_Fuel_Rod.rodCompressedPlutonium_2, 1)), 50000.0, 1.0, "GoodGenerator", 50, 1.0, 2, true));
            ITEM_LIST.put(aID++, new FuelRod(64, "fuelRodQuadCompressedPlutonium", new GT_ItemStack(GG_Utils.getGG_Fuel_Rod(GG_Utils.GG_Fuel_Rod.rodCompressedPlutonium_4, 1)), 50000.0, 1.0, "GoodGenerator", 50, 1.0, 4, true));
        }
        ITEM_MAP = ComponentFactory.makeItemMap();
    }
}

