/*
 * Decompiled with CFR 0.152.
 */
package Ic2ExpReactorPlanner;

import java.math.BigInteger;
import java.util.Base64;

public class BigintStorage {
    private BigInteger storedValue = BigInteger.ZERO;

    public void store(int value, int max) {
        if (value < 0 || value > max) {
            throw new IllegalArgumentException();
        }
        this.storedValue = this.storedValue.multiply(BigInteger.valueOf(max + 1)).add(BigInteger.valueOf(value));
    }

    public int extract(int max) {
        BigInteger[] values = this.storedValue.divideAndRemainder(BigInteger.valueOf(max + 1));
        this.storedValue = values[0];
        return values[1].intValue();
    }

    public static BigintStorage inputBase64(String code) {
        BigintStorage result = new BigintStorage();
        byte[] temp = Base64.getDecoder().decode(code);
        result.storedValue = new BigInteger(temp);
        return result;
    }

    public String outputBase64() {
        byte[] temp = this.storedValue.toByteArray();
        return Base64.getEncoder().encodeToString(temp);
    }
}

