/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.tinkers.util;

import gregtech.api.enums.Materials;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TinkersUtils {
    private static final Class<?> mClass_Smeltery;
    private static final Class<?> mClass_TConstructRegistry;
    private static final Class<?> mClass_ToolMaterial;
    private static final Class<?> mClass_IPattern;
    private static final Class<?> mClass_DynamicToolPart;
    private static final Class<?> mClass_FluidType;
    private static final Class<?> mClass_CastingRecipe;
    private static final Class<?> mClass_TinkerSmeltery;
    private static final Field mField_MoltenIronFluid;
    private static final Method mMethod_getFluidType;
    private static final Method mMethod_getCastingRecipes;
    private static Object mSmelteryInstance;
    private static Object mTinkersRegistryInstance;
    private static final HashMap<String, Method> mMethodCache;
    private static Item mTinkerMetalPattern;
    private static AutoMap<?> mDryingRackRecipes;

    private static void setTiConDataInstance() {
        if (!LoadedMods.TiCon) {
            return;
        }
        if (mSmelteryInstance == null && mClass_Smeltery != null) {
            try {
                mSmelteryInstance = ReflectionUtils.getField(mClass_Smeltery, "instance").get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        if (mTinkersRegistryInstance == null && mClass_TConstructRegistry != null) {
            try {
                mTinkersRegistryInstance = ReflectionUtils.getField(mClass_TConstructRegistry, "instance").get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    public static final boolean isTiConFirstInOD() {
        if (LoadedMods.TiCon) {
            try {
                return (Boolean)ReflectionUtils.getField(ReflectionUtils.getClass("PHConstruct"), "tconComesFirst").get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static final boolean stopTiconLoadingFirst() {
        if (TinkersUtils.isTiConFirstInOD()) {
            try {
                ReflectionUtils.setFinalFieldValue(ReflectionUtils.getClass("PHConstruct"), "tconComesFirst", (Object)false);
                if (!((Boolean)ReflectionUtils.getField(ReflectionUtils.getClass("PHConstruct"), "tconComesFirst").get(null)).booleanValue()) {
                    return true;
                }
                ItemUtils.getNonTinkersDust("", 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void addSmelteryFuel(Fluid fluid, int power, int duration) {
        TinkersUtils.setTiConDataInstance();
        ReflectionUtils.invokeVoid(mSmelteryInstance, "addSmelteryFuel", new Class[]{Fluid.class, Integer.TYPE, Integer.TYPE}, new Object[]{fluid, power, duration});
    }

    public static boolean isSmelteryFuel(Fluid fluid) {
        TinkersUtils.setTiConDataInstance();
        return ReflectionUtils.invoke(mSmelteryInstance, "isSmelteryFuel", new Class[]{Fluid.class}, new Object[]{fluid});
    }

    public static int getFuelPower(Fluid fluid) {
        TinkersUtils.setTiConDataInstance();
        return (Integer)ReflectionUtils.invokeNonBool(mSmelteryInstance, "getFuelPower", new Class[]{Fluid.class}, new Object[]{fluid});
    }

    public static int getFuelDuration(Fluid fluid) {
        TinkersUtils.setTiConDataInstance();
        return (Integer)ReflectionUtils.invokeNonBool(mSmelteryInstance, "getFuelDuration", new Class[]{Fluid.class}, new Object[]{fluid});
    }

    public static boolean registerFluidType(String name, Block block, int meta, int baseTemperature, Fluid fluid, boolean isToolpart) {
        if (mMethodCache.get("registerFluidType") == null) {
            Method m = ReflectionUtils.getMethod(ReflectionUtils.getClass("tconstruct.library.crafting.FluidType"), "registerFluidType", String.class, Block.class, Integer.TYPE, Integer.TYPE, Fluid.class, Boolean.TYPE);
            mMethodCache.put("registerFluidType", m);
        }
        try {
            mMethodCache.get("registerFluidType").invoke(null, name, block, meta, baseTemperature, fluid, isToolpart);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean addBaseMeltingRecipes(Material aMaterial) {
        return TinkersUtils.addMelting(aMaterial.getBlock(1), aMaterial.getBlock(), 0, aMaterial.getMeltingPointC(), aMaterial.getFluidStack(1296)) && TinkersUtils.addMelting(aMaterial.getIngot(1), aMaterial.getBlock(), 0, aMaterial.getMeltingPointC(), aMaterial.getFluidStack(144));
    }

    public static boolean addMelting(ItemStack input, Block block, int metadata, int temperature, FluidStack liquid) {
        if (mMethodCache.get("addMelting") == null) {
            Method m = ReflectionUtils.getMethod(mClass_Smeltery, "addMelting", ItemStack.class, Block.class, Integer.TYPE, Integer.TYPE, FluidStack.class);
            mMethodCache.put("addMelting", m);
        }
        try {
            mMethodCache.get("addMelting").invoke(null, input, block, metadata, temperature, liquid);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean addMelting(Object type, ItemStack input, int temperatureDifference, int fluidAmount) {
        if (mMethodCache.get("addMelting") == null) {
            Method m = ReflectionUtils.getMethod(mClass_Smeltery, "addMelting", mClass_FluidType, ItemStack.class, Integer.TYPE, Integer.TYPE);
            mMethodCache.put("addMelting", m);
        }
        try {
            mMethodCache.get("addMelting").invoke(null, type, input, temperatureDifference, fluidAmount);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean addBaseBasinRecipes(Material aMaterial) {
        return TinkersUtils.addBasinRecipe(aMaterial.getBlock(1), aMaterial.getFluidStack(1296), null, true, 100);
    }

    public static boolean addBasinRecipe(ItemStack output, FluidStack metal, ItemStack cast, boolean consume, int delay) {
        if (mMethodCache.get("addBasinRecipe") == null) {
            Method m = ReflectionUtils.getMethod(ReflectionUtils.getClass("tconstruct.library.crafting.LiquidCasting"), "addCastingRecipe", ItemStack.class, FluidStack.class, ItemStack.class, Boolean.TYPE, Integer.TYPE);
            mMethodCache.put("addBasinRecipe", m);
        }
        try {
            mMethodCache.get("addBasinRecipe").invoke(TinkersUtils.getCastingInstance(0), output, metal, cast, consume, delay);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean addBaseCastingRecipes(Material aMaterial) {
        ItemStack ingotcast = TinkersUtils.getPattern(1);
        return TinkersUtils.addCastingTableRecipe(aMaterial.getIngot(1), aMaterial.getFluidStack(144), ingotcast, false, 50);
    }

    public static boolean addCastingTableRecipe(ItemStack output, FluidStack metal, ItemStack cast, boolean consume, int delay) {
        if (mMethodCache.get("addCastingTableRecipe") == null) {
            Method m = ReflectionUtils.getMethod(ReflectionUtils.getClass("tconstruct.library.crafting.LiquidCasting"), "addCastingRecipe", ItemStack.class, FluidStack.class, ItemStack.class, Boolean.TYPE, Integer.TYPE);
            mMethodCache.put("addCastingTableRecipe", m);
        }
        try {
            mMethodCache.get("addCastingTableRecipe").invoke(TinkersUtils.getCastingInstance(1), output, metal, cast, consume, delay);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    public static Object getCastingInstance(int aType) {
        TinkersUtils.setTiConDataInstance();
        Method m = null;
        if (aType == 0) {
            m = ReflectionUtils.getMethod(mTinkersRegistryInstance, "getTableCasting", new Class[0]);
        } else if (aType == 1) {
            m = ReflectionUtils.getMethod(mTinkersRegistryInstance, "getBasinCasting", new Class[0]);
        }
        if (m != null) {
            try {
                return m.invoke(mTinkersRegistryInstance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static ItemStack getPattern(int aType) {
        Field m;
        if (mTinkerMetalPattern == null && (m = ReflectionUtils.getField(mClass_TinkerSmeltery, "metalPattern")) != null) {
            try {
                mTinkerMetalPattern = (Item)m.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        if (mTinkerMetalPattern != null) {
            ItemStack ingotCast = new ItemStack(mTinkerMetalPattern, aType, 0);
            return ingotCast;
        }
        return ItemUtils.getErrorStack(1, "Bad Tinkers Pattern");
    }

    public static List<?> getDryingRecipes() {
        if (mDryingRackRecipes != null) {
            return mDryingRackRecipes;
        }
        AutoMap aData = new AutoMap();
        int aCount = 0;
        try {
            ArrayList recipes = (ArrayList)ReflectionUtils.getField(ReflectionUtils.getClass("tconstruct.library.crafting.DryingRackRecipes"), "recipes").get(null);
            if (recipes != null) {
                for (Object o : recipes) {
                    aData.put(o);
                    ++aCount;
                }
                Logger.INFO("Found " + aCount + " Tinkers drying rack recipes.");
            } else {
                Logger.INFO("Failed to find any Tinkers drying rack recipes.");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Logger.INFO("Failed to find any Tinkers drying rack recipes.");
        }
        mDryingRackRecipes = aData;
        return aData;
    }

    public static Object generateToolMaterial(String name, String localizationString, int level, int durability, int speed, int damage, float handle, int reinforced, float stonebound, String style, int primaryColor) {
        try {
            Constructor<?> constructor = mClass_ToolMaterial.getConstructor(String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Integer.TYPE, Float.TYPE, String.class, Integer.TYPE);
            Object myObject = constructor.newInstance(name, localizationString, level, durability, speed, damage, Float.valueOf(handle), reinforced, Float.valueOf(stonebound), style, primaryColor);
            return myObject;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void addToolMaterial(int id, Object aToolMaterial) {
        if (mMethodCache.get("addToolMaterial") == null) {
            Method m = ReflectionUtils.getMethod(mClass_TConstructRegistry, "addtoolMaterial", Integer.TYPE, mClass_ToolMaterial);
            mMethodCache.put("addToolMaterial", m);
        }
        try {
            mMethodCache.get("addToolMaterial").invoke(mClass_TConstructRegistry, id, aToolMaterial);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void addDefaultToolPartMaterial(int id) {
        if (mMethodCache.get("addDefaultToolPartMaterial") == null) {
            Method m = ReflectionUtils.getMethod(mClass_TConstructRegistry, "addDefaultToolPartMaterial", Integer.TYPE);
            mMethodCache.put("addDefaultToolPartMaterial", m);
        }
        try {
            mMethodCache.get("addDefaultToolPartMaterial").invoke(mClass_TConstructRegistry, id);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void addBowMaterial(int id, int drawspeed, float maxSpeed) {
        if (mMethodCache.get("addBowMaterial") == null) {
            Method m = ReflectionUtils.getMethod(mClass_TConstructRegistry, "addBowMaterial", Integer.TYPE, Integer.TYPE, Float.TYPE);
            mMethodCache.put("addBowMaterial", m);
        }
        try {
            mMethodCache.get("addBowMaterial").invoke(mClass_TConstructRegistry, id, drawspeed, Float.valueOf(maxSpeed));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void addArrowMaterial(int id, float mass, float fragility) {
        if (mMethodCache.get("addArrowMaterial") == null) {
            Method m = ReflectionUtils.getMethod(mClass_TConstructRegistry, "addArrowMaterial", Integer.TYPE, Float.TYPE, Float.TYPE);
            mMethodCache.put("addArrowMaterial", m);
        }
        try {
            mMethodCache.get("addArrowMaterial").invoke(mClass_TConstructRegistry, id, Float.valueOf(mass), Float.valueOf(fragility));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static List<?> getTableCastingRecipes() {
        Object aCastingTableHandlerInstance = TinkersUtils.getCastingInstance(0);
        try {
            List aTemp = (List)mMethod_getCastingRecipes.invoke(aCastingTableHandlerInstance, new Object[0]);
            return aTemp;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return new ArrayList();
        }
    }

    public static boolean generateCastingRecipes(Material aMaterial, int aID) {
        LinkedList<CastingRecipeHandler> newRecipies = new LinkedList<CastingRecipeHandler>();
        Iterator<?> iterator1 = TinkersUtils.getTableCastingRecipes().iterator();
        Fluid aMoltenIron = null;
        if (aMoltenIron == null) {
            try {
                aMoltenIron = (Fluid)mField_MoltenIronFluid.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                aMoltenIron = Materials.Iron.getMolten(0L).getFluid();
            }
        }
        while (iterator1.hasNext()) {
            CastingRecipeHandler recipe = new CastingRecipeHandler(iterator1.next());
            if (recipe == null || !recipe.valid) continue;
            try {
                if (recipe.castingMetal.getFluid() != aMoltenIron || recipe.cast == null || !mClass_IPattern.isInstance(recipe.cast.func_77973_b()) || !mClass_DynamicToolPart.isInstance(recipe.getResult().func_77973_b())) continue;
                newRecipies.add(recipe);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            Object ft = mMethod_getFluidType.invoke(null, aMaterial.getLocalizedName());
            Iterator iterator2 = newRecipies.iterator();
            while (iterator2.hasNext()) {
                CastingRecipeHandler recipe = new CastingRecipeHandler(iterator2.next());
                if (!recipe.valid) continue;
                ItemStack output = recipe.getResult().func_77946_l();
                output.func_77964_b(aID);
                FluidStack liquid2 = new FluidStack(aMaterial.getFluidStack(0).getFluid(), recipe.castingMetal.amount);
                TinkersUtils.addCastingTableRecipe(output, liquid2, recipe.cast, recipe.consumeCast, recipe.coolTime);
                TinkersUtils.addMelting(ft, output, 0, liquid2.amount / 2);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        mMethodCache = new LinkedHashMap<String, Method>();
        mClass_Smeltery = ReflectionUtils.getClass("tconstruct.library.crafting.Smeltery");
        mClass_TConstructRegistry = ReflectionUtils.getClass("tconstruct.library.TConstructRegistry");
        mClass_ToolMaterial = ReflectionUtils.getClass("tconstruct.library.tools.ToolMaterial");
        mClass_IPattern = ReflectionUtils.getClass("tconstruct.library.util.IPattern");
        mClass_DynamicToolPart = ReflectionUtils.getClass("tconstruct.library.tools.DynamicToolPart");
        mClass_FluidType = ReflectionUtils.getClass("tconstruct.library.crafting.FluidType");
        mClass_CastingRecipe = ReflectionUtils.getClass("tconstruct.library.crafting.CastingRecipe");
        mClass_TinkerSmeltery = ReflectionUtils.getClass("tconstruct.smeltery.TinkerSmeltery");
        mField_MoltenIronFluid = ReflectionUtils.getField(mClass_TinkerSmeltery, "moltenIronFluid");
        mMethod_getFluidType = ReflectionUtils.getMethod(mClass_FluidType, "getFluidType", String.class);
        mMethod_getCastingRecipes = ReflectionUtils.getMethod(TinkersUtils.getCastingInstance(0), "getCastingRecipes", new Class[0]);
    }

    private static class CastingRecipeHandler {
        public ItemStack output;
        public FluidStack castingMetal;
        public ItemStack cast;
        public boolean consumeCast;
        public int coolTime;
        public boolean valid;

        public CastingRecipeHandler(Object aCastingRecipe) {
            if (mClass_CastingRecipe.isInstance(aCastingRecipe)) {
                try {
                    Field aF_output = ReflectionUtils.getField(mClass_CastingRecipe, "output");
                    Field aF_castingMetal = ReflectionUtils.getField(mClass_CastingRecipe, "castingMetal");
                    Field aF_cast = ReflectionUtils.getField(mClass_CastingRecipe, "cast");
                    Field aF_consumeCast = ReflectionUtils.getField(mClass_CastingRecipe, "consumeCast");
                    Field aF_coolTime = ReflectionUtils.getField(mClass_CastingRecipe, "coolTime");
                    this.output = (ItemStack)aF_output.get(aCastingRecipe);
                    this.castingMetal = (FluidStack)aF_castingMetal.get(aCastingRecipe);
                    this.cast = (ItemStack)aF_cast.get(aCastingRecipe);
                    this.consumeCast = (Boolean)aF_consumeCast.get(aCastingRecipe);
                    this.coolTime = (Integer)aF_coolTime.get(aCastingRecipe);
                    this.valid = true;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.valid = false;
                }
            } else {
                this.valid = false;
            }
        }

        public boolean matches(FluidStack metal, ItemStack inputCast) {
            return this.castingMetal.isFluidEqual(metal) && (this.cast != null && this.cast.func_77960_j() == Short.MAX_VALUE && inputCast.func_77973_b() == this.cast.func_77973_b() || ItemStack.func_77989_b((ItemStack)this.cast, (ItemStack)inputCast));
        }

        public ItemStack getResult() {
            return this.output.func_77946_l();
        }
    }
}

