/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.tinkers.util;

import gregtech.api.enums.GT_Values;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.tinkers.util.TinkersUtils;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TinkersDryingRecipe {
    public static AutoMap<TinkersDryingRecipe> recipes = new AutoMap();
    public final int time;
    public final ItemStack input;
    public final ItemStack result;

    public static void generateAllDryingRecipes() {
        List<?> aRecipes = TinkersUtils.getDryingRecipes();
        if (aRecipes != null && aRecipes.size() > 0) {
            for (Object o : aRecipes) {
                Logger.INFO("Trying to generate recipe using object of type " + o.getClass().getSimpleName());
                TinkersDryingRecipe.generateFromTinkersRecipeObject(o);
            }
        } else {
            Logger.INFO("Error generating Drying recipes, map was either null or empty. Null? " + (aRecipes != null) + ", Size: " + aRecipes.size());
        }
        if (!recipes.isEmpty()) {
            Logger.INFO("Adding " + recipes.size() + " drying rack recipes to the dehydrator.");
            for (TinkersDryingRecipe r : recipes) {
                CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedCircuit(16), r.input}, GT_Values.NF, GT_Values.NF, new ItemStack[]{r.result}, new int[0], r.time / 10, 30);
            }
        }
    }

    public static TinkersDryingRecipe generateFromTinkersRecipeObject(Object o) {
        Class<?> aTinkerClass = ReflectionUtils.getClass("tconstruct.library.crafting.DryingRackRecipes.DryingRecipe");
        if (aTinkerClass == null || !LoadedMods.TiCon) {
            Logger.INFO("Error generating Drying Recipe, could not find class. Exists? " + ReflectionUtils.doesClassExist("tconstruct.library.crafting.DryingRackRecipes.DryingRecipe"));
            Class<?> clazz = ReflectionUtils.getClass("tconstruct.library.crafting.DryingRackRecipes");
            Class<?>[] y = clazz.getDeclaredClasses();
            if (y == null || y.length <= 0) {
                Logger.INFO("No hidden inner classes.");
                return null;
            }
            boolean found = false;
            for (Class<?> h : y) {
                Logger.INFO("Found hidden inner class: " + h.getCanonicalName());
                if (!h.getSimpleName().toLowerCase().equals("dryingrecipe")) continue;
                Logger.INFO("Found correct recipe. Caching at correct location.");
                ReflectionUtils.mCachedClasses.put("tconstruct.library.crafting.DryingRackRecipes.DryingRecipe", h);
                aTinkerClass = h;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        Field aTime = ReflectionUtils.getField(aTinkerClass, "time");
        Field aInput = ReflectionUtils.getField(aTinkerClass, "input");
        Field aOutput = ReflectionUtils.getField(aTinkerClass, "result");
        try {
            int time_internal = aTime.getInt(o);
            ItemStack input_internal = (ItemStack)aInput.get(o);
            ItemStack result_internal = (ItemStack)aOutput.get(o);
            return new TinkersDryingRecipe(input_internal, time_internal, result_internal);
        }
        catch (Throwable b) {
            b.printStackTrace();
            return null;
        }
    }

    public TinkersDryingRecipe(ItemStack input, int time, ItemStack result) {
        this.time = time;
        this.input = input;
        this.result = result;
        Logger.INFO("Generating Drying Recipe. Input: " + input.func_82833_r() + ", Output: " + result.func_82833_r());
        recipes.add(this);
    }

    public boolean matches(ItemStack input) {
        if (input.func_77942_o()) {
            input = input.func_77946_l();
            input.func_77978_p().func_82580_o("frypanKill");
            if (input.func_77978_p().func_82582_d()) {
                input.func_77982_d((NBTTagCompound)null);
            }
        }
        return ItemStack.func_77989_b((ItemStack)this.input, (ItemStack)input);
    }

    public ItemStack getResult() {
        return this.result.func_77946_l();
    }
}

