/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.thaumcraft.objects.wrapper.aspect;

import gregtech.api.enums.TC_Aspects;
import gregtech.api.util.GT_LanguageManager;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.thaumcraft.util.ThaumcraftUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class TC_Aspect_Wrapper {
    private static Class mClass_Aspect = ReflectionUtils.getClass("thaumcraft.api.aspects.Aspect");
    private static Field mField_Aspects;
    private final String tag;
    private final TC_Aspect_Wrapper[] components;
    private final int color;
    private String chatcolor;
    private final ResourceLocation image;
    private final int blend;
    public final Object mAspect;
    public final TC_Aspects mGtEnumField;
    private static int aInternalAspectIDAllocation;
    private static Map<String, TC_Aspect_Wrapper> mInternalAspectCache;

    public static LinkedHashMap<String, Object> getVanillaAspectList() {
        try {
            if (mField_Aspects == null) {
                mField_Aspects = ReflectionUtils.getField(mClass_Aspect, "aspects");
            }
            return (LinkedHashMap)mField_Aspects.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Logger.REFLECTION("Failed configuring TC Aspect compatibility.");
            return new LinkedHashMap<String, Object>();
        }
    }

    public static Object getVanillaAspectObject(String aAspectName) {
        return TC_Aspect_Wrapper.getVanillaAspectList().get(aAspectName);
    }

    public TC_Aspect_Wrapper(String tag, int color, String chatcolor, int blend, String aTooltip) {
        this(tag, color, (TC_Aspect_Wrapper[])null, blend, aTooltip);
        this.chatcolor = chatcolor;
    }

    public TC_Aspect_Wrapper(String tag, int color, TC_Aspect_Wrapper[] components, String aTooltip) {
        this(tag, color, components, false, 1, aTooltip);
    }

    public TC_Aspect_Wrapper(String tag, int color, TC_Aspect_Wrapper[] components, int blend, String aTooltip) {
        this(tag, color, components, false, blend, aTooltip);
    }

    public TC_Aspect_Wrapper(String tag, int color, TC_Aspect_Wrapper[] components, boolean vanilla, int blend, String aTooltip) {
        this(tag, color, components, vanilla ? new ResourceLocation("thaumcraft", "textures/aspects/" + tag.toLowerCase() + ".png") : new ResourceLocation("miscutils", "textures/aspects/" + tag.toLowerCase() + ".png"), vanilla, blend, aTooltip);
    }

    public TC_Aspect_Wrapper(String tag, int color, TC_Aspect_Wrapper[] components, ResourceLocation image, boolean vanilla, int blend, String aTooltip) {
        if (components == null) {
            components = new TC_Aspect_Wrapper[]{};
        }
        String aTag = tag.toLowerCase();
        if (TC_Aspect_Wrapper.getAspectList().containsKey(tag.toLowerCase())) {
            this.tag = aTag;
            this.components = components;
            this.color = color;
            this.image = image;
            this.blend = blend;
            this.mAspect = null;
            this.mGtEnumField = null;
        } else {
            this.tag = aTag;
            this.components = components;
            this.color = color;
            this.image = image;
            this.blend = blend;
            this.mAspect = vanilla ? TC_Aspect_Wrapper.getVanillaAspectObject(this.tag) : this.generateTcAspect();
            TC_Aspects y = null;
            for (TC_Aspects e : TC_Aspects.values()) {
                try {
                    String gtTag = ThaumcraftUtils.getTagFromAspectObject(e.mAspect);
                    if (gtTag == null || !gtTag.equals(this.tag)) continue;
                    y = e;
                    break;
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
            }
            this.mGtEnumField = y;
            mInternalAspectCache.put(this.tag, this);
            if (!vanilla) {
                mInternalAspectCache.put("custom" + aInternalAspectIDAllocation++, this);
                GT_LanguageManager.addStringLocalization((String)("tc.aspect." + aTag), (String)aTooltip);
            }
            Logger.INFO("[Thaumcraft++] Adding support for Aspect: " + tag);
        }
    }

    public static TC_Aspect_Wrapper generate(Object aBaseAspect) {
        try {
            Field aTagF = ReflectionUtils.getField(mClass_Aspect, "tag");
            if (aTagF == null) {
                return null;
            }
            String aTafB = (String)aTagF.get(aBaseAspect);
            if (aTafB == null) {
                return null;
            }
            String aTag = aTafB.toLowerCase();
            if (aTag != null && TC_Aspect_Wrapper.getAspectList().containsKey(aTag.toLowerCase())) {
                return TC_Aspect_Wrapper.getAspect(aTag);
            }
            TC_Aspect_Wrapper aTemp = new TC_Aspect_Wrapper(aTag, (Integer)ReflectionUtils.getField(mClass_Aspect, "color").get(aBaseAspect), TC_Aspect_Wrapper.generateAspectArrayInternal(ReflectionUtils.getField(mClass_Aspect, "components"), aBaseAspect), (ResourceLocation)ReflectionUtils.getField(mClass_Aspect, "image").get(aBaseAspect), true, (Integer)ReflectionUtils.getField(mClass_Aspect, "blend").get(aBaseAspect), "");
            if (aTemp != null) {
                aTemp.chatcolor = (String)ReflectionUtils.getField(mClass_Aspect, "chatcolor").get(aBaseAspect);
                return aTemp;
            }
            return null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static TC_Aspect_Wrapper getAspect(String aAspectName) {
        String aName = aAspectName.toLowerCase();
        TC_Aspect_Wrapper g = mInternalAspectCache.get(aName);
        if (g != null) {
            return g;
        }
        try {
            TC_Aspect_Wrapper aTemp = TC_Aspect_Wrapper.generate(TC_Aspect_Wrapper.getVanillaAspectList().get(aName));
            if (aTemp != null) {
                mInternalAspectCache.put(aName, aTemp);
                return aTemp;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, TC_Aspect_Wrapper> getAspectList() {
        return mInternalAspectCache;
    }

    private static TC_Aspect_Wrapper[] generateAspectArrayInternal(Field aField, Object aInstance) {
        TC_Aspect_Wrapper[] aAspectArray;
        try {
            Object[] components = (Object[])aField.get(aInstance);
            aAspectArray = new TC_Aspect_Wrapper[components == null ? 0 : components.length];
            if (aAspectArray.length > 0) {
                int i = 0;
                for (Object g : components) {
                    aAspectArray[i] = TC_Aspect_Wrapper.getAspect((String)ReflectionUtils.getField(mClass_Aspect, "tag").get(g));
                    ++i;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            aAspectArray = new TC_Aspect_Wrapper[]{};
        }
        return aAspectArray;
    }

    public Object generateTcAspect() {
        try {
            Method setChatColour;
            Object[] aAspectArray = (Object[])Array.newInstance(mClass_Aspect, 0);
            if (this.components.length > 0) {
                aAspectArray = (Object[])Array.newInstance(mClass_Aspect, this.components.length);
                int i = 0;
                for (TC_Aspect_Wrapper g : this.components) {
                    if (g == null || g.mAspect == null) continue;
                    aAspectArray[i++] = g.mAspect;
                }
            }
            Constructor constructor = mClass_Aspect.getConstructor(String.class, Integer.TYPE, aAspectArray.getClass(), ResourceLocation.class, Integer.TYPE);
            Object myObject = constructor.newInstance(this.tag, this.color, aAspectArray, this.image, this.blend);
            if (this.chatcolor != null && this.chatcolor.length() > 0 && (setChatColour = ReflectionUtils.getMethod(mClass_Aspect, "setChatcolor", String.class)) != null) {
                setChatColour.invoke(myObject, this.chatcolor);
            }
            return myObject;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static boolean isObjectAnAspect(Object aAspect) {
        return mClass_Aspect.isInstance(aAspect);
    }

    static {
        aInternalAspectIDAllocation = 1;
        mInternalAspectCache = new LinkedHashMap<String, TC_Aspect_Wrapper>();
    }
}

