/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.registration.gregtech;

import gregtech.GT_Mod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GregtechNitroDieselFix {
    public static void run() {
        if (CORE.ConfigSwitches.enableNitroFix) {
            Logger.INFO("Gregtech5u Content | Attempting to Fix Nitro-Diesel production.");
            try {
                Object df;
                Class<?> mb;
                int mSub = Utils.getGregtechSubVersion();
                if (mSub != 0 && mSub >= 30 && (mb = ReflectionUtils.getClass("gregtech.api.enums.MaterialBuilder")).isInstance(df = mb.getConstructor(Integer.TYPE, TextureSet.class, String.class).newInstance(975, TextureSet.SET_FLUID, "Nitro-Diesel [Old]"))) {
                    boolean[] didAdd;
                    Materials[] mFuels;
                    Logger.INFO("[Nitro] Created new instance of Material builder, for Nitro fix.");
                    Method addFluid = mb.getDeclaredMethod("addFluid", new Class[0]);
                    Method addCell = mb.getDeclaredMethod("addCell", new Class[0]);
                    Method setColour = mb.getDeclaredMethod("setColor", Dyes.class);
                    Method setFuelPower = mb.getDeclaredMethod("setFuelPower", Integer.TYPE);
                    Method setMaterials = mb.getDeclaredMethod("setMaterialList", List.class);
                    Method setTemp = mb.getDeclaredMethod("setLiquidTemperature", Integer.TYPE);
                    Method setRGB = mb.getDeclaredMethod("setRGB", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    Method construct = mb.getDeclaredMethod("constructMaterial", new Class[0]);
                    Logger.INFO("[Nitro] Got internal methods for setting fields.");
                    addFluid.invoke(df, new Object[0]);
                    addCell.invoke(df, new Object[0]);
                    setColour.invoke(df, Dyes.dyeLime);
                    setFuelPower.invoke(df, 512000);
                    setMaterials.invoke(df, Arrays.asList(new MaterialStack(Materials.Glyceryl, 1L), new MaterialStack(Materials.Fuel, 4L)));
                    setTemp.invoke(df, 295);
                    setRGB.invoke(df, 200, 255, 0);
                    Materials mNitroFix = (Materials)construct.invoke(df, new Object[0]);
                    Logger.INFO("[Nitro] Invoked 8 method calls successfully.");
                    GT_Mod.gregtechproxy.addFluid("NitroFuel_Old", "Nitro Diesel [Old]", mNitroFix, 1, 295, GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.cell, (Object)mNitroFix, (long)1L), ItemUtils.getEmptyCell(), 1000);
                    Logger.INFO("[Nitro] Added a fluid.");
                    GT_Recipe.GT_Recipe_Map recipeMapMultiblockChemReactor = (GT_Recipe.GT_Recipe_Map)FieldUtils.getDeclaredField(GT_Recipe.GT_Recipe_Map.class, (String)"sMultiblockChemicalRecipes", (boolean)true).get(null);
                    Collection xSingle = GT_Recipe.GT_Recipe_Map.sChemicalRecipes.mRecipeList;
                    Collection xMulti = recipeMapMultiblockChemReactor.mRecipeList;
                    FluidStack mNitroStack = Materials.NitroFuel.getFluid(1000L);
                    GT_Recipe[] toRemoveSingle = new GT_Recipe[99];
                    GT_Recipe[] toRemoveMulti = new GT_Recipe[99];
                    int mIndexSingle = 0;
                    int mIndexMulti = 0;
                    for (GT_Recipe rnd : xSingle) {
                        for (FluidStack fluidStack : rnd.mFluidOutputs) {
                            if (!fluidStack.isFluidEqual(mNitroStack)) continue;
                            toRemoveSingle[mIndexSingle++] = rnd;
                        }
                    }
                    Logger.INFO("[Nitro] Found " + mIndexSingle + " single block Chemical Reactor recipes to remove.");
                    for (GT_Recipe rnd : xMulti) {
                        for (FluidStack fluidStack : rnd.mFluidOutputs) {
                            if (!fluidStack.isFluidEqual(mNitroStack)) continue;
                            toRemoveMulti[mIndexMulti++] = rnd;
                        }
                    }
                    Logger.INFO("[Nitro] Found " + mIndexMulti + " multi block Chemical Reactor recipes to remove.");
                    int mRemovedSingle = 0;
                    int mRemovedMulti = 0;
                    for (FluidStack fluidStack : toRemoveSingle) {
                        if (!GT_Recipe.GT_Recipe_Map.sChemicalRecipes.mRecipeList.remove(fluidStack)) continue;
                        ++mRemovedSingle;
                    }
                    Logger.INFO("[Nitro] Removed " + mRemovedSingle + " single block Chemical Reactor recipes.");
                    for (FluidStack fluidStack : toRemoveMulti) {
                        if (!recipeMapMultiblockChemReactor.mRecipeList.remove(fluidStack)) continue;
                        ++mRemovedMulti;
                    }
                    Logger.INFO("[Nitro] Removed " + mRemovedMulti + " multi block Chemical Reactor recipes.");
                    Materials mGlycerol = Materials.valueOf((String)"Glycerol");
                    Materials mLightFuel = Materials.valueOf((String)"LightFuel");
                    for (Materials fuel : mFuels = new Materials[]{mLightFuel, Materials.Fuel}) {
                        didAdd = new boolean[3];
                        Logger.INFO("[Nitro] Getting ready to add back in the old nitro-diesel recipe to the mixer, using " + fuel.mDefaultLocalName + " as the fuel input.");
                        didAdd[0] = GT_Values.RA.addMixerRecipe(GregtechNitroDieselFix.getCells(fuel, 4), GregtechNitroDieselFix.getCells(mGlycerol, 1), GT_Values.NI, GT_Values.NI, GT_Values.NF, GT_Values.NF, GregtechNitroDieselFix.getCells(mNitroFix, 5), 20, 30);
                        didAdd[1] = GT_Values.RA.addMixerRecipe(GregtechNitroDieselFix.getCells(fuel, 4), GT_Values.NI, GT_Values.NI, GT_Values.NI, mGlycerol.getFluid(1000L), mNitroFix.getFluid(5000L), ItemList.Cell_Empty.get(4L, new Object[0]), 20, 30);
                        didAdd[2] = GT_Values.RA.addMixerRecipe(GregtechNitroDieselFix.getCells(mGlycerol, 1), GT_Values.NI, GT_Values.NI, GT_Values.NI, fuel.getFluid(4000L), mNitroFix.getFluid(5000L), ItemList.Cell_Empty.get(1L, new Object[0]), 20, 30);
                        Logger.INFO("[Nitro] Did the recipes add? 1: " + didAdd[0] + " |  2: " + didAdd[1] + " |  3: " + didAdd[2]);
                    }
                    for (Materials fuel : mFuels) {
                        didAdd = new boolean[3];
                        Logger.INFO("[Nitro] Getting ready to add back in the old nitro-diesel recipe to the chemical reactors, using " + fuel.mDefaultLocalName + " as the fuel input.");
                        didAdd[0] = GT_Values.RA.addChemicalRecipe(GregtechNitroDieselFix.getCells(fuel, 4), GregtechNitroDieselFix.getCells(mGlycerol, 1), GT_Values.NF, GT_Values.NF, GregtechNitroDieselFix.getCells(mNitroFix, 5), 20);
                        didAdd[1] = GT_Values.RA.addChemicalRecipe(GregtechNitroDieselFix.getCells(fuel, 4), GT_Values.NI, mGlycerol.getFluid(1000L), mNitroFix.getFluid(5000L), ItemList.Cell_Empty.get(4L, new Object[0]), 20);
                        didAdd[2] = GT_Values.RA.addChemicalRecipe(GregtechNitroDieselFix.getCells(mGlycerol, 1), GT_Values.NI, fuel.getFluid(4000L), mNitroFix.getFluid(5000L), ItemList.Cell_Empty.get(1L, new Object[0]), 20);
                        Logger.INFO("[Nitro] Did the recipes add? 1: " + didAdd[0] + " |  2: " + didAdd[1] + " |  3: " + didAdd[2]);
                    }
                    Logger.INFO("[Nitro] Getting ready to add back in the old glycerol recipe!");
                    GT_Values.RA.addChemicalRecipe(GregtechNitroDieselFix.getCells(Materials.Nitrogen, 1), GregtechNitroDieselFix.getDust(Materials.Carbon, 1), Materials.Water.getFluid(2000L), mGlycerol.getFluid(3000L), ItemList.Cell_Empty.get(1L, new Object[0]), 3000);
                    Logger.INFO("[Nitro] Added recipes.");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Logger.INFO("[Nitro] ================ Error ================");
                e.printStackTrace();
                Logger.INFO("[Nitro] ================ Error ================");
            }
        }
    }

    public static ItemStack getCells(Materials mat, int amount) {
        String mName = MaterialUtils.getMaterialName(mat);
        return ItemUtils.getItemStackOfAmountFromOreDict("cell" + mName, amount);
    }

    public static ItemStack getDust(Materials mat, int amount) {
        String mName = MaterialUtils.getMaterialName(mat);
        return ItemUtils.getItemStackOfAmountFromOreDict("dust" + mName, amount);
    }
}

