/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public class GT_Material_Loader {
    private static volatile GT_Material_Loader instance = new GT_Material_Loader();
    private volatile Object mProxyObject;
    private static AutoMap<Materials> mMaterials = new AutoMap();
    private static volatile boolean mHasRun = false;

    public synchronized GT_Material_Loader getInstance() {
        return instance;
    }

    public synchronized boolean getRunAbility() {
        return !mHasRun;
    }

    public synchronized void setRunAbility(boolean b) {
        mHasRun = Utils.invertBoolean(b);
    }

    public GT_Material_Loader() {
        if (this.getRunAbility()) {
            instance = this;
            Class<?> mInterface = ReflectionUtils.getClass("gregtech.api.interfaces.IMaterialHandler");
            if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK && mInterface != null) {
                if (this.mProxyObject == null) {
                    this.mProxyObject = Proxy.newProxyInstance(mInterface.getClassLoader(), new Class[]{mInterface}, (InvocationHandler)new MaterialHandler(this.getInstance()));
                }
                if (ReflectionUtils.invoke(Materials.class, "add", new Class[]{ReflectionUtils.getClass("gregtech.api.interfaces.IMaterialHandler")}, new Object[]{this.mProxyObject})) {
                    Logger.REFLECTION("Successfully invoked add, on the proxied object implementing IMaterialHandler.");
                    Logger.REFLECTION("Examining Proxy to ensure it implements the correct Interface.");
                    Class<?>[] i = this.mProxyObject.getClass().getInterfaces();
                    for (int r = 0; r < i.length; ++r) {
                        Logger.REFLECTION("Contains " + i[r].getCanonicalName() + ".");
                        if (i[r] != mInterface) continue;
                        Logger.REFLECTION("Found gregtech.api.interfaces.IMaterialHandler. This Proxy is valid.");
                    }
                } else {
                    Logger.REFLECTION("Failed to invoke add, on the proxied object implementing IMaterialHandler.");
                }
            }
            this.setRunAbility(false);
        }
    }

    public void onMaterialsInit() {
        Logger.DEBUG_MATERIALS("onMaterialsInit()");
    }

    public void onComponentInit() {
        Logger.DEBUG_MATERIALS("onComponentInit()");
        if (!mMaterials.isEmpty()) {
            Logger.DEBUG_MATERIALS("Found " + mMaterials.size() + " materials to re-enable.");
            for (Materials M : mMaterials.values()) {
                String name = MaterialUtils.getMaterialName(M);
                Logger.DEBUG_MATERIALS("Trying to enable " + name + ".");
                boolean success = GT_Material_Loader.tryEnableAllComponentsForMaterial(M);
                if (success) {
                    Logger.DEBUG_MATERIALS("Success! Enabled " + name + ".");
                    continue;
                }
                Logger.DEBUG_MATERIALS("Failure... Did not enable " + name + ".");
            }
        }
    }

    public void onComponentIteration(Materials aMaterial) {
        Logger.DEBUG_MATERIALS("onComponentIteration()");
    }

    public synchronized boolean enableMaterial(Materials m) {
        if (mMaterials.setValue(m)) {
            Logger.DEBUG_MATERIALS("Added " + MaterialUtils.getMaterialName(m) + " to internal Map.");
            return true;
        }
        Logger.DEBUG_MATERIALS("Failed to add " + MaterialUtils.getMaterialName(m) + " to internal Map.");
        return false;
    }

    private static synchronized boolean tryEnableMaterial(Materials mMaterial) {
        if (!CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            return false;
        }
        boolean value = ReflectionUtils.setField((Object)mMaterial, "mHasParentMod", (Object)true);
        if (value) {
            Logger.DEBUG_MATERIALS("Set mHasParentMod true for " + mMaterial.mDefaultLocalName);
        } else {
            Logger.DEBUG_MATERIALS("Failed to set mHasParentMod true for " + mMaterial.mDefaultLocalName);
        }
        return value;
    }

    private static synchronized boolean tryEnableMaterialPart(OrePrefixes prefix, Materials mMaterial) {
        if (!CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            return false;
        }
        try {
            Method enableComponent = ReflectionUtils.getClass("gregtech.api.enums.OrePrefixes").getDeclaredMethod("enableComponent", Materials.class);
            enableComponent.invoke((Object)prefix, mMaterial);
            Logger.DEBUG_MATERIALS("Enabled " + prefix.name() + " for " + mMaterial.mDefaultLocalName + ".");
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException error) {
            Logger.DEBUG_MATERIALS("Failed to enabled " + prefix.name() + " for " + mMaterial.mDefaultLocalName + ". Caught " + error.getCause().toString() + ".");
            error.printStackTrace();
            Logger.DEBUG_MATERIALS("Did not enable " + prefix.name() + " for " + mMaterial.mDefaultLocalName + ". Report this error to Alkalus on Github.");
            return false;
        }
    }

    private static synchronized boolean tryEnableAllComponentsForMaterial(Materials material) {
        if (!CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            return false;
        }
        try {
            GT_Material_Loader.tryEnableMaterial(material);
            int mValid = 0;
            for (OrePrefixes ore : OrePrefixes.values()) {
                if (!GT_Material_Loader.tryEnableMaterialPart(ore, material)) continue;
                ++mValid;
            }
            if (mValid > 0) {
                Logger.DEBUG_MATERIALS("Success - Re-enabled all components for " + MaterialUtils.getMaterialName(material));
            } else {
                Logger.DEBUG_MATERIALS("Failure - Did not enable any components for " + MaterialUtils.getMaterialName(material));
            }
            return mValid > 0;
        }
        catch (IllegalArgumentException | SecurityException e) {
            Logger.DEBUG_MATERIALS("Total Failure - Unable to re-enable " + MaterialUtils.getMaterialName(material) + ". Most likely an IllegalArgumentException, but small chance it's a SecurityException.");
            return false;
        }
    }

    public class MaterialHandler
    implements InvocationHandler {
        private final Map<String, Method> methods = new HashMap<String, Method>();
        private Object target;

        public MaterialHandler(Object target) {
            Logger.REFLECTION("Created a Proxy Interface which implements IMaterialHandler.");
            this.target = target;
            for (Method method : target.getClass().getDeclaredMethods()) {
                Logger.REFLECTION("Adding " + method.getName() + " to internal method map.");
                this.methods.put(method.getName(), method);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            long start = System.nanoTime();
            Object result = this.methods.get(method.getName()).invoke(this.target, args);
            long elapsed = System.nanoTime() - start;
            Logger.INFO("[Debug] Executed " + method.getName() + " in " + elapsed + " ns");
            return result;
        }
    }
}

