/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.redstone;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.GT_MetaTileEntity_RedstoneBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_RedstoneButtonPanel
extends GT_MetaTileEntity_RedstoneBase {
    public byte mRedstoneStrength = 0;
    public byte mType = 0;
    public byte mUpdate = 0;
    public static TexturesGtBlock.CustomIcon[] sIconList = new TexturesGtBlock.CustomIcon[64];

    public GT_MetaTileEntity_RedstoneButtonPanel(int aID) {
        super(aID, "redstone.button.panel", "Button Panel", 5, 0, "Right-click with Screwdriver to change Button Design", new ITexture[0]);
    }

    public GT_MetaTileEntity_RedstoneButtonPanel(String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 5, 0, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_RedstoneButtonPanel(this.mName, this.mDescription, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mRedstoneStrength", this.mRedstoneStrength);
        aNBT.func_74774_a("mType", this.mType);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mRedstoneStrength = aNBT.func_74771_c("mRedstoneStrength");
        this.mType = aNBT.func_74771_c("mType");
    }

    public void onValueUpdate(byte aValue) {
        this.mRedstoneStrength = (byte)(aValue & 0xF);
        this.mType = (byte)(aValue >>> 4);
    }

    public byte getUpdateData() {
        return (byte)(this.mRedstoneStrength & 0xF | this.mType << 4);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            if (this.getBaseMetaTileEntity().isServerSide()) {
                this.mUpdate = (byte)2;
                block0 : switch (this.mType) {
                    default: {
                        switch (aSide) {
                            case 0: 
                            case 1: {
                                this.mRedstoneStrength = (byte)((byte)(aX * 4.0f) + 4 * (byte)(aZ * 4.0f));
                                break;
                            }
                            case 2: {
                                this.mRedstoneStrength = (byte)((byte)(4.0f - aX * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                                break;
                            }
                            case 3: {
                                this.mRedstoneStrength = (byte)((byte)(aX * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                                break;
                            }
                            case 4: {
                                this.mRedstoneStrength = (byte)((byte)(aZ * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                                break;
                            }
                            case 5: {
                                this.mRedstoneStrength = (byte)((byte)(4.0f - aZ * 4.0f) + 4 * (byte)(4.0f - aY * 4.0f));
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (aSide) {
                            case 0: 
                            case 1: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aX * 2.0f) + 2 * (byte)(aZ * 2.0f));
                                break;
                            }
                            case 2: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(2.0f - aX * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                                break;
                            }
                            case 3: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aX * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                                break;
                            }
                            case 4: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aZ * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                                break;
                            }
                            case 5: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(2.0f - aZ * 2.0f) + 2 * (byte)(2.0f - aY * 2.0f));
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (aSide) {
                            case 0: 
                            case 1: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(aZ * 4.0f));
                                break block0;
                            }
                            case 2: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(4.0f - aY * 4.0f));
                                break block0;
                            }
                            case 3: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(4.0f - aY * 4.0f));
                                break block0;
                            }
                            case 4: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(4.0f - aY * 4.0f));
                                break block0;
                            }
                            case 5: {
                                this.mRedstoneStrength = (byte)(this.mRedstoneStrength ^ 1 << (byte)(4.0f - aY * 4.0f));
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.getBaseMetaTileEntity().setGenericRedstoneOutput(true);
            if (this.mUpdate > 0) {
                this.mUpdate = (byte)(this.mUpdate - 1);
            } else if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                this.mRedstoneStrength = 0;
            }
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.getBaseMetaTileEntity().setStrongOutputRedstoneSignal(i, i == this.getBaseMetaTileEntity().getFrontFacing() ? (byte)0 : this.mRedstoneStrength);
                this.getBaseMetaTileEntity().setInternalOutputRedstoneSignal(i, i == this.getBaseMetaTileEntity().getFrontFacing() ? (byte)0 : this.mRedstoneStrength);
            }
        }
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aSide == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mType = (byte)((this.mType + 1) % 3);
        }
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getSides(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getSidesActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], new GT_RenderedTexture((IIconContainer)sIconList[this.mType * 16 + this.mRedstoneStrength])};
        }
        return this.mTextures[(aActive || this.hasRedstoneSignal() ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Top_Main_Off)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Top_Main_On)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Bottom_Main_Off)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Bottom_Main_On)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_Main_Off)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Redstone_Side_Main_On)};
    }

    static {
        for (int i = 0; i < 64; ++i) {
            GT_MetaTileEntity_RedstoneButtonPanel.sIconList[i] = new TexturesGtBlock.CustomIcon("TileEntities/gt4/redstone/ButtonPanel/" + i);
        }
    }
}

