/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.chemplant;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Triplet;
import gtPlusPlus.core.item.chemistry.general.ItemGenericChemBase;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers.GT_MetaTileEntity_Hatch_Catalysts;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMTE_ChemicalPlant
extends GregtechMeta_MultiBlockBase<GregtechMTE_ChemicalPlant>
implements ISurvivalConstructable {
    private int mSolidCasingTier = 0;
    private int mMachineCasingTier = 0;
    private int mPipeCasingTier = 0;
    private int mCoilTier = 0;
    private HeatingCoilLevel checkCoil;
    private int[] checkCasing = new int[8];
    private int checkMachine;
    private int checkPipe;
    private int maxTierOfHatch;
    private int mCasing;
    private IStructureDefinition<GregtechMTE_ChemicalPlant> STRUCTURE_DEFINITION = null;
    private final ArrayList<GT_MetaTileEntity_Hatch_Catalysts> mCatalystBuses = new ArrayList();
    private static final HashMap<Integer, Triplet<Block, Integer, Integer>> mTieredBlockRegistry = new HashMap();
    private static final HashMap<Long, AutoMap<GT_Recipe>> mTieredRecipeMap = new HashMap();
    private static final AutoMap<GT_Recipe> aTier0Recipes = new AutoMap();
    private static final AutoMap<GT_Recipe> aTier1Recipes = new AutoMap();
    private static final AutoMap<GT_Recipe> aTier2Recipes = new AutoMap();
    private static final AutoMap<GT_Recipe> aTier3Recipes = new AutoMap();
    private static final AutoMap<GT_Recipe> aTier4Recipes = new AutoMap();
    private static final AutoMap<GT_Recipe> aTier5Recipes = new AutoMap();
    private static final AutoMap<GT_Recipe> aTier6Recipes = new AutoMap();
    private static final AutoMap<GT_Recipe> aTier7Recipes = new AutoMap();
    private static boolean mInitRecipeCache = false;

    public GregtechMTE_ChemicalPlant(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_ChemicalPlant(String aName) {
        super(aName);
    }

    public static boolean registerMachineCasingForTier(int aTier, Block aBlock, int aMeta, int aCasingTextureID) {
        Triplet<Block, Integer, Integer> aCasingData = new Triplet<Block, Integer, Integer>(aBlock, aMeta, aCasingTextureID);
        if (mTieredBlockRegistry.containsKey(aTier)) {
            CORE.crash("Tried to register a Machine casing for tier " + aTier + " to the Chemical Plant, however this tier already contains one.");
        }
        mTieredBlockRegistry.put(aTier, aCasingData);
        return true;
    }

    private static int getCasingTextureIdForTier(int aTier) {
        if (!mTieredBlockRegistry.containsKey(aTier)) {
            return 10;
        }
        int aCasingID = mTieredBlockRegistry.get(aTier).getValue_3();
        return aCasingID;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_ChemicalPlant(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Chemical Plant";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Chemical Plant").addInfo("Heavy Industry, now right at your doorstep!").addInfo("Please read the user manual for more information on construction and usage").addSeparator().addController("Bottom Center").addStructureHint("Catalyst Housing", new int[]{1}).addInputBus("Bottom Casing", new int[]{1}).addOutputBus("Bottom Casing", new int[]{1}).addInputHatch("Bottom Casing", new int[]{1}).addOutputHatch("Bottom Casing", new int[]{1}).addEnergyHatch("Bottom Casing", new int[]{1}).addMaintenanceHatch("Bottom Casing", new int[]{1}).addSubChannelUsage("casing", "metal machine casing").addSubChannelUsage("machine", "tier machine casing").addSubChannelUsage("coil", "heating coil blocks").addSubChannelUsage("pipe", "pipe casing blocks").toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public void setMachineMeta(int meta) {
        this.checkMachine = meta;
    }

    public int getMachineMeta() {
        return this.checkMachine;
    }

    public void setPipeMeta(int meta) {
        this.checkPipe = meta;
    }

    public int getPipeMeta() {
        return this.checkPipe;
    }

    public void setCoilMeta(HeatingCoilLevel meta) {
        this.checkCoil = meta;
    }

    public HeatingCoilLevel getCoilMeta() {
        return this.checkCoil;
    }

    public int coilTier(int meta) {
        switch (meta) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 14;
            }
        }
        return 0;
    }

    public IStructureDefinition<GregtechMTE_ChemicalPlant> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            IStructureElement allCasingsElement = StructureUtility.withChannel((String)"casing", (IStructureElement)StructureUtility.ofChain(IntStream.range(0, 8).mapToObj(GregtechMTE_ChemicalPlant::ofSolidCasing).collect(Collectors.toList())));
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX", "XXXXXXX"}, {"X     X", " MMMMM ", " MHHHM ", " MHHHM ", " MHHHM ", " MMMMM ", "X     X"}, {"X     X", "       ", "  PPP  ", "  PPP  ", "  PPP  ", "       ", "X     X"}, {"X     X", "       ", "  HHH  ", "  HHH  ", "  HHH  ", "       ", "X     X"}, {"X     X", "       ", "  PPP  ", "  PPP  ", "  PPP  ", "       ", "X     X"}, {"X     X", " MMMMM ", " MHHHM ", " MHHHM ", " MHHHM ", " MMMMM ", "X     X"}, {"CCC~CCC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CMMMMMC", "CCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMTE_ChemicalPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance}).casingIndex(this.getCasingTextureID()).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_ChemicalPlant.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus}).adder(GregtechMTE_ChemicalPlant::addChemicalPlantList).hatchItemFilterAnd((t, s) -> GT_StructureUtility.filterByMTETier((int)Integer.MIN_VALUE, (int)(s.field_77994_a >= 10 ? Integer.MAX_VALUE : s.field_77994_a))).casingIndex(this.getCasingTextureID()).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_ChemicalPlant.class).hatchClass(GT_MetaTileEntity_Hatch_Catalysts.class).adder(GregtechMTE_ChemicalPlant::addChemicalPlantList).casingIndex(this.getCasingTextureID()).dot(1).build(), allCasingsElement})).addElement('X', allCasingsElement).addElement('M', StructureUtility.withChannel((String)"machine", GregtechMTE_ChemicalPlant.addTieredBlock(GregTech_API.sBlockCasings1, GregtechMTE_ChemicalPlant::setMachineMeta, GregtechMTE_ChemicalPlant::getMachineMeta, 10))).addElement('H', StructureUtility.withChannel((String)"coil", (IStructureElement)GT_StructureUtility.ofCoil(GregtechMTE_ChemicalPlant::setCoilMeta, GregtechMTE_ChemicalPlant::getCoilMeta))).addElement('P', StructureUtility.withChannel((String)"pipe", GregtechMTE_ChemicalPlant.addTieredBlock(GregTech_API.sBlockCasings2, GregtechMTE_ChemicalPlant::setPipeMeta, GregtechMTE_ChemicalPlant::getPipeMeta, 12, 16))).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    private static IStructureElement<GregtechMTE_ChemicalPlant> ofSolidCasing(final int aIndex) {
        return new IStructureElement<GregtechMTE_ChemicalPlant>(){

            public boolean check(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z) {
                if (this.check(aIndex, world, x, y, z)) {
                    int[] nArray = t.checkCasing;
                    int n = aIndex;
                    nArray[n] = nArray[n] + 1;
                    t.mCasing++;
                    return true;
                }
                return false;
            }

            private boolean check(int aIndex2, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                Block target = (Block)((Triplet)mTieredBlockRegistry.get(aIndex2)).getValue_1();
                int targetMeta = (Integer)((Triplet)mTieredBlockRegistry.get(aIndex2)).getValue_2();
                return target.equals(block) && meta == targetMeta;
            }

            int getIndex(int size) {
                if (size > 8) {
                    size = 8;
                }
                return size - 1;
            }

            public boolean spawnHint(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)((Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1()), (int)((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()));
                return true;
            }

            public boolean placeBlock(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, (Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1(), ((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()).intValue(), 3);
            }

            @Nullable
            public IStructureElement.BlocksToPlace getBlocksToPlace(GregtechMTE_ChemicalPlant gregtechMTE_chemicalPlant, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)((Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1()), (int)((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(GregtechMTE_ChemicalPlant t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(this.getIndex(trigger.field_77994_a), world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)((Block)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_1()), (int)((Integer)((Triplet)mTieredBlockRegistry.get(this.getIndex(trigger.field_77994_a))).getValue_2()), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 3, 6, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int i;
        this.mCasing = 0;
        for (i = 0; i < 8; ++i) {
            this.checkCasing[i] = 0;
        }
        this.checkPipe = 0;
        this.checkMachine = 0;
        this.mSolidCasingTier = 0;
        this.mMachineCasingTier = 0;
        this.mPipeCasingTier = 0;
        this.mCoilTier = 0;
        this.mCatalystBuses.clear();
        if (this.checkPiece(this.mName, 3, 6, 0) && this.mCasing >= 70) {
            for (i = 0; i < 8; ++i) {
                if (this.checkCasing[i] == this.mCasing) {
                    this.mSolidCasingTier = i;
                    continue;
                }
                if (this.checkCasing[i] <= 0) continue;
                return false;
            }
            this.mMachineCasingTier = this.checkMachine - 1;
            this.mPipeCasingTier = this.checkPipe - 12;
            this.mCoilTier = this.checkCoil.getTier();
            this.getBaseMetaTileEntity().sendBlockEvent((byte)1, this.getUpdateData());
            this.updateHatchTexture();
            return this.mMachineCasingTier >= 9 || this.mMachineCasingTier >= this.maxTierOfHatch;
        }
        return false;
    }

    public void updateHatchTexture() {
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mCatalystBuses) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mInputBusses) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mMaintenanceHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mEnergyHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mOutputBusses) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mInputHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
        for (GT_MetaTileEntity_Hatch gT_MetaTileEntity_Hatch : this.mOutputHatches) {
            gT_MetaTileEntity_Hatch.updateTexture(this.getCasingTextureID());
        }
    }

    public final boolean addChemicalPlantList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Catalysts) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            this.maxTierOfHatch = Math.max(this.maxTierOfHatch, ((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity).mTier);
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(207);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getCasingTextureID();
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (GTPP_Recipe.GTPP_Recipe_Map.sChemicalPlant_GT.mRecipeList.size() == 0) {
            GregtechMTE_ChemicalPlant.generateRecipes();
        }
        return GTPP_Recipe.GTPP_Recipe_Map.sChemicalPlant_GT;
    }

    public static void generateRecipes() {
        for (GT_Recipe i : GTPP_Recipe.GTPP_Recipe_Map.sChemicalPlantRecipes.mRecipeList) {
            GTPP_Recipe.GTPP_Recipe_Map.sChemicalPlant_GT.add(i);
        }
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * this.getPipeCasingTier();
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    private int getSolidCasingTier() {
        return this.mSolidCasingTier;
    }

    private int getMachineCasingTier() {
        return this.mMachineCasingTier;
    }

    private int getPipeCasingTier() {
        return this.mPipeCasingTier;
    }

    private int getCasingTextureID() {
        int aTier = this.mSolidCasingTier;
        return GregtechMTE_ChemicalPlant.getCasingTextureIdForTier(aTier);
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity) {
        int aMaxTier = this.getMachineCasingTier();
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_TieredMachineBlock) {
            GT_MetaTileEntity_TieredMachineBlock aMachineBlock = (GT_MetaTileEntity_TieredMachineBlock)aMetaTileEntity;
            byte aTileTier = aMachineBlock.mTier;
            if (aTileTier > aMaxTier) {
                this.log("Hatch tier too high.");
                return false;
            }
            return this.addToMachineList(aTileEntity, this.getCasingTextureID());
        }
        this.log("Bad Tile Entity being added to hatch map.");
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mSolidCasingTier", this.mSolidCasingTier);
        aNBT.func_74768_a("mMachineCasingTier", this.mMachineCasingTier);
        aNBT.func_74768_a("mPipeCasingTier", this.mPipeCasingTier);
        aNBT.func_74768_a("mCoilTier", this.mCoilTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSolidCasingTier = aNBT.func_74762_e("mSolidCasingTier");
        this.mMachineCasingTier = aNBT.func_74762_e("mMachineCasingTier");
        this.mPipeCasingTier = aNBT.func_74762_e("mPipeCasingTier");
        this.mCoilTier = aNBT.func_74762_e("mCoilTier");
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Catalysts) {
            this.log("Found GT_MetaTileEntity_Hatch_Catalysts");
            return this.addToMachineListInternal(this.mCatalystBuses, aMetaTileEntity, aBaseCasingIndex);
        }
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    public int getSpeedBonus() {
        return 50 * (this.mCoilTier - 1);
    }

    public int getMaxCatalystDurability() {
        return 50;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mCatalystBuses.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public byte getUpdateData() {
        return (byte)this.mSolidCasingTier;
    }

    public void receiveClientEvent(byte aEventID, byte aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (aEventID == 1 && (aValue & 0x80) == 0) {
            this.mSolidCasingTier = aValue;
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), this.getSpeedBonus());
    }

    @Override
    public boolean checkRecipeGeneric(int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        ArrayList<ItemStack> tItems = this.getStoredInputs();
        ArrayList tFluids = this.getStoredFluids();
        ItemStack[] tItemInputs = tItems.toArray(new ItemStack[tItems.size()]);
        FluidStack[] tFluidInputs = tFluids.toArray(new FluidStack[tFluids.size()]);
        return this.checkRecipeGeneric(tItemInputs, tFluidInputs, aMaxParallelRecipes, aEUPercent, aSpeedBonusPercent, aOutputChanceRoll);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        void var29_35;
        int parallelRecipes;
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.log("Running checkRecipeGeneric(0)");
        GT_Recipe tRecipe = this.findRecipe(this.mLastRecipe, GT_Values.V[tTier], (long)this.getSolidCasingTier(), aItemInputs, aFluidInputs);
        if (tRecipe == null) {
            this.log("BAD RETURN - 1");
            return false;
        }
        ItemStack tCatalystRecipe = null;
        boolean aDoesRecipeNeedCatalyst = false;
        for (ItemStack aInputItem : tRecipe.mInputs) {
            if (!ItemUtils.isCatalyst(aInputItem)) continue;
            aDoesRecipeNeedCatalyst = true;
            break;
        }
        if (aDoesRecipeNeedCatalyst) {
            tCatalystRecipe = this.findCatalyst(aItemInputs, tRecipe.mInputs);
            if (tCatalystRecipe == null) {
                this.log("does not have catalyst");
                return false;
            }
            if (this.mCatalystBuses.size() != 1) {
                this.log("does not have correct number of catalyst hatches. (Required 1, found " + this.mCatalystBuses.size() + ")");
                return false;
            }
        }
        this.log("Running checkRecipeGeneric(1)");
        this.mLastRecipe = tRecipe;
        if (tRecipe.mSpecialValue > this.mSolidCasingTier) {
            this.log("solid tier is too low");
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        ArrayList<ItemStack> tCatalysts = null;
        int tMaxParallelCatalyst = aMaxParallelRecipes;
        if (tCatalystRecipe != null) {
            tCatalysts = new ArrayList<ItemStack>();
            tMaxParallelCatalyst = this.getCatalysts(aItemInputs, tCatalystRecipe, aMaxParallelRecipes, tCatalysts);
            this.log("Can process " + tMaxParallelCatalyst + " recipes. If less than " + aMaxParallelRecipes + ", catalyst does not have enough durability.");
        }
        if (tMaxParallelCatalyst == 0) {
            this.log("found not enough catalysts");
            return false;
        }
        float tRecipeEUt = (float)((long)tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("aEUPercent " + aEUPercent);
        this.log("mEUt " + tRecipe.mEUt);
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + tMaxParallelCatalyst);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tVoltage: " + tVoltage);
        this.log("tEnergy: " + tEnergy);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < tMaxParallelCatalyst && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                this.log("Broke at " + parallelRecipes + ".");
                break;
            }
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            this.log("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var29_35 < n) {
            Object tS = objectArray[var29_35];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var29_35;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        if (tCatalystRecipe != null) {
            this.log("damaging catalyst");
            this.damageCatalyst(tCatalystRecipe, parallelRecipes);
        }
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        for (GT_MetaTileEntity_Hatch_Catalysts h : this.mCatalystBuses) {
            h.updateSlots();
            h.tryFillUsageSlots();
        }
        this.startProcess();
        this.log("GOOD RETURN - 1");
        return true;
    }

    private static void initRecipeCaches() {
        if (!mInitRecipeCache) {
            mTieredRecipeMap.put(0L, aTier0Recipes);
            mTieredRecipeMap.put(1L, aTier1Recipes);
            mTieredRecipeMap.put(2L, aTier2Recipes);
            mTieredRecipeMap.put(3L, aTier3Recipes);
            mTieredRecipeMap.put(4L, aTier4Recipes);
            mTieredRecipeMap.put(5L, aTier5Recipes);
            mTieredRecipeMap.put(6L, aTier6Recipes);
            mTieredRecipeMap.put(7L, aTier7Recipes);
            block10: for (GT_Recipe aRecipe : GTPP_Recipe.GTPP_Recipe_Map.sChemicalPlant_GT.mRecipeList) {
                if (aRecipe == null) continue;
                switch (aRecipe.mSpecialValue) {
                    case 0: {
                        aTier0Recipes.add(aRecipe);
                        continue block10;
                    }
                    case 1: {
                        aTier1Recipes.add(aRecipe);
                        continue block10;
                    }
                    case 2: {
                        aTier2Recipes.add(aRecipe);
                        continue block10;
                    }
                    case 3: {
                        aTier3Recipes.add(aRecipe);
                        continue block10;
                    }
                    case 4: {
                        aTier4Recipes.add(aRecipe);
                        continue block10;
                    }
                    case 5: {
                        aTier5Recipes.add(aRecipe);
                        continue block10;
                    }
                    case 6: {
                        aTier6Recipes.add(aRecipe);
                        continue block10;
                    }
                    case 7: {
                        aTier7Recipes.add(aRecipe);
                        continue block10;
                    }
                }
            }
            mInitRecipeCache = true;
        }
    }

    public GT_Recipe findRecipe(GT_Recipe aRecipe, long aVoltage, long aSpecialValue, ItemStack[] aInputs, FluidStack[] aFluids) {
        if (!mInitRecipeCache) {
            GregtechMTE_ChemicalPlant.initRecipeCaches();
        }
        if (this.getRecipeMap().mRecipeList.isEmpty()) {
            this.log("No Recipes in Map to search through.");
            return null;
        }
        this.log("Checking tier " + aSpecialValue + " recipes and below. Using Input Voltage of " + aVoltage + "V.");
        this.log("We have " + aInputs.length + " Items and " + aFluids.length + " Fluids.");
        if (aRecipe != null && aRecipe.isRecipeInputEqual(false, aFluids, aInputs) && (long)aRecipe.mEUt <= aVoltage) {
            Logger.INFO("Using cached recipe.");
            return aRecipe;
        }
        AutoMap<AutoMap<GT_Recipe>> aMasterMap = new AutoMap<AutoMap<GT_Recipe>>();
        for (long i = 0L; i <= aSpecialValue; ++i) {
            aMasterMap.add(mTieredRecipeMap.get(i));
        }
        GT_Recipe aFoundRecipe = null;
        block1: for (AutoMap autoMap : aMasterMap) {
            for (GT_Recipe aRecipeToCheck : autoMap) {
                if (!aRecipeToCheck.isRecipeInputEqual(false, aFluids, aInputs)) continue;
                this.log("Found recipe with matching inputs!");
                if ((long)aRecipeToCheck.mSpecialValue > aSpecialValue || (long)aRecipeToCheck.mEUt > aVoltage) continue;
                aFoundRecipe = aRecipeToCheck;
                break block1;
            }
        }
        if (aFoundRecipe != null) {
            this.log("Found valid recipe.");
            return aFoundRecipe;
        }
        this.log("Did not find valid recipe.");
        return null;
    }

    private int getCatalysts(ItemStack[] aItemInputs, ItemStack aRecipeCatalyst, int aMaxParrallel, ArrayList<ItemStack> aOutPut) {
        int allowedParallel = 0;
        for (ItemStack aInput : aItemInputs) {
            if (!aRecipeCatalyst.func_77969_a(aInput)) continue;
            int aDurabilityRemaining = this.getMaxCatalystDurability() - this.getDamage(aInput);
            return Math.min(aMaxParrallel, aDurabilityRemaining);
        }
        return allowedParallel;
    }

    private ItemStack findCatalyst(ItemStack[] aItemInputs, ItemStack[] aRecipeInputs) {
        if (aItemInputs != null) {
            for (ItemStack aInput : aItemInputs) {
                if (aInput == null || !ItemUtils.isCatalyst(aInput)) continue;
                for (ItemStack aRecipeInput : aRecipeInputs) {
                    if (!GT_Utility.areStacksEqual((ItemStack)aRecipeInput, (ItemStack)aInput, (boolean)true)) continue;
                    return aInput;
                }
            }
        }
        return null;
    }

    private void damageCatalyst(ItemStack aStack, int parallelRecipes) {
        for (int i = 0; i < parallelRecipes; ++i) {
            if (this.mCoilTier >= 10 && this.mPipeCasingTier >= 4) {
                this.log("not consuming catalyst");
                continue;
            }
            if ((double)(MathUtils.randFloat(0.0f, 1.0E7f) / 1.0E7f) < (double)1.2f - 0.2 * (double)this.mPipeCasingTier) {
                int damage = this.getDamage(aStack) + 1;
                this.log("damage catalyst " + damage);
                if (damage >= this.getMaxCatalystDurability()) {
                    this.log("consume catalyst");
                    this.addOutput(CI.getEmptyCatalyst(1));
                    --aStack.field_77994_a;
                    continue;
                }
                this.log("damaging catalyst");
                this.setDamage(aStack, damage);
                continue;
            }
            this.log("not consuming catalyst");
        }
    }

    private int getDamage(ItemStack aStack) {
        return ItemGenericChemBase.getCatalystDamage(aStack);
    }

    private void setDamage(ItemStack aStack, int aAmount) {
        ItemGenericChemBase.setCatalystDamage(aStack, aAmount);
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList tItems = super.getStoredInputs();
        if (this.hasSlotInGUI() && this.getGUIItemStack() != null) {
            tItems.add(this.getGUIItemStack());
        }
        for (GT_MetaTileEntity_Hatch_Catalysts tHatch : this.mCatalystBuses) {
            AutoMap<ItemStack> aHatchContent;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GregtechMTE_ChemicalPlant.isValidMetaTileEntity((MetaTileEntity)tHatch) || (aHatchContent = tHatch.getContentUsageSlots()).isEmpty()) continue;
            tItems.addAll(aHatchContent);
        }
        return tItems;
    }
}

