/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_MatterFab;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_MatterFab;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_MassFabricator
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_MassFabricator>
implements ISurvivalConstructable {
    public static int sUUAperUUM = 1;
    public static int sUUASpeedBonus = 4;
    public static int sDurationMultiplier = 3200;
    public int mMatterProduced = 0;
    public int mScrapProduced = 0;
    public int mAmplifierProduced = 0;
    public int mScrapUsed = 0;
    public int mAmplifierUsed = 0;
    public static String mCasingName1 = "Matter Fabricator Casing";
    public static String mCasingName2 = "Containment Casing";
    public static String mCasingName3 = "Matter Generation Coil";
    private int mMode = 0;
    private static final int MODE_SCRAP = 1;
    private static final int MODE_UU = 0;
    public static boolean sRequiresUUA = false;
    private static FluidStack[] mUU = new FluidStack[2];
    private static ItemStack[] mScrap = new ItemStack[2];
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_MassFabricator> STRUCTURE_DEFINITION = null;
    public static boolean sInit = false;

    public int getAmplifierUsed() {
        return this.mAmplifierUsed;
    }

    public int getMatterProduced() {
        return this.mMatterProduced;
    }

    public int getScrapProduced() {
        return this.mScrapProduced;
    }

    public GregtechMetaTileEntity_MassFabricator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_MassFabricator(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Mass Fabricator / Recycler";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Matter Fabricator").addInfo("Speed: +0% | EU Usage: 80%").addInfo("Parallel: Scrap = 64 | UU = 8 * Tier").addInfo("Produces UU-A, UU-M & Scrap").addInfo("Change mode with screwdriver").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(5, 4, 5, true).addController("Front Center").addCasingInfo(mCasingName3, 9).addCasingInfo(mCasingName2, 24).addCasingInfo(mCasingName1, 40).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Active_Animated;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_MatterFab_Animated;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(9);
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "MatterFabricator";
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GUI_MatterFab(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MatterFabricator.png");
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new CONTAINER_MatterFab(aPlayerInventory, aBaseMetaTileEntity);
    }

    public void onConfigLoad(GT_Config aConfig) {
        super.onConfigLoad(aConfig);
        sDurationMultiplier = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUM_Duration_Multiplier", sDurationMultiplier);
        sUUAperUUM = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_per_UUM", sUUAperUUM);
        sUUASpeedBonus = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Speed_Bonus", sUUASpeedBonus);
        sRequiresUUA = aConfig.get((Object)ConfigCategories.machineconfig, "Massfabricator.UUA_Requirement", sRequiresUUA);
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList tItems = this.getStoredInputs();
        ArrayList tFluids = this.getStoredFluids();
        ItemStack[] tItemInputs = tItems.toArray(new ItemStack[tItems.size()]);
        FluidStack[] tFluidInputs = tFluids.toArray(new FluidStack[tFluids.size()]);
        GregtechMetaTileEntity_MassFabricator.init();
        return this.checkRecipeGeneric(tItemInputs, tFluidInputs, 4, 80L, 0, 10000);
    }

    public static void init() {
        if (!sInit) {
            if (mScrap[0] == null) {
                GregtechMetaTileEntity_MassFabricator.mScrap[0] = ItemUtils.getSimpleStack(ItemUtils.getItemFromFQRN("IC2:itemScrap"));
            }
            if (mScrap[1] == null) {
                GregtechMetaTileEntity_MassFabricator.mScrap[1] = ItemUtils.getSimpleStack(ItemUtils.getItemFromFQRN("IC2:itemScrapbox"));
            }
            if (mUU[0] == null) {
                GregtechMetaTileEntity_MassFabricator.mUU[0] = Materials.UUAmplifier.getFluid(100L);
            }
            if (mUU[1] == null) {
                GregtechMetaTileEntity_MassFabricator.mUU[1] = Materials.UUMatter.getFluid(100L);
            }
            sInit = true;
        }
    }

    public IStructureDefinition<GregtechMetaTileEntity_MassFabricator> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CC~CC", "CHHHC", "CHHHC", "CHHHC", "CCCCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_MassFabricator.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.GTPP_INDEX(9)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)9))})).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)8)).addElement('G', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)15)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 2, 3, 0) && this.mCasing >= 40 && this.checkHatch();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiMassFabricator;
    }

    @Override
    public int getAmountOfOutputs() {
        return 10;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_MassFabricator(this.mName);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mMode == 1 ? GT_Recipe.GT_Recipe_Map.sRecyclerRecipes : GTPP_Recipe.GTPP_Recipe_Map.sMatterFab2Recipes;
    }

    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        if (this.mMode == 1) {
            return this.checkRecipeScrap(aItemInputs, aFluidInputs, this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), aSpeedBonusPercent, aOutputChanceRoll);
        }
        return this.checkRecipeUU(aItemInputs, aFluidInputs, this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), aSpeedBonusPercent, aOutputChanceRoll);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkRecipeScrap(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        int parallelRecipes;
        ItemStack[] itemStackArray;
        if (aItemInputs == null || aItemInputs.length <= 0) {
            return false;
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        ItemStack aPotentialOutput = GT_ModHandler.getRecyclerOutput((ItemStack)GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aItemInputs[0]}), (int)0);
        ItemStack[] itemStackArray2 = new ItemStack[]{GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aItemInputs[0]})};
        if (aPotentialOutput == null) {
            itemStackArray = null;
        } else {
            ItemStack[] itemStackArray3 = new ItemStack[1];
            itemStackArray = itemStackArray3;
            itemStackArray3[0] = aPotentialOutput;
        }
        GTPP_Recipe tRecipe = new GTPP_Recipe(false, itemStackArray2, itemStackArray, null, new int[]{2000}, null, null, 40, MaterialUtils.getVoltageForTier(1), 0);
        float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes);
        if (aMaxParallelRecipes == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt && tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs); tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ". ");
        }
        this.log("Broke at " + parallelRecipes + ".");
        if (parallelRecipes > 0) {
            void var23_29;
            void var22_25;
            aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
            float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
            this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
            this.mEUt = (int)Math.ceil(tTotalEUt);
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            if (this.mEUt <= 16) {
                this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                this.mMaxProgresstime /= 1 << tTier - 1;
            } else {
                while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                    this.mEUt *= 4;
                    this.mMaxProgresstime /= 4;
                }
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
            for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
                if (tRecipe.getOutput(h) == null) continue;
                tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
                tOutputItems[h].field_77994_a = 0;
            }
            for (int f = 0; f < tOutputItems.length; ++f) {
                if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
                for (int g = 0; g < parallelRecipes; ++g) {
                    if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                    tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
                }
            }
            for (ItemStack itemStack : tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems)) {
                if (itemStack == null) continue;
                this.mScrapProduced += itemStack.field_77994_a;
            }
            ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
            Object[] g = tOutputItems;
            int n = g.length;
            boolean bl = false;
            while (var22_25 < n) {
                ItemStack itemStack = g[var22_25];
                while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                    ItemStack tmp = itemStack.func_77946_l();
                    tmp.field_77994_a = tmp.func_77976_d();
                    itemStack.field_77994_a -= itemStack.func_77976_d();
                    splitStacks.add(tmp);
                }
                ++var22_25;
            }
            if (splitStacks.size() > 0) {
                Object[] tmp = new ItemStack[splitStacks.size()];
                tmp = splitStacks.toArray(tmp);
                tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
            }
            ArrayList<Object> tSList = new ArrayList<Object>();
            Object[] objectArray = tOutputItems;
            int n2 = objectArray.length;
            boolean bl2 = false;
            while (var23_29 < n2) {
                Object tS = objectArray[var23_29];
                if (((ItemStack)tS).field_77994_a > 0) {
                    tSList.add(tS);
                }
                ++var23_29;
            }
            tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
            this.mOutputItems = tOutputItems;
            this.updateSlots();
            this.startProcess();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkRecipeUU(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        void var27_35;
        int parallelRecipes;
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.log("Running checkRecipeGeneric(0)");
        GT_Recipe tRecipe = this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        this.log("Running checkRecipeGeneric(1)");
        this.mLastRecipe = tRecipe;
        if (tRecipe == null) {
            this.log("BAD RETURN - 1");
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tVoltage: " + tVoltage);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt && tRecipe.isRecipeInputEqual(true, false, aFluidInputs, aItemInputs); tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        this.log("Broke at " + parallelRecipes + ".");
        if (parallelRecipes == 0) {
            this.log("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 4;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        int aMatterProduced = 0;
        int aAmplifierProduced = 0;
        int aScrapUsed = 0;
        int aAmplifierUsed = 0;
        for (int i = 0; i < parallelRecipes; ++i) {
            for (ItemStack itemStack : tRecipe.mInputs) {
                if (itemStack == null || !GT_Utility.areStacksEqual((ItemStack)itemStack, (ItemStack)mScrap[0], (boolean)true)) continue;
                aScrapUsed += itemStack.field_77994_a;
            }
            for (ItemStack itemStack : tRecipe.mFluidInputs) {
                if (itemStack == null || !GT_Utility.areFluidsEqual((FluidStack)itemStack, (FluidStack)mUU[0], (boolean)true)) continue;
                aAmplifierUsed += itemStack.amount;
            }
            for (ItemStack itemStack : tRecipe.mFluidOutputs) {
                if (itemStack != null && GT_Utility.areFluidsEqual((FluidStack)itemStack, (FluidStack)mUU[0], (boolean)true)) {
                    aAmplifierProduced += itemStack.amount;
                }
                if (itemStack == null || !GT_Utility.areFluidsEqual((FluidStack)itemStack, (FluidStack)mUU[1], (boolean)true)) continue;
                aMatterProduced += itemStack.amount;
            }
        }
        this.mMatterProduced += aMatterProduced;
        this.mAmplifierProduced += aAmplifierProduced;
        this.mScrapUsed += aScrapUsed;
        this.mAmplifierUsed += aAmplifierUsed;
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var27_35 < n) {
            Object tS = objectArray[var27_35];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var27_35;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        this.log("GOOD RETURN - 1");
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mMode == 1 ? 64 : 8 * Math.max(1, GT_Utility.getTier((long)this.getMaxInputVoltage()));
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 80;
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int aMode = this.mMode + 1;
        if (aMode > 1) {
            this.mMode = 0;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Matter/AmpliFabricator");
        } else if (aMode == 1) {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        } else {
            this.mMode = 1;
            PlayerUtils.messagePlayer(aPlayer, "Mode [" + this.mMode + "]: Recycler");
        }
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mScrapProduced", this.mScrapProduced);
        aNBT.func_74768_a("mAmplifierProduced", this.mAmplifierProduced);
        aNBT.func_74768_a("mMatterProduced", this.mMatterProduced);
        aNBT.func_74768_a("mScrapUsed", this.mScrapUsed);
        aNBT.func_74768_a("mAmplifierUsed", this.mAmplifierUsed);
        aNBT.func_74768_a("mMode", this.mMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mScrapProduced = aNBT.func_74762_e("mScrapProduced");
        this.mAmplifierProduced = aNBT.func_74762_e("mAmplifierProduced");
        this.mMatterProduced = aNBT.func_74762_e("mMatterProduced");
        this.mScrapUsed = aNBT.func_74762_e("mScrapUsed");
        this.mAmplifierUsed = aNBT.func_74762_e("mAmplifierUsed");
        this.mMode = aNBT.func_74762_e("mMode");
        super.loadNBTData(aNBT);
    }
}

