/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialRockBreaker
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialRockBreaker>
implements ISurvivalConstructable {
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialRockBreaker> STRUCTURE_DEFINITION = null;
    private static final GT_Recipe.GT_Recipe_Map sFakeRecipeMap = new GT_Recipe.GT_Recipe_Map(new HashSet(0), "gt.recipe.fakerockbreaker", "Rock Breaker", "smelting", "gregtech:textures/gui/basicmachines/E_Furnace", 1, 1, 0, 0, 1, "", 1, "", true, false);
    private static GT_Recipe sRecipe_Cobblestone;
    private static GT_Recipe sRecipe_SmoothStone;
    private static GT_Recipe sRecipe_Redstone;

    public GregtechMetaTileEntity_IndustrialRockBreaker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialRockBreaker(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialRockBreaker(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Rock Breaker";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Rock Breaker").addInfo("Speed: +200% | EU Usage: 75% | Parallel: Tier x 8").addInfo("Circuit goes in the GUI slot").addInfo("1 = cobble, 2 = stone, 3 = obsidian").addInfo("Supply Water/Lava").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 4, 3, true).addController("Bottom Center").addCasingInfo("Thermal Processing Casing", 9).addCasingInfo("Thermal Containment Casing", 16).addInputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialRockBreaker> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialRockBreaker.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.GTPP_INDEX(16)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)0))})).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)11)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        boolean aCheckPiece = this.checkPiece(this.mName, 1, 3, 0);
        boolean aCasingCount = this.mCasing >= 9;
        boolean aCheckHatch = this.checkHatch();
        this.log("" + aCheckPiece + ", " + aCasingCount + ", " + aCheckHatch);
        return aCheckPiece && aCasingCount && aCheckHatch;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(208);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(16);
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "ElectricBlastFurnace";
    }

    private static void generateRecipeMap() {
        if (sRecipe_Cobblestone == null || sRecipe_SmoothStone == null || sRecipe_Redstone == null) {
            GregtechMetaTileEntity_IndustrialRockBreaker.generateRecipes();
        }
        FluidStack[] aInputFluids = new FluidStack[]{FluidUtils.getWater(1000), FluidUtils.getLava(1000)};
        GT_Recipe aTemp = sRecipe_Cobblestone.copy();
        aTemp.mFluidInputs = aInputFluids;
        sFakeRecipeMap.add(aTemp);
        aTemp = sRecipe_SmoothStone.copy();
        aTemp.mFluidInputs = aInputFluids;
        sFakeRecipeMap.add(aTemp);
        aTemp = sRecipe_Redstone.copy();
        aTemp.mFluidInputs = aInputFluids;
        sFakeRecipeMap.add(aTemp);
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (GregtechMetaTileEntity_IndustrialRockBreaker.sFakeRecipeMap.mRecipeList.isEmpty()) {
            GregtechMetaTileEntity_IndustrialRockBreaker.generateRecipeMap();
        }
        return sFakeRecipeMap;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private static final void generateRecipes() {
        sRecipe_Cobblestone = new GTPP_Recipe(false, new ItemStack[]{CI.getNumberedCircuit(1)}, new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150347_e)}, null, new int[]{10000}, null, null, 16, 32, 0);
        sRecipe_SmoothStone = new GTPP_Recipe(false, new ItemStack[]{CI.getNumberedCircuit(2)}, new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150348_b)}, null, new int[]{10000}, null, null, 16, 32, 0);
        sRecipe_Redstone = new GTPP_Recipe(false, new ItemStack[]{CI.getNumberedCircuit(3), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Redstone, (long)1L)}, new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150343_Z)}, null, new int[]{10000}, null, null, 128, 32, 0);
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList aFluids = this.getStoredFluids();
        if (!aFluids.isEmpty()) {
            void var30_36;
            float tTotalEUt;
            int parallelRecipes;
            boolean aHasWater = false;
            boolean aHasLava = false;
            for (FluidStack aFluid : aFluids) {
                if (aFluid.getFluid() == FluidRegistry.WATER) {
                    aHasWater = true;
                    continue;
                }
                if (aFluid.getFluid() != FluidRegistry.LAVA) continue;
                aHasLava = true;
            }
            ArrayList<ItemStack> aItems = this.getStoredInputs();
            boolean aHasRedstone = false;
            if (!aItems.isEmpty()) {
                for (ItemStack aItem : aItems) {
                    if (!GT_Utility.areStacksEqual((ItemStack)aItem, (ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Redstone, (long)1L))) continue;
                    aHasRedstone = true;
                    break;
                }
            }
            if (!aHasWater || !aHasLava) {
                this.log("BAD RETURN - 0-1");
                return false;
            }
            ItemStack aGuiCircuit = this.getGUIItemStack();
            if (aGuiCircuit == null || !ItemUtils.isControlCircuit(aGuiCircuit)) {
                this.log("BAD RETURN - 0-2");
                return false;
            }
            if (sRecipe_Cobblestone == null || sRecipe_SmoothStone == null || sRecipe_Redstone == null) {
                GregtechMetaTileEntity_IndustrialRockBreaker.generateRecipes();
            }
            int aCircuit = aGuiCircuit.func_77960_j();
            GT_Recipe tRecipe = null;
            switch (aCircuit) {
                case 1: {
                    tRecipe = sRecipe_Cobblestone;
                    break;
                }
                case 2: {
                    tRecipe = sRecipe_SmoothStone;
                    break;
                }
                case 3: {
                    if (!aHasRedstone) break;
                    tRecipe = sRecipe_Redstone;
                }
            }
            if (tRecipe == null) {
                this.log("BAD RETURN - 0-3");
                return false;
            }
            ItemStack[] aItemInputs = aItems.toArray(new ItemStack[aItems.size()]);
            FluidStack[] aFluidInputs = new FluidStack[]{};
            this.mEUt = 0;
            this.mMaxProgresstime = 0;
            this.mOutputItems = new ItemStack[0];
            this.mOutputFluids = new FluidStack[0];
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
            long tEnergy = this.getMaxInputEnergy();
            this.log("Running checkRecipeGeneric(0)");
            this.log("Running checkRecipeGeneric(1)");
            this.mLastRecipe = tRecipe;
            int aMaxParallelRecipes = this.getMaxParallelRecipes();
            int aEUPercent = this.getEuDiscountForParallelism();
            int aSpeedBonusPercent = 200;
            aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes);
            if (aMaxParallelRecipes == 0) {
                this.log("BAD RETURN - 2");
                return false;
            }
            float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
            this.log("parallelRecipes: " + parallelRecipes);
            this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
            this.log("tTotalEUt: " + tTotalEUt);
            this.log("tVoltage: " + tVoltage);
            this.log("tRecipeEUt: " + tRecipeEUt);
            if (aItems.size() > 0 && aCircuit == 3) {
                for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt && this.depleteInput(tRecipe.mInputs[1]); tTotalEUt += tRecipeEUt, ++parallelRecipes) {
                    this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
                }
            } else if (aCircuit >= 1 && aCircuit <= 2) {
                for (tTotalEUt = 0.0f; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
                    this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
                }
            }
            this.log("Broke at " + parallelRecipes + ".");
            if (parallelRecipes == 0) {
                this.log("BAD RETURN - 3");
                return false;
            }
            aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
            float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
            this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
            this.mEUt = (int)Math.ceil(tTotalEUt);
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            if (this.mEUt <= 16) {
                this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                this.mMaxProgresstime /= 1 << tTier - 1;
            } else {
                while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                    this.mEUt *= 4;
                    this.mMaxProgresstime /= 2;
                }
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
            for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
                if (tRecipe.getFluidOutput(h) == null) continue;
                tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
                tOutputFluids[h].amount *= parallelRecipes;
            }
            Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
            for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
                if (tRecipe.getOutput(h) == null) continue;
                tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
                tOutputItems[h].field_77994_a = 0;
            }
            for (int f = 0; f < tOutputItems.length; ++f) {
                if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
                for (int g = 0; g < parallelRecipes; ++g) {
                    if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= tRecipe.getOutputChance(f)) continue;
                    tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
                }
            }
            tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
            ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : tOutputItems) {
                while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                    ItemStack tmp = itemStack.func_77946_l();
                    tmp.field_77994_a = tmp.func_77976_d();
                    itemStack.field_77994_a -= itemStack.func_77976_d();
                    splitStacks.add(tmp);
                }
            }
            if (splitStacks.size() > 0) {
                Object[] tmp = new ItemStack[splitStacks.size()];
                tmp = splitStacks.toArray(tmp);
                tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
            }
            ArrayList<Object> tSList = new ArrayList<Object>();
            Object[] objectArray = tOutputItems;
            int n = objectArray.length;
            boolean bl = false;
            while (var30_36 < n) {
                Object tS = objectArray[var30_36];
                if (((ItemStack)tS).field_77994_a > 0) {
                    tSList.add(tS);
                }
                ++var30_36;
            }
            tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
            this.mOutputItems = tOutputItems;
            this.mOutputFluids = tOutputFluids;
            this.updateSlots();
            this.startProcess();
            this.log("GOOD RETURN - 1");
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 75;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialRockBreaker;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 2;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList aInputs = super.getStoredInputs();
        if (this.hasSlotInGUI() && this.getGUIItemStack() != null) {
            aInputs.add(this.getGUIItemStack());
        }
        return aInputs;
    }
}

