/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_AlloyBlastSmelter
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_AlloyBlastSmelter>
implements ISurvivalConstructable {
    private int mMode = 0;
    private boolean isUsingControllerCircuit = false;
    private boolean isBussesSeparate = false;
    private static Item circuit;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_AlloyBlastSmelter> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_AlloyBlastSmelter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_AlloyBlastSmelter(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_AlloyBlastSmelter(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Fluid Alloy Cooker";
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("isBussesSeparate", this.isBussesSeparate);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.isBussesSeparate = aNBT.func_74767_n("isBussesSeparate");
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Alloy Blast Smelter").addInfo("20% Faster than the Electric Blast Furnace").addInfo("Allows Complex GT++ alloys to be created").addInfo("Accepts only one Energy Hatch").addInfo("Circuit for recipe goes in the Input Bus or GUI slot").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 4, 3, true).addController("Bottom Center").addCasingInfo("Blast Smelter Casings", 5).addCasingInfo("Blast Smelter Heat Containment Coils", 16).addInputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_AlloyBlastSmelter> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_AlloyBlastSmelter.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.GTPP_INDEX(15)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)15))})).addElement('H', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)14)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 3, 0) && this.mCasing >= 5 && this.mEnergyHatches.size() == 1 && this.checkHatch();
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(208);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(15);
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "ElectricBlastFurnace";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sAlloyBlastSmelterRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (circuit == null) {
                circuit = CI.getNumberedCircuit(0).func_77973_b();
            }
            if (aStack != null && aStack.func_77973_b() == circuit) {
                this.mMode = aStack.func_77960_j();
                this.isUsingControllerCircuit = true;
                return true;
            }
            if (aStack == null) {
                this.isUsingControllerCircuit = false;
                return true;
            }
            Logger.WARNING("Not circuit in GUI inputs.");
            this.isUsingControllerCircuit = false;
            return false;
        }
        Logger.WARNING("No Circuit, clientside.");
        this.isUsingControllerCircuit = false;
        return false;
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            ArrayList<ItemStack> tInputList = null;
            this.isUsingControllerCircuit = this.isCorrectMachinePart(aStack);
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
            ItemStack[] tInputs = null;
            FluidStack[] tFluids = this.getCompactedFluids();
            GT_Recipe tRecipe = null;
            if (this.isBussesSeparate) {
                for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
                    tInputList = new ArrayList<ItemStack>();
                    tBus.mRecipeMap = this.getRecipeMap();
                    if (GregtechMetaTileEntity_AlloyBlastSmelter.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                        for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                            if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                            tInputList.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                        }
                    }
                    tInputs = tInputList.toArray(new ItemStack[0]);
                    tRecipe = GTPP_Recipe.GTPP_Recipe_Map.sAlloyBlastSmelterRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
                    if (tRecipe == null) continue;
                    break;
                }
            } else {
                tInputList = this.getStoredInputs();
                block2: for (int i = 0; i < tInputList.size() - 1; ++i) {
                    for (int j = i + 1; j < tInputList.size(); ++j) {
                        if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tInputList.get(i)), (ItemStack)((ItemStack)tInputList.get(j)))) continue;
                        if (((ItemStack)tInputList.get((int)i)).field_77994_a >= ((ItemStack)tInputList.get((int)j)).field_77994_a) {
                            tInputList.remove(j--);
                            continue;
                        }
                        tInputList.remove(i--);
                        continue block2;
                    }
                }
                tInputs = tInputList.toArray(new ItemStack[0]);
                tRecipe = GTPP_Recipe.GTPP_Recipe_Map.sAlloyBlastSmelterRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            }
            if (this.isUsingControllerCircuit && tInputList.size() < 1 || !this.isUsingControllerCircuit && tInputList.size() < 2) {
                Logger.WARNING("Not enough inputs.");
                return false;
            }
            if (this.isUsingControllerCircuit && tInputList.size() >= 1) {
                tInputList.add(CI.getNumberedCircuit(this.mMode));
            }
            if (tInputList.size() > 1 && tRecipe != null && tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                Logger.WARNING("Found some Valid Inputs.");
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                if (tRecipe.mEUt <= 16) {
                    this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                    this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
                } else {
                    this.mEUt = tRecipe.mEUt;
                    this.mMaxProgresstime = tRecipe.mDuration;
                    while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                        this.mEUt *= 4;
                        this.mMaxProgresstime /= 2;
                    }
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
                ArrayList<ItemStack> tOutPutItems = new ArrayList<ItemStack>();
                for (ItemStack tOut : tRecipe.mOutputs) {
                    if (!ItemUtils.checkForInvalidItems(tOut)) continue;
                    tOutPutItems.add(tOut);
                }
                if (tOutPutItems.size() > 0) {
                    this.mOutputItems = tOutPutItems.toArray(new ItemStack[tOutPutItems.size()]);
                }
                this.updateSlots();
                return true;
            }
        }
        Logger.WARNING("Failed to find some Valid Inputs or Clientside.");
        return false;
    }

    public boolean onWireCutterRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.isBussesSeparate = !this.isBussesSeparate;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.isBussesSeparate));
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiABS;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 2;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

