/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.nuclear.NUCLIDE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMTE_NuclearReactor
extends GregtechMeta_MultiBlockBase<GregtechMTE_NuclearReactor>
implements ISurvivalConstructable {
    protected int mFuelRemaining = 0;
    private int mCasing;
    private IStructureDefinition<GregtechMTE_NuclearReactor> STRUCTURE_DEFINITION = null;

    public GregtechMTE_NuclearReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_NuclearReactor(String aName) {
        super(aName);
    }

    public long maxEUStore() {
        return 640000000L * (long)Math.min(16, this.mEnergyHatches.size()) / 16L;
    }

    @Override
    public String getMachineType() {
        return "Reactor";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sLiquidFluorineThoriumReactorRecipes;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Liquid Fluoride Thorium Reactor.").addInfo("Produces Heat & Energy from Radioactive Beta Decay.").addInfo("Input Li2BeF4 and a molten salt as fuel, and match the 4 Dynamo Hatches:").addInfo("LFTR Fuel 1 (4 IV amps), LFTR Fuel 2 (4 LuV amps), LFTR Fuel 3 (4 ZPM amps)").addInfo("Outputs U233 every 10 seconds, on average, while the reactor is running").addInfo("Check NEI to see the other outputs - they differ between fuels").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(7, 4, 7, true).addController("Bottom Center").addCasingInfo("Hastelloy-N Reactor Casing", 27).addCasingInfo("Zeron-100 Reactor Shielding", 26).addInputHatch("Top or bottom layer edges", new int[]{1}).addOutputHatch("Top or bottom layer edges", new int[]{1}).addDynamoHatch("Top or bottom layer edges", new int[]{1}).addMaintenanceHatch("Top or bottom layer edges", new int[]{1}).addMufflerHatch("Top 3x3", new int[]{2}).addStructureInfo("All dynamos must be between EV and LuV tier.").addStructureInfo("All other hatches must be IV+ tier.").addStructureInfo("3x Output Hatches, 2x Input Hatches, 4x Dynamo Hatches").addStructureInfo("2x Maintenance Hatches, 4x Mufflers").toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    @Override
    public String[] getExtraInfoData() {
        String tRunning = this.mMaxProgresstime > 0 ? "Reactor running" : "Reactor stopped";
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance";
        return new String[]{"Liquid Fluoride Thorium Reactor", tRunning, tMaintainance, "Current Output: " + this.mEUt + " EU/t", "Fuel Remaining: " + this.mFuelRemaining + " Litres", "Current Efficiency: " + this.mEfficiency / 5 + "%", "Current Efficiency (Raw): " + this.mEfficiency, "It requires you to have 100% Efficiency."};
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        boolean aWarmedUp;
        boolean bl = aWarmedUp = this.mEfficiency == this.getMaxEfficiency(null);
        if (!aBaseMetaTileEntity.isActive() || !aWarmedUp) {
            if (aSide == aFacing) {
                if (aActive) {
                    return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(12)), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR_ACTIVE}).extFacing().build()};
                }
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(12)), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR}).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(12))};
        }
        if (aBaseMetaTileEntity.isActive() && aWarmedUp) {
            if (aSide == aFacing) {
                if (aActive) {
                    return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(13)), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR_ACTIVE}).extFacing().build()};
                }
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(13)), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_REPLICATOR}).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(13))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(12))};
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "MatterFabricator";
    }

    public final boolean addNuclearReactorEdgeList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo && ((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity).mTier >= 4 && ((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity).mTier <= 6) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input && ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mTier >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output && ((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity).mTier >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addNuclearReactorTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler && ((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity).mTier >= 5) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public IStructureDefinition<GregtechMTE_NuclearReactor> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCCCCCC", "COOOOOC", "COXXXOC", "COXXXOC", "COXXXOC", "COOOOOC", "CCCCCCC"}, {"GGGGGGG", "G-----G", "G-----G", "G-----G", "G-----G", "G-----G", "GGGGGGG"}, {"GGGGGGG", "G-----G", "G-----G", "G-----G", "G-----G", "G-----G", "GGGGGGG"}, {"CCC~CCC", "COOOOOC", "COOOOOC", "COOOOOC", "COOOOOC", "COOOOOC", "CCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMTE_NuclearReactor.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance}).casingIndex(TAE.GTPP_INDEX(12)).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_NuclearReactor.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).adder(GregtechMTE_NuclearReactor::addNuclearReactorEdgeList).hatchItemFilterAnd(t -> GT_StructureUtility.filterByMTETier((int)5, (int)Integer.MAX_VALUE)).casingIndex(TAE.GTPP_INDEX(12)).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_NuclearReactor.class).atLeast(new IHatchElement[]{GT_HatchElement.Dynamo}).adder(GregtechMTE_NuclearReactor::addNuclearReactorEdgeList).hatchItemFilterAnd(t -> GT_StructureUtility.filterByMTETier((int)4, (int)6)).casingIndex(TAE.GTPP_INDEX(12)).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)12))})).addElement('X', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMTE_NuclearReactor.class).atLeast(new IHatchElement[]{GT_HatchElement.Muffler}).adder(GregtechMTE_NuclearReactor::addNuclearReactorTopList).hatchItemFilterAnd(t -> GT_StructureUtility.filterByMTETier((int)5, (int)Integer.MAX_VALUE)).casingIndex(TAE.GTPP_INDEX(12)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)12))})).addElement('O', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)12)).addElement('G', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)13)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        if (this.checkPiece(this.mName, 3, 3, 0) && this.mCasing >= 27 && this.mOutputHatches.size() >= 3 && this.mInputHatches.size() >= 2 && this.mDynamoHatches.size() == 4 && this.mMufflerHatches.size() == 4 && this.mMaintenanceHatches.size() == 2) {
            this.mWrench = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mHardHammer = true;
            this.mSolderingTool = true;
            this.mCrowbar = true;
            this.turnCasingActive(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_NuclearReactor(this.mName);
    }

    public boolean turnCasingActive(boolean status) {
        if (this.mDynamoHatches != null) {
            for (GT_MetaTileEntity_Hatch_Dynamo hatch : this.mDynamoHatches) {
                hatch.mMachineBlock = status ? (byte)TAE.GTPP_INDEX(13) : (byte)TAE.GTPP_INDEX(12);
            }
        }
        if (this.mMufflerHatches != null) {
            for (GT_MetaTileEntity_Hatch_Dynamo hatch : this.mMufflerHatches) {
                hatch.mMachineBlock = status ? (byte)TAE.GTPP_INDEX(13) : (byte)TAE.GTPP_INDEX(12);
            }
        }
        if (this.mOutputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Dynamo hatch : this.mOutputHatches) {
                hatch.mMachineBlock = status ? (byte)TAE.GTPP_INDEX(13) : (byte)TAE.GTPP_INDEX(12);
            }
        }
        if (this.mInputHatches != null) {
            for (GT_MetaTileEntity_Hatch_Dynamo hatch : this.mInputHatches) {
                hatch.mMachineBlock = status ? (byte)TAE.GTPP_INDEX(13) : (byte)TAE.GTPP_INDEX(12);
            }
        }
        if (this.mMaintenanceHatches != null) {
            for (GT_MetaTileEntity_Hatch_Dynamo hatch : this.mMaintenanceHatches) {
                hatch.mMachineBlock = status ? (byte)TAE.GTPP_INDEX(13) : (byte)TAE.GTPP_INDEX(12);
            }
        }
        return true;
    }

    public FluidStack[] getStoredFluidsAsArray() {
        return this.getStoredFluids().toArray(new FluidStack[0]);
    }

    public int getStoredFuel(GT_Recipe aRecipe) {
        int aFuelStored = 0;
        FluidStack aFuelFluid = null;
        for (FluidStack aFluidInput : aRecipe.mFluidInputs) {
            if (aFluidInput.getFluid().equals(NUCLIDE.Li2BeF4.getFluid())) continue;
            aFuelFluid = aFluidInput;
            break;
        }
        if (aFuelFluid != null) {
            for (GT_MetaTileEntity_Hatch_Input aInputHatch : this.mInputHatches) {
                if (aInputHatch.getFluid() == null || aInputHatch.getFluidAmount() <= 0 || !aInputHatch.getFluid().isFluidEqual(aFuelFluid)) continue;
                aFuelStored += aInputHatch.getFluidAmount();
            }
        }
        return aFuelStored;
    }

    public boolean checkRecipe(ItemStack aStack) {
        Logger.WARNING("Checking LFTR recipes.");
        if (this.mEfficiency < this.getMaxEfficiency(null)) {
            this.mOutputItems = new ItemStack[0];
            this.mOutputFluids = new FluidStack[0];
            this.mProgresstime = 0;
            this.mMaxProgresstime = 1;
            this.mEfficiencyIncrease = 2;
            Logger.WARNING("Warming Up! " + this.mEfficiency + "/" + this.getMaxEfficiency(null));
            return true;
        }
        Logger.WARNING("Warmed up, checking LFTR recipes.");
        FluidStack[] tFluids = this.getStoredFluidsAsArray();
        Collection tRecipeList = this.getRecipeMap().mRecipeList;
        if (tFluids.length > 0 && tRecipeList != null && tRecipeList.size() > 0) {
            Logger.WARNING("Found more than one input fluid and a list of valid recipes.");
            GT_Recipe aFuelProcessing = this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, true, 0L, tFluids, new ItemStack[0]);
            if (aFuelProcessing == null) {
                Logger.WARNING("Did not find valid recipe for given inputs.");
                return false;
            }
            Logger.WARNING("Found recipe? " + (aFuelProcessing != null ? "true" : "false"));
            for (FluidStack aFluidInput : aFuelProcessing.mFluidInputs) {
                Logger.WARNING("Using " + aFluidInput.getLocalizedName());
            }
            this.mEUt = 0;
            this.mMaxProgresstime = 0;
            this.mOutputItems = new ItemStack[0];
            this.mOutputFluids = new FluidStack[0];
            this.mLastRecipe = aFuelProcessing;
            if (aFuelProcessing.mFluidInputs.length > 0) {
                for (FluidStack aInputToConsume : aFuelProcessing.mFluidInputs) {
                    Logger.WARNING("Depleting " + aInputToConsume.getLocalizedName() + " - " + aInputToConsume.amount + "L");
                    this.depleteInput(aInputToConsume);
                }
            }
            this.mMaxProgresstime = aFuelProcessing.mDuration;
            this.mEUt = aFuelProcessing.mSpecialValue * 4;
            Logger.WARNING("Outputting " + this.mEUt + "eu/t");
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            Logger.WARNING("Recipe time: " + this.mMaxProgresstime);
            this.mFuelRemaining = this.getStoredFuel(aFuelProcessing);
            this.mOutputFluids = (FluidStack[])aFuelProcessing.mFluidOutputs.clone();
            this.updateSlots();
            Logger.WARNING("Recipe Good!");
            return true;
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        Logger.WARNING("Recipe Bad!");
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    @Override
    public void explodeMultiblock() {
        this.mInventory[1] = null;
        long explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
        for (MetaTileEntity tTileEntity : this.mInputBusses) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mOutputBusses) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mInputHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mOutputHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mDynamoHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mMufflerHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mEnergyHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        for (MetaTileEntity tTileEntity : this.mMaintenanceHatches) {
            explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
            tTileEntity.getBaseMetaTileEntity().doExplosion(explodevalue);
        }
        explodevalue = MathUtils.randLong(Integer.MAX_VALUE, 0x1FFFFFFFCL);
        this.getBaseMetaTileEntity().doExplosion(explodevalue);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.getWorld().field_72995_K) {
            if (aBaseMetaTileEntity.isActive()) {
                if (this.mEfficiency == this.getMaxEfficiency(null)) {
                    this.turnCasingActive(true);
                } else {
                    this.turnCasingActive(false);
                }
            } else {
                this.turnCasingActive(false);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEfficiency == this.getMaxEfficiency(null) && MathUtils.randInt(1, 300) == 1) {
            this.addOutput(ELEMENT.getInstance().URANIUM233.getFluidStack(MathUtils.randInt(1, 10)));
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFuelRemaining", this.mFuelRemaining);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFuelRemaining = aNBT.func_74762_e("mFuelRemaining");
        super.loadNBTData(aNBT);
    }
}

