/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Element;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_ElementalDataOrbHolder;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMTE_ElementalDuplicator
extends GregtechMeta_MultiBlockBase<GregtechMTE_ElementalDuplicator> {
    private final ArrayList<GT_MetaTileEntity_Hatch_ElementalDataOrbHolder> mReplicatorDataOrbHatches = new ArrayList();
    private static final int CASING_TEXTURE_ID = TAE.getIndexFromPage(0, 3);
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private IStructureDefinition<GregtechMTE_ElementalDuplicator> STRUCTURE_DEFINITION = null;

    public GregtechMTE_ElementalDuplicator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_ElementalDuplicator(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_ElementalDuplicator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Replicator";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Produces Elemental Material from UU Matter").addInfo("Speed: +100% | EU Usage: 100% | Parallel: 8 * Tier").addInfo("Maximum 1x of each bus/hatch.").addInfo("Does not require both Output Hatch & Bus").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(9, 6, 9, true).addController("Top Center").addCasingInfo("Elemental Confinement Shell", 138).addCasingInfo("Matter Fabricator Casing", 24).addCasingInfo("Particle Containment Casing", 24).addCasingInfo("Matter Generation Coil", 24).addCasingInfo("High Voltage Current Capacitor", 20).addCasingInfo("Resonance Chamber III", 24).addCasingInfo("Modulator III", 16).addOtherStructurePart("Data Orb Repository", "1x", new int[]{1}).addInputHatch("Any 1 dot hint", new int[]{1}).addOutputBus("Any 1 dot hint", new int[]{1}).addOutputHatch("Any 1 dot hint", new int[]{1}).addEnergyHatch("Any 1 dot hint", new int[]{1}).addMaintenanceHatch("Any 1 dot hint", new int[]{1}).addMufflerHatch("Any 1 dot hint", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMTE_ElementalDuplicator> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"   ccc   ", "  ccccc  ", " ccccccc ", "ccchhhccc", "ccch~hccc", "ccchhhccc", " ccccccc ", "  ccccc  ", "   ccc   "}, {"   cac   ", "  abfba  ", " abfgfba ", "cbfgdgfbc", "afgdddgfa", "cbfgdgfbc", " abfgfba ", "  abfba  ", "   cac   "}, {"   cec   ", "  e   e  ", " e     e ", "c   d   c", "e  ddd  e", "c   d   c", " e     e ", "  e   e  ", "   cec   "}, {"   cec   ", "  e   e  ", " e     e ", "c   d   c", "e  ddd  e", "c   d   c", " e     e ", "  e   e  ", "   cec   "}, {"   cac   ", "  abfba  ", " abfgfba ", "cbfgdgfbc", "afgdddgfa", "cbfgdgfbc", " abfgfba ", "  abfba  ", "   cac   "}, {"   ccc   ", "  ccccc  ", " ccccccc ", "ccchhhccc", "ccchhhccc", "ccchhhccc", " ccccccc ", "  ccccc  ", "   ccc   "}}).addElement('a', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock4(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta6())).addElement('b', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock4(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta7())).addElement('d', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock2(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta2())).addElement('e', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock2(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta3())).addElement('f', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock3(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta4())).addElement('g', StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock3(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta5())).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta())))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(GregtechMTE_ElementalDuplicator.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Muffler, GT_HatchElement.Energy}).casingIndex(GregtechMTE_ElementalDuplicator.getCasingTextureIndex()).dot(1).build(), GT_StructureUtility.buildHatchAdder(GregtechMTE_ElementalDuplicator.class).hatchClass(GT_MetaTileEntity_Hatch_ElementalDataOrbHolder.class).adder(GregtechMTE_ElementalDuplicator::addDataOrbHatch).casingIndex(GregtechMTE_ElementalDuplicator.getCasingTextureIndex()).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregtechMTE_ElementalDuplicator.getCasingBlock(), (int)GregtechMTE_ElementalDuplicator.getCasingMeta()))}))).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 4, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        boolean aDidBuild = this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 4, 0);
        if (this.mInputHatches.size() != 1 || this.mOutputBusses.size() != 1 && this.mOutputHatches.size() != 0 || this.mEnergyHatches.size() != 1 || this.mReplicatorDataOrbHatches.size() != 1) {
            return false;
        }
        this.log("Casings: " + this.mCasing);
        return aDidBuild && this.mCasing >= 138 && this.checkHatch();
    }

    protected static int getCasingTextureIndex() {
        return CASING_TEXTURE_ID;
    }

    protected static Block getCasingBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    protected static Block getCasingBlock2() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    protected static Block getCasingBlock3() {
        return ModBlocks.blockSpecialMultiCasings2;
    }

    protected static Block getCasingBlock4() {
        return ModBlocks.blockCasingsMisc;
    }

    protected static int getCasingMeta() {
        return 3;
    }

    protected static int getCasingMeta2() {
        return 12;
    }

    protected static int getCasingMeta3() {
        return 13;
    }

    protected static int getCasingMeta4() {
        return 2;
    }

    protected static int getCasingMeta5() {
        return 6;
    }

    protected static int getCasingMeta6() {
        return 9;
    }

    protected static int getCasingMeta7() {
        return 8;
    }

    private boolean addDataOrbHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_ElementalDataOrbHolder) {
            try {
                ((GT_MetaTileEntity_Hatch_ElementalDataOrbHolder)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
                return this.addToMachineListInternal(this.mReplicatorDataOrbHatches, aMetaTileEntity, aBaseCasingIndex);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sElementalDuplicatorRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), 100L, 100);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        void var25_35;
        int parallelRecipes;
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.log("Running checkRecipeGeneric(0)");
        GT_Recipe tRecipe = null;
        try {
            this.log("Checking " + aItemInputs.length + " Data Orbs");
            for (int i = 0; i < aItemInputs.length; ++i) {
                ItemStack aItem = aItemInputs[i];
                this.log("Found: " + aItem.func_82833_r());
            }
            ItemStack aDataOrbStack = null;
            block3: for (GT_Recipe nRecipe : this.getRecipeMap().mRecipeList) {
                ItemStack aTempStack = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(nRecipe);
                if (aTempStack == null) continue;
                for (ItemStack aItem : aItemInputs) {
                    if (nRecipe.mSpecialItems == null || !GT_Utility.areStacksEqual((ItemStack)aTempStack, (ItemStack)aItem, (boolean)false)) continue;
                    Materials tMaterial = (Materials)Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)aTempStack)).mLinkedMaterials.get(0);
                    this.log("Found: " + aTempStack.func_82833_r() + " for " + tMaterial.name());
                    aDataOrbStack = aTempStack;
                    break block3;
                }
            }
            if (aDataOrbStack != null) {
                tRecipe = this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, false, GT_Values.V[tTier], aFluidInputs, aDataOrbStack, aItemInputs);
                if (tRecipe != null) {
                    Materials tMaterial = (Materials)Element.get((String)Behaviour_DataOrb.getDataName(aDataOrbStack)).mLinkedMaterials.get(0);
                    this.log("Found recipe for " + tMaterial.name());
                } else {
                    this.log("No Recipe Found");
                }
            } else {
                this.log("Null DO");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.log("Running checkRecipeGeneric(1)");
        this.mLastRecipe = tRecipe;
        if (tRecipe == null) {
            this.log("BAD RETURN - 1");
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        float tRecipeEUt = (float)((long)tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tVoltage: " + tVoltage);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                this.log("Broke at " + parallelRecipes + ".");
                break;
            }
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            this.log("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 4;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var25_35 < n) {
            Object tS = objectArray[var25_35];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var25_35;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        this.log("GOOD RETURN - 1");
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiMolecularTransformer;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().getFrontFacing() != 1) {
            this.getBaseMetaTileEntity().setFrontFacing((byte)1);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mReplicatorDataOrbHatches.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList tItems = super.getStoredInputs();
        for (GT_MetaTileEntity_Hatch_ElementalDataOrbHolder tHatch : this.mReplicatorDataOrbHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GregtechMTE_ElementalDuplicator.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            tItems.addAll(tHatch.getInventory());
        }
        tItems.removeAll(Collections.singleton(null));
        return tItems;
    }

    @Override
    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
        ItemStack aRecipeSpecial;
        Collection tRecipes;
        int n;
        GT_Recipe.GT_Recipe_Map mRecipeMap = this.getRecipeMap();
        if (mRecipeMap.mRecipeList.isEmpty()) {
            return null;
        }
        if (GregTech_API.sPostloadFinished) {
            int n2;
            FluidStack[] fluidStackArray;
            int tAmount;
            if (mRecipeMap.mMinimalInputFluids > 0) {
                if (aFluids == null) {
                    return null;
                }
                tAmount = 0;
                fluidStackArray = aFluids;
                n = fluidStackArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    FluidStack aFluid = fluidStackArray[n2];
                    if (aFluid == null) continue;
                    ++tAmount;
                }
                if (tAmount < mRecipeMap.mMinimalInputFluids) {
                    return null;
                }
            }
            if (mRecipeMap.mMinimalInputItems > 0) {
                if (aInputs == null) {
                    return null;
                }
                tAmount = 0;
                fluidStackArray = aInputs;
                n = fluidStackArray.length;
                for (n2 = 0; n2 < n; ++n2) {
                    FluidStack aInput = fluidStackArray[n2];
                    if (aInput == null) continue;
                    ++tAmount;
                }
                if (tAmount < mRecipeMap.mMinimalInputItems) {
                    return null;
                }
            }
        }
        if (aNotUnificated) {
            aInputs = GT_OreDictUnificator.getStackArray((boolean)true, (Object[])aInputs);
        }
        if (aRecipe != null) {
            ItemStack aRecipeSpecial2 = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(aRecipe);
            if (!aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) && GT_Utility.areStacksEqual((ItemStack)aRecipeSpecial2, (ItemStack)aSpecialSlot, (boolean)false) && GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial2, aSpecialSlot)) {
                return aRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)aRecipe.mEUt ? aRecipe : null;
            }
        }
        if (mRecipeMap.mUsualInputCount > 0 && aInputs != null) {
            ItemStack[] itemStackArray = aInputs;
            int n3 = itemStackArray.length;
            for (n = 0; n < n3; ++n) {
                ItemStack tStack = itemStackArray[n];
                if (tStack == null) continue;
                tRecipes = (Collection)mRecipeMap.mRecipeItemMap.get(new GT_ItemStack(tStack));
                if (tRecipes != null) {
                    for (GT_Recipe tRecipe : tRecipes) {
                        if (!tRecipe.mFakeRecipe && tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) && GT_Utility.areStacksEqual((ItemStack)(aRecipeSpecial = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(tRecipe)), (ItemStack)aSpecialSlot, (boolean)false) && GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial, aSpecialSlot)) {
                            return tRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                        }
                        tRecipes = (Collection)mRecipeMap.mRecipeItemMap.get(new GT_ItemStack(tStack, true));
                    }
                }
                if (tRecipes == null) continue;
                for (GT_Recipe tRecipe : tRecipes) {
                    if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !GT_Utility.areStacksEqual((ItemStack)(aRecipeSpecial = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(tRecipe)), (ItemStack)aSpecialSlot, (boolean)false) || !GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial, aSpecialSlot)) continue;
                    return tRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                }
            }
        }
        if (mRecipeMap.mMinimalInputItems == 0 && aFluids != null) {
            for (FluidStack aFluid : aFluids) {
                if (aFluid == null || (tRecipes = (Collection)mRecipeMap.mRecipeFluidMap.get(aFluid.getFluid())) == null) continue;
                for (GT_Recipe tRecipe : tRecipes) {
                    if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs) || !GT_Utility.areStacksEqual((ItemStack)(aRecipeSpecial = GregtechMTE_ElementalDuplicator.getSpecialSlotStack(tRecipe)), (ItemStack)aSpecialSlot, (boolean)false) || !GregtechMTE_ElementalDuplicator.areDataOrbsEqual(aRecipeSpecial, aSpecialSlot)) continue;
                    return tRecipe.mEnabled && aVoltage * (long)mRecipeMap.mAmperage >= (long)tRecipe.mEUt ? tRecipe : null;
                }
            }
        }
        return null;
    }

    public static ItemStack getSpecialSlotStack(GT_Recipe aRecipe) {
        ItemStack aStack = null;
        if (aRecipe.mSpecialItems != null && aRecipe.mSpecialItems instanceof ItemStack[]) {
            ItemStack[] aTempStackArray = (ItemStack[])aRecipe.mSpecialItems;
            aStack = aTempStackArray[0];
        }
        return aStack;
    }

    private static boolean areDataOrbsEqual(ItemStack aOrb1, ItemStack aOrb2) {
        Materials tMaterial2;
        Materials tMaterial1;
        return aOrb1 != null && aOrb2 != null && (tMaterial1 = (Materials)Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)aOrb1)).mLinkedMaterials.get(0)).equals(tMaterial2 = (Materials)Element.get((String)Behaviour_DataOrb.getDataName((ItemStack)aOrb2)).mLinkedMaterials.get(0));
    }
}

