/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialMultiMachine
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialMultiMachine>
implements ISurvivalConstructable {
    protected int mInternalMode = 0;
    protected GT_Recipe[] mLastRecipeExtended = new GT_Recipe[9];
    private static final int MODE_COMPRESSOR = 0;
    private static final int MODE_LATHE = 1;
    private static final int MODE_MAGNETIC = 2;
    private static final int MODE_FERMENTER = 3;
    private static final int MODE_FLUIDEXTRACT = 4;
    private static final int MODE_EXTRACTOR = 5;
    private static final int MODE_LASER = 6;
    private static final int MODE_AUTOCLAVE = 7;
    private static final int MODE_FLUIDSOLIDIFY = 8;
    private static final int[][] MODE_MAP = new int[][]{{0, 1, 2}, {3, 4, 5}, {6, 7, 8}};
    public static final String[] aToolTipNames = new String[9];
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialMultiMachine> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialMultiMachine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialMultiMachine(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialMultiMachine(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Nine in One";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        String[] aBuiltStrings = new String[]{aToolTipNames[0] + ", " + aToolTipNames[1] + ", " + aToolTipNames[2], aToolTipNames[3] + ", " + aToolTipNames[4] + ", " + aToolTipNames[5], aToolTipNames[6] + ", " + aToolTipNames[7] + ", " + aToolTipNames[8]};
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Multi-Machine").addInfo("250% faster than using single block machines of the same voltage").addInfo("Only uses 80% of the EU/t normally required").addInfo("Processes two items per voltage tier").addInfo("Machine Type: [A] - " + EnumChatFormatting.YELLOW + aBuiltStrings[0] + EnumChatFormatting.RESET).addInfo("Machine Type: [B] - " + EnumChatFormatting.YELLOW + aBuiltStrings[1] + EnumChatFormatting.RESET).addInfo("Machine Type: [C] - " + EnumChatFormatting.YELLOW + aBuiltStrings[2] + EnumChatFormatting.RESET).addInfo("Read Multi-Machine Manual for extra information").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfo("Multi-Use Casings", 6).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialMultiMachine> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialMultiMachine.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex(this.getTextureIndex()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)2))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getTextureIndex();
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "Generic3By3";
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList tFluids = this.getStoredFluids();
        for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
            FluidStack[] properArray;
            ArrayList<ItemStack> tBusItems = new ArrayList<ItemStack>();
            tBus.mRecipeMap = this.getRecipeMap();
            if (GregtechMetaTileEntity_IndustrialMultiMachine.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                    if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                    tBusItems.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                }
            }
            boolean aFoundCircuitInBus = false;
            for (ItemStack aBusItem : tBusItems) {
                if (!ItemUtils.isControlCircuit(aBusItem)) continue;
                aFoundCircuitInBus = true;
            }
            if (!aFoundCircuitInBus) continue;
            FluidStack[] tempArray = tFluids.toArray(new FluidStack[0]);
            FluidStack[] fluidStackArray = properArray = tempArray != null && tempArray.length > 0 ? tempArray : new FluidStack[]{};
            if (!this.checkRecipeGeneric(tBusItems.toArray(new ItemStack[0]), properArray, 2 * GT_Utility.getTier((long)this.getMaxInputVoltage()), 80L, 250, 10000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 80;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        if (this.mInternalMode == 0) {
            return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMultiMachine_ModeMetal;
        }
        if (this.mInternalMode == 1) {
            return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMultiMachine_ModeFluid;
        }
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMultiMachine_ModeMisc;
    }

    public int getTextureIndex() {
        return TAE.getIndexFromPage(2, 2);
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private ItemStack getCircuit(ItemStack[] t) {
        for (ItemStack j : t) {
            if (j.func_77973_b() != CI.getNumberedCircuit(0).func_77973_b() || j.func_77960_j() < 20 || j.func_77960_j() > 22) continue;
            return j;
        }
        return null;
    }

    private final int getCircuitID(ItemStack circuit) {
        int H = circuit.func_77960_j();
        int T = H == 20 ? 0 : (H == 21 ? 1 : (H == 22 ? 2 : -1));
        return MODE_MAP[this.mInternalMode][T];
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    private final GT_Recipe.GT_Recipe_Map getRecipeMap(ItemStack circuit) {
        return GregtechMetaTileEntity_IndustrialMultiMachine.getRecipeMap(this.getCircuitID(circuit));
    }

    private static final GT_Recipe.GT_Recipe_Map getRecipeMap(int aMode) {
        if (aMode == 0) {
            return GT_Recipe.GT_Recipe_Map.sCompressorRecipes;
        }
        if (aMode == 1) {
            return GT_Recipe.GT_Recipe_Map.sLatheRecipes;
        }
        if (aMode == 2) {
            return GT_Recipe.GT_Recipe_Map.sPolarizerRecipes;
        }
        if (aMode == 3) {
            return GT_Recipe.GT_Recipe_Map.sFermentingRecipes;
        }
        if (aMode == 4) {
            return GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes;
        }
        if (aMode == 5) {
            return GT_Recipe.GT_Recipe_Map.sExtractorRecipes;
        }
        if (aMode == 6) {
            return GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes;
        }
        if (aMode == 7) {
            return GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes;
        }
        if (aMode == 8) {
            return GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, long aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        void var27_30;
        int parallelRecipes;
        GT_Recipe tRecipe;
        ItemStack tCircuit = this.getCircuit(aItemInputs);
        int tCircuitID = this.getCircuitID(tCircuit);
        Logger.MACHINE_INFO("Mode: " + tCircuitID, new Object[0]);
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        GT_Recipe.GT_Recipe_Map tRecipeMap = this.getRecipeMap(tCircuit);
        if (tRecipeMap == null) {
            return false;
        }
        this.mLastRecipeExtended[tCircuitID] = tRecipe = tRecipeMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipeExtended[tCircuitID], false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        if (tRecipe == null) {
            Logger.MACHINE_INFO("BAD RETURN - 1|" + tCircuitID, new Object[0]);
            if (aItemInputs.length > 0) {
                Logger.MACHINE_INFO("Input Items: " + ItemUtils.getArrayStackNames(aItemInputs), new Object[0]);
            }
            if (aFluidInputs.length > 0) {
                Logger.MACHINE_INFO("Input Fluids: " + ItemUtils.getFluidArrayStackNames(aFluidInputs), new Object[0]);
            }
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            Logger.MACHINE_INFO("BAD RETURN - 2|" + tCircuitID, new Object[0]);
            return false;
        }
        float tRecipeEUt = (float)((long)tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        Logger.WARNING("parallelRecipes: " + parallelRecipes);
        Logger.WARNING("aMaxParallelRecipes: " + aMaxParallelRecipes);
        Logger.WARNING("tTotalEUt: " + tTotalEUt);
        Logger.WARNING("tVoltage: " + tVoltage);
        Logger.WARNING("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                Logger.WARNING("Broke at " + parallelRecipes + ".");
                break;
            }
            Logger.WARNING("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            Logger.MACHINE_INFO("BAD RETURN - 3|" + tCircuitID, new Object[0]);
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var27_30 < n) {
            Object tS = objectArray[var27_30];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var27_30;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        Logger.MACHINE_INFO("GOOD RETURN - 1|" + tCircuitID, new Object[0]);
        return true;
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mInternalMode = this.mInternalMode < 2 ? ++this.mInternalMode : 0;
        String mModeString = this.mInternalMode == 0 ? "Metal" : (this.mInternalMode == 1 ? "Fluid" : (this.mInternalMode == 2 ? "Misc." : "null"));
        PlayerUtils.messagePlayer(aPlayer, "Multi-Machine is now in " + mModeString + " mode.");
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mInternalMode", this.mInternalMode);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mInternalMode = aNBT.func_74762_e("mInternalMode");
        super.loadNBTData(aNBT);
    }

    static {
        for (int id = 0; id < 9; ++id) {
            GT_Recipe.GT_Recipe_Map recipeMap = GregtechMetaTileEntity_IndustrialMultiMachine.getRecipeMap(id);
            if (recipeMap == null) continue;
            String aNEI = GT_LanguageManager.getTranslation((String)GregtechMetaTileEntity_IndustrialMultiMachine.getRecipeMap((int)id).mNEIName);
            GregtechMetaTileEntity_IndustrialMultiMachine.aToolTipNames[id] = aNEI != null ? aNEI : "BAD NEI NAME (Report to Github)";
        }
    }
}

