/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialForgeHammer
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialForgeHammer>
implements ISurvivalConstructable {
    private int mCasing;
    private int mAnvil;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialForgeHammer> STRUCTURE_DEFINITION = null;
    private static Block sAnvil;
    private static Block sSteelAnvil;
    private static Block sDarkSteelAnvil;
    private static Block sThaumiumAnvil;
    private static Block sVoidAnvil;

    public GregtechMetaTileEntity_IndustrialForgeHammer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialForgeHammer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        return new GregtechMetaTileEntity_IndustrialForgeHammer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Forge Hammer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Forge Hammer").addInfo("Speed: +100% | EU Usage: 100% | Parallel: Tier x Anvil Tier x 8").addInfo("T1 - Vanilla Anvil").addInfo("Anvil goes in Middle 3x3x3 Structure");
        if (LoadedMods.Railcraft) {
            tt.addInfo("T2 - Steel Anvil");
        }
        if (LoadedMods.EnderIO) {
            tt.addInfo("T3 - Dark Steel Anvil");
        }
        if (LoadedMods.ThaumicBases) {
            tt.addInfo("T3 - Thaumic Anvil");
            tt.addInfo("T4 - Void Anvil");
        }
        tt.addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfo("Forge Casing", 10).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialForgeHammer> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            HashMap<Block, Integer> aBlockMap = new HashMap<Block, Integer>();
            aBlockMap.put(sAnvil, 0);
            if (LoadedMods.Railcraft) {
                aBlockMap.put(sSteelAnvil, 0);
            }
            if (LoadedMods.EnderIO) {
                aBlockMap.put(sDarkSteelAnvil, 0);
            }
            if (LoadedMods.ThaumicBases) {
                aBlockMap.put(sThaumiumAnvil, 0);
                aBlockMap.put(sVoidAnvil, 0);
            }
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "CAC", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialForgeHammer.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(TAE.getIndexFromPage(1, 11)).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)6))})).addElement('A', StructureUtility.onElementPass(x -> ++x.mAnvil, (IStructureElement)StructureUtility.ofBlocksFlat(aBlockMap, (Block)sAnvil, (int)0))).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(1);
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(1, 11);
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "MaterialPress";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sHammerRecipes;
    }

    public boolean checkRecipe(ItemStack aStack) {
        int aAnvilTier;
        Block aAnvil = this.getBaseMetaTileEntity().getBlockAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (aAnvil != null && (aAnvilTier = GregtechMetaTileEntity_IndustrialForgeHammer.getAnvilTier(aAnvil)) > 0) {
            for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
                ArrayList<ItemStack> tBusItems = new ArrayList<ItemStack>();
                tBus.mRecipeMap = this.getRecipeMap();
                if (GregtechMetaTileEntity_IndustrialForgeHammer.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                    for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                        if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                        tBusItems.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                    }
                }
                if (!this.checkRecipeGeneric(tBusItems.toArray(new ItemStack[0]), new FluidStack[0], this.getMaxParallelRecipes() * aAnvilTier, 100L, 100, 10000)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialForgeHammer;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private static void setAnvilBlocks() {
        if (sAnvil == null) {
            sAnvil = Blocks.field_150467_bQ;
            if (LoadedMods.Railcraft) {
                sSteelAnvil = GameRegistry.findBlock((String)"Railcraft", (String)"anvil");
            }
            if (LoadedMods.EnderIO) {
                sDarkSteelAnvil = GameRegistry.findBlock((String)"EnderIO", (String)"blockDarkSteelAnvil");
            }
            if (LoadedMods.ThaumicBases) {
                sThaumiumAnvil = GameRegistry.findBlock((String)"thaumicbases", (String)"thaumicAnvil");
                sVoidAnvil = GameRegistry.findBlock((String)"thaumicbases", (String)"voidAnvil");
            }
        }
    }

    public static boolean isBlockAnvil(Block aBlock) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        if (sAnvil == aBlock) {
            return true;
        }
        if (LoadedMods.Railcraft && sSteelAnvil == aBlock) {
            return true;
        }
        if (LoadedMods.EnderIO && sDarkSteelAnvil == aBlock) {
            return true;
        }
        return LoadedMods.ThaumicBases && (sThaumiumAnvil == aBlock || sVoidAnvil == aBlock);
    }

    public static int getAnvilTier(Block aBlock) {
        if (GregtechMetaTileEntity_IndustrialForgeHammer.isBlockAnvil(aBlock)) {
            if (sAnvil == aBlock) {
                return 1;
            }
            if (LoadedMods.Railcraft && sSteelAnvil == aBlock) {
                return 2;
            }
            if (LoadedMods.EnderIO && sDarkSteelAnvil == aBlock) {
                return 3;
            }
            if (LoadedMods.ThaumicBases) {
                if (sThaumiumAnvil == aBlock) {
                    return 3;
                }
                if (sVoidAnvil == aBlock) {
                    return 4;
                }
            }
        }
        return 0;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        super.onFirstTick(aBaseMetaTileEntity);
    }
}

