/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GregtechMetaTileEntity_IndustrialCuttingMachine
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialCuttingMachine>
implements ISurvivalConstructable {
    private boolean mCuttingMode = true;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialCuttingMachine> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialCuttingMachine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialCuttingMachine(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialCuttingMachine(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Cutting Machine / Slicing Machine";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Cutting Factory").addInfo("200% faster than using single block machines of the same voltage").addInfo("Only uses 75% of the EU/t normally required").addInfo("Processes four items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 5, true).addController("Front Center").addCasingInfo("Cutting Factory Frames", 26).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialCuttingMachine> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC", "CCC", "CCC"}, {"C~C", "C-C", "C-C", "C-C", "CCC"}, {"CCC", "CCC", "CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialCuttingMachine.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex((int)this.getCasingTextureIndex()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)13))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 26 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(29);
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "IndustrialCuttingMachine";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mCuttingMode ? GT_Recipe.GT_Recipe_Map.sCutterRecipes : GT_Recipe.GT_Recipe_Map.sSlicerRecipes;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(4 * GT_Utility.getTier((long)this.getMaxInputVoltage()), 75L, 200);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 75;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialCuttingMachine;
    }

    @Override
    public int getAmountOfOutputs() {
        return 2;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings2Misc;
    }

    public byte getCasingMeta() {
        return 13;
    }

    public byte getCasingTextureIndex() {
        return (byte)TAE.GTPP_INDEX(29);
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mCuttingMode = Utils.invertBoolean(this.mCuttingMode);
        String aMode = this.mCuttingMode ? "Cutting" : "Slicing";
        PlayerUtils.messagePlayer(aPlayer, "Mode: " + aMode);
        this.mLastRecipe = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mCuttingMode", this.mCuttingMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mCuttingMode = aNBT.func_74764_b("mCuttingMode") ? aNBT.func_74767_n("mCuttingMode") : true;
    }
}

