/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GregtechMetaTileEntity_IndustrialCentrifuge
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialCentrifuge>
implements ISurvivalConstructable {
    private boolean mIsAnimated = true;
    private static final TexturesGtBlock.CustomIcon frontFaceActive = new TexturesGtBlock.CustomIcon("iconsets/LARGECENTRIFUGE_ACTIVE5");
    private static final TexturesGtBlock.CustomIcon frontFace = new TexturesGtBlock.CustomIcon("iconsets/LARGECENTRIFUGE5");
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialCentrifuge> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialCentrifuge(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialCentrifuge(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialCentrifuge(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Centrifuge";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Centrifuge").addInfo("125% faster than using single block machines of the same voltage").addInfo("Disable animations with a screwdriver").addInfo("Only uses 90% of the EU/t normally required").addInfo("Processes six items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfo("Centrifuge Casings", 10).addInputBus("Any Casing except front", new int[]{1}).addOutputBus("Any Casing except front", new int[]{1}).addInputHatch("Any Casing except front", new int[]{1}).addOutputHatch("Any Casing except front", new int[]{1}).addEnergyHatch("Any Casing except front", new int[]{1}).addMaintenanceHatch("Any Casing except front", new int[]{1}).addMufflerHatch("Any Casing except front", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialCentrifuge> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_IndustrialCentrifuge.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch}).casingIndex((int)this.getCasingTextureIndex()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)0))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        if (this.usingAnimations()) {
            return frontFaceActive;
        }
        return frontFace;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return frontFace;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(0);
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "IndustrialCentrifuge";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sMultiblockCentrifugeRecipes_GT;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(6 * GT_Utility.getTier((long)this.getMaxInputVoltage()), 90L, 125);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 6 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 90;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasingsMisc;
    }

    public byte getCasingMeta() {
        return 0;
    }

    public byte getCasingTextureIndex() {
        return (byte)TAE.GTPP_INDEX(0);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialCentrifuge;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mIsAnimated = !this.mIsAnimated;
        Logger.INFO("Is Centrifuge animated " + this.mIsAnimated);
        if (this.mIsAnimated) {
            PlayerUtils.messagePlayer(aPlayer, "Using Animated Turbine Texture. ");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Using Static Turbine Texture. ");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mIsAnimated", this.mIsAnimated);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mIsAnimated = aNBT.func_74764_b("mIsAnimated") ? aNBT.func_74767_n("mIsAnimated") : true;
    }

    public boolean usingAnimations() {
        return this.mIsAnimated;
    }
}

