/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMetaTileEntity;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.ChargingHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GregtechMetaWirelessCharger
extends GregtechMetaTileEntity {
    private boolean mHasBeenMapped = false;
    private int mCurrentDimension = 0;
    public int mMode = 0;
    public boolean mLocked = true;
    private Map<String, UUID> mWirelessChargingMap = new HashMap<String, UUID>();
    private Map<String, UUID> mLocalChargingMap = new HashMap<String, UUID>();

    public GregtechMetaWirelessCharger(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public GregtechMetaWirelessCharger(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.mDescription, "Can be locked to the owner by sneaking with a screwdriver", "Can also be locked with a lock upgrade", "", "3 Modes, Long-Range, Local and Mixed.", "Long-Range: Can supply 2A of power to a single player up to " + GT_Values.V[this.mTier] * 4L + "m away.", "Local: Can supply several Amps to each player within " + this.mTier * 20 + "m.", "Mixed: Provides both 2A of long range and 1A per player locally.", "Mixed mode is more conservative of power and as a result only", "Gets half the distances each singular mode gets.", CORE.GT_Tooltip};
    }

    public int getTier() {
        return this.mTier;
    }

    public int getMode() {
        return this.mMode;
    }

    public int getDimensionID() {
        return this.mCurrentDimension;
    }

    public Map<String, UUID> getLocalMap() {
        return this.mLocalChargingMap;
    }

    public Map<String, UUID> getLongRangeMap() {
        return this.mWirelessChargingMap;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Screen_2)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Screen_2)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.mLocked = !this.mLocked;
            PlayerUtils.messagePlayer(aPlayer, this.mLocked ? "Locked to owner." : "Unlocked.");
            return;
        }
        this.mWirelessChargingMap.clear();
        this.mLocalChargingMap.clear();
        if (!this.getBaseMetaTileEntity().getWorld().field_73010_i.isEmpty()) {
            for (Object mTempPlayer : this.getBaseMetaTileEntity().getWorld().field_73010_i) {
                if (!(mTempPlayer instanceof EntityPlayer) && !(mTempPlayer instanceof EntityPlayerMP)) continue;
                EntityPlayer mTemp = (EntityPlayer)mTempPlayer;
                ChargingHelper.removeValidPlayer(mTemp, this);
            }
        }
        this.mMode = this.mMode >= 2 ? 0 : ++this.mMode;
        if (this.mMode == 0) {
            PlayerUtils.messagePlayer(aPlayer, "Now in Long-Range Charge Mode.");
        } else if (this.mMode == 1) {
            PlayerUtils.messagePlayer(aPlayer, "Now in Local Charge Mode.");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Now in Mixed Charge Mode.");
        }
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaWirelessCharger(this.mName, (int)this.mTier, this.mDescription, this.mTextures, this.mInventory.length);
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isInputFacing(byte aSide) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 128L;
    }

    public int getCapacity() {
        return (int)(GT_Values.V[this.mTier] * 32L);
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesIn() {
        if (this.mMode == 0) {
            return 2L;
        }
        if (this.mMode == 1) {
            return this.mLocalChargingMap.size() * 8;
        }
        return this.mLocalChargingMap.size() * 4 + this.mWirelessChargingMap.size();
    }

    public long maxAmperesOut() {
        return 0L;
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }

    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public String[] getInfoData() {
        return new String[]{this.getLocalName()};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mLocked", this.mLocked);
        aNBT.func_74768_a("mMode", this.mMode);
        aNBT.func_74768_a("mCurrentDimension", this.mCurrentDimension);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mLocked = aNBT.func_74767_n("mLocked");
        this.mMode = aNBT.func_74762_e("mMode");
        this.mCurrentDimension = aNBT.func_74762_e("mCurrentDimension");
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
    }

    private boolean isValidPlayer(EntityPlayer aPlayer) {
        BaseMetaTileEntity aTile = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (this.mLocked || aTile != null && aTile.privateAccess()) {
            return aPlayer.func_110124_au().equals(this.getBaseMetaTileEntity().getOwnerUuid());
        }
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mCurrentDimension != aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g) {
                this.mCurrentDimension = aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g;
            }
            if (!this.mHasBeenMapped && ChargingHelper.addEntry(this.getTileEntityPosition(), this)) {
                this.mHasBeenMapped = true;
            }
            if (aTick % 20L == 0L && this.mHasBeenMapped && !aBaseMetaTileEntity.getWorld().field_73010_i.isEmpty()) {
                for (Object mTempPlayer : aBaseMetaTileEntity.getWorld().field_73010_i) {
                    int tempRange;
                    if (!(mTempPlayer instanceof EntityPlayer) && !(mTempPlayer instanceof EntityPlayerMP)) continue;
                    EntityPlayer mTemp = (EntityPlayer)mTempPlayer;
                    if (this.mMode == 1 || this.mMode == 2) {
                        int n = tempRange = this.mMode == 1 ? this.mTier * 20 : this.mTier * 10;
                        if (this.getDistanceBetweenTwoPositions(this.getTileEntityPosition(), this.getPositionOfEntity((Entity)mTemp)) < (double)tempRange) {
                            if (this.isValidPlayer(mTemp) && !this.mLocalChargingMap.containsKey(mTemp.getDisplayName())) {
                                this.mLocalChargingMap.put(mTemp.getDisplayName(), mTemp.getPersistentID());
                                ChargingHelper.addValidPlayer(mTemp, this);
                            }
                        } else if (this.mLocalChargingMap.containsKey(mTemp.getDisplayName()) && this.mLocalChargingMap.remove(mTemp.getDisplayName()) != null) {
                            ChargingHelper.removeValidPlayer(mTemp, this);
                        }
                    }
                    if (this.mMode != 0 && this.mMode != 2) continue;
                    tempRange = (int)(this.mMode == 0 ? 4L * GT_Values.V[this.mTier] : 2L * GT_Values.V[this.mTier]);
                    if (this.getDistanceBetweenTwoPositions(this.getTileEntityPosition(), this.getPositionOfEntity((Entity)mTemp)) <= (double)tempRange) {
                        if (this.mWirelessChargingMap.containsKey(mTemp.getDisplayName()) || !this.isValidPlayer(mTemp)) continue;
                        this.mWirelessChargingMap.put(mTemp.getDisplayName(), mTemp.getPersistentID());
                        ChargingHelper.addValidPlayer(mTemp, this);
                        PlayerUtils.messagePlayer(mTemp, "You have entered charging range. [" + tempRange + "m - Long-Range].");
                        continue;
                    }
                    if (!this.mWirelessChargingMap.containsKey(mTemp.getDisplayName()) || this.mWirelessChargingMap.remove(mTemp.getDisplayName()) == null) continue;
                    PlayerUtils.messagePlayer(mTemp, "You have left charging range. [" + tempRange + "m - Long Range].");
                    ChargingHelper.removeValidPlayer(mTemp, this);
                }
            }
        }
    }

    public BlockPos getTileEntityPosition() {
        return new BlockPos(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld());
    }

    public BlockPos getPositionOfEntity(Entity mEntity) {
        if (mEntity == null) {
            return null;
        }
        return EntityUtils.findBlockPosUnderEntity(mEntity);
    }

    public double getDistanceBetweenTwoPositions(BlockPos objectA, BlockPos objectB) {
        if (objectA == null || objectB == null) {
            return 0.0;
        }
        int[] objectArray1 = new int[]{objectA.xPos, objectA.yPos, objectA.zPos};
        int[] objectArray2 = new int[]{objectB.xPos, objectB.yPos, objectB.zPos};
        double distance = Math.sqrt((objectArray2[0] - objectArray1[0]) * (objectArray2[0] - objectArray1[0]) + (objectArray2[1] - objectArray1[1]) * (objectArray2[1] - objectArray1[1]) + (objectArray2[2] - objectArray1[2]) * (objectArray2[2] - objectArray1[2]));
        return distance;
    }

    public void onRemoval() {
        ChargingHelper.removeEntry(this.getTileEntityPosition(), this);
        this.mWirelessChargingMap.clear();
        this.mLocalChargingMap.clear();
        if (!this.getBaseMetaTileEntity().getWorld().field_73010_i.isEmpty()) {
            for (Object mTempPlayer : this.getBaseMetaTileEntity().getWorld().field_73010_i) {
                if (!(mTempPlayer instanceof EntityPlayer) && !(mTempPlayer instanceof EntityPlayerMP)) continue;
                EntityPlayer mTemp = (EntityPlayer)mTempPlayer;
                ChargingHelper.removeValidPlayer(mTemp, this);
            }
        }
        super.onRemoval();
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        int tempRange;
        if (this.mMode == 0 || this.mMode == 2) {
            tempRange = (int)(this.mMode == 0 ? 4L * GT_Values.V[this.mTier] : 2L * GT_Values.V[this.mTier]);
        } else {
            int n = tempRange = this.mMode == 1 ? this.mTier * 20 : this.mTier * 10;
        }
        if (this.mMode == 2) {
            PlayerUtils.messagePlayer(aPlayer, "Mixed Mode | Local: " + this.mTier * 10 + "m | Long: " + tempRange + "m");
            PlayerUtils.messagePlayer(aPlayer, "Players with access:");
            for (String name : this.getLocalMap().keySet()) {
                PlayerUtils.messagePlayer(aPlayer, "Local: " + name);
            }
            for (String name : this.getLongRangeMap().keySet()) {
                PlayerUtils.messagePlayer(aPlayer, "Long: " + name);
            }
        } else if (this.mMode == 1) {
            PlayerUtils.messagePlayer(aPlayer, "Local Mode: " + this.mTier * 20 + "m");
            PlayerUtils.messagePlayer(aPlayer, "Players with access:");
            for (String name : this.getLocalMap().keySet()) {
                PlayerUtils.messagePlayer(aPlayer, "" + name);
            }
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Long-range Mode: " + tempRange + "m");
            PlayerUtils.messagePlayer(aPlayer, "Players with access:");
            for (String name : this.getLongRangeMap().keySet()) {
                PlayerUtils.messagePlayer(aPlayer, "" + name);
            }
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, aSide, aX, aY, aZ);
    }

    public void onServerStart() {
        this.mWirelessChargingMap.clear();
        this.mLocalChargingMap.clear();
        super.onServerStart();
    }

    public void onExplosion() {
        ChargingHelper.removeEntry(this.getTileEntityPosition(), this);
        super.onExplosion();
    }

    public void doExplosion(long aExplosionPower) {
        ChargingHelper.removeEntry(this.getTileEntityPosition(), this);
        super.doExplosion(aExplosionPower);
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && !this.mHasBeenMapped && ChargingHelper.addEntry(this.getTileEntityPosition(), this)) {
            this.mHasBeenMapped = true;
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }
}

