/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_SteamCondenser;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_SteamCondenser;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.generators.GregtechMetaBoilerBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GregtechMetaCondensor
extends GregtechMetaBoilerBase {
    public GregtechMetaCondensor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, "A Steam condenser - [IC2->Steam]", new ITexture[0]);
    }

    public GregtechMetaCondensor(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "IC2 Steam + Water = Normal Steam.", "Requires no power to run, although it's not very fast.", CORE.GT_Tooltip};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[5][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa))};
            rTextures[1][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[2][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[3][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER)};
            rTextures[4][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_VENT, Dyes.getModulation((int)i, (short[])Dyes.MACHINE_METAL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_POTIONBREWER_ACTIVE)};
        }
        return rTextures;
    }

    @Override
    public int maxProgresstime() {
        return 1000;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new CONTAINER_SteamCondenser(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GUI_SteamCondenser(aPlayerInventory, aBaseMetaTileEntity, "SteelBoiler.png");
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaCondensor(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.RI = MathUtils.randLong(5L, 30L);
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L) {
            if (this.mTemperature <= 5) {
                this.mTemperature = 5;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > 10) {
                --this.mTemperature;
                this.mLossTimer = 0;
            }
            for (byte i = 1; this.mSteam != null && i < 6; i = (byte)(i + 1)) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTileEntity;
                if (i == aBaseMetaTileEntity.getFrontFacing() || (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(i)) == null || (tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), Math.max(1, this.mSteam.amount / 2), false)) == null || (tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), tDrained, false)) <= 0) continue;
                tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), tFilledAmount, true), true);
            }
            if (aTick % 10L == 0L) {
                if (this.mTemperature > 5) {
                    if (this.mFluid == null || !GT_ModHandler.isWater((FluidStack)this.mFluid) || this.mFluid.amount <= 0) {
                        this.mHadNoWater = true;
                    } else {
                        if (this.mHadNoWater) {
                            aBaseMetaTileEntity.doExplosion(2048L);
                            return;
                        }
                        --this.mFluid.amount;
                        if (this.mSteam == null) {
                            this.mSteam = GT_ModHandler.getSteam((long)30L);
                        } else if (GT_ModHandler.isSteam((FluidStack)this.mSteam)) {
                            this.mSteam.amount += 30;
                        } else {
                            this.mSteam = GT_ModHandler.getSteam((long)30L);
                        }
                    }
                } else {
                    this.mHadNoWater = false;
                }
            }
            if (this.mSteam != null && this.mSteam.amount > this.getSteamCapacity()) {
                this.sendSound((byte)1);
                this.mSteam.amount = this.getSteamCapacity() * 3 / 4;
            }
            if (this.mTemperature < 1000 && this.mProcessingEnergy > 0 && aTick % this.RI == 0L) {
                this.mProcessingEnergy -= 40;
                this.mTemperature += 2;
            }
            aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
        }
    }

    public final int fill(FluidStack aFluid, boolean doFill) {
        if (Utils.isIC2Steam(aFluid) && this.mProcessingEnergy < 50) {
            int tFilledAmount = Math.min(50, aFluid.amount);
            if (doFill) {
                this.mProcessingEnergy += tFilledAmount;
            }
            return tFilledAmount;
        }
        return super.fill(aFluid, doFill);
    }
}

