/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_AdvancedBoiler;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_AdvancedBoiler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Boiler_Solar
extends GT_MetaTileEntity_Boiler {
    private int mRunTime = 0;

    public GT_MetaTileEntity_Boiler_Solar(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, "Steam Power by the Sun", new ITexture[0]);
    }

    public GT_MetaTileEntity_Boiler_Solar(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "Produces " + this.getPollution() * 20 + " pollution/sec", CORE.GT_Tooltip};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[4][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            ITexture[] tmp0 = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM, Dyes.getModulation((int)i, (short[])Dyes._NULL.mRGBa))};
            rTextures[0][i + 1] = tmp0;
            ITexture[] tmp1 = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP, Dyes.getModulation((int)i, (short[])Dyes._NULL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.BOILER_SOLAR)};
            rTextures[1][i + 1] = tmp1;
            ITexture[] tmp2 = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, Dyes.getModulation((int)i, (short[])Dyes._NULL.mRGBa))};
            rTextures[2][i + 1] = tmp2;
            ITexture[] tmp3 = new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, Dyes.getModulation((int)i, (short[])Dyes._NULL.mRGBa)), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE)};
            rTextures[3][i + 1] = tmp3;
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[aSide >= 2 ? (byte)(aSide != aFacing ? 2 : 3) : aSide][aColorIndex + 1];
    }

    public int maxProgresstime() {
        return 500;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new CONTAINER_AdvancedBoiler(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GUI_AdvancedBoiler(aPlayerInventory, aBaseMetaTileEntity, "SolarBoiler.png");
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boiler_Solar(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mRunTime", this.mRunTime);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mRunTime = aNBT.func_74762_e("mRunTime");
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick > 20L) {
            int tFilledAmount;
            FluidStack tDrained;
            byte i;
            IFluidHandler tTileEntity;
            if (this.mTemperature <= 20) {
                this.mTemperature = 20;
                this.mLossTimer = 0;
            }
            if (++this.mLossTimer > 45) {
                --this.mTemperature;
                this.mLossTimer = 0;
            }
            if (this.mSteam != null && (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(i = aBaseMetaTileEntity.getFrontFacing())) != null && (tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), Math.max(1, this.mSteam.amount / 2), false)) != null && (tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), tDrained, false)) > 0) {
                tTileEntity.fill(ForgeDirection.getOrientation((int)i).getOpposite(), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)i), tFilledAmount, true), true);
            }
            if (aTick % 25L == 0L) {
                if (this.mTemperature > 100) {
                    if (this.mFluid == null || !GT_ModHandler.isWater((FluidStack)this.mFluid) || this.mFluid.amount <= 0) {
                        this.mHadNoWater = true;
                    } else {
                        if (this.mHadNoWater) {
                            aBaseMetaTileEntity.doExplosion(2048L);
                            return;
                        }
                        --this.mFluid.amount;
                        ++this.mRunTime;
                        int tOutput = 150;
                        if (this.mRunTime > 10000) {
                            tOutput = Math.max(50, 150 - (this.mRunTime - 10000) / 100);
                        }
                        if (this.mSteam == null) {
                            this.mSteam = GT_ModHandler.getSteam((long)tOutput);
                        } else if (GT_ModHandler.isSteam((FluidStack)this.mSteam)) {
                            this.mSteam.amount += tOutput;
                        } else {
                            this.mSteam = GT_ModHandler.getSteam((long)tOutput);
                        }
                    }
                } else {
                    this.mHadNoWater = false;
                }
            }
            if (this.mSteam != null && this.mSteam.amount > 16000) {
                this.sendSound((byte)1);
                this.mSteam.amount = 12000;
            }
            if (this.mProcessingEnergy <= 0 && aBaseMetaTileEntity.isAllowedToWork() && aTick % 256L == 0L && !aBaseMetaTileEntity.getWorld().func_72911_I()) {
                boolean bRain;
                boolean bl = bRain = aBaseMetaTileEntity.getWorld().func_72896_J() && aBaseMetaTileEntity.getBiome().field_76751_G > 0.0f;
                this.mProcessingEnergy += bRain && aBaseMetaTileEntity.getWorld().field_73008_k >= 4 || !aBaseMetaTileEntity.getSkyAtSide((byte)1) ? 0 : (!bRain && aBaseMetaTileEntity.getWorld().func_72935_r() ? 8 : 1);
            }
            if (this.mTemperature < 500 && this.mProcessingEnergy > 0 && aTick % 12L == 0L) {
                --this.mProcessingEnergy;
                ++this.mTemperature;
            }
            aBaseMetaTileEntity.setActive(this.mProcessingEnergy > 0);
        }
    }

    protected int getPollution() {
        return 0;
    }

    protected int getProductionPerSecond() {
        return 0;
    }

    protected int getMaxTemperature() {
        return 0;
    }

    protected int getEnergyConsumption() {
        return 0;
    }

    protected int getCooldownInterval() {
        return 0;
    }

    protected void updateFuel(IGregTechTileEntity iGregTechTileEntity, long l) {
    }
}

