/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers;

import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.common.Meta_GT_Proxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class VolumetricFlaskHelper {
    private static final Class sClassVolumetricFlask;
    private static final Method sMethodGetFlaskMaxCapacity;
    private static Item mFlask;

    public static ItemStack getVolumetricFlask(int aAmount) {
        ItemStack aFlask = ItemUtils.getValueOfItemList("VOLUMETRIC_FLASK", aAmount, (ItemStack)null);
        return aFlask;
    }

    public static ItemStack getLargeVolumetricFlask(int aAmount) {
        ItemStack aFlask = GregtechItemList.VOLUMETRIC_FLASK_8k.get(aAmount, new Object[0]);
        return aFlask;
    }

    public static ItemStack getGiganticVolumetricFlask(int aAmount) {
        ItemStack aFlask = GregtechItemList.VOLUMETRIC_FLASK_32k.get(aAmount, new Object[0]);
        return aFlask;
    }

    public static boolean isVolumetricFlask(ItemStack aStack) {
        return VolumetricFlaskHelper.isNormalVolumetricFlask(aStack) || VolumetricFlaskHelper.isLargeVolumetricFlask(aStack) || VolumetricFlaskHelper.isGiganticVolumetricFlask(aStack);
    }

    public static boolean isNormalVolumetricFlask(ItemStack aStack) {
        ItemStack aFlask;
        if (mFlask == null && (aFlask = ItemUtils.getValueOfItemList("VOLUMETRIC_FLASK", 1, (ItemStack)null)) != null) {
            mFlask = aFlask.func_77973_b();
        }
        return aStack.func_77973_b() == mFlask;
    }

    public static boolean isLargeVolumetricFlask(ItemStack aStack) {
        return GregtechItemList.VOLUMETRIC_FLASK_8k.getItem() == aStack.func_77973_b();
    }

    public static boolean isGiganticVolumetricFlask(ItemStack aStack) {
        return GregtechItemList.VOLUMETRIC_FLASK_32k.getItem() == aStack.func_77973_b();
    }

    public static int getMaxFlaskCapacity(ItemStack aStack) {
        Item aItem;
        if (aStack != null && sMethodGetFlaskMaxCapacity != null && sClassVolumetricFlask.isInstance(aItem = aStack.func_77973_b())) {
            int aMaxCapacity = (Integer)ReflectionUtils.invokeNonBool(aItem, sMethodGetFlaskMaxCapacity, new Object[0]);
            return aMaxCapacity;
        }
        return 0;
    }

    public static boolean isFlaskEmpty(ItemStack aStack) {
        return VolumetricFlaskHelper.getFlaskFluid(aStack) == null;
    }

    public static FluidStack getFlaskFluid(ItemStack aStack) {
        NBTTagCompound nbt;
        if (aStack.func_77942_o() && (nbt = aStack.func_77978_p()).func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public static void setFluid(ItemStack stack, FluidStack fluidStack) {
        boolean removeFluid = fluidStack == null || fluidStack.amount <= 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            if (removeFluid) {
                return;
            }
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (removeFluid) {
            nbt.func_82580_o("Fluid");
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        } else {
            nbt.func_74782_a("Fluid", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    public static int getFlaskCapacity(ItemStack aStack) {
        NBTTagCompound nbt;
        int capacity = 1000;
        if (aStack.func_77942_o() && (nbt = aStack.func_77978_p()).func_150297_b("Capacity", 3)) {
            capacity = nbt.func_74762_e("Capacity");
        }
        return Math.min(VolumetricFlaskHelper.getMaxFlaskCapacity(aStack), capacity);
    }

    public static boolean setNewFlaskCapacity(ItemStack aStack, int aCapacity) {
        if (aStack == null || aCapacity <= 0) {
            return false;
        }
        aCapacity = Math.min(aCapacity, VolumetricFlaskHelper.getMaxFlaskCapacity(aStack));
        NBTTagCompound nbt = aStack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            aStack.func_77982_d(nbt);
        }
        nbt.func_74768_a("Capacity", aCapacity);
        return true;
    }

    public static int fillFlask(ItemStack stack, FluidStack resource, boolean doFill) {
        if (stack.field_77994_a != 1) {
            return 0;
        }
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidStack fluidStack = VolumetricFlaskHelper.getFlaskFluid(stack);
        if (fluidStack == null) {
            fluidStack = new FluidStack(resource, 0);
        } else if (!fluidStack.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(VolumetricFlaskHelper.getMaxFlaskCapacity(stack) - fluidStack.amount, resource.amount);
        if (doFill && amount > 0) {
            fluidStack.amount += amount;
            VolumetricFlaskHelper.setFluid(stack, fluidStack);
        }
        return amount;
    }

    public static Item generateNewFlask(String unlocalized, String english, int maxCapacity) {
        Object aInstance;
        Constructor<?> aFlask = ReflectionUtils.getConstructor(sClassVolumetricFlask, String.class, String.class, Integer.TYPE);
        if (aFlask != null && (aInstance = ReflectionUtils.createNewInstanceFromConstructor(aFlask, new Object[]{unlocalized, english, maxCapacity})) != null && aInstance instanceof Item) {
            Item aNewFlaskItem = (Item)aInstance;
            return aNewFlaskItem;
        }
        return null;
    }

    static {
        if (Meta_GT_Proxy.sDoesVolumetricFlaskExist) {
            sClassVolumetricFlask = ReflectionUtils.getClass("gregtech.common.items.GT_VolumetricFlask");
            Method aMaxCapacity = null;
            try {
                aMaxCapacity = sClassVolumetricFlask.getDeclaredMethod("getMaxCapacity", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                CORE.crash("Secondary Error Obtaining instance of 'getMaxCapacity' from 'GT_VolumetricFlask'. Crashing.");
            }
            sMethodGetFlaskMaxCapacity = aMaxCapacity;
        } else {
            sClassVolumetricFlask = null;
            sMethodGetFlaskMaxCapacity = null;
        }
    }
}

