/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;

public class GT_MethodHelper {
    private static final Method mGetTexture;
    private static final Class mITexturedTileEntity;

    public static ITexture[] getTexture(TileEntity tTileEntity, Block aBlock, byte aSide) {
        if (mITexturedTileEntity.isInstance(tTileEntity)) {
            if (mGetTexture != null) {
                try {
                    mGetTexture.invoke((Object)tTileEntity, aBlock, aSide);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else if (tTileEntity instanceof BaseMetaTileEntity) {
                try {
                    BaseMetaTileEntity aTile = (BaseMetaTileEntity)tTileEntity;
                    ITexture rIcon = aTile.getCoverTexture(aSide);
                    Field aFacing = ReflectionUtils.getField(BaseMetaTileEntity.class, "mFacing");
                    Field aColor = ReflectionUtils.getField(BaseMetaTileEntity.class, "mColor");
                    Field aActive = ReflectionUtils.getField(BaseMetaTileEntity.class, "mActive");
                    Field aMetaTile = ReflectionUtils.getField(BaseMetaTileEntity.class, "mMetaTileEntity");
                    Method aHasValidTile = ReflectionUtils.getMethod(BaseMetaTileEntity.class, "hasValidMetaTileEntity", new Class[0]);
                    boolean hasValidTileObj = (Boolean)aHasValidTile.invoke((Object)aTile, new Object[0]);
                    boolean aActiveObj = aActive.getBoolean(aTile);
                    byte aFacingObj = aFacing.getByte(aTile);
                    byte aColorObj = aColor.getByte(aTile);
                    MetaTileEntity aMetaTileObj = (MetaTileEntity)aMetaTile.get(aTile);
                    if (rIcon != null) {
                        return new ITexture[]{rIcon};
                    }
                    return hasValidTileObj ? aMetaTileObj.getTexture((IGregTechTileEntity)aTile, aSide, aFacingObj, (byte)(aColorObj - 1), aActiveObj, aTile.getOutputRedstoneSignal(aSide) > 0) : Textures.BlockIcons.ERROR_RENDERING;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    static {
        Class<?> clazz = null;
        Method aMeth = null;
        if (ReflectionUtils.doesClassExist("gregtech.api.interfaces.tileentity.ITexturedTileEntity")) {
            clazz = ReflectionUtils.getClass("gregtech.api.interfaces.tileentity.ITexturedTileEntity");
            aMeth = ReflectionUtils.getMethod(clazz, "getTexture", Block.class, Byte.TYPE);
        }
        mITexturedTileEntity = clazz;
        mGetTexture = aMeth;
    }
}

