/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.covers;

import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.IGuiScreen;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.minecraft.LangUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GTPP_Cover_Overflow
extends GT_CoverBehavior {
    public final int mTransferRate;
    public final int mInitialTransferRate;
    public final int mMaxTransferRate;

    public GTPP_Cover_Overflow(int aTransferRate) {
        this.mTransferRate = aTransferRate * 1000 / 10;
        this.mInitialTransferRate = aTransferRate;
        this.mMaxTransferRate = aTransferRate * 1000;
    }

    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable == 0) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler) {
            FluidStack tLiquid;
            int aAmountToDrain;
            FluidStack aTankStack;
            ForgeDirection directionFrom = ForgeDirection.UNKNOWN;
            IFluidHandler tTank1 = (IFluidHandler)aTileEntity;
            if (tTank1 == null || (aTankStack = tTank1.getTankInfo((ForgeDirection)directionFrom)[0].fluid) == null || aTankStack.amount <= aCoverVariable || (aAmountToDrain = aTankStack.amount - aCoverVariable) <= 0 || (tLiquid = tTank1.drain(directionFrom, Math.abs(aAmountToDrain), true)) != null) {
                // empty if block
            }
        }
        return aCoverVariable;
    }

    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable = GT_Utility.getClickedFacingCoords((byte)aSide, (float)aX, (float)aY, (float)aZ)[0] >= 0.5f ? (int)((float)aCoverVariable + (float)this.mMaxTransferRate * (aPlayer.func_70093_af() ? 0.1f : 0.01f)) : (int)((float)aCoverVariable - (float)this.mMaxTransferRate * (aPlayer.func_70093_af() ? 0.1f : 0.01f));
        if (aCoverVariable > this.mMaxTransferRate) {
            aCoverVariable = this.mInitialTransferRate;
        }
        if (aCoverVariable <= 0) {
            aCoverVariable = this.mMaxTransferRate;
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(LangUtils.trans("322", "Overflow point: ") + aCoverVariable + this.trans("323", "L")));
        return aCoverVariable;
    }

    public boolean onCoverRightclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int aAmount;
        boolean aShift = aPlayer.func_70093_af();
        int n = aAmount = aShift ? 128 : 8;
        aCoverVariable = GT_Utility.getClickedFacingCoords((byte)aSide, (float)aX, (float)aY, (float)aZ)[0] >= 0.5f ? (aCoverVariable += aAmount) : (aCoverVariable -= aAmount);
        if (aCoverVariable > this.mMaxTransferRate) {
            aCoverVariable = this.mInitialTransferRate;
        }
        if (aCoverVariable <= 0) {
            aCoverVariable = this.mMaxTransferRate;
        }
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(LangUtils.trans("322", "Overflow point: ") + aCoverVariable + this.trans("323", "L")));
        aTileEntity.setCoverDataAtSide(aSide, aCoverVariable);
        return true;
    }

    public boolean letsRedstoneGoIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsRedstoneGoOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsEnergyIn(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsEnergyOut(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsItemsIn(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsItemsOut(byte aSide, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    public boolean letsFluidOut(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    public boolean hasCoverGUI() {
        return true;
    }

    public Object getClientGUI(byte aSide, int aCoverID, int coverData, ICoverable aTileEntity) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private GT_GuiIntegerTextBox tBox;
        private int coverVariable;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private boolean warn;

        public GUI(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack((int)aCoverID));
            this.warn = false;
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.tBox = new GT_GuiIntegerTextBox((IGuiScreen)this, 2, 10, 33, 69, 12);
            this.tBox.func_146180_a(String.valueOf(this.coverVariable));
            this.tBox.func_146203_f(10);
        }

        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.tBox.func_146195_b(true);
        }

        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.getFontRenderer().func_78276_b(GTPP_Cover_Overflow.this.trans("323", "L"), 82, 37, -11184811);
            if (this.warn) {
                this.getFontRenderer().func_78276_b(GTPP_Cover_Overflow.this.trans("325", "Max") + ": " + this.coverVariable + "/" + GTPP_Cover_Overflow.this.mMaxTransferRate + " " + GTPP_Cover_Overflow.this.trans("323", "L"), 10, 53, -65536);
            } else {
                this.getFontRenderer().func_78276_b(GTPP_Cover_Overflow.this.trans("324", "Now") + ": " + this.coverVariable + "/" + GTPP_Cover_Overflow.this.mMaxTransferRate + " " + GTPP_Cover_Overflow.this.trans("323", "L"), 10, 53, -11184811);
            }
        }

        public void onMouseWheel(int x, int y, int delta) {
            for (GT_GuiIntegerTextBox box : this.textBoxes) {
                long i;
                if (!box.func_146206_l()) continue;
                int step = Math.max(1, Math.abs(delta / 120));
                step = (GUI.func_146272_n() ? 50 : (GUI.func_146271_m() ? 5 : 1)) * (delta > 0 ? step : -step);
                try {
                    i = Long.parseLong(box.func_146179_b());
                }
                catch (NumberFormatException e) {
                    return;
                }
                if (i > 9223372036854774807L) break;
                if ((i += (long)step) <= 0L) {
                    i = 0L;
                }
                box.func_146180_a(String.valueOf(i));
                break;
            }
        }

        public void applyTextBox(GT_GuiIntegerTextBox box) {
            long i;
            String s = box.func_146179_b().trim();
            try {
                i = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                this.resetTextBox(box);
                return;
            }
            this.warn = false;
            if (box.id == 2) {
                if (i > (long)GTPP_Cover_Overflow.this.mMaxTransferRate) {
                    i = GTPP_Cover_Overflow.this.mMaxTransferRate;
                    this.warn = true;
                } else if (i < 0L) {
                    i = 0L;
                }
                this.coverVariable = (int)i;
            }
            box.func_146180_a(String.valueOf(i));
            GT_Values.NW.sendToServer((GT_Packet)new GT_Packet_TileEntityCover(this.side, this.coverID, this.coverVariable, this.tile));
        }

        public void resetTextBox(GT_GuiIntegerTextBox box) {
            if (box.id == 2) {
                box.func_146180_a(String.valueOf(this.coverVariable));
            }
        }
    }
}

