/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.util;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.objects.GT_HashSet;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.StaticFields59;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GregtechOreDictUnificator {
    private static final Map<String, ItemStack> sName2StackMap = new HashMap<String, ItemStack>();
    private static final Map<GT_ItemStack, ItemData> sItemStack2DataMap = new HashMap<GT_ItemStack, ItemData>();
    private static final Map<GT_ItemStack, List<ItemStack>> sUnificationTable = new HashMap<GT_ItemStack, List<ItemStack>>();
    private static final GT_HashSet<GT_ItemStack> sNoUnificationList = new GT_HashSet();
    private static int isRegisteringOre = 0;
    private static int isAddingOre = 0;
    private static boolean mRunThroughTheList = true;

    public static void addToBlacklist(ItemStack aStack) {
        if (GT_Utility.isStackValid((Object)aStack) && !GT_Utility.isStackInList((ItemStack)aStack, sNoUnificationList)) {
            sNoUnificationList.add(aStack);
        }
    }

    public static boolean isBlacklisted(ItemStack aStack) {
        return GT_Utility.isStackInList((ItemStack)aStack, sNoUnificationList);
    }

    public static void add(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack) {
        GregtechOreDictUnificator.set(aPrefix, aMaterial, aStack, false, false);
    }

    public static void set(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack) {
        GregtechOreDictUnificator.set(aPrefix, aMaterial, aStack, true, false);
    }

    public static void set(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aOverwrite, boolean aAlreadyRegistered) {
        if (aMaterial == null || aPrefix == null || GT_Utility.isStackInvalid((Object)aStack) || Items.field_151008_G.getDamage(aStack) == Short.MAX_VALUE) {
            return;
        }
        ++isAddingOre;
        aStack = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack});
        if (!aAlreadyRegistered) {
            GregtechOreDictUnificator.registerOre(aPrefix.get((Object)aMaterial), aStack);
        }
        GregtechOreDictUnificator.addAssociation(aPrefix, aMaterial, aStack, GregtechOreDictUnificator.isBlacklisted(aStack));
        if (aOverwrite || GT_Utility.isStackInvalid((Object)sName2StackMap.get(aPrefix.get((Object)aMaterial).toString()))) {
            sName2StackMap.put(aPrefix.get((Object)aMaterial).toString(), aStack);
        }
        --isAddingOre;
    }

    public static ItemStack getFirstOre(Object aName, long aAmount) {
        if (GT_Utility.isStringInvalid((Object)aName)) {
            return null;
        }
        ItemStack tStack = sName2StackMap.get(aName.toString());
        if (GT_Utility.isStackValid((Object)tStack)) {
            return GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{tStack});
        }
        return GT_Utility.copyAmount((long)aAmount, (Object[])GregtechOreDictUnificator.getOres(aName).toArray());
    }

    public static ItemStack get(Object aName, long aAmount) {
        return GregtechOreDictUnificator.get(aName, null, aAmount, true, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount) {
        return GregtechOreDictUnificator.get(aName, aReplacement, aAmount, true, true);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, long aAmount) {
        return GregtechOreDictUnificator.get(aPrefix, aMaterial, null, aAmount);
    }

    public static ItemStack get(OrePrefixes aPrefix, Object aMaterial, ItemStack aReplacement, long aAmount) {
        if (StaticFields59.geOrePrefixesBooleanPreventableComponents().contains(aPrefix) && StaticFields59.getOrePrefixesBooleanDisabledItems().contains(aMaterial)) {
            return aReplacement;
        }
        return GregtechOreDictUnificator.get(aPrefix.get(aMaterial), aReplacement, aAmount, false, true);
    }

    public static ItemStack get(Object aName, ItemStack aReplacement, long aAmount, boolean aMentionPossibleTypos, boolean aNoInvalidAmounts) {
        if (aNoInvalidAmounts && aAmount < 1L) {
            return null;
        }
        if (!sName2StackMap.containsKey(aName.toString()) && aMentionPossibleTypos) {
            GT_Log.err.println("Unknown Key for Unification, Typo? " + aName);
        }
        return GT_Utility.copyAmount((long)aAmount, (Object[])new Object[]{sName2StackMap.get(aName.toString()), GregtechOreDictUnificator.getFirstOre(aName, aAmount), aReplacement});
    }

    public static ItemStack[] setStackArray(boolean aUseBlackList, ItemStack ... aStacks) {
        for (int i = 0; i < aStacks.length; ++i) {
            aStacks[i] = GregtechOreDictUnificator.get(aUseBlackList, GT_Utility.copy((Object[])new Object[]{aStacks[i]}));
        }
        return aStacks;
    }

    public static ItemStack[] getStackArray(boolean aUseBlackList, Object ... aStacks) {
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = GregtechOreDictUnificator.get(aUseBlackList, GT_Utility.copy((Object[])new Object[]{aStacks[i]}));
        }
        return rStacks;
    }

    public static ItemStack setStack(ItemStack aStack) {
        return GregtechOreDictUnificator.setStack(true, aStack);
    }

    public static ItemStack setStack(boolean aUseBlackList, ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return aStack;
        }
        ItemStack tStack = GregtechOreDictUnificator.get(aUseBlackList, aStack);
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)tStack)) {
            return aStack;
        }
        aStack.func_150996_a(tStack.func_77973_b());
        Items.field_151008_G.setDamage(aStack, Items.field_151008_G.getDamage(tStack));
        return aStack;
    }

    public static ItemStack get(ItemStack aStack) {
        return GregtechOreDictUnificator.get(true, aStack);
    }

    public static ItemStack get(boolean aUseBlackList, ItemStack aStack) {
        return GregtechOreDictUnificator.get(aUseBlackList, aStack, false);
    }

    public static ItemStack get(boolean aUseBlackList, ItemStack aStack, boolean aOnUnificationTableCreation) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return null;
        }
        ItemData tPrefixMaterial = GregtechOreDictUnificator.getAssociation(aStack);
        ItemStack rStack = null;
        if (tPrefixMaterial == null || !tPrefixMaterial.hasValidPrefixMaterialData() || aUseBlackList && tPrefixMaterial.mBlackListed) {
            return GT_Utility.copy((Object[])new Object[]{aStack});
        }
        if (aUseBlackList && !GregTech_API.sUnificationEntriesRegistered && GregtechOreDictUnificator.isBlacklisted(aStack)) {
            tPrefixMaterial.mBlackListed = true;
            return GT_Utility.copy((Object[])new Object[]{aStack});
        }
        if (tPrefixMaterial.mUnificationTarget == null) {
            tPrefixMaterial.mUnificationTarget = sName2StackMap.get(tPrefixMaterial.toString());
            if (!aOnUnificationTableCreation) {
                sUnificationTable.clear();
            }
        }
        if (GT_Utility.isStackInvalid((Object)(rStack = tPrefixMaterial.mUnificationTarget))) {
            return GT_Utility.copy((Object[])new Object[]{aStack});
        }
        assert (rStack != null);
        rStack.func_77982_d(aStack.func_77978_p());
        return GT_Utility.copyAmount((long)aStack.field_77994_a, (Object[])new Object[]{rStack});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ItemStack> getNonUnifiedStacks(Object obj) {
        Map<GT_ItemStack, List<ItemStack>> map = sUnificationTable;
        synchronized (map) {
            if (sUnificationTable.isEmpty() && !sItemStack2DataMap.isEmpty()) {
                for (GT_ItemStack tGTStack0 : sItemStack2DataMap.keySet()) {
                    ItemStack tStack0 = tGTStack0.toStack();
                    ItemStack tStack1 = GregtechOreDictUnificator.get(false, tStack0, true);
                    if (tStack0 == null || tStack1 == null || GT_Utility.areStacksEqual((ItemStack)tStack0, (ItemStack)tStack1)) continue;
                    GT_ItemStack tGTStack1 = new GT_ItemStack(tStack1);
                    List<ItemStack> list = sUnificationTable.get(tGTStack1);
                    if (list == null) {
                        list = new ArrayList<ItemStack>();
                        sUnificationTable.put(tGTStack1, list);
                    }
                    if (list.contains(tStack0)) continue;
                    list.add(tStack0);
                }
            }
        }
        ItemStack[] aStacks = new ItemStack[]{};
        if (obj instanceof ItemStack) {
            aStacks = new ItemStack[]{(ItemStack)obj};
        } else if (obj instanceof ItemStack[]) {
            aStacks = (ItemStack[])obj;
        } else if (obj instanceof List) {
            aStacks = ((List)obj).toArray(new ItemStack[0]);
        }
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (ItemStack aStack : aStacks) {
            rList.add(aStack);
            List<ItemStack> tList = sUnificationTable.get(new GT_ItemStack(aStack));
            if (tList == null) continue;
            for (ItemStack tStack : tList) {
                ItemStack tStack1 = GT_Utility.copyAmount((long)aStack.field_77994_a, (Object[])new Object[]{tStack});
                tStack1.func_77982_d(aStack.func_77978_p());
                rList.add(tStack1);
            }
        }
        return rList;
    }

    public static void addItemData(ItemStack aStack, ItemData aData) {
        if (GT_Utility.isStackValid((Object)aStack) && GregtechOreDictUnificator.getItemData(aStack) == null && aData != null) {
            GregtechOreDictUnificator.setItemData(aStack, aData);
        }
    }

    public static void setItemData(ItemStack aStack, ItemData aData) {
        block13: {
            ItemData tData;
            block11: {
                block12: {
                    if (GT_Utility.isStackInvalid((Object)aStack) || aData == null) {
                        return;
                    }
                    tData = GregtechOreDictUnificator.getItemData(aStack);
                    if (tData != null && tData.hasValidPrefixMaterialData()) break block11;
                    if (tData != null) {
                        for (Object tObject : tData.mExtraData) {
                            if (aData.mExtraData.contains(tObject)) continue;
                            aData.mExtraData.add(tObject);
                        }
                    }
                    if (aStack.field_77994_a > 1) {
                        if (aData.mMaterial != null) {
                            aData.mMaterial.mAmount /= (long)aStack.field_77994_a;
                        }
                        for (MaterialStack tMaterial : aData.mByProducts) {
                            tMaterial.mAmount /= (long)aStack.field_77994_a;
                        }
                        aStack = GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack});
                    }
                    sItemStack2DataMap.put(new GT_ItemStack(aStack), aData);
                    if (aData.hasValidMaterialData()) {
                        long tValidMaterialAmount = aData.mMaterial.mMaterial.contains(SubTag.NO_RECYCLING) ? 0L : (aData.mMaterial.mAmount >= 0L ? aData.mMaterial.mAmount : 3628800L);
                        for (MaterialStack tMaterial : aData.mByProducts) {
                            tValidMaterialAmount += tMaterial.mMaterial.contains(SubTag.NO_RECYCLING) ? 0L : (tMaterial.mAmount >= 0L ? tMaterial.mAmount : 3628800L);
                        }
                        if (tValidMaterialAmount < 3628800L) {
                            GT_ModHandler.addToRecyclerBlackList((ItemStack)aStack);
                        }
                    }
                    if (!mRunThroughTheList) break block12;
                    if (!GregTech_API.sLoadStarted) break block13;
                    mRunThroughTheList = false;
                    for (Map.Entry<GT_ItemStack, ItemData> tEntry : sItemStack2DataMap.entrySet()) {
                        if (tEntry.getValue().hasValidPrefixData() && !tEntry.getValue().mPrefix.mAllowNormalRecycling) continue;
                        GT_RecipeRegistrator.registerMaterialRecycling((ItemStack)tEntry.getKey().toStack(), (ItemData)tEntry.getValue());
                    }
                    break block13;
                }
                if (aData.hasValidPrefixData() && !aData.mPrefix.mAllowNormalRecycling) break block13;
                GT_RecipeRegistrator.registerMaterialRecycling((ItemStack)aStack, (ItemData)aData);
                break block13;
            }
            for (Object tObject : aData.mExtraData) {
                if (tData.mExtraData.contains(tObject)) continue;
                tData.mExtraData.add(tObject);
            }
        }
    }

    public static void addAssociation(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aBlackListed) {
        if (aPrefix == null || aMaterial == null || GT_Utility.isStackInvalid((Object)aStack)) {
            return;
        }
        if (Items.field_151008_G.getDamage(aStack) == Short.MAX_VALUE) {
            for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                GregtechOreDictUnificator.setItemData(GT_Utility.copyAmountAndMetaData((long)1L, (long)i, (Object[])new Object[]{aStack}), new ItemData(aPrefix, aMaterial, aBlackListed));
            }
        }
        GregtechOreDictUnificator.setItemData(aStack, new ItemData(aPrefix, aMaterial, aBlackListed));
    }

    public static ItemData getItemData(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return null;
        }
        ItemData rData = sItemStack2DataMap.get(new GT_ItemStack(aStack));
        if (rData == null) {
            rData = sItemStack2DataMap.get(new GT_ItemStack(GT_Utility.copyMetaData((long)32767L, (Object[])new Object[]{aStack})));
        }
        return rData;
    }

    public static ItemData getAssociation(ItemStack aStack) {
        ItemData rData = GregtechOreDictUnificator.getItemData(aStack);
        return rData != null && rData.hasValidPrefixMaterialData() ? rData : null;
    }

    public static boolean isItemStackInstanceOf(ItemStack aStack, Object aName) {
        if (GT_Utility.isStringInvalid((Object)aName) || GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        for (ItemStack tOreStack : GregtechOreDictUnificator.getOres(aName.toString())) {
            if (!GT_Utility.areStacksEqual((ItemStack)tOreStack, (ItemStack)aStack, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemStackDye(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        for (Dyes tDye : Dyes.VALUES) {
            if (!GregtechOreDictUnificator.isItemStackInstanceOf(aStack, tDye.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean registerOre(OrePrefixes aPrefix, Object aMaterial, ItemStack aStack) {
        return GregtechOreDictUnificator.registerOre(aPrefix.get(aMaterial), aStack);
    }

    public static boolean registerOre(Object aName, ItemStack aStack) {
        if (aName == null || GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        String tName = aName.toString();
        if (GT_Utility.isStringInvalid((Object)tName)) {
            return false;
        }
        ArrayList<ItemStack> tList = GregtechOreDictUnificator.getOres(tName);
        for (int i = 0; i < tList.size(); ++i) {
            if (!GT_Utility.areStacksEqual((ItemStack)tList.get(i), (ItemStack)aStack, (boolean)true)) continue;
            return false;
        }
        ++isRegisteringOre;
        OreDictionary.registerOre((String)tName, (ItemStack)GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack}));
        --isRegisteringOre;
        return true;
    }

    public static boolean isRegisteringOres() {
        return isRegisteringOre > 0;
    }

    public static boolean isAddingOres() {
        return isAddingOre > 0;
    }

    public static void resetUnificationEntries() {
        for (ItemData tPrefixMaterial : sItemStack2DataMap.values()) {
            tPrefixMaterial.mUnificationTarget = null;
        }
        sUnificationTable.clear();
    }

    public static ItemStack getGem(MaterialStack aMaterial) {
        return aMaterial == null ? null : GregtechOreDictUnificator.getGem(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getGem(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GregtechOreDictUnificator.getGem(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getGem(Materials aMaterial, long aMaterialAmount) {
        ItemStack rStack = null;
        if (aMaterialAmount >= 3628800L) {
            rStack = GregtechOreDictUnificator.get(OrePrefixes.gem, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null) {
            if (aMaterialAmount * 2L % 3628800L == 0L || aMaterialAmount >= 58060800L) {
                rStack = GregtechOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, aMaterialAmount * 2L / 3628800L);
            }
            if (aMaterialAmount * 4L >= 3628800L) {
                rStack = GregtechOreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, aMaterialAmount * 4L / 3628800L);
            }
        }
        return rStack;
    }

    public static ItemStack getDust(MaterialStack aMaterial) {
        return aMaterial == null ? null : GregtechOreDictUnificator.getDust(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getDust(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GregtechOreDictUnificator.getDust(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getDust(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 58060800L) {
            rStack = GregtechOreDictUnificator.get(OrePrefixes.dust, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && (aMaterialAmount * 4L % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            rStack = GregtechOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, aMaterialAmount * 4L / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            rStack = GregtechOreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack getIngot(MaterialStack aMaterial) {
        return aMaterial == null ? null : GregtechOreDictUnificator.getIngot(aMaterial.mMaterial, aMaterial.mAmount);
    }

    public static ItemStack getIngot(Materials aMaterial, OrePrefixes aPrefix) {
        return aMaterial == null ? null : GregtechOreDictUnificator.getIngot(aMaterial, aPrefix.mMaterialAmount);
    }

    public static ItemStack getIngot(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = null;
        if (aMaterialAmount % 32659200L == 0L && aMaterialAmount / 32659200L > 1L || aMaterialAmount >= 261273600L) {
            rStack = GregtechOreDictUnificator.get(OrePrefixes.block, aMaterial, aMaterialAmount / 32659200L);
        }
        if (rStack == null && (aMaterialAmount % 3628800L == 0L || aMaterialAmount >= 29030400L)) {
            rStack = GregtechOreDictUnificator.get(OrePrefixes.ingot, aMaterial, aMaterialAmount / 3628800L);
        }
        if (rStack == null && aMaterialAmount * 9L >= 3628800L) {
            rStack = GregtechOreDictUnificator.get(OrePrefixes.nugget, aMaterial, aMaterialAmount * 9L / 3628800L);
        }
        return rStack;
    }

    public static ItemStack getIngotOrDust(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = GregtechOreDictUnificator.getIngot(aMaterial, aMaterialAmount);
        if (rStack == null) {
            rStack = GregtechOreDictUnificator.getDust(aMaterial, aMaterialAmount);
        }
        return rStack;
    }

    public static ItemStack getIngotOrDust(MaterialStack aMaterial) {
        ItemStack rStack = GregtechOreDictUnificator.getIngot(aMaterial);
        if (aMaterial != null && aMaterial.mMaterial != null && (aMaterial.mMaterial == Materials.Naquadah || aMaterial.mMaterial == Materials.NaquadahEnriched)) {
            rStack = GregtechOreDictUnificator.getDust(aMaterial);
        }
        if (rStack == null) {
            rStack = GregtechOreDictUnificator.getDust(aMaterial);
        }
        return rStack;
    }

    public static ItemStack getDustOrIngot(Materials aMaterial, long aMaterialAmount) {
        if (aMaterialAmount <= 0L) {
            return null;
        }
        ItemStack rStack = GregtechOreDictUnificator.getDust(aMaterial, aMaterialAmount);
        if (rStack == null) {
            rStack = GregtechOreDictUnificator.getIngot(aMaterial, aMaterialAmount);
        }
        return rStack;
    }

    public static ItemStack getDustOrIngot(MaterialStack aMaterial) {
        ItemStack rStack = GregtechOreDictUnificator.getDust(aMaterial);
        if (rStack == null) {
            rStack = GregtechOreDictUnificator.getIngot(aMaterial);
        }
        return rStack;
    }

    public static ArrayList<ItemStack> getOres(OrePrefixes aPrefix, Object aMaterial) {
        return GregtechOreDictUnificator.getOres(aPrefix.get(aMaterial));
    }

    public static ArrayList<ItemStack> getOres(Object aOreName) {
        String aName = aOreName == null ? "" : aOreName.toString();
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        if (GT_Utility.isStringValid((Object)aName)) {
            rList.addAll(OreDictionary.getOres((String)aName));
        }
        return rList;
    }

    static {
        if (ReflectionUtils.getField(GT_OreDictUnificator.class, "sUnificationTable") == null) {
            GregTech_API.sItemStackMappings.add(sUnificationTable);
        }
    }
}

