/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.generators;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class GregtechRocketFuelGeneratorBase
extends GT_MetaTileEntity_BasicTank {
    private boolean useFuel = false;
    protected int pollMin = (int)((double)CORE.ConfigSwitches.baseMinPollutionPerSecondRocketFuelGenerator * CORE.ConfigSwitches.pollutionReleasedByTierRocketFuelGenerator[this.mTier]);
    protected int pollMax = (int)((double)CORE.ConfigSwitches.baseMaxPollutionPerSecondRocketFuelGenerator * CORE.ConfigSwitches.pollutionReleasedByTierRocketFuelGenerator[this.mTier]);

    public GregtechRocketFuelGeneratorBase(int aID, String aName, String aNameRegional, int aTier, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 3, aDescription, aTextures);
    }

    public GregtechRocketFuelGeneratorBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    public String[] getDescription() {
        String aPollution = "Causes between " + this.pollMin + " and " + this.pollMax + " Pollution per second";
        return new String[]{this.mDescription, "Fuel Efficiency: " + this.getEfficiency() + "%", aPollution, CORE.GT_Tooltip};
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFront(aColor);
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getBack(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return this.getTop(aColor);
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    public boolean isFacingValid(byte aSide) {
        return aSide > 1;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex < 2;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public boolean isOutputFacing(byte aSide) {
        return this.getBaseMetaTileEntity().getFrontFacing() == aSide;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public long maxEUOutput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUStore() {
        return Math.max(this.getEUVar(), GT_Values.V[this.mTier] * 500L + this.getMinimumStoredEU());
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return true;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.getFuelValue(aFluid) > 0;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick % 10L == 0L) {
            int tFuelValue;
            if (this.mFluid == null) {
                if (aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + this.getMinimumStoredEU()) {
                    this.mInventory[this.getStackDisplaySlot()] = null;
                } else {
                    if (this.mInventory[this.getStackDisplaySlot()] == null) {
                        this.mInventory[this.getStackDisplaySlot()] = new ItemStack((Block)Blocks.field_150480_ab, 1);
                    }
                    this.mInventory[this.getStackDisplaySlot()].func_151001_c("Generating: " + (aBaseMetaTileEntity.getUniversalEnergyStored() - this.getMinimumStoredEU()) + " EU");
                }
            } else {
                long tFluidAmountToUse;
                tFuelValue = this.getFuelValue(this.mFluid);
                int tConsumed = this.consumedFluidPerOperation(this.mFluid);
                if (tFuelValue > 0 && tConsumed > 0 && this.mFluid.amount >= tConsumed && (tFluidAmountToUse = Math.min((long)(this.mFluid.amount / tConsumed), (this.maxEUOutput() * 20L + this.getMinimumStoredEU() - aBaseMetaTileEntity.getUniversalEnergyStored()) / (long)tFuelValue)) > 0L && aBaseMetaTileEntity.increaseStoredEnergyUnits(tFluidAmountToUse * (long)tFuelValue, true)) {
                    int aSafeFloor = (int)Math.max(tFluidAmountToUse * (long)tConsumed / 3L, 1L);
                    this.mFluid.amount -= aSafeFloor;
                    PollutionUtils.addPollution(this.getBaseMetaTileEntity(), 10 * this.getPollution());
                }
            }
            if (this.mInventory[this.getInputSlot()] != null && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU() && GT_Utility.getFluidForFilledItem((ItemStack)this.mInventory[this.getInputSlot()], (boolean)true) == null && (tFuelValue = this.getFuelValue(this.mInventory[this.getInputSlot()])) > 0) {
                ItemStack tEmptyContainer = this.getEmptyContainer(this.mInventory[this.getInputSlot()]);
                if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tEmptyContainer)) {
                    aBaseMetaTileEntity.increaseStoredEnergyUnits((long)tFuelValue, true);
                    aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                    PollutionUtils.addPollution(this.getBaseMetaTileEntity(), 10 * this.getPollution());
                }
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    public int getPollution() {
        return MathUtils.randInt(this.pollMin, this.pollMax);
    }

    public abstract GT_Recipe.GT_Recipe_Map getRecipes();

    public abstract int getEfficiency();

    public int consumedFluidPerOperation(FluidStack aLiquid) {
        return 1;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null || this.getRecipes() == null) {
            return 0;
        }
        Collection tRecipeList = this.getRecipes().mRecipeList;
        if (tRecipeList != null) {
            for (GT_Recipe tFuel : tRecipeList) {
                FluidStack tLiquid = tFuel.mFluidInputs[0];
                if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
                int aperOp = this.consumedFluidPerOperation(tLiquid);
                int aConsume = (int)((long)tFuel.mSpecialValue * (long)this.getEfficiency() * (long)aperOp / 100L);
                return aConsume;
            }
        }
        return 0;
    }

    public int getFuelValue(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack) || this.getRecipes() == null) {
            return 0;
        }
        GT_Recipe tFuel = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, new ItemStack[]{aStack});
        if (tFuel != null) {
            return (int)((long)tFuel.mSpecialValue * 1000L * (long)this.getEfficiency() / 100L);
        }
        return 0;
    }

    public ItemStack getEmptyContainer(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack) || this.getRecipes() == null) {
            return null;
        }
        GT_Recipe tFuel = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, new ItemStack[]{aStack});
        if (tFuel != null) {
            return GT_Utility.copy((Object[])new Object[]{tFuel.getOutput(0)});
        }
        return GT_Utility.getContainerItem((ItemStack)aStack, (boolean)true);
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && (this.getFuelValue(aStack) > 0 || this.getFuelValue(GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true)) > 0);
    }

    public int getCapacity() {
        return 32000;
    }

    public int getTankPressure() {
        return -100;
    }
}

